/***************************************************************************
    file	         : kb_blockproxy.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>


#include	"kb_classes.h"
#include	"kb_formblock.h"

#include	"kb_idbase.h"
#include	"kb_objectproxy.h"
#include	"kb_itemproxy.h"
#include	"kb_blockproxy.h"
#include	"kb_kjsregister.h"



extern	QString kjsStringArg	(KJS::ExecState *, const KJS::List &, int) ;


/*  KBBlockProxy								*/
/*  KBBlockProxy: Constructor for rekall block proxy			*/
/*  interp	: KJS::Interpreter *	: Intepreter object		*/
/*  block	: KBBlock *		: Rekall block			*/
/*  (returns)	: KBBlockProxy		:				*/

KBBlockProxy::KBBlockProxy
	(	KJS::Interpreter	*interp,
		KBBlock			*block
	)
	:
	KBItemProxy	(interp, block)
{
}

/*  KBBlockProxy								*/
/* ~KBBlockProxy	: Destructor for rekall block proxy		*/
/*  (returns)	:		:					*/

KBBlockProxy::~KBBlockProxy ()
{
}

/*  KBBlockProxy								*/
/*  addBindings	: Add proxy bindings to specified object		*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  object	: KJS::Object &		: Object to which to add	*/
/*  (returns)	: void			:				*/

void	KBBlockProxy::addBindings
	(	KJS::ExecState	*exec,
		KJS::Object	&object
	)
{
	static	struct	MethodSpec
	{	cchar		*name	;
		uint		id	;
	}
		methods	[] =
		{
			{	"gotoQueryRow",		MethodImp::id_gotoQueryRow	},
			{	"doAction",		MethodImp::id_doAction		},
			{	"firstRecord",		MethodImp::id_firstRecord	},
			{	"previousRecord",	MethodImp::id_previousRecord	},
			{	"nextRecord",		MethodImp::id_nextRecord	},
			{	"lastRecord",		MethodImp::id_lastRecord	},
			{	"addRecord",		MethodImp::id_addRecord		},
			{	"saveRecord",		MethodImp::id_saveRecord	},
			{	"deleteRecord",		MethodImp::id_deleteRecord	},
			{	"startQuery",		MethodImp::id_startQuery	},
			{	"executeQuery",		MethodImp::id_executeQuery	},
			{	"cancelQuery",		MethodImp::id_cancelQuery	},
			{	0,			0				}
		}	;

	for (MethodSpec *ms = &methods[0] ; ms->name != 0 ; ms += 1)
		object.put
		(	m_interp->globalExec(),
			ms->name,
			KJS::Object(new MethodImp(ms->id, this))
		)	;

	KBItemProxy::addBindings (exec, object) ;
}

/*  KBBlockProxy								*/
/*  get		: Get property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: constKJS::UString &	: Property name			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBBlockProxy::get
	(	KJS::ExecState		*exec,
		const KJS::UString	&property
	)
	const
{
	QString	p = property.qstring() ;


	return	KJS::ObjectImp::get (exec, property) ;
}

/*  KBBlockProxy								*/
/*  put		: Set property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: const KJS::UString &	: Property name			*/
/*  value	: const KJS::Value &	: Value				*/
/*  attr	: int			:				*/
/*  (returns)	: void			:				*/

void	KBBlockProxy::put
	(	KJS::ExecState		*exec,
		const KJS::UString	&property,
		const KJS::Value	&value,
		int			attr
	)
{
	QString	p = property.qstring() ;


	KJS::ObjectImp::put (exec, property, value, attr) ;
}


/*  ------------------------------------------------------------------  */

/*  KBBlockProxy								*/
/*  MethodImp	: 							*/
/*  MethodImp	: Object implementation					*/
/*  id		: uint		 : Method identifier			*/
/*  object	: KBBlockProxy * : Associated proxy			*/
/*  (return)	: MethodImp	 :					*/

KBBlockProxy::MethodImp::MethodImp
	(	uint			id,
		const KBBlockProxy	*block
	)
	:
	KBItemProxy::MethodImp(id, block),
	m_block		      (block)
{
}


/*  MethodImp								*/
/*  call	: Invoke a method					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  obj		: KJS::Object &		: Apparently "self"		*/
/*  args	: const KJS::List	: Argument list			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBBlockProxy::MethodImp::call
	(	KJS::ExecState		*exec,
		KJS::Object		&object,
		const KJS::List		&args
	)
{
	uint		arg0	= args.at(0).toInteger(exec) ;
	KBFormBlock	*fblk	= m_block->m_object->isFormBlock() ;

	switch (m_id)
	{
		case id_gotoQueryRow	:
		case id_doAction	:
		case id_firstRecord	:
		case id_previousRecord	:
		case id_nextRecord	:
		case id_lastRecord	:
		case id_addRecord	:
		case id_saveRecord	:
		case id_deleteRecord	:
		case id_startQuery	:
		case id_executeQuery	:
		case id_cancelQuery	:
			break	;

		default	:
			return	KBItemProxy::MethodImp::call (exec, object, args) ;
	}

	if (fblk == 0)
		return	KJS::Null() ;

	switch (m_id)
	{
		case id_gotoQueryRow	:
			fblk->gotoQRow (arg0) ;
			break	;

		case id_doAction	:
			fblk->doAction ((KB::Action)arg0) ;
			break	;

		case id_firstRecord	:
			fblk->doAction (KB::First   ) ;
			break	;

		case id_previousRecord	:
			fblk->doAction (KB::Previous) ;
			break	;

		case id_nextRecord	:
			fblk->doAction (KB::Next    ) ;
			break	;

		case id_lastRecord	:
			fblk->doAction (KB::Last    ) ;
			break	;

		case id_addRecord	:
			fblk->doAction (KB::Add     ) ;
			break	;

		case id_saveRecord	:
			fblk->doAction (KB::Save    ) ;
			break	;

		case id_deleteRecord	:
			fblk->doAction (KB::Delete  ) ;
			break	;

		case id_startQuery	:
			fblk->doAction (KB::Query   ) ;
			break	;

		case id_executeQuery	:
			fblk->doAction (KB::Execute ) ;
			break	;

		case id_cancelQuery	:
			fblk->doAction (KB::Cancel  ) ;
			break	;

		default	:
			break	;
	}

	return	KJS::Null()	;
}


KBObjectProxy
	*makeBlockProxy
	(	KJS::Interpreter	*interp,
		KBNode			*node
	)
{
	fprintf
	(	stderr,
		"**** called: makeBlockProxy\n"
	)	;

	return	new KBBlockProxy (interp, (KBBlock *)node) ;
}

static	const char	*blockAlias[] =
{	"KBFormBlock",
	"KBReportBlock",
	"KBFormSubBlock",
	"KBReportSubBlock",
	0
}	;

static	KBKJSRegister	_blockReg ("KBBlock", makeBlockProxy, blockAlias) ;
