/***************************************************************************
    file	         : kb_blockproxy.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_BLOCKPROXY_H
#define	__KB_BLOCKPROXY_H


/*  KBBlockProxy								*/
/*  ------------								*/
/*  Proxy class for Rekall blocks ....					*/

class	KBBlockProxy : public KBItemProxy
{
public	:

	KBBlockProxy	(KJS::Interpreter *, KBBlock *) ;
	~KBBlockProxy	() ;


	virtual	void		addBindings
				(	KJS::ExecState		*,
					KJS::Object		&
				)	;

	virtual	KJS::Value	get
				(	KJS::ExecState		*,
					const KJS::UString	&
				)
				const	;

	virtual	void		put
				(	KJS::ExecState		*,
					const KJS::UString	&,
					const KJS::Value	&,
					int			= KJS::None
				)	;

protected :

	class MethodImp : public KBItemProxy::MethodImp
	{
	protected :

		const KBBlockProxy	*m_block	;

	public	:


		MethodImp	(uint, const KBBlockProxy *) ;
		~MethodImp()	{}

		virtual	KJS::Value call
			(	KJS::ExecState	*,
				KJS::Object	&,
				const KJS::List &
			)	;

		static	const uint	id_gotoQueryRow	   = IDB_BLOCK +  1 ;
		static	const uint	id_doAction	   = IDB_BLOCK +  2 ;
		static	const uint	id_firstRecord	   = IDB_BLOCK +  3 ;
		static	const uint	id_previousRecord  = IDB_BLOCK +  4 ;
		static	const uint	id_nextRecord	   = IDB_BLOCK +  5 ;
		static	const uint	id_lastRecord	   = IDB_BLOCK +  6 ;
		static	const uint	id_addRecord	   = IDB_BLOCK +  7 ;
		static	const uint	id_saveRecord	   = IDB_BLOCK +  8 ;
		static	const uint	id_deleteRecord	   = IDB_BLOCK +  9 ;
		static	const uint	id_startQuery	   = IDB_BLOCK + 10 ;
		static	const uint	id_executeQuery	   = IDB_BLOCK + 11 ;
		static	const uint	id_cancelQuery	   = IDB_BLOCK + 12 ;

	}	;

	friend	class	MethodImp ;
}	;

#endif	// __KB_BLOCKPROXY_H
