/***************************************************************************
    file	         : sip.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef _SIP_H
#define	_SIP_H

#include	<Python.h>

#ifdef __cplusplus
extern "C" {
#endif


/* In case this is Python prior to v1.5.2. */

#if !defined(PyMethod_GET_FUNCTION)
#define	PyMethod_GET_FUNCTION	PyMethod_Function
#endif

#if !defined(PyMethod_GET_SELF)
#define	PyMethod_GET_SELF	PyMethod_Self
#endif

#if !defined(PyMethod_GET_CLASS)
#define	PyMethod_GET_CLASS	PyMethod_Class
#endif

#if !defined(ANY)
#define ANY void
#endif

/* If you don't know what this is for, be grateful. */

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
#define	SIP_EXPORT	__declspec(dllexport)
#define	SIP_IMPORT	__declspec(dllimport)
#if defined(SIP_MAKE_DLL)
#define	SIP_EXTERN	SIP_EXPORT
#elif defined(SIP_USE_DLL)
#define	SIP_EXTERN	SIP_IMPORT
#endif
#endif

#if !defined(SIP_EXPORT)
#define	SIP_EXPORT
#endif

#if !defined(SIP_IMPORT)
#define	SIP_IMPORT
#endif

#if !defined(SIP_EXTERN)
#define	SIP_EXTERN
#endif


/* Define the interface between a generated module and the library. */

typedef struct {
	char *cd_name;			/* The class name. */
	PyCFunction cd_thisctor;	/* The "this" ctor. */
	PyObject **cd_classptr;		/* The address of the Python class. */
	PyMethodDef *cd_attrtab;	/* The lazy attribute table. */
	PyMethodDef **cd_vartab;	/* The variable hierachy table. */
} sipClassDef;

typedef struct _sipModuleDef {
	char *md_name;			/* The module name. */
	int md_nrclasses;		/* The number of classes. */
	sipClassDef *md_classes;	/* The table of classes. */
	PyObject *md_dict;		/* The module dictionary. */
	struct _sipModuleDef *md_next;	/* The next in the list. */
} sipModuleDef;


/*
 * The information describing an enum value instance to be added to a
 * dictionary.
 */

typedef struct {
	char *evi_name;			/* The enum value name. */
	int evi_val;			/* The enum value value. */
} sipEnumValueInstanceDef;


/*
 * The information describing a void pointer instance to be added to a
 * dictionary.
 */

typedef struct {
	char *vi_name;			/* The void pointer name. */
	void *vi_val;			/* The void pointer value. */
} sipVoidPtrInstanceDef;


/*
 * The information describing a char instance to be added to a dictionary.
 */

typedef struct {
	char *ci_name;			/* The char name. */
	char ci_val;			/* The char value. */
} sipCharInstanceDef;


/*
 * The information describing a string instance to be added to a dictionary.
 */

typedef struct {
	char *si_name;			/* The string name. */
	char *si_val;			/* The string value. */
} sipStringInstanceDef;


/*
 * The information describing a long instance to be added to a dictionary.
 */

typedef struct {
	char *li_name;			/* The long name. */
	long li_val;			/* The long value. */
} sipLongInstanceDef;


/*
 * The information describing a double instance to be added to a dictionary.
 */

typedef struct {
	char *di_name;			/* The double name. */
	double di_val;			/* The double value. */
} sipDoubleInstanceDef;


/*
 * The information describing a class instance to be added to a dictionary.
 */

typedef struct {
	char *ci_name;			/* The class name. */
	const void *ci_ptr;		/* The actual instance or access func. */
	PyObject *ci_class;		/* The Python class object. */
	int ci_flags;			/* The wrapping flags. */
} sipClassInstanceDef;


/*
 * A Python method's component parts.  This allows us to re-create the method
 * without changing the reference counts of the components.
 */

typedef struct {
	PyObject *mfunc;		/* The function. */
	PyObject *mself;		/* Self if it is a bound method. */
	PyObject *mclass;		/* The class. */
} sipPyMethod;


/*
 * Cache a reference to a Python member function.
 */

typedef struct {
	int mcflags;			/* Method cache flags. */
	sipPyMethod pyMethod;		/* The method. */
} sipMethodCache;


/*
 * Extra type specific information.
 */

typedef struct {
	const void *(*castfunc)(const void *,PyObject *);	/* Cast function. */
	void *proxyfunc;		/* Create proxy function. */
	struct _sipQtSignal *emitTable;	/* Emit table for Qt sigs (complex). */
} sipExtraType;


/*
 * A slot.
 */

typedef struct {
	char *name;			/* Name if a Qt or Python signal. */
	PyObject *pyobj;		/* Signal or Qt slot object. */
	sipPyMethod meth;		/* Python slot method, pyobj is NULL. */
	PyObject *weakSlot;		/* A weak reference to the slot. */
} sipSlot;


/*
 * A receiver of a Python signal.
 */

typedef struct _sipPySigRx {
	sipSlot rx;			/* The receiver. */
	struct _sipPySigRx *next;	/* Next in the list. */
} sipPySigRx;


/*
 * A Python signal.
 */

typedef struct _sipPySig {
	char *name;			/* The name of the signal. */
	sipPySigRx *rxlist;		/* The list of receivers. */
	struct _sipPySig *next;		/* Next in the list. */
} sipPySig;


/*
 * A C/C++ object wrapped as a Python object.
 */

typedef struct _sipThisType {
	PyObject_HEAD
	union {
		const void *cppPtr;	/* C/C++ object pointer. */
		const void *(*afPtr)();	/* Access function. */
	} u;
	int flags;			/* Object flags. */
	PyObject *sipSelf;		/* The Python class instance. */
	sipPySig *pySigList;		/* Python signal list (complex). */
	sipExtraType *xType;		/* Extra type information. */
} sipThisType;


/*
 * Maps the name of a Qt signal to a wrapper function to emit it.
 */

typedef struct _sipQtSignal {
	char *st_name;
	int (*st_emitfunc)(sipThisType *,PyObject *);
} sipQtSignal;


/*
 * Public support functions, can be called by handwritten code.
 */

extern SIP_EXTERN int sipParseArgs Py_PROTO((int *,PyObject *,char *,...));
extern SIP_EXTERN const void *sipGetComplexCppPtr Py_PROTO((sipThisType *));
extern SIP_EXTERN const void *sipGetCppPtr Py_PROTO((sipThisType *,PyObject *));
extern SIP_EXTERN int sipIsSubClassInstance Py_PROTO((PyObject *,PyObject *));
extern SIP_EXTERN const void *sipConvertToCpp Py_PROTO((PyObject *,PyObject *,int *));
extern SIP_EXTERN sipThisType *sipGetThisWrapper Py_PROTO((const void *,PyObject *));
extern SIP_EXTERN PyObject *sipMapCppToSelf Py_PROTO((const void *,PyObject *));
extern SIP_EXTERN void *sipConvertToVoidPtr Py_PROTO((PyObject *));
extern SIP_EXTERN PyObject *sipConvertFromVoidPtr Py_PROTO((void *));
extern SIP_EXTERN PyObject *sipConvertFromBool Py_PROTO((int));
extern SIP_EXTERN PyObject *sipEvalMethod Py_PROTO((const sipPyMethod *,PyObject *));
extern SIP_EXTERN void sipBadVirtualResultType Py_PROTO((char *,char *));
extern SIP_EXTERN void sipBadSetType Py_PROTO((char *,char *));
extern SIP_EXTERN void sipReleaseLock Py_PROTO(());
extern SIP_EXTERN void sipAcquireLock Py_PROTO(());
extern SIP_EXTERN void sipCondReleaseLock Py_PROTO((int));
extern SIP_EXTERN int sipCondAcquireLock Py_PROTO(());
extern SIP_EXTERN ANY *sipMalloc Py_PROTO((size_t));
extern SIP_EXTERN void sipFree Py_PROTO((ANY *));
extern SIP_EXTERN void sipCheckNone Py_PROTO((int,int *,char *));
extern SIP_EXTERN void sipCallHook Py_PROTO((char *));


/*
 * These are private, should only be called by generated code.
 */

#define	SIP_PY_OWNED	0x01		/* Owned by Python. */
#define	SIP_SIMPLE	0x02		/* If the instance is simple. */
#define	SIP_INDIRECT	0x04		/* If there is a level of indirection. */
#define	SIP_ACCFUNC	0x08		/* If there is an access function. */

#define	sipIsPyOwned(w)		((w) -> flags & SIP_PY_OWNED)
#define	sipSetPyOwned(w)	((w) -> flags |= SIP_PY_OWNED)
#define	sipResetPyOwned(w)	((w) -> flags &= ~SIP_PY_OWNED)
#define	sipIsSimple(w)		((w) -> flags & SIP_SIMPLE)
#define	sipSetSimple(w)		((w) -> flags |= SIP_SIMPLE)
#define	sipResetSimple(w)	((w) -> flags &= ~SIP_SIMPLE)
#define	sipIsIndirect(w)	((w) -> flags & SIP_INDIRECT)
#define	sipSetIndirect(w)	((w) -> flags |= SIP_INDIRECT)
#define	sipResetIndirect(w)	((w) -> flags &= ~SIP_INDIRECT)
#define	sipIsAccessFunc(w)	((w) -> flags & SIP_ACCFUNC)
#define	sipSetIsAccessFunc(w)	((w) -> flags |= SIP_ACCFUNC)
#define	sipResetIsAccessFunc(w)	((w) -> flags &= ~SIP_ACCFUNC)

#define	SIP_MC_FOUND	0x01		/* If we have looked for the method. */
#define	SIP_MC_ISMETH	0x02		/* If we looked and there was one. */

#define	sipFoundMethod(m)	((m) -> mcflags & SIP_MC_FOUND)
#define	sipSetFoundMethod(m)	((m) -> mcflags |= SIP_MC_FOUND)
#define	sipIsMethod(m)		((m) -> mcflags & SIP_MC_ISMETH)
#define	sipSetIsMethod(m)	((m) -> mcflags |= SIP_MC_ISMETH)

extern SIP_EXTERN int sipRegisterModule Py_PROTO((sipModuleDef *));
extern SIP_EXTERN int sipRegisterClasses Py_PROTO((sipModuleDef *,int));
extern SIP_EXTERN void sipSaveMethod Py_PROTO((sipPyMethod *,PyObject *));
extern SIP_EXTERN void sipCommonCtor Py_PROTO((sipMethodCache *,int));
extern SIP_EXTERN void sipCommonDtor Py_PROTO((sipThisType *));
extern SIP_EXTERN void sipTransferSelf Py_PROTO((PyObject *,int));
extern SIP_EXTERN void sipDeleteThis Py_PROTO((sipThisType *));
extern SIP_EXTERN void sipNoCtor Py_PROTO((int,char *));
extern SIP_EXTERN void sipNoFunction Py_PROTO((int,char *));
extern SIP_EXTERN void sipNoMethod Py_PROTO((int,char *,char *));
extern SIP_EXTERN int sipIsPyMethod Py_PROTO((sipMethodCache *,sipThisType *,char *,char *,int *));
extern SIP_EXTERN int sipSetInstanceAttr Py_PROTO((PyObject *,PyObject *,PyObject *));
extern SIP_EXTERN int sipAddVoidPtrInstances Py_PROTO((PyObject *,sipVoidPtrInstanceDef *));
extern SIP_EXTERN int sipAddCharInstances Py_PROTO((PyObject *,sipCharInstanceDef *));
extern SIP_EXTERN int sipAddStringInstances Py_PROTO((PyObject *,sipStringInstanceDef *));
extern SIP_EXTERN int sipAddLongInstances Py_PROTO((PyObject *,sipLongInstanceDef *));
extern SIP_EXTERN int sipAddDoubleInstances Py_PROTO((PyObject *,sipDoubleInstanceDef *));
extern SIP_EXTERN int sipAddEnumInstances Py_PROTO((PyObject *,sipEnumValueInstanceDef *));
extern SIP_EXTERN int sipAddClassInstances Py_PROTO((PyObject *,sipClassInstanceDef *));
extern SIP_EXTERN int sipAddFunctions Py_PROTO((PyObject *,PyMethodDef *));
extern SIP_EXTERN sipThisType *sipCreateThis Py_PROTO((PyObject *,const void *,PyTypeObject *,int,sipExtraType *));
extern SIP_EXTERN sipThisType *sipGetThis Py_PROTO((PyObject *,PyObject **,PyObject *));
extern SIP_EXTERN sipThisType *sipMapSelfToThis Py_PROTO((PyObject *));
extern SIP_EXTERN PyObject *sipNewCppToSelf Py_PROTO((const void *,PyObject *,int));
extern SIP_EXTERN PyObject *sipCallCtor Py_PROTO((sipModuleDef *,PyObject *));
extern SIP_EXTERN PyObject *sipGetVar Py_PROTO((sipModuleDef *,PyObject *));
extern SIP_EXTERN PyObject *sipSetVar Py_PROTO((sipModuleDef *,PyObject *));
extern SIP_EXTERN PyObject *sipGetClass Py_PROTO((PyObject *));
extern SIP_EXTERN PyObject *sipGetWeakRef Py_PROTO((PyObject *));
extern SIP_EXTERN const void *sipGetPending Py_PROTO((int *));
extern SIP_EXTERN void sipBadClass Py_PROTO((char *));

#ifdef __cplusplus
}
#endif

#endif
