
class ProjectVO:
    def __init__(self, projectname=None, unixname=None, groupid=None):
        self.projectname = projectname
        self.unixname = unixname
        self.groupid = groupid
        self.packages = None

    def copy(self):
        return ProjectVO(self.projectname,
                         self.unixname,
                         self.groupid)

    def __eq__(self, cmp):
        if self.projectname == cmp.projectname \
           and self.unixname == cmp.unixname \
           and self.groupid == cmp.groupid:
            return True
        else:
            return False


    def deepeq(self, cmp):
        if self.__eq__(cmp) and self.packages == cmp.packages:
            return True
        else:
            return False

    def __cmp__(self, other):
        if self.unixname < other.unixname: return -1
        elif self.unixname == other.unixname: return 0
        else: return 1
        

    def __repr__(self):
        return "ProjectVO: <%s - %s - %s>" %(self.projectname,
                                             self.unixname,
                                             self.groupid)

    def __hash__(self):
        return hash("%s:%s:%s" % (self.projectname, self.unixname, self.groupid))

    def setProjectName(self, projectname):
        self.projectname = projectname

    def setUnixName(self, unixname):
        self.unixname = unixname

    def setGroupId(self, groupid):
        self.groupid = groupid

    def setPackages(self, packages):
        self.packages = packages

    def getProjectName(self):
        return self.projectname

    def getUnixName(self):
        return self.unixname

    def getGroupId(self):
        return self.groupid

    def getPackages(self):
        return self.packages


    def dump(self):
        print "ProjectVO: %s - %s - %s" % (self.packagename,
                                           self.unixname,
                                           self.groupid)
        if self.packages:
            print " - Packages:"
            for pkg in self.packages:
                print "   %s - %s" % (pkg.packagename, pkg.packageid)
                
