from qt import QMessageBox
from freshmeatReleaseBA import FreshmeatReleaseBA
import logging
from messageQueue import mainMessageQueue

debug = logging.getLogger("FreshmeatRelease").debug

class FreshmeatRelease(FreshmeatReleaseBA):
    def __init__(self, parent, fm_comm, fmProjectVO):
        FreshmeatReleaseBA.__init__(self, parent)
        self.parent = parent
        self.fm_comm = fm_comm
        self.projectVO = fmProjectVO
        self.project_name = fmProjectVO.getProjectName()
        self.data = None

        
    def initialize(self, username, password):
        self.fm_comm.set_credentials(username, password)
        branches = self.fm_comm.get_branches(self.project_name)
        
        self.populateBranches(branches)
        return branches


    def populateBranches(self, branches):
        self.branchComboBox.clear()
        for branch in branches:
            self.branchComboBox.insertItem(branch)

        self.branchComboBox.adjustSize()
        
        
    def err(self, message):
        QMessageBox.critical(self,
                             "Error: Cannot submit data",
                             message)
        

    def validate(self):
        # returns True if user input is valid (and sets self.data accordingly)
        # otherwise, False is returned along w/ a QMessageBox error message
        changes = str(self.changesTextEdit.text())
        if len(changes) > 600:
            self.err("Changes cannot exceed 600 characters.\n" + 
                     "Current character count is: %d" % len(changes))
            return False

        version = str(self.versionLineEdit.text()).strip()
        if not version:
            self.err("Version field must contain a valid string")
            return False

        try:
            release_focus = str(self.releaseFocusComboBox.currentText()).split(" ")[0]
        except Exception, e:
            self.err(str(e))
            return False
            
        self.data = {'project_name': self.project_name,
                     'changes': changes,
                     'release_focus': release_focus,
                     'hide_from_frontpage': str(self.hideComboBox.currentText()),
                     'version': version,
                     'branch_name': str(self.branchComboBox.currentText())}
        return True

            
    def accept(self):
        if not self.validate(): return

        debug("data: %s",  self.data)
        ok, message = self.fm_comm.publish_release(self.data)
        debug("response: %s - %s", ok, message)
        if not ok:
            self.err("Received an error from Freshmeat xml-rpc:\n%s" % message)
            return

        mainMessageQueue.put(message)
        FreshmeatReleaseBA.accept(self)


