from qt import *
from preferencesBA import PreferencesBA
from help import Help

class Preferences(PreferencesBA):
    def __init__(self, parent, settings):
        self.parent = parent
        self.settings = settings
        PreferencesBA.__init__(self, parent)

        self.configFileLineEdit.setText(settings.getFilename())
        self.dataPathLineEdit.setText(settings['data_path'])
        try:
            font = self.settings.parseFontStr(settings['main_font'])
        except:
            font = self.parent.font()

        self.setFontButtonText(self.mainFontPushButton, font)
        
        self.show()


    def accept(self):
        data_path = str(self.dataPathLineEdit.text())
        if not data_path:
            QMessageBox.critical(self,
                                 "Data Path Error",
                                 "Data path cannot be blank")
            return

        config_file = str(self.configFileLineEdit.text())
        if not config_file:
            QMessageBox.critical(self,
                                 "Configuration File",
                                 "Configuration file cannot be blank")
            return

        
        self.settings.setFilename(config_file)
        self.settings['data_path'] = data_path
        self.settings.setFont('main_font', self.mainFontPushButton.font())
        self.parent.setMainFont()
        err = self.settings.saveSettings()
        if err:
            QMessageBox.critical(self,
                                 "Error Saving Configuration File",
                                 str(err))
            return

        PreferencesBA.accept(self)


    def setFontButtonText(self, button, font):
        #self.fontButton.setText("%s %s" % (str(font.family()),font.pointSize() ))
        button.setText("%s %s" % (str(font.family()),font.pointSize() ))


    def chooseMainFont(self):
        (font, ok) = QFontDialog.getFont(self.parent.font())
        if ok:
            self.mainFontPushButton.setFont(font)
            self.setFontButtonText(self.mainFontPushButton, font)


    def chooseConfigFile(self):
        fn = QFileDialog.getOpenFileName(self.configFileLineEdit.text(), "*.cfg\nAll (*)",
                                         self, "Choose ReleaseForge configuration file")
        if not fn.isEmpty():
            self.configFileLineEdit.setText(fn)


    def chooseDataPath(self):
        dn = QFileDialog.getExistingDirectory(self.dataPathLineEdit.text(), 
                                         self, "Choose location for ReleaseForge data")
        if not dn.isEmpty():
            self.dataPathLineEdit.setText(dn)

    def help(self):
        self._help = Help(self, "preferences.html")
        
