/* alist.h - An array-based list with a container object (unlike GList)
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __ALIST_H__
#define __ALIST_H__

#include <sys/types.h>
#include "compat.h"
#include "common.h"
#include "iterator.h"

typedef struct _AList AList;

AList *alist_new(void);
AList *alist_new_with_capacity(uint32_t capacity);
void alist_free(AList *list);
void alist_ensure_capacity(AList *list, uint32_t min_capacity);
void alist_add(AList *list, void *data);
void *alist_get(AList *list, uint32_t index);
uint32_t alist_size(AList *list);
void *alist_remove_at(AList *list, uint32_t index);
void alist_add_at(AList *list, uint32_t index, void *data);
Iterator *alist_iterator(AList *list);
bool alist_contains(AList *list, void *data);
uint32_t alist_index_of(AList *list, void *data);
uint32_t alist_last_index_of(AList *list, void *data);
void alist_clear(AList *list);
void *alist_set(AList *list, uint32_t index, void *data);
void **alist_to_array(AList *list);
void **alist_to_null_terminated_array(AList *list);
void alist_trim_to_size(AList *list);

#endif
