/* memory.h - Wrapper functions to catch memory allocation errors.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __MEMORY_H__
#define __MEMORY_H__

#include <config.h>
#include <stdlib.h>
#include <string.h>

#define memclear(mem, size)	memset((mem), 0, (size))

char *xasprintf(const char *format, ...);
void *xmalloc(size_t size);
void *xrealloc(void *mem, size_t size);
char *xstrdup(const char *str);

extern inline void *
xmalloc_clear(size_t size)
{
	void *memory = xmalloc(size);
	memclear(memory, size);
	return memory;
}

#endif
