/* random.c - Utilities for generating random numbers.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#include <config.h>
#include <stdlib.h>
#include <time.h>
#include "common.h"

/**
 * Initialize the random number engine by seeding with current
 * time.
 */
void
rand_init(void)
{
	srand((int) time(NULL));	/* ignore errors */
}

/**
 * Generate a random value between 0, inclusive, and the specified
 * maximum value, exclusive.
 */
int
rand_int(int maxvalue)
{
	return (int) (maxvalue*1.0*rand()/(RAND_MAX+1.0));
}

/**
 * Generate a random boolean.
 */
bool
rand_bool(void)
{
	return (rand_int(2) == 1 ? TRUE : FALSE);
}
