/* regex-utils.c - Convenience functions for POSIX regular expressions
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#include <config.h>
#include "regex-utils.h"
#include "error.h"
#include "memory.h"

char *
xregerror (int errcode, regex_t *compiled)
{
	size_t length = regerror(errcode, compiled, NULL, 0);
	char *buffer = xmalloc(length);
	regerror(errcode, compiled, buffer, length);
	return buffer;
}

bool
xregexec(const regex_t *pref, const char *string, size_t nmatch, regmatch_t *pmatch,
		int eflags)
{
	int rc = regexec(pref, string, nmatch, pmatch, eflags);

	switch (rc) {
	case 0:
		return TRUE;
	case REG_ESPACE:
		die_memory();
		break;
	case REG_NOMATCH:
	default:
		return FALSE;
	}
}

bool
xregexec_substring(const regex_t *pref, char *string, int start, int end,
		size_t nmatch, regmatch_t *pmatch, int eflags)
{
	bool rc;
	char tmp;

	tmp = string[end];
	string[end] = '\0';

	rc = xregexec(pref, string+start, nmatch, pmatch, eflags);
	string[end] = tmp;

	if (rc && start != 0) {
		for (; nmatch > 0; nmatch--) {
			pmatch[nmatch-1].rm_so += start;
			pmatch[nmatch-1].rm_eo += start;
		}
	}

	return rc;
}
