/* vasprintf.c - Reimplementation of vasprintf and asprintf.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#include <config.h>

#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>

#if !HAVE_VASPRINTF

int
vasprintf(char **strp, const char *format, va_list ap)
{
	int size = 256;
	int rc;

	*strp = malloc(size);
	if (*strp == NULL)
		return -1;

	while ((rc = vsnprintf(*strp, size, format, ap)) == -1) {
		size *= 2;
		*strp = realloc(*strp, size);
		if (*strp == NULL)
			return -1;
	}

	return rc;
}

int
asprintf(char **strp, const char *format, ...)
{
	int rc;
	va_list ap;

	va_start(ap, format);
	rc = vasprintf(strp, format, ap);
	va_end(ap);

	return rc;
}

#endif
