\name{ReposList-class}
\docType{class}
\alias{ReposList-class}
\alias{ReposList}
\alias{downloadRepFile}
\alias{getRepeEntry}
\alias{numReps}
\alias{repList<-}
\alias{repList}
\alias{repNames}
\alias{repPkgInfoList}
\alias{repPkgs}
\alias{repURLs}
\alias{getRepEntry}
\alias{downloadRepFile,ReposList-method}
\alias{getRepEntry,ReposList-method}
\alias{numReps,ReposList-method}
\alias{repList,ReposList-method}
\alias{repList<-,ReposList-method}
\alias{repNames,ReposList-method}
\alias{repPkgInfoList,ReposList-method}
\alias{repPkgs,ReposList-method}
\alias{repURLs,ReposList-method}
\alias{show,ReposList-method}
\title{Class "ReposList", a class to coordinate repository information}
\description{A class to manage multiple repositories as a single entity.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("ReposList", ...)}.
A convenience function, \code{buildReposList} can be used as well.
}
\section{Slots}{
  \describe{
    \item{\code{repList}:}{Object of class \code{"list"} a list of
      \code{ReposEntry} objects.}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "ReposList")}: Provides a
      display of contained information}
    \item{downloadRepFile}{\code{signature(object = "ReposList")}: Will
      download a file from a given repository }
    \item{getRepEntry}{\code{signature(object = "ReposList")}: Retrieves
    a specific \code{ReposEntry} object from the list}
    \item{numReps}{\code{signature(object = "ReposList")}: The number of
      repositories managed by the list}
    \item{repList<-}{\code{signature(object = "ReposList")}: Edits the
      repository listing.  Can use either another \code{ReposList}, a
      \code{ReposEntry}, or an actual list.}
    \item{repList}{\code{signature(object = "ReposList")}: Retunrs the
      \code{repList} slot.}
    \item{repNames}{\code{signature(object = "ReposList")}: Returns the
      names of the known repositories.}
    \item{repPkgInfoList}{\code{signature(object = "ReposList")}:
      Returns a list of \code{pkgInfo} objects for packages stored in
      the known repositories.}
    \item{repPkgs}{\code{signature(object = "ReposList")}: Returns the
      names of the packages in the known repositories. }
    \item{repURLs}{\code{signature(object = "ReposList")}: Returns the
      URLs for the known repositories.}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildReposList}}, \code{\link{getReposList}},
   \code{\link{ReposEntry}}, \code{\link{pkgInfo}}}

\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}
