use strict;
use warnings;

use RT::Test nodb => 1, tests => undef;
use RT::Interface::Web; # This gets us HTML::Mason::Commands
use Test::LongString;

{
    my $html = '<div id="metadata"><span class="actions"><a>OH HAI</a></span></div><p>Moose</p>';
    my $expected = '<div><span><a>OH HAI</a></span></div><p>Moose</p>';
    is_string(scrub_html($html), $expected, "class and id are stripped");
}

sub scrub_html {
    return HTML::Mason::Commands::ScrubHTML(shift);
}

done_testing;
