/*
 * Resource manager client
 *
 * Copyright (C) 2002, Olaf Kirch <okir@lst.de>
 */

#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/un.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <pwd.h>
#include <grp.h>
#include "protocol.h"


int
main(int argc, char **argv)
{
	const char *	opt_socket = _PATH_RESMGR_SOCKET;
	const char *	opt_user = NULL;
	int		opt_terse = 0;
	struct conn	*conn;
	char		buffer[1024], *s;
	int		c, result = 0;

	if ((s = getenv("RESMGR_SOCKET")) != NULL)
		opt_socket = s;

	while ((c = getopt(argc, argv, "+s:tu:")) != -1) {
		switch (c) {
		case 's':
			opt_socket = optarg;
			break;
		case 't':
			opt_terse = 1;
			break;
		case 'u':
			opt_user = optarg;
			break;
		default:
			fprintf(stderr,
				"usage: resmgr [-u user] cmd ...\n");
			return 1;
		}
	}

	if (opt_user) {
		struct passwd	*pw;

		if (!(pw = getpwnam(opt_user))
		 || initgroups(opt_user, pw->pw_uid) < 0
		 || setuid(pw->pw_uid) < 0) {
			perror(opt_user);
			return 1;
		}
	}

	conn = rsm_connect(opt_socket);
	if (conn == 0) {
		perror("Unable to connect to resource manager");
		return 1;
	}

	buffer[0] = 0;
	while (optind < argc) {
		if (buffer[0])
			strcat(buffer, " ");
		strcat(buffer, argv[optind++]);
	}
	strcat(buffer, "\n");

	if (rsm_send(conn, buffer, strlen(buffer)) < 0) {
		perror("rsm_send");
		return 1;
	}

	while (rsm_recv(conn, buffer, sizeof(buffer)) >= 0) {
		unsigned int	code;
		char		*ep;

		code = strtoul(buffer, &ep, 10);
		if (result == 0) {
			if (code != 100 && !opt_terse)
				printf("status code %03d\n"
				       "server message follows:\n",
				       code);
			result = code;
		} else if (result != code) {
			fprintf(stderr,
				"Protocol error; result was %d, code %d\n",
				result, code);
		}
		printf("%s", opt_terse? buffer : ep + 1);
		if (*ep != '-')
			break;
	}
	if (conn->passfd >= 0)
		printf("Received file on descriptor %d\n", conn->passfd);

	return 0;
}
