#include "gtkUtils.h"
#include "gtkFuncs.h"
#include "gtkEnum.h"


#include "RGtk.h"

USER_OBJECT_
 S_gtk_item_factory_add_foreign ( USER_OBJECT_ s_accel_widget, USER_OBJECT_ s_full_path, USER_OBJECT_ s_accel_group, USER_OBJECT_ s_keyval, USER_OBJECT_ s_modifiers )
{
   GtkWidget * accel_widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_accel_widget )) ;
   string full_path = CHAR_DEREF( STRING_ELT( s_full_path , 0)) ;
   GtkAccelGroup * accel_group = ( GtkAccelGroup * ) getPtrValue( s_accel_group ) ;
   unsigned int keyval = INTEGER_DATA( s_keyval )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_factory_add_foreign ( accel_widget, full_path, accel_group, keyval, modifiers );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_set_position ( USER_OBJECT_ s_paned, USER_OBJECT_ s_position )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_set_position ( paned, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_start_selection ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_start_selection ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_item_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_menu_item_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_check_menu_item_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_selectable ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_selectable ( clist, row );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_screen_height (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_screen_height (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_set_default_icon ( USER_OBJECT_ s_colormap, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask, USER_OBJECT_ s_hot_x, USER_OBJECT_ s_hot_y )
{
   GdkColormap * colormap = ( GdkColormap * ) getPtrValue( s_colormap ) ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;
   int hot_x = INTEGER_DATA( s_hot_x )[0] ;
   int hot_y = INTEGER_DATA( s_hot_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_set_default_icon ( colormap, pixmap, mask, hot_x, hot_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_resizeable ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_resizeable )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   Rboolean resizeable = LOGICAL_DATA( s_resizeable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_resizeable ( clist, column, resizeable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_draw_step_back ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_draw_step_back ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_label_packing ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_expand, USER_OBJECT_ s_fill, USER_OBJECT_ s_pack_type )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   Rboolean expand = LOGICAL_DATA( s_expand )[0] ;
   Rboolean fill = LOGICAL_DATA( s_fill )[0] ;
   GtkPackType pack_type = ( GtkPackType ) INTEGER_DATA( s_pack_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_label_packing ( notebook, child, expand, fill, pack_type );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_drag_status ( USER_OBJECT_ s_context, USER_OBJECT_ s_action, USER_OBJECT_ s_time )
{
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;
   GdkDragAction action = ( GdkDragAction ) INTEGER_DATA( s_action )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_drag_status ( context, action, time );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_next_page ( USER_OBJECT_ s_notebook )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_next_page ( notebook );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_colormap ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GdkColormap * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_colormap ( widget );
   _result = toRPointer(ans, "GdkColormap");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_end_selection ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_end_selection ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_set_orientation ( USER_OBJECT_ s_pbar, USER_OBJECT_ s_orientation )
{
   GtkProgressBar * pbar = GTK_PROGRESS_BAR ((GtkObject*) getPtrValue( s_pbar )) ;
   GtkProgressBarOrientation orientation = ( GtkProgressBarOrientation ) INTEGER_DATA( s_orientation )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_bar_set_orientation ( pbar, orientation );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_set_adjustments ( USER_OBJECT_ s_text, USER_OBJECT_ s_hadj, USER_OBJECT_ s_vadj )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   GtkAdjustment * hadj = Rf_length( s_hadj ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadj )) ;
   GtkAdjustment * vadj = Rf_length( s_vadj ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadj )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_set_adjustments ( text, hadj, vadj );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_new ( USER_OBJECT_ s_hadj, USER_OBJECT_ s_vadj )
{
   GtkAdjustment * hadj = Rf_length( s_hadj ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadj )) ;
   GtkAdjustment * vadj = Rf_length( s_vadj ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadj )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_text_new ( hadj, vadj );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_clear_marks ( USER_OBJECT_ s_calendar )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_calendar_clear_marks ( calendar );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vscrollbar_new ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = Rf_length( s_adjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vscrollbar_new ( adjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_fixed_move ( USER_OBJECT_ s_fixed, USER_OBJECT_ s_widget, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkFixed * fixed = GTK_FIXED ((GtkObject*) getPtrValue( s_fixed )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_fixed_move ( fixed, widget, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_item_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_list_item_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_new (  )
{


    GtkAccelGroup * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_group_new (  );
   _result = toRPointer(ans, "GtkAccelGroup");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hbutton_box_set_layout_default ( USER_OBJECT_ s_layout )
{
   GtkButtonBoxStyle layout = ( GtkButtonBoxStyle ) INTEGER_DATA( s_layout )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_hbutton_box_set_layout_default ( layout );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_groups_activate ( USER_OBJECT_ s_object, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_groups_activate ( object, key, modifiers );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_select_region ( USER_OBJECT_ s_editable, USER_OBJECT_ s_start, USER_OBJECT_ s_end )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int end = INTEGER_DATA( s_end )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_select_region ( editable, start, end );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_hide_all ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_hide_all ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_atom_intern ( USER_OBJECT_ s_atom_name, USER_OBJECT_ s_only_if_exists )
{
   string atom_name = CHAR_DEREF( STRING_ELT( s_atom_name , 0)) ;
   int only_if_exists = INTEGER_DATA( s_only_if_exists )[0] ;


    GdkAtom ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_atom_intern ( atom_name, only_if_exists );
  _result = asRGdkAtom ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_fixed_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_fixed_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gdk_screen_width (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_screen_width (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scale_set_digits ( USER_OBJECT_ s_scale, USER_OBJECT_ s_digits )
{
   GtkScale * scale = GTK_SCALE ((GtkObject*) getPtrValue( s_scale )) ;
   unsigned int digits = INTEGER_DATA( s_digits )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scale_set_digits ( scale, digits );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_list_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_set_tooltips ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_enable )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   Rboolean enable = LOGICAL_DATA( s_enable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_set_tooltips ( toolbar, enable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_get_vadjustment ( USER_OBJECT_ s_layout )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_layout_get_vadjustment ( layout );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_append ( USER_OBJECT_ s_menu_shell, USER_OBJECT_ s_child )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_append ( menu_shell, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_add ( USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers, USER_OBJECT_ s_flags, USER_OBJECT_ s_object, USER_OBJECT_ s_signal )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;
   GtkAccelFlags flags = ( GtkAccelFlags ) INTEGER_DATA( s_flags )[0] ;
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   string signal = CHAR_DEREF( STRING_ELT( s_signal , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_add ( group, key, modifiers, flags, object, signal );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_events ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GdkEventMask ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_events ( widget );
   _result =  S_check_GdkEventMask_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_menu_label ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_menu_label )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * menu_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu_label )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_menu_label ( notebook, child, menu_label );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_path_from_widget ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_item_factory_path_from_widget ( widget );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_width ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_width )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_width ( clist, column, width );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_activate_item ( USER_OBJECT_ s_menu_shell, USER_OBJECT_ s_menu_item, USER_OBJECT_ s_force_deactivate )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;
   GtkWidget * menu_item = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu_item )) ;
   Rboolean force_deactivate = LOGICAL_DATA( s_force_deactivate )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_activate_item ( menu_shell, menu_item, force_deactivate );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_frame_new ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_frame_new ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_adjustment ( USER_OBJECT_ s_progress, USER_OBJECT_ s_adjustment )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_adjustment ( progress, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_remove_page ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_page_num )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   int page_num = INTEGER_DATA( s_page_num )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_remove_page ( notebook, page_num );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_signal_handlers_destroy ( USER_OBJECT_ s_object )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_signal_handlers_destroy ( object );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_notebook_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_option_menu_remove_menu ( USER_OBJECT_ s_option_menu )
{
   GtkOptionMenu * option_menu = GTK_OPTION_MENU ((GtkObject*) getPtrValue( s_option_menu )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_option_menu_remove_menu ( option_menu );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_column_titles_active ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_column_titles_active ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_resize ( USER_OBJECT_ s_table, USER_OBJECT_ s_rows, USER_OBJECT_ s_cols )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   int rows = INTEGER_DATA( s_rows )[0] ;
   int cols = INTEGER_DATA( s_cols )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_resize ( table, rows, cols );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_attach ( USER_OBJECT_ s_group, USER_OBJECT_ s_object )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_attach ( group, object );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_set_editable ( USER_OBJECT_ s_text, USER_OBJECT_ s_editable )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   Rboolean editable = LOGICAL_DATA( s_editable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_set_editable ( text, editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_set_spacing ( USER_OBJECT_ s_packer, USER_OBJECT_ s_spacing )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   unsigned int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_set_spacing ( packer, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_insert ( USER_OBJECT_ s_menu_shell, USER_OBJECT_ s_child, USER_OBJECT_ s_position )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_insert ( menu_shell, child, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_sort_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_sort_recursive ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_new ( USER_OBJECT_ s_hadjustment, USER_OBJECT_ s_vadjustment )
{
   GtkAdjustment * hadjustment = Rf_length( s_hadjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadjustment )) ;
   GtkAdjustment * vadjustment = Rf_length( s_vadjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_layout_new ( hadjustment, vadjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_activate ( USER_OBJECT_ s_menu_item )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_activate ( menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_delete_text ( USER_OBJECT_ s_editable, USER_OBJECT_ s_start, USER_OBJECT_ s_end )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int end = INTEGER_DATA( s_end )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_delete_text ( editable, start, end );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_page_num ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_page )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * page = GTK_WIDGET ((GtkObject*) getPtrValue( s_page )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_notebook_page_num ( notebook, page );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_text_alignment ( USER_OBJECT_ s_progress, USER_OBJECT_ s_x_align, USER_OBJECT_ s_y_align )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   float x_align = NUMERIC_DATA( s_x_align )[0] ;
   float y_align = NUMERIC_DATA( s_y_align )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_text_alignment ( progress, x_align, y_align );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_insert ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_text )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   string * text = asCStringArray( s_text ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_insert ( clist, row, text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_configure ( USER_OBJECT_ s_menu_item, USER_OBJECT_ s_show_toggle_indicator, USER_OBJECT_ s_show_submenu_indicator )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;
   Rboolean show_toggle_indicator = LOGICAL_DATA( s_show_toggle_indicator )[0] ;
   Rboolean show_submenu_indicator = LOGICAL_DATA( s_show_submenu_indicator )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_configure ( menu_item, show_toggle_indicator, show_submenu_indicator );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_digits ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_digits )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   unsigned int digits = INTEGER_DATA( s_digits )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_digits ( spin_button, digits );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_new ( USER_OBJECT_ s_rows, USER_OBJECT_ s_columns, USER_OBJECT_ s_homogenous )
{
   int rows = INTEGER_DATA( s_rows )[0] ;
   int columns = INTEGER_DATA( s_columns )[0] ;
   Rboolean homogenous = LOGICAL_DATA( s_homogenous )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_table_new ( rows, columns, homogenous );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toggle_button_toggled ( USER_OBJECT_ s_toggle_button )
{
   GtkToggleButton * toggle_button = GTK_TOGGLE_BUTTON ((GtkObject*) getPtrValue( s_toggle_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toggle_button_toggled ( toggle_button );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_numeric ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_numeric )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   Rboolean numeric = LOGICAL_DATA( s_numeric )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_numeric ( spin_button, numeric );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_enter ( USER_OBJECT_ s_button )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_enter ( button );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_font_load ( USER_OBJECT_ s_name )
{
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


    GdkFont * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_font_load ( name );
   _result = toRPointer(ans, "GdkFont");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_update ( USER_OBJECT_ s_progress_bar, USER_OBJECT_ s_percentage )
{
   GtkProgressBar * progress_bar = GTK_PROGRESS_BAR ((GtkObject*) getPtrValue( s_progress_bar )) ;
   float percentage = NUMERIC_DATA( s_percentage )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_bar_update ( progress_bar, percentage );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_selection_owner_set ( USER_OBJECT_ s_widget, USER_OBJECT_ s_selection, USER_OBJECT_ s_time )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkAtom selection = ( GdkAtom) NUMERIC_DATA( s_selection )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_selection_owner_set ( widget, selection, time );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_pop_style (  )
{


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_pop_style (  );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_set_indent ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_indent )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   int indent = INTEGER_DATA( s_indent )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_set_indent ( ctree, indent );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_add_defaults ( USER_OBJECT_ s_packer, USER_OBJECT_ s_child, USER_OBJECT_ s_side, USER_OBJECT_ s_anchor, USER_OBJECT_ s_options )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkSideType side = ( GtkSideType ) INTEGER_DATA( s_side )[0] ;
   GtkAnchorType anchor = ( GtkAnchorType ) INTEGER_DATA( s_anchor )[0] ;
   GtkPackerOptions options = ( GtkPackerOptions ) INTEGER_DATA( s_options )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_add_defaults ( packer, child, side, anchor, options );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_deactivate ( USER_OBJECT_ s_menu_shell )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_deactivate ( menu_shell );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_set_editable ( USER_OBJECT_ s_entry, USER_OBJECT_ s_editable )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   Rboolean editable = LOGICAL_DATA( s_editable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_set_editable ( entry, editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_curve_reset ( USER_OBJECT_ s_curve )
{
   GtkCurve * curve = GTK_CURVE ((GtkObject*) getPtrValue( s_curve )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_curve_reset ( curve );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_is_ancestor ( USER_OBJECT_ s_widget, USER_OBJECT_ s_ancestor )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkWidget * ancestor = GTK_WIDGET ((GtkObject*) getPtrValue( s_ancestor )) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_is_ancestor ( widget, ancestor );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_handle_box_set_shadow_type ( USER_OBJECT_ s_handle_box, USER_OBJECT_ s_type )
{
   GtkHandleBox * handle_box = GTK_HANDLE_BOX ((GtkObject*) getPtrValue( s_handle_box )) ;
   GtkShadowType type = ( GtkShadowType ) INTEGER_DATA( s_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_handle_box_set_shadow_type ( handle_box, type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_statusbar_get_context_id ( USER_OBJECT_ s_statusbar, USER_OBJECT_ s_context_description )
{
   GtkStatusbar * statusbar = GTK_STATUSBAR ((GtkObject*) getPtrValue( s_statusbar )) ;
   string context_description = CHAR_DEREF( STRING_ELT( s_context_description , 0)) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_statusbar_get_context_id ( statusbar, context_description );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_get_relief ( USER_OBJECT_ s_button )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;


    GtkReliefStyle ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_button_get_relief ( button );
   _result =  S_check_GtkReliefStyle_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_set_spacing ( USER_OBJECT_ s_widget, USER_OBJECT_ s_spacing )
{
   GtkButtonBox * widget = GTK_BUTTON_BOX ((GtkObject*) getPtrValue( s_widget )) ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_box_set_spacing ( widget, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_foreground ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_color )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   GdkColor * color = ( GdkColor * ) getPtrValue( s_color ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_foreground ( ctree, node, color );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_unmap ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_unmap ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_parse_rc ( USER_OBJECT_ s_file_name )
{
   string file_name = CHAR_DEREF( STRING_ELT( s_file_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_factory_parse_rc ( file_name );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_moveto ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column, USER_OBJECT_ s_row_align, USER_OBJECT_ s_col_align )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;
   float row_align = NUMERIC_DATA( s_row_align )[0] ;
   float col_align = NUMERIC_DATA( s_col_align )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_moveto ( ctree, node, column, row_align, col_align );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_unselect_child ( USER_OBJECT_ s_list, USER_OBJECT_ s_child )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_unselect_child ( list, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_cell_style ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column, USER_OBJECT_ s_style )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_cell_style ( ctree, node, column, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_text ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column, USER_OBJECT_ s_text )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_text ( clist, row, column, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_option_menu_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_option_menu_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gdk_screen_width_mm (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_screen_width_mm (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_extension_events ( USER_OBJECT_ s_widget, USER_OBJECT_ s_events )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkExtensionMode events = ( GdkExtensionMode ) INTEGER_DATA( s_events )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_extension_events ( widget, events );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ruler_draw_ticks ( USER_OBJECT_ s_ruler )
{
   GtkRuler * ruler = GTK_RULER ((GtkObject*) getPtrValue( s_ruler )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ruler_draw_ticks ( ruler );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_get_menu_label ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_notebook_get_menu_label ( notebook, child );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_clear_items ( USER_OBJECT_ s_list, USER_OBJECT_ s_start, USER_OBJECT_ s_end )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int end = INTEGER_DATA( s_end )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_clear_items ( list, start, end );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_popdown ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_popdown ( menu );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tree_item_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_reset_rc_styles ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_reset_rc_styles ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toggle_button_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toggle_button_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_select_item ( USER_OBJECT_ s_menu_shell, USER_OBJECT_ s_menu_item )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;
   GtkWidget * menu_item = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_select_item ( menu_shell, menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_expand_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_expand_recursive ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_shape_combine_mask ( USER_OBJECT_ s_widget, USER_OBJECT_ s_mask, USER_OBJECT_ s_ofs_x, USER_OBJECT_ s_ofs_y )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;
   int ofs_x = INTEGER_DATA( s_ofs_x )[0] ;
   int ofs_y = INTEGER_DATA( s_ofs_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_shape_combine_mask ( widget, mask, ofs_x, ofs_y );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_screen_height_mm (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_screen_height_mm (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_GTK_CHECK_TYPE ( USER_OBJECT_ s_object, USER_OBJECT_ s_type )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   unsigned int type = INTEGER_DATA( s_type )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  GTK_CHECK_TYPE ( object, type );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_get_chars ( USER_OBJECT_ s_editable, USER_OBJECT_ s_start, USER_OBJECT_ s_end )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int end = INTEGER_DATA( s_end )[0] ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_editable_get_chars ( editable, start, end );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tips_query_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tips_query_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_popup ( USER_OBJECT_ s_widget, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_popup ( widget, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_get_value_as_float ( USER_OBJECT_ s_spin_button )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_spin_button_get_value_as_float ( spin_button );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_get_current_percentage ( USER_OBJECT_ s_progress )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_get_current_percentage ( progress );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_set_expand ( USER_OBJECT_ s_preview, USER_OBJECT_ s_expand )
{
   GtkPreview * preview = GTK_PREVIEW ((GtkObject*) getPtrValue( s_preview )) ;
   int expand = INTEGER_DATA( s_expand )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_set_expand ( preview, expand );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_events ( USER_OBJECT_ s_widget, USER_OBJECT_ s_events )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkEventMask events = ( GdkEventMask ) INTEGER_DATA( s_events )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_events ( widget, events );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_set_space_style ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_space_style )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   GtkToolbarSpaceStyle space_style = ( GtkToolbarSpaceStyle ) INTEGER_DATA( s_space_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_set_space_style ( toolbar, space_style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_set_row_spacings ( USER_OBJECT_ s_table, USER_OBJECT_ s_spacing )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_set_row_spacings ( table, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_destroy ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_destroy ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_set_icon_widget ( USER_OBJECT_ s_context, USER_OBJECT_ s_widget, USER_OBJECT_ s_hot_x, USER_OBJECT_ s_hot_y )
{
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int hot_x = INTEGER_DATA( s_hot_x )[0] ;
   int hot_y = INTEGER_DATA( s_hot_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_set_icon_widget ( context, widget, hot_x, hot_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vruler_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vruler_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_unselect_item ( USER_OBJECT_ s_list, USER_OBJECT_ s_item )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   int item = INTEGER_DATA( s_item )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_unselect_item ( list, item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_set_tip ( USER_OBJECT_ s_tooltips, USER_OBJECT_ s_widget, USER_OBJECT_ s_tip_text, USER_OBJECT_ s_tip_private )
{
   GtkTooltips * tooltips = GTK_TOOLTIPS ((GtkObject*) getPtrValue( s_tooltips )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string tip_text = CHAR_DEREF( STRING_ELT( s_tip_text , 0)) ;
   string tip_private = CHAR_DEREF( STRING_ELT( s_tip_private , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tooltips_set_tip ( tooltips, widget, tip_text, tip_private );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_viewport_set_vadjustment ( USER_OBJECT_ s_viewport, USER_OBJECT_ s_adjustment )
{
   GtkViewport * viewport = GTK_VIEWPORT ((GtkObject*) getPtrValue( s_viewport )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_viewport_set_vadjustment ( viewport, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_show_all ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_show_all ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_add2 ( USER_OBJECT_ s_paned, USER_OBJECT_ s_child )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_add2 ( paned, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_add1 ( USER_OBJECT_ s_paned, USER_OBJECT_ s_child )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_add1 ( paned, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_set_icon_pixmap ( USER_OBJECT_ s_context, USER_OBJECT_ s_colormap, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask, USER_OBJECT_ s_hot_x, USER_OBJECT_ s_hot_y )
{
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;
   GdkColormap * colormap = ( GdkColormap * ) getPtrValue( s_colormap ) ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;
   int hot_x = INTEGER_DATA( s_hot_x )[0] ;
   int hot_y = INTEGER_DATA( s_hot_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_set_icon_pixmap ( context, colormap, pixmap, mask, hot_x, hot_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_queue_clear ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_queue_clear ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_unhighlight ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_unhighlight ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_input_remove ( USER_OBJECT_ s_tag )
{
   int tag = INTEGER_DATA( s_tag )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_input_remove ( tag );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_foreground ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_color )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   GdkColor * color = ( GdkColor * ) getPtrValue( s_color ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_foreground ( clist, row, color );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_set_submenu ( USER_OBJECT_ s_menu_item, USER_OBJECT_ s_submenu )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;
   GtkWidget * submenu = GTK_WIDGET ((GtkObject*) getPtrValue( s_submenu )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_set_submenu ( menu_item, submenu );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_get_cell_type ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;


    GtkCellType ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_node_get_cell_type ( ctree, node, column );
   _result =  S_check_GtkCellType_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_bar_append ( USER_OBJECT_ s_menu_bar, USER_OBJECT_ s_child )
{
   GtkMenuBar * menu_bar = GTK_MENU_BAR ((GtkObject*) getPtrValue( s_menu_bar )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_bar_append ( menu_bar, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_select_all ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_select_all ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tips_query_start_query ( USER_OBJECT_ s_tips_query )
{
   GtkTipsQuery * tips_query = GTK_TIPS_QUERY ((GtkObject*) getPtrValue( s_tips_query )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tips_query_start_query ( tips_query );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_get_source_widget ( USER_OBJECT_ s_context )
{
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_drag_get_source_widget ( context );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_columns_autosize ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_columns_autosize ( clist );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_label_set_accel_widget ( USER_OBJECT_ s_accel_label, USER_OBJECT_ s_accel_widget )
{
   GtkAccelLabel * accel_label = GTK_ACCEL_LABEL ((GtkObject*) getPtrValue( s_accel_label )) ;
   GtkWidget * accel_widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_accel_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_label_set_accel_widget ( accel_label, accel_widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_color_selection_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_color_selection_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_wmclass ( USER_OBJECT_ s_window, USER_OBJECT_ s_wmclass_class, USER_OBJECT_ s_wmclass_name )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   string wmclass_class = CHAR_DEREF( STRING_ELT( s_wmclass_class , 0)) ;
   string wmclass_name = CHAR_DEREF( STRING_ELT( s_wmclass_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_wmclass ( window, wmclass_class, wmclass_name );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_default_colormap (  )
{


    GdkColormap * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_default_colormap (  );
   _result = toRPointer(ans, "GdkColormap");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_dialog_set_preview_text ( USER_OBJECT_ s_fsd, USER_OBJECT_ s_text )
{
   GtkFontSelectionDialog * fsd = GTK_FONT_SELECTION_DIALOG ((GtkObject*) getPtrValue( s_fsd )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_font_selection_dialog_set_preview_text ( fsd, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_append ( USER_OBJECT_ s_tree, USER_OBJECT_ s_child )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_append ( tree, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_get_spacing ( USER_OBJECT_ s_widget )
{
   GtkButtonBox * widget = GTK_BUTTON_BOX ((GtkObject*) getPtrValue( s_widget )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_button_box_get_spacing ( widget );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_set_use_arrows ( USER_OBJECT_ s_combo, USER_OBJECT_ s_val )
{
   GtkCombo * combo = GTK_COMBO ((GtkObject*) getPtrValue( s_combo )) ;
   Rboolean val = LOGICAL_DATA( s_val )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_combo_set_use_arrows ( combo, val );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_set_gutter_size ( USER_OBJECT_ s_paned, USER_OBJECT_ s_size )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   unsigned int size = INTEGER_DATA( s_size )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_set_gutter_size ( paned, size );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_label_new ( USER_OBJECT_ s_string )
{
   string string = CHAR_DEREF( STRING_ELT( s_string , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_label_new ( string );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_policy ( USER_OBJECT_ s_window, USER_OBJECT_ s_allow_shrink, USER_OBJECT_ s_allow_grow, USER_OBJECT_ s_auto_shrink )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   Rboolean allow_shrink = LOGICAL_DATA( s_allow_shrink )[0] ;
   Rboolean allow_grow = LOGICAL_DATA( s_allow_grow )[0] ;
   Rboolean auto_shrink = LOGICAL_DATA( s_auto_shrink )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_policy ( window, allow_shrink, allow_grow, auto_shrink );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_unselect_child ( USER_OBJECT_ s_tree, USER_OBJECT_ s_child )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_unselect_child ( tree, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_insert ( USER_OBJECT_ s_tree, USER_OBJECT_ s_child, USER_OBJECT_ s_position )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_insert ( tree, child, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_selection_mode ( USER_OBJECT_ s_clist, USER_OBJECT_ s_mode )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   GtkSelectionMode mode = ( GtkSelectionMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_selection_mode ( clist, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_new ( USER_OBJECT_ s_hadjustment, USER_OBJECT_ s_vadjustment )
{
   GtkAdjustment * hadjustment = Rf_length( s_hadjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadjustment )) ;
   GtkAdjustment * vadjustment = Rf_length( s_vadjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_scrolled_window_new ( hadjustment, vadjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_arrow_new ( USER_OBJECT_ s_arrow_type, USER_OBJECT_ s_shadow_type )
{
   GtkArrowType arrow_type = ( GtkArrowType ) INTEGER_DATA( s_arrow_type )[0] ;
   GtkShadowType shadow_type = ( GtkShadowType ) INTEGER_DATA( s_shadow_type )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_arrow_new ( arrow_type, shadow_type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_add_accelerator ( USER_OBJECT_ s_widget, USER_OBJECT_ s_signal_name, USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers, USER_OBJECT_ s_flags )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string signal_name = CHAR_DEREF( STRING_ELT( s_signal_name , 0)) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;
   GtkAccelFlags flags = ( GtkAccelFlags ) INTEGER_DATA( s_flags )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_add_accelerator ( widget, signal_name, group, key, modifiers, flags );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_hide_on_delete ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_hide_on_delete ( widget );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_reparent ( USER_OBJECT_ s_widget, USER_OBJECT_ s_new_parent )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkWidget * new_parent = GTK_WIDGET ((GtkObject*) getPtrValue( s_new_parent )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_reparent ( widget, new_parent );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_add_with_viewport ( USER_OBJECT_ s_scrolled_window, USER_OBJECT_ s_child )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scrolled_window_add_with_viewport ( scrolled_window, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_unlock_entry ( USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_unlock_entry ( group, key, modifiers );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_value ( USER_OBJECT_ s_progress, USER_OBJECT_ s_value )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   float value = NUMERIC_DATA( s_value )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_value ( progress, value );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_curve_set_gamma ( USER_OBJECT_ s_curve, USER_OBJECT_ s_gamma )
{
   GtkCurve * curve = GTK_CURVE ((GtkObject*) getPtrValue( s_curve )) ;
   float gamma = NUMERIC_DATA( s_gamma )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_curve_set_gamma ( curve, gamma );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_is_visible ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


    GtkVisibility ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_node_is_visible ( ctree, node );
   _result =  S_check_GtkVisibility_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_label_set_text ( USER_OBJECT_ s_label, USER_OBJECT_ s_str )
{
   GtkLabel * label = GTK_LABEL ((GtkObject*) getPtrValue( s_label )) ;
   string str = CHAR_DEREF( STRING_ELT( s_str , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_label_set_text ( label, str );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_curve_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_curve_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_default_size ( USER_OBJECT_ s_window, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_default_size ( window, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_enable ( USER_OBJECT_ s_tooltips )
{
   GtkTooltips * tooltips = GTK_TOOLTIPS ((GtkObject*) getPtrValue( s_tooltips )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tooltips_enable ( tooltips );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_append_page_menu ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label, USER_OBJECT_ s_menu_label )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;
   GtkWidget * menu_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu_label )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_append_page_menu ( notebook, child, tab_label, menu_label );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_clear ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_clear ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hbutton_box_set_spacing_default ( USER_OBJECT_ s_spacing )
{
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_hbutton_box_set_spacing_default ( spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_insert ( USER_OBJECT_ s_menu, USER_OBJECT_ s_child, USER_OBJECT_ s_position )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_insert ( menu, child, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_set_style ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_style )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   GtkToolbarStyle style = ( GtkToolbarStyle ) INTEGER_DATA( s_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_set_style ( toolbar, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_object_destroy ( USER_OBJECT_ s_object )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_object_destroy ( object );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_undo_selection ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_undo_selection ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_leave ( USER_OBJECT_ s_button )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_leave ( button );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_set_editable ( USER_OBJECT_ s_editable, USER_OBJECT_ s_is_editable )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;
   Rboolean is_editable = LOGICAL_DATA( s_is_editable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_set_editable ( editable, is_editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_toggle ( USER_OBJECT_ s_item )
{
   GtkItem * item = GTK_ITEM ((GtkObject*) getPtrValue( s_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_toggle ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_arrow_set ( USER_OBJECT_ s_arrow, USER_OBJECT_ s_arrow_type, USER_OBJECT_ s_shadow_type )
{
   GtkArrow * arrow = GTK_ARROW ((GtkObject*) getPtrValue( s_arrow )) ;
   GtkArrowType arrow_type = ( GtkArrowType ) INTEGER_DATA( s_arrow_type )[0] ;
   GtkShadowType shadow_type = ( GtkShadowType ) INTEGER_DATA( s_shadow_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_arrow_set ( arrow, arrow_type, shadow_type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_frame_set_shadow_type ( USER_OBJECT_ s_frame, USER_OBJECT_ s_type )
{
   GtkFrame * frame = GTK_FRAME ((GtkObject*) getPtrValue( s_frame )) ;
   GtkShadowType type = ( GtkShadowType ) INTEGER_DATA( s_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_frame_set_shadow_type ( frame, type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_set_update_policy ( USER_OBJECT_ s_range, USER_OBJECT_ s_policy )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;
   GtkUpdateType policy = ( GtkUpdateType ) INTEGER_DATA( s_policy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_set_update_policy ( range, policy );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_remove ( USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers, USER_OBJECT_ s_object )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_remove ( group, key, modifiers, object );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_freeze ( USER_OBJECT_ s_layout )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_freeze ( layout );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_select_region ( USER_OBJECT_ s_entry, USER_OBJECT_ s_start, USER_OBJECT_ s_end )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int end = INTEGER_DATA( s_end )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_select_region ( entry, start, end );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hbutton_box_get_layout_default (  )
{


    GtkButtonBoxStyle ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hbutton_box_get_layout_default (  );
   _result =  S_check_GtkButtonBoxStyle_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_end_drag_selection ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_end_drag_selection ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_file_selection_new ( USER_OBJECT_ s_title )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_file_selection_new ( title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_set_col_spacings ( USER_OBJECT_ s_table, USER_OBJECT_ s_spacing )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_set_col_spacings ( table, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_set_word_wrap ( USER_OBJECT_ s_text, USER_OBJECT_ s_word_wrap )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   int word_wrap = INTEGER_DATA( s_word_wrap )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_set_word_wrap ( text, word_wrap );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_quit_add_destroy ( USER_OBJECT_ s_main_level, USER_OBJECT_ s_object )
{
   unsigned int main_level = INTEGER_DATA( s_main_level )[0] ;
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_quit_add_destroy ( main_level, object );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_get_vadjustment ( USER_OBJECT_ s_scrolled_window )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_scrolled_window_get_vadjustment ( scrolled_window );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_file_selection_complete ( USER_OBJECT_ s_filesel, USER_OBJECT_ s_pattern )
{
   GtkFileSelection * filesel = GTK_FILE_SELECTION ((GtkObject*) getPtrValue( s_filesel )) ;
   string pattern = CHAR_DEREF( STRING_ELT( s_pattern , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_file_selection_complete ( filesel, pattern );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_new_with_adjustment ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_bar_new_with_adjustment ( adjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_style ( USER_OBJECT_ s_widget, USER_OBJECT_ s_style )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_style ( widget, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_set_placement ( USER_OBJECT_ s_scrolled_window, USER_OBJECT_ s_window_placement )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;
   GtkCornerType window_placement = ( GtkCornerType ) INTEGER_DATA( s_window_placement )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scrolled_window_set_placement ( scrolled_window, window_placement );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_get_length ( USER_OBJECT_ s_text )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_text_get_length ( text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_plug_new ( USER_OBJECT_ s_socket_id )
{
   unsigned int socket_id = INTEGER_DATA( s_socket_id )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_plug_new ( socket_id );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_activate_focus ( USER_OBJECT_ s_window )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_window_activate_focus ( window );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_alignment_set ( USER_OBJECT_ s_alignment, USER_OBJECT_ s_xalign, USER_OBJECT_ s_yalign, USER_OBJECT_ s_xscale, USER_OBJECT_ s_yscale )
{
   GtkAlignment * alignment = GTK_ALIGNMENT ((GtkObject*) getPtrValue( s_alignment )) ;
   float xalign = NUMERIC_DATA( s_xalign )[0] ;
   float yalign = NUMERIC_DATA( s_yalign )[0] ;
   float xscale = NUMERIC_DATA( s_xscale )[0] ;
   float yscale = NUMERIC_DATA( s_yscale )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_alignment_set ( alignment, xalign, yalign, xscale, yscale );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_app_paintable ( USER_OBJECT_ s_widget, USER_OBJECT_ s_app_paintable )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   Rboolean app_paintable = LOGICAL_DATA( s_app_paintable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_app_paintable ( widget, app_paintable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_set_install_cmap ( USER_OBJECT_ s_install_cmap )
{
   int install_cmap = INTEGER_DATA( s_install_cmap )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_set_install_cmap ( install_cmap );


  return(_result);
}
 

USER_OBJECT_
 S_GTK_OBJECT_TYPE ( USER_OBJECT_ s_object )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  GTK_OBJECT_TYPE ( object );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_viewport_set_shadow_type ( USER_OBJECT_ s_viewport, USER_OBJECT_ s_type )
{
   GtkViewport * viewport = GTK_VIEWPORT ((GtkObject*) getPtrValue( s_viewport )) ;
   GtkShadowType type = ( GtkShadowType ) INTEGER_DATA( s_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_viewport_set_shadow_type ( viewport, type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_combo_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_button_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_check_button_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_append_text ( USER_OBJECT_ s_entry, USER_OBJECT_ s_text )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_append_text ( entry, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ruler_set_metric ( USER_OBJECT_ s_ruler, USER_OBJECT_ s_metric )
{
   GtkRuler * ruler = GTK_RULER ((GtkObject*) getPtrValue( s_ruler )) ;
   GtkMetricType metric = ( GtkMetricType ) INTEGER_DATA( s_metric )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ruler_set_metric ( ruler, metric );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_draw_line ( USER_OBJECT_ s_drawable, USER_OBJECT_ s_gc, USER_OBJECT_ s_x1, USER_OBJECT_ s_y1, USER_OBJECT_ s_x2, USER_OBJECT_ s_y2 )
{
   GdkDrawable * drawable = ( GdkDrawable * ) getPtrValue( s_drawable ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   int x1 = INTEGER_DATA( s_x1 )[0] ;
   int y1 = INTEGER_DATA( s_y1 )[0] ;
   int x2 = INTEGER_DATA( s_x2 )[0] ;
   int y2 = INTEGER_DATA( s_y2 )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_draw_line ( drawable, gc, x1, y1, x2, y2 );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_set_visibility ( USER_OBJECT_ s_entry, USER_OBJECT_ s_visible )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   Rboolean visible = LOGICAL_DATA( s_visible )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_set_visibility ( entry, visible );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_label ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_label ( notebook, child, tab_label );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_curve_set_range ( USER_OBJECT_ s_curve, USER_OBJECT_ s_min_x, USER_OBJECT_ s_max_x, USER_OBJECT_ s_min_y, USER_OBJECT_ s_max_y )
{
   GtkCurve * curve = GTK_CURVE ((GtkObject*) getPtrValue( s_curve )) ;
   float min_x = NUMERIC_DATA( s_min_x )[0] ;
   float max_x = NUMERIC_DATA( s_max_x )[0] ;
   float min_y = NUMERIC_DATA( s_min_y )[0] ;
   float max_y = NUMERIC_DATA( s_max_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_curve_set_range ( curve, min_x, max_x, min_y, max_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_focus ( USER_OBJECT_ s_container, USER_OBJECT_ s_direction )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkDirectionType direction = ( GtkDirectionType ) INTEGER_DATA( s_direction )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_container_focus ( container, direction );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_misc_set_alignment ( USER_OBJECT_ s_misc, USER_OBJECT_ s_xalign, USER_OBJECT_ s_yalign )
{
   GtkMisc * misc = GTK_MISC ((GtkObject*) getPtrValue( s_misc )) ;
   float xalign = NUMERIC_DATA( s_xalign )[0] ;
   float yalign = NUMERIC_DATA( s_yalign )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_misc_set_alignment ( misc, xalign, yalign );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hscrollbar_new ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = Rf_length( s_adjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hscrollbar_new ( adjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_item_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_draw_default ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_draw_default ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_auto_resize ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_auto_resize )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   Rboolean auto_resize = LOGICAL_DATA( s_auto_resize )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_auto_resize ( clist, column, auto_resize );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_bar_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_bar_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_new ( USER_OBJECT_ s_orientation, USER_OBJECT_ s_style )
{
   GtkOrientation orientation = ( GtkOrientation ) INTEGER_DATA( s_orientation )[0] ;
   GtkToolbarStyle style = ( GtkToolbarStyle ) INTEGER_DATA( s_style )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toolbar_new ( orientation, style );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_child_composite_name ( USER_OBJECT_ s_container, USER_OBJECT_ s_child )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_container_child_composite_name ( container, child );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_position ( USER_OBJECT_ s_window, USER_OBJECT_ s_position )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   GtkWindowPosition position = ( GtkWindowPosition ) INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_position ( window, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_set_vadjustment ( USER_OBJECT_ s_scrolled_window, USER_OBJECT_ s_adjustment )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scrolled_window_set_vadjustment ( scrolled_window, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vbutton_box_set_spacing_default ( USER_OBJECT_ s_spacing )
{
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_vbutton_box_set_spacing_default ( spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_toggle_expansion ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_toggle_expansion ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_get_position ( USER_OBJECT_ s_editable )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_editable_get_position ( editable );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_file_selection_get_filename ( USER_OBJECT_ s_filesel )
{
   GtkFileSelection * filesel = GTK_FILE_SELECTION ((GtkObject*) getPtrValue( s_filesel )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_file_selection_get_filename ( filesel );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toggle_button_get_active ( USER_OBJECT_ s_toggle_button )
{
   GtkToggleButton * toggle_button = GTK_TOGGLE_BUTTON ((GtkObject*) getPtrValue( s_toggle_button )) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toggle_button_get_active ( toggle_button );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_adjustment_value_changed ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_adjustment_value_changed ( adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_set_expander_style ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_style )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeExpanderStyle style = ( GtkCTreeExpanderStyle ) INTEGER_DATA( s_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_set_expander_style ( ctree, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_draw_step_forw ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_draw_step_forw ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_select_day ( USER_OBJECT_ s_calendar, USER_OBJECT_ s_day )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;
   unsigned int day = INTEGER_DATA( s_day )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_calendar_select_day ( calendar, day );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_get_tab_label ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_notebook_get_tab_label ( notebook, child );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_collapse_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_collapse_recursive ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_source_set_icon ( USER_OBJECT_ s_widget, USER_OBJECT_ s_colormap, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkColormap * colormap = ( GdkColormap * ) getPtrValue( s_colormap ) ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_source_set_icon ( widget, colormap, pixmap, mask );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_force_window ( USER_OBJECT_ s_tooltips )
{
   GtkTooltips * tooltips = GTK_TOOLTIPS ((GtkObject*) getPtrValue( s_tooltips )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tooltips_force_window ( tooltips );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toggle_button_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toggle_button_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_new ( USER_OBJECT_ s_container_type, USER_OBJECT_ s_path, USER_OBJECT_ s_group )
{
   unsigned int container_type = INTEGER_DATA( s_container_type )[0] ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;


    GtkItemFactory * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_item_factory_new ( container_type, path, group );
   _result = toRPointer(ans, "GtkItemFactory");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_get_widget ( USER_OBJECT_ s_ifactory, USER_OBJECT_ s_path )
{
   GtkItemFactory * ifactory = GTK_ITEM_FACTORY ((GtkObject*) getPtrValue( s_ifactory )) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_item_factory_get_widget ( ifactory, path );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_row_move ( USER_OBJECT_ s_clist, USER_OBJECT_ s_source_row, USER_OBJECT_ s_dest_row )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int source_row = INTEGER_DATA( s_source_row )[0] ;
   int dest_row = INTEGER_DATA( s_dest_row )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_row_move ( clist, source_row, dest_row );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_pressed ( USER_OBJECT_ s_button )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_pressed ( button );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_label_parse_uline ( USER_OBJECT_ s_label, USER_OBJECT_ s_string )
{
   GtkLabel * label = GTK_LABEL ((GtkObject*) getPtrValue( s_label )) ;
   string string = CHAR_DEREF( STRING_ELT( s_string , 0)) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_label_parse_uline ( label, string );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_input_dialog_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_input_dialog_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_set_active ( USER_OBJECT_ s_menu, USER_OBJECT_ s_index )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   int index = INTEGER_DATA( s_index )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_set_active ( menu, index );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_prepend_widget ( USER_OBJECT_ s_Toolbar, USER_OBJECT_ s_Widget, USER_OBJECT_ s_tooltip_text, USER_OBJECT_ s_tooltip_private_text )
{
   GtkToolbar * Toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_Toolbar )) ;
   GtkWidget * Widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_Widget )) ;
   string tooltip_text = CHAR_DEREF( STRING_ELT( s_tooltip_text , 0)) ;
   string tooltip_private_text = CHAR_DEREF( STRING_ELT( s_tooltip_private_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_prepend_widget ( Toolbar, Widget, tooltip_text, tooltip_private_text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_fixed_put ( USER_OBJECT_ s_fixed, USER_OBJECT_ s_widget, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkFixed * fixed = GTK_FIXED ((GtkObject*) getPtrValue( s_fixed )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_fixed_put ( fixed, widget, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vpaned_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vpaned_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_extension_events ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GdkExtensionMode ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_extension_events ( widget );
   _result =  S_check_GdkExtensionMode_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_set_delay ( USER_OBJECT_ s_tooltips, USER_OBJECT_ s_delay )
{
   GtkTooltips * tooltips = GTK_TOOLTIPS ((GtkObject*) getPtrValue( s_tooltips )) ;
   int delay = INTEGER_DATA( s_delay )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tooltips_set_delay ( tooltips, delay );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_delete_selection ( USER_OBJECT_ s_editable )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_delete_selection ( editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_set_bar_style ( USER_OBJECT_ s_pbar, USER_OBJECT_ s_style )
{
   GtkProgressBar * pbar = GTK_PROGRESS_BAR ((GtkObject*) getPtrValue( s_pbar )) ;
   GtkProgressBarStyle style = ( GtkProgressBarStyle ) INTEGER_DATA( s_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_bar_set_bar_style ( pbar, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_select_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_select_recursive ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_mark_day ( USER_OBJECT_ s_calendar, USER_OBJECT_ s_day )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;
   unsigned int day = INTEGER_DATA( s_day )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_calendar_mark_day ( calendar, day );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_get_widget_by_action ( USER_OBJECT_ s_ifactory, USER_OBJECT_ s_action )
{
   GtkItemFactory * ifactory = GTK_ITEM_FACTORY ((GtkObject*) getPtrValue( s_ifactory )) ;
   unsigned int action = INTEGER_DATA( s_action )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_item_factory_get_widget_by_action ( ifactory, action );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_viewport_get_hadjustment ( USER_OBJECT_ s_viewport )
{
   GtkViewport * viewport = GTK_VIEWPORT ((GtkObject*) getPtrValue( s_viewport )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_viewport_get_hadjustment ( viewport );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_ensure_uline_accel_group ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


    GtkAccelGroup * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_ensure_uline_accel_group ( menu );
   _result = toRPointer(ans, "GtkAccelGroup");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_select_item ( USER_OBJECT_ s_list, USER_OBJECT_ s_item )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   int item = INTEGER_DATA( s_item )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_select_item ( list, item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_unlock ( USER_OBJECT_ s_group )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_unlock ( group );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_remove_accelerator ( USER_OBJECT_ s_widget, USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_remove_accelerator ( widget, group, key, modifiers );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_set_accel_group ( USER_OBJECT_ s_menu, USER_OBJECT_ s_group )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_set_accel_group ( menu, group );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_button_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_grab_add ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_grab_add ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_set_focus_child ( USER_OBJECT_ s_container, USER_OBJECT_ s_child )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkWidget * child = Rf_length( s_child ) == 0 ? NULL :  GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_set_focus_child ( container, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_reposition ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_reposition ( menu );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_set_focus_hadjustment ( USER_OBJECT_ s_container, USER_OBJECT_ s_adjustment )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_set_focus_hadjustment ( container, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_get_cell_style ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_node_get_cell_style ( ctree, node, column );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_get_accel_group ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


    GtkAccelGroup * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_get_accel_group ( menu );
   _result = toRPointer(ans, "GtkAccelGroup");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_set_placement ( USER_OBJECT_ s_menu_item, USER_OBJECT_ s_placement )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;
   GtkSubmenuPlacement placement = ( GtkSubmenuPlacement ) INTEGER_DATA( s_placement )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_set_placement ( menu_item, placement );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tips_query_stop_query ( USER_OBJECT_ s_tips_query )
{
   GtkTipsQuery * tips_query = GTK_TIPS_QUERY ((GtkObject*) getPtrValue( s_tips_query )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tips_query_stop_query ( tips_query );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_scroll_horizontal ( USER_OBJECT_ s_list, USER_OBJECT_ s_scroll_type, USER_OBJECT_ s_pos )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkScrollType scroll_type = ( GtkScrollType ) INTEGER_DATA( s_scroll_type )[0] ;
   float pos = NUMERIC_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_scroll_horizontal ( list, scroll_type, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_title ( USER_OBJECT_ s_window, USER_OBJECT_ s_title )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_title ( window, title );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_append_page ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_append_page ( notebook, child, tab_label );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_draw_arc ( USER_OBJECT_ s_drawable, USER_OBJECT_ s_gc, USER_OBJECT_ s_filled, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_width, USER_OBJECT_ s_height, USER_OBJECT_ s_angle1, USER_OBJECT_ s_angle2 )
{
   GdkDrawable * drawable = ( GdkDrawable * ) getPtrValue( s_drawable ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   int filled = INTEGER_DATA( s_filled )[0] ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;
   int angle1 = INTEGER_DATA( s_angle1 )[0] ;
   int angle2 = INTEGER_DATA( s_angle2 )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_draw_arc ( drawable, gc, filled, x, y, width, height, angle1, angle2 );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_new ( USER_OBJECT_ s_columns, USER_OBJECT_ s_tree_column )
{
   int columns = INTEGER_DATA( s_columns )[0] ;
   int tree_column = INTEGER_DATA( s_tree_column )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_new ( columns, tree_column );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_set_node_info ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_text, USER_OBJECT_ s_spacing, USER_OBJECT_ s_pixmap_closed, USER_OBJECT_ s_mask_closed, USER_OBJECT_ s_pixmap_opened, USER_OBJECT_ s_mask_opened, USER_OBJECT_ s_is_leaf, USER_OBJECT_ s_expanded )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   unsigned int spacing = INTEGER_DATA( s_spacing )[0] ;
   GdkPixmap * pixmap_closed = ( GdkPixmap * ) getPtrValue( s_pixmap_closed ) ;
   GdkBitmap * mask_closed = ( GdkBitmap * ) getPtrValue( s_mask_closed ) ;
   GdkPixmap * pixmap_opened = ( GdkPixmap * ) getPtrValue( s_pixmap_opened ) ;
   GdkBitmap * mask_opened = ( GdkBitmap * ) getPtrValue( s_mask_opened ) ;
   Rboolean is_leaf = LOGICAL_DATA( s_is_leaf )[0] ;
   Rboolean expanded = LOGICAL_DATA( s_expanded )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_set_node_info ( ctree, node, text, spacing, pixmap_closed, mask_closed, pixmap_opened, mask_opened, is_leaf, expanded );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_set_policy ( USER_OBJECT_ s_scrolled_window, USER_OBJECT_ s_hscrollbar_policy, USER_OBJECT_ s_vscrollbar_policy )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;
   GtkPolicyType hscrollbar_policy = ( GtkPolicyType ) INTEGER_DATA( s_hscrollbar_policy )[0] ;
   GtkPolicyType vscrollbar_policy = ( GtkPolicyType ) INTEGER_DATA( s_vscrollbar_policy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scrolled_window_set_policy ( scrolled_window, hscrollbar_policy, vscrollbar_policy );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_prepend_page_menu ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label, USER_OBJECT_ s_menu_label )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;
   GtkWidget * menu_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu_label )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_prepend_page_menu ( notebook, child, tab_label, menu_label );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_justification ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_justification )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   GtkJustification justification = ( GtkJustification ) INTEGER_DATA( s_justification )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_justification ( clist, column, justification );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scale_set_draw_value ( USER_OBJECT_ s_scale, USER_OBJECT_ s_draw_value )
{
   GtkScale * scale = GTK_SCALE ((GtkObject*) getPtrValue( s_scale )) ;
   Rboolean draw_value = LOGICAL_DATA( s_draw_value )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scale_set_draw_value ( scale, draw_value );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_dialog_get_font ( USER_OBJECT_ s_fsd )
{
   GtkFontSelectionDialog * fsd = GTK_FONT_SELECTION_DIALOG ((GtkObject*) getPtrValue( s_fsd )) ;


    GdkFont * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_dialog_get_font ( fsd );
   _result = toRPointer(ans, "GdkFont");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_prepend_page ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_prepend_page ( notebook, child, tab_label );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_draw_rectangle ( USER_OBJECT_ s_drawable, USER_OBJECT_ s_gc, USER_OBJECT_ s_filled, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GdkDrawable * drawable = ( GdkDrawable * ) getPtrValue( s_drawable ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   int filled = INTEGER_DATA( s_filled )[0] ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_draw_rectangle ( drawable, gc, filled, x, y, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_auto_sort ( USER_OBJECT_ s_clist, USER_OBJECT_ s_auto_sort )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   Rboolean auto_sort = LOGICAL_DATA( s_auto_sort )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_auto_sort ( clist, auto_sort );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_set_selection_mode ( USER_OBJECT_ s_list, USER_OBJECT_ s_mode )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkSelectionMode mode = ( GtkSelectionMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_set_selection_mode ( list, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_new_with_titles ( USER_OBJECT_ s_columns, USER_OBJECT_ s_tree_column, USER_OBJECT_ s_titles )
{
   int columns = INTEGER_DATA( s_columns )[0] ;
   int tree_column = INTEGER_DATA( s_tree_column )[0] ;
   string * titles = asCStringArray( s_titles ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_new_with_titles ( columns, tree_column, titles );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gdk_draw_point ( USER_OBJECT_ s_drawable, USER_OBJECT_ s_gc, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GdkDrawable * drawable = ( GdkDrawable * ) getPtrValue( s_drawable ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_draw_point ( drawable, gc, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_pack_end_defaults ( USER_OBJECT_ s_box, USER_OBJECT_ s_child )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_pack_end_defaults ( box, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_statusbar_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_statusbar_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_push_colormap ( USER_OBJECT_ s_cmap )
{
   GdkColormap * cmap = ( GdkColormap * ) getPtrValue( s_cmap ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_push_colormap ( cmap );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tips_query_set_labels ( USER_OBJECT_ s_tips_query, USER_OBJECT_ s_label_inactive, USER_OBJECT_ s_label_no_tip )
{
   GtkTipsQuery * tips_query = GTK_TIPS_QUERY ((GtkObject*) getPtrValue( s_tips_query )) ;
   string label_inactive = CHAR_DEREF( STRING_ELT( s_label_inactive , 0)) ;
   string label_no_tip = CHAR_DEREF( STRING_ELT( s_label_no_tip , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tips_query_set_labels ( tips_query, label_inactive, label_no_tip );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_get_row_style ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_node_get_row_style ( ctree, node );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_option_menu_set_history ( USER_OBJECT_ s_option_menu, USER_OBJECT_ s_index )
{
   GtkOptionMenu * option_menu = GTK_OPTION_MENU ((GtkObject*) getPtrValue( s_option_menu )) ;
   int index = INTEGER_DATA( s_index )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_option_menu_set_history ( option_menu, index );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_insert_page ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label, USER_OBJECT_ s_position )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_insert_page ( notebook, child, tab_label, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_popup ( USER_OBJECT_ s_menu, USER_OBJECT_ s_parent_shell, USER_OBJECT_ s_parent_item, USER_OBJECT_ s_func, USER_OBJECT_ s_data, USER_OBJECT_ s_button, USER_OBJECT_ s_activate_time )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   GtkWidget * parent_shell = GTK_WIDGET ((GtkObject*) getPtrValue( s_parent_shell )) ;
   GtkWidget * parent_item = GTK_WIDGET ((GtkObject*) getPtrValue( s_parent_item )) ;
   GtkMenuPositionFunc * func = ( GtkMenuPositionFunc * ) getPtrValue( s_func ) ;
   gpointer * data = ( gpointer * ) getPtrValue( s_data ) ;
   guint * button = ( guint * ) getPtrValue( s_button ) ;
   guint32 * activate_time = ( guint32 * ) getPtrValue( s_activate_time ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_popup ( menu, parent_shell, parent_item, func, data, button, activate_time );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vbutton_box_get_layout_default (  )
{


    GtkButtonBoxStyle ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vbutton_box_get_layout_default (  );
   _result =  S_check_GtkButtonBoxStyle_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_get_preview_text ( USER_OBJECT_ s_fontsel )
{
   GtkFontSelection * fontsel = GTK_FONT_SELECTION ((GtkObject*) getPtrValue( s_fontsel )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_get_preview_text ( fontsel );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_collapse_to_depth ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_depth )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int depth = INTEGER_DATA( s_depth )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_collapse_to_depth ( ctree, node, depth );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_menu_item_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_check_menu_item_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_set_child_packing ( USER_OBJECT_ s_box, USER_OBJECT_ s_child, USER_OBJECT_ s_expand, USER_OBJECT_ s_fill, USER_OBJECT_ s_padding, USER_OBJECT_ s_pack_type )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   Rboolean expand = LOGICAL_DATA( s_expand )[0] ;
   Rboolean fill = LOGICAL_DATA( s_fill )[0] ;
   int padding = INTEGER_DATA( s_padding )[0] ;
   GtkPackType pack_type = ( GtkPackType ) INTEGER_DATA( s_pack_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_set_child_packing ( box, child, expand, fill, padding, pack_type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_select_child ( USER_OBJECT_ s_list, USER_OBJECT_ s_child )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_select_child ( list, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_toggle_expansion_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_toggle_expansion_recursive ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_adjustment_new ( USER_OBJECT_ s_value, USER_OBJECT_ s_lower, USER_OBJECT_ s_upper, USER_OBJECT_ s_step_increment, USER_OBJECT_ s_page_increment, USER_OBJECT_ s_page_size )
{
   float value = NUMERIC_DATA( s_value )[0] ;
   float lower = NUMERIC_DATA( s_lower )[0] ;
   float upper = NUMERIC_DATA( s_upper )[0] ;
   float step_increment = NUMERIC_DATA( s_step_increment )[0] ;
   float page_increment = NUMERIC_DATA( s_page_increment )[0] ;
   float page_size = NUMERIC_DATA( s_page_size )[0] ;


    GtkObject * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_adjustment_new ( value, lower, upper, step_increment, page_increment, page_size );
   _result = toRPointer(ans, "GtkObject");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_set_button_relief ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_relief )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   GtkReliefStyle relief = ( GtkReliefStyle ) INTEGER_DATA( s_relief )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_set_button_relief ( toolbar, relief );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_file_selection_set_filename ( USER_OBJECT_ s_filesel, USER_OBJECT_ s_filename )
{
   GtkFileSelection * filesel = GTK_FILE_SELECTION ((GtkObject*) getPtrValue( s_filesel )) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_file_selection_set_filename ( filesel, filename );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_viewport_get_vadjustment ( USER_OBJECT_ s_viewport )
{
   GtkViewport * viewport = GTK_VIEWPORT ((GtkObject*) getPtrValue( s_viewport )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_viewport_get_vadjustment ( viewport );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_socket_steal ( USER_OBJECT_ s_socket, USER_OBJECT_ s_window_id )
{
   GtkSocket * socket = GTK_SOCKET ((GtkObject*) getPtrValue( s_socket )) ;
   unsigned int window_id = INTEGER_DATA( s_window_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_socket_steal ( socket, window_id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_deselect ( USER_OBJECT_ s_tree_item )
{
   GtkTreeItem * tree_item = GTK_TREE_ITEM ((GtkObject*) getPtrValue( s_tree_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_item_deselect ( tree_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_detach ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_detach ( menu );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_set_tearoff_state ( USER_OBJECT_ s_menu, USER_OBJECT_ s_torn_off )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   Rboolean torn_off = LOGICAL_DATA( s_torn_off )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_set_tearoff_state ( menu, torn_off );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_selectable ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_selectable )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   Rboolean selectable = LOGICAL_DATA( s_selectable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_selectable ( clist, row, selectable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_border ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_border_width )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   int border_width = INTEGER_DATA( s_border_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_border ( notebook, border_width );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toggle_button_set_mode ( USER_OBJECT_ s_toggle_button, USER_OBJECT_ s_draw_indicator )
{
   GtkToggleButton * toggle_button = GTK_TOGGLE_BUTTON ((GtkObject*) getPtrValue( s_toggle_button )) ;
   Rboolean draw_indicator = LOGICAL_DATA( s_draw_indicator )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toggle_button_set_mode ( toggle_button, draw_indicator );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_ensure_style ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_ensure_style ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_popup_enable ( USER_OBJECT_ s_notebook )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_popup_enable ( notebook );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_row_style ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_row_style ( clist, row );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_bar_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_prepend ( USER_OBJECT_ s_tree, USER_OBJECT_ s_child )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_prepend ( tree, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_selection_add_target ( USER_OBJECT_ s_widget, USER_OBJECT_ s_selection, USER_OBJECT_ s_target, USER_OBJECT_ s_info )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkAtom selection = ( GdkAtom) NUMERIC_DATA( s_selection )[0] ;
   GdkAtom target = ( GdkAtom) NUMERIC_DATA( s_target )[0] ;
   unsigned int info = INTEGER_DATA( s_info )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_selection_add_target ( widget, selection, target, info );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_set_line_wrap ( USER_OBJECT_ s_text, USER_OBJECT_ s_line_wrap )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   int line_wrap = INTEGER_DATA( s_line_wrap )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_set_line_wrap ( text, line_wrap );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_popup_disable ( USER_OBJECT_ s_notebook )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_popup_disable ( notebook );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_set_col_spacing ( USER_OBJECT_ s_table, USER_OBJECT_ s_column, USER_OBJECT_ s_spacing )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_set_col_spacing ( table, column, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_select ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_select ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_undo_selection ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_undo_selection ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_set_show_stub ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_show_stub )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   Rboolean show_stub = LOGICAL_DATA( s_show_stub )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_set_show_stub ( ctree, show_stub );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_append_widget ( USER_OBJECT_ s_Toolbar, USER_OBJECT_ s_Widget, USER_OBJECT_ s_tooltip_text, USER_OBJECT_ s_tooltip_private_text )
{
   GtkToolbar * Toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_Toolbar )) ;
   GtkWidget * Widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_Widget )) ;
   string tooltip_text = CHAR_DEREF( STRING_ELT( s_tooltip_text , 0)) ;
   string tooltip_private_text = CHAR_DEREF( STRING_ELT( s_tooltip_private_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_append_widget ( Toolbar, Widget, tooltip_text, tooltip_private_text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_new ( USER_OBJECT_ s_type )
{
   GtkPreviewType type = ( GtkPreviewType ) INTEGER_DATA( s_type )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_preview_new ( type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_insert_widget ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_widget, USER_OBJECT_ s_tooltip_text, USER_OBJECT_ s_tooltip_private_text, USER_OBJECT_ s_position )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string tooltip_text = CHAR_DEREF( STRING_ELT( s_tooltip_text , 0)) ;
   string tooltip_private_text = CHAR_DEREF( STRING_ELT( s_tooltip_private_text , 0)) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_insert_widget ( toolbar, widget, tooltip_text, tooltip_private_text, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_rc_parse ( USER_OBJECT_ s_file )
{
   string file = CHAR_DEREF( STRING_ELT( s_file , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_rc_parse ( file );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_get_value ( USER_OBJECT_ s_progress )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_get_value ( progress );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_toggle_row ( USER_OBJECT_ s_list, USER_OBJECT_ s_item )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkWidget * item = GTK_WIDGET ((GtkObject*) getPtrValue( s_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_toggle_row ( list, item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_grab_get_current (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_grab_get_current (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_from_widget ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GtkItemFactory * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_item_factory_from_widget ( widget );
   _result = toRPointer(ans, "GtkItemFactory");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_set_icon_default ( USER_OBJECT_ s_context )
{
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_set_icon_default ( context );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_backward_delete ( USER_OBJECT_ s_text, USER_OBJECT_ s_nchars )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   unsigned int nchars = INTEGER_DATA( s_nchars )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_backward_delete ( text, nchars );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_pixmap_new ( USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask )
{
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_pixmap_new ( pixmap, mask );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_unselect ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_unselect ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_get_hadjustment ( USER_OBJECT_ s_scrolled_window )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_scrolled_window_get_hadjustment ( scrolled_window );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_get_percentage_from_value ( USER_OBJECT_ s_progress, USER_OBJECT_ s_value )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   float value = NUMERIC_DATA( s_value )[0] ;


    float ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_get_percentage_from_value ( progress, value );
  _result = asRNumeric ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_reorder_child ( USER_OBJECT_ s_packer, USER_OBJECT_ s_widget, USER_OBJECT_ s_position )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_reorder_child ( packer, widget, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_reorder_child ( USER_OBJECT_ s_menu, USER_OBJECT_ s_child, USER_OBJECT_ s_position )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_reorder_child ( menu, child, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ruler_set_range ( USER_OBJECT_ s_ruler, USER_OBJECT_ s_lower, USER_OBJECT_ s_upper, USER_OBJECT_ s_position, USER_OBJECT_ s_max_size )
{
   GtkRuler * ruler = GTK_RULER ((GtkObject*) getPtrValue( s_ruler )) ;
   float lower = NUMERIC_DATA( s_lower )[0] ;
   float upper = NUMERIC_DATA( s_upper )[0] ;
   float position = NUMERIC_DATA( s_position )[0] ;
   float max_size = NUMERIC_DATA( s_max_size )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ruler_set_range ( ruler, lower, upper, position, max_size );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_button_actions ( USER_OBJECT_ s_clist, USER_OBJECT_ s_button, USER_OBJECT_ s_button_actions )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   unsigned int button = INTEGER_DATA( s_button )[0] ;
   unsigned int button_actions = INTEGER_DATA( s_button_actions )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_button_actions ( clist, button, button_actions );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_option_menu_get_menu ( USER_OBJECT_ s_option_menu )
{
   GtkOptionMenu * option_menu = GTK_OPTION_MENU ((GtkObject*) getPtrValue( s_option_menu )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_option_menu_get_menu ( option_menu );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_rc_style ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_rc_style ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_item_deselect ( USER_OBJECT_ s_list_item )
{
   GtkListItem * list_item = GTK_LIST_ITEM ((GtkObject*) getPtrValue( s_list_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_item_deselect ( list_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_draw_trough ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_draw_trough ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_reorderable ( USER_OBJECT_ s_clist, USER_OBJECT_ s_reorderable )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   Rboolean reorderable = LOGICAL_DATA( s_reorderable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_reorderable ( clist, reorderable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_freeze ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_freeze ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_row_is_visible ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_row_is_visible ( clist, row );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_set_resize_mode ( USER_OBJECT_ s_container, USER_OBJECT_ s_resize_mode )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkResizeMode resize_mode = ( GtkResizeMode ) INTEGER_DATA( s_resize_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_set_resize_mode ( container, resize_mode );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_pop_colormap (  )
{


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_pop_colormap (  );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_label_refetch ( USER_OBJECT_ s_accel_label )
{
   GtkAccelLabel * accel_label = GTK_ACCEL_LABEL ((GtkObject*) getPtrValue( s_accel_label )) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_label_refetch ( accel_label );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tearoff_menu_item_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tearoff_menu_item_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_get_value_as_int ( USER_OBJECT_ s_spin_button )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_spin_button_get_value_as_int ( spin_button );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_value ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_value )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   float value = NUMERIC_DATA( s_value )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_value ( spin_button, value );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_scroll_adjustments ( USER_OBJECT_ s_widget, USER_OBJECT_ s_hadjustment, USER_OBJECT_ s_vadjustment )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkAdjustment * hadjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadjustment )) ;
   GtkAdjustment * vadjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadjustment )) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_set_scroll_adjustments ( widget, hadjustment, vadjustment );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_highlight ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_highlight ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_prepend ( USER_OBJECT_ s_menu_shell, USER_OBJECT_ s_child )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_prepend ( menu_shell, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_set_position ( USER_OBJECT_ s_entry, USER_OBJECT_ s_position )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_set_position ( entry, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_set_colors ( USER_OBJECT_ s_tooltips, USER_OBJECT_ s_background, USER_OBJECT_ s_foreground )
{
   GtkTooltips * tooltips = GTK_TOOLTIPS ((GtkObject*) getPtrValue( s_tooltips )) ;
   GdkColor * background = ( GdkColor * ) getPtrValue( s_background ) ;
   GdkColor * foreground = ( GdkColor * ) getPtrValue( s_foreground ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tooltips_set_colors ( tooltips, background, foreground );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_queue_clear_area ( USER_OBJECT_ s_widget, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_queue_clear_area ( widget, x, y, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_calendar_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_set_max_length ( USER_OBJECT_ s_entry, USER_OBJECT_ s_max )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   unsigned int max = INTEGER_DATA( s_max )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_set_max_length ( entry, max );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scrolled_window_set_hadjustment ( USER_OBJECT_ s_scrolled_window, USER_OBJECT_ s_adjustment )
{
   GtkScrolledWindow * scrolled_window = GTK_SCROLLED_WINDOW ((GtkObject*) getPtrValue( s_scrolled_window )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scrolled_window_set_hadjustment ( scrolled_window, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_size ( USER_OBJECT_ s_preview, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkPreview * preview = GTK_PREVIEW ((GtkObject*) getPtrValue( s_preview )) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_size ( preview, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_is_viewable ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_is_viewable ( ctree, node );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_min_width ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_min_width )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   int min_width = INTEGER_DATA( s_min_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_min_width ( clist, column, min_width );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_adjustment ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_adjustment )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_adjustment ( spin_button, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_select_row ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_select_row ( clist, row, column );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_rc_parse_string ( USER_OBJECT_ s_rc_string )
{
   string rc_string = CHAR_DEREF( STRING_ELT( s_rc_string , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_rc_parse_string ( rc_string );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_row_style ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_style )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_row_style ( clist, row, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_show_tabs ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_show_tabs )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   Rboolean show_tabs = LOGICAL_DATA( s_show_tabs )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_show_tabs ( notebook, show_tabs );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_unselect_all ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_unselect_all ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_attach_defaults ( USER_OBJECT_ s_table, USER_OBJECT_ s_child, USER_OBJECT_ s_left_attach, USER_OBJECT_ s_right_attach, USER_OBJECT_ s_top_attach, USER_OBJECT_ s_bottom_attach )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int left_attach = INTEGER_DATA( s_left_attach )[0] ;
   int right_attach = INTEGER_DATA( s_right_attach )[0] ;
   int top_attach = INTEGER_DATA( s_top_attach )[0] ;
   int bottom_attach = INTEGER_DATA( s_bottom_attach )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_attach_defaults ( table, child, left_attach, right_attach, top_attach, bottom_attach );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_select_month ( USER_OBJECT_ s_calendar, USER_OBJECT_ s_month, USER_OBJECT_ s_year )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;
   unsigned int month = INTEGER_DATA( s_month )[0] ;
   unsigned int year = INTEGER_DATA( s_year )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_calendar_select_month ( calendar, month, year );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hbutton_box_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hbutton_box_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_scroll_vertical ( USER_OBJECT_ s_list, USER_OBJECT_ s_scroll_type, USER_OBJECT_ s_pos )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkScrollType scroll_type = ( GtkScrollType ) INTEGER_DATA( s_scroll_type )[0] ;
   float pos = NUMERIC_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_scroll_vertical ( list, scroll_type, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_style ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_style ( widget );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vbutton_box_get_spacing_default (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vbutton_box_get_spacing_default (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_parent_window ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GdkWindow * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_parent_window ( widget );
   _result = toRPointer(ans, "GdkWindow");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_remove_accelerators ( USER_OBJECT_ s_widget, USER_OBJECT_ s_signal_name, USER_OBJECT_ s_visible_only )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string signal_name = CHAR_DEREF( STRING_ELT( s_signal_name , 0)) ;
   Rboolean visible_only = LOGICAL_DATA( s_visible_only )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_remove_accelerators ( widget, signal_name, visible_only );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_pack_end ( USER_OBJECT_ s_box, USER_OBJECT_ s_child, USER_OBJECT_ s_expand, USER_OBJECT_ s_fill, USER_OBJECT_ s_padding )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   Rboolean expand = LOGICAL_DATA( s_expand )[0] ;
   Rboolean fill = LOGICAL_DATA( s_fill )[0] ;
   int padding = INTEGER_DATA( s_padding )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_pack_end ( box, child, expand, fill, padding );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scale_draw_value ( USER_OBJECT_ s_scale )
{
   GtkScale * scale = GTK_SCALE ((GtkObject*) getPtrValue( s_scale )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scale_draw_value ( scale );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_column_widget ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_column_widget ( clist, column );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_lock_accelerators ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_lock_accelerators ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_set_space_size ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_space_size )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   int space_size = INTEGER_DATA( s_space_size )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_set_space_size ( toolbar, space_size );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_disable ( USER_OBJECT_ s_tooltips )
{
   GtkTooltips * tooltips = GTK_TOOLTIPS ((GtkObject*) getPtrValue( s_tooltips )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tooltips_disable ( tooltips );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_child_position ( USER_OBJECT_ s_list, USER_OBJECT_ s_child )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_list_child_position ( list, child );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_get_button_relief ( USER_OBJECT_ s_toolbar )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;


    GtkReliefStyle ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toolbar_get_button_relief ( toolbar );
   _result =  S_check_GtkReliefStyle_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_unselect_row ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_unselect_row ( clist, row, column );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_put ( USER_OBJECT_ s_preview, USER_OBJECT_ s_window, USER_OBJECT_ s_gc, USER_OBJECT_ s_srcx, USER_OBJECT_ s_srcy, USER_OBJECT_ s_destx, USER_OBJECT_ s_desty, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkPreview * preview = GTK_PREVIEW ((GtkObject*) getPtrValue( s_preview )) ;
   GdkWindow * window = ( GdkWindow * ) getPtrValue( s_window ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   int srcx = INTEGER_DATA( s_srcx )[0] ;
   int srcy = INTEGER_DATA( s_srcy )[0] ;
   int destx = INTEGER_DATA( s_destx )[0] ;
   int desty = INTEGER_DATA( s_desty )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_put ( preview, window, gc, srcx, srcy, destx, desty, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_alignment_new ( USER_OBJECT_ s_xalign, USER_OBJECT_ s_yalign, USER_OBJECT_ s_xscale, USER_OBJECT_ s_yscale )
{
   float xalign = NUMERIC_DATA( s_xalign )[0] ;
   float yalign = NUMERIC_DATA( s_yalign )[0] ;
   float xscale = NUMERIC_DATA( s_xscale )[0] ;
   float yscale = NUMERIC_DATA( s_yscale )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_alignment_new ( xalign, yalign, xscale, yscale );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_default_style ( USER_OBJECT_ s_style )
{
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_default_style ( style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_lock_entry ( USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_lock_entry ( group, key, modifiers );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_file_selection_hide_fileop_buttons ( USER_OBJECT_ s_filesel )
{
   GtkFileSelection * filesel = GTK_FILE_SELECTION ((GtkObject*) getPtrValue( s_filesel )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_file_selection_hide_fileop_buttons ( filesel );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_insert_space ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_position )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_insert_space ( toolbar, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_pos ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_pos )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkPositionType pos = ( GtkPositionType ) INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_pos ( notebook, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_type_from_name ( USER_OBJECT_ s_name )
{
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_type_from_name ( name );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_deselect ( USER_OBJECT_ s_item )
{
   GtkItem * item = GTK_ITEM ((GtkObject*) getPtrValue( s_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_deselect ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_dest_set_proxy ( USER_OBJECT_ s_widget, USER_OBJECT_ s_proxy_window, USER_OBJECT_ s_protocol, USER_OBJECT_ s_use_coordinates )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkWindow * proxy_window = ( GdkWindow * ) getPtrValue( s_proxy_window ) ;
   GdkDragProtocol protocol = ( GdkDragProtocol ) INTEGER_DATA( s_protocol )[0] ;
   Rboolean use_coordinates = LOGICAL_DATA( s_use_coordinates )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_dest_set_proxy ( widget, proxy_window, protocol, use_coordinates );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_add_events ( USER_OBJECT_ s_widget, USER_OBJECT_ s_events )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkEventMask events = ( GdkEventMask ) INTEGER_DATA( s_events )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_add_events ( widget, events );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_map ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_map ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_selection_remove_all ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_selection_remove_all ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_set_text ( USER_OBJECT_ s_entry, USER_OBJECT_ s_text )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_set_text ( entry, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_label_new ( USER_OBJECT_ s_str )
{
   string str = CHAR_DEREF( STRING_ELT( s_str , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_label_new ( str );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_handle_box_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_handle_box_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_select ( USER_OBJECT_ s_item )
{
   GtkItem * item = GTK_ITEM ((GtkObject*) getPtrValue( s_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_select ( item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_dialog_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_dialog_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_update ( USER_OBJECT_ s_spin_button )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_update ( spin_button );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_add ( USER_OBJECT_ s_container, USER_OBJECT_ s_widget )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_add ( container, widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_rc_load_image ( USER_OBJECT_ s_colormap, USER_OBJECT_ s_transparent_color, USER_OBJECT_ s_filename )
{
   GdkColormap * colormap = ( GdkColormap * ) getPtrValue( s_colormap ) ;
   GdkColor * transparent_color = ( GdkColor * ) getPtrValue( s_transparent_color ) ;
   string filename = CHAR_DEREF( STRING_ELT( s_filename , 0)) ;


    GdkPixmap * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_rc_load_image ( colormap, transparent_color, filename );
   _result = toRPointer(ans, "GdkPixmap");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hseparator_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hseparator_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_real_select_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_state )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int state = INTEGER_DATA( s_state )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_real_select_recursive ( ctree, node, state );


  return(_result);
}
 

USER_OBJECT_
 S_GTK_OBJECT_FLAGS ( USER_OBJECT_ s_object )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


    GtkWidgetFlags ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  GTK_OBJECT_FLAGS ( object );
   _result =  S_check_GtkWidgetFlags_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_statusbar_remove ( USER_OBJECT_ s_statusbar, USER_OBJECT_ s_context_id, USER_OBJECT_ s_message_id )
{
   GtkStatusbar * statusbar = GTK_STATUSBAR ((GtkObject*) getPtrValue( s_statusbar )) ;
   unsigned int context_id = INTEGER_DATA( s_context_id )[0] ;
   unsigned int message_id = INTEGER_DATA( s_message_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_statusbar_remove ( statusbar, context_id, message_id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_max_width ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_max_width )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   int max_width = INTEGER_DATA( s_max_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_max_width ( clist, column, max_width );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_column_titles_passive ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_column_titles_passive ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_expand ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_expand ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_sensitive ( USER_OBJECT_ s_widget, USER_OBJECT_ s_sensitive )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   Rboolean sensitive = LOGICAL_DATA( s_sensitive )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_sensitive ( widget, sensitive );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scale_get_value_width ( USER_OBJECT_ s_scale )
{
   GtkScale * scale = GTK_SCALE ((GtkObject*) getPtrValue( s_scale )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_scale_get_value_width ( scale );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_quit_remove ( USER_OBJECT_ s_quit_id )
{
   unsigned int quit_id = INTEGER_DATA( s_quit_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_quit_remove ( quit_id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_last ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


    GtkCTreeNode * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_last ( ctree, node );
   _result = toRPointer(ans, "GtkCTreeNode");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vbutton_box_set_layout_default ( USER_OBJECT_ s_layout )
{
   GtkButtonBoxStyle layout = ( GtkButtonBoxStyle ) INTEGER_DATA( s_layout )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_vbutton_box_set_layout_default ( layout );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_gamma_curve_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_gamma_curve_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_show_now ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_show_now ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_set_case_sensitive ( USER_OBJECT_ s_combo, USER_OBJECT_ s_val )
{
   GtkCombo * combo = GTK_COMBO ((GtkObject*) getPtrValue( s_combo )) ;
   Rboolean val = LOGICAL_DATA( s_val )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_combo_set_case_sensitive ( combo, val );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_set_discrete_blocks ( USER_OBJECT_ s_pbar, USER_OBJECT_ s_blocks )
{
   GtkProgressBar * pbar = GTK_PROGRESS_BAR ((GtkObject*) getPtrValue( s_pbar )) ;
   unsigned int blocks = INTEGER_DATA( s_blocks )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_bar_set_discrete_blocks ( pbar, blocks );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_prepend_space ( USER_OBJECT_ s_toolbar )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_prepend_space ( toolbar );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_extend_selection ( USER_OBJECT_ s_list, USER_OBJECT_ s_scroll_type, USER_OBJECT_ s_position, USER_OBJECT_ s_auto_start )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;
   GtkScrollType scroll_type = ( GtkScrollType ) INTEGER_DATA( s_scroll_type )[0] ;
   float position = NUMERIC_DATA( s_position )[0] ;
   Rboolean auto_start = LOGICAL_DATA( s_auto_start )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_extend_selection ( list, scroll_type, position, auto_start );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_set_homogeneous ( USER_OBJECT_ s_box, USER_OBJECT_ s_homogenous )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   Rboolean homogenous = LOGICAL_DATA( s_homogenous )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_set_homogeneous ( box, homogenous );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_button_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gdk_cursor_new ( USER_OBJECT_ s_cursor_type )
{
   GdkCursorType cursor_type = ( GdkCursorType ) INTEGER_DATA( s_cursor_type )[0] ;


    GdkCursor * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_cursor_new ( cursor_type );
   _result = toRPointer(ans, "GdkCursor");


  return(_result);
}
 

USER_OBJECT_
 S_GTK_OBJECT_SET_FLAGS ( USER_OBJECT_ s_object, USER_OBJECT_ s_flags )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   GtkWidgetFlags flags = ( GtkWidgetFlags ) INTEGER_DATA( s_flags )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  GTK_OBJECT_SET_FLAGS ( object, flags );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_set_vadjustment ( USER_OBJECT_ s_layout, USER_OBJECT_ s_adjustment )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_set_vadjustment ( layout, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_queue_draw ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_queue_draw ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_set_subtree ( USER_OBJECT_ s_tree_item, USER_OBJECT_ s_subtree )
{
   GtkTreeItem * tree_item = GTK_TREE_ITEM ((GtkObject*) getPtrValue( s_tree_item )) ;
   GtkWidget * subtree = GTK_WIDGET ((GtkObject*) getPtrValue( s_subtree )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_item_set_subtree ( tree_item, subtree );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_prev_page ( USER_OBJECT_ s_notebook )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_prev_page ( notebook );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_default_colormap ( USER_OBJECT_ s_cmap )
{
   GdkColormap * cmap = ( GdkColormap * ) getPtrValue( s_cmap ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_default_colormap ( cmap );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_set_child_size ( USER_OBJECT_ s_widget, USER_OBJECT_ s_min_width, USER_OBJECT_ s_min_height )
{
   GtkButtonBox * widget = GTK_BUTTON_BOX ((GtkObject*) getPtrValue( s_widget )) ;
   int min_width = INTEGER_DATA( s_min_width )[0] ;
   int min_height = INTEGER_DATA( s_min_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_box_set_child_size ( widget, min_width, min_height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_append_space ( USER_OBJECT_ s_toolbar )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_append_space ( toolbar );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_set_child_ipadding_default ( USER_OBJECT_ s_ipad_x, USER_OBJECT_ s_ipad_y )
{
   int ipad_x = INTEGER_DATA( s_ipad_x )[0] ;
   int ipad_y = INTEGER_DATA( s_ipad_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_box_set_child_ipadding_default ( ipad_x, ipad_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_set_default_pad ( USER_OBJECT_ s_packer, USER_OBJECT_ s_pad_x, USER_OBJECT_ s_pad_y )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   unsigned int pad_x = INTEGER_DATA( s_pad_x )[0] ;
   unsigned int pad_y = INTEGER_DATA( s_pad_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_set_default_pad ( packer, pad_x, pad_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_cut_clipboard ( USER_OBJECT_ s_edtiable )
{
   GtkEditable * edtiable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_edtiable )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_cut_clipboard ( edtiable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_packer_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_set_gamma ( USER_OBJECT_ s_gamma )
{
   double gamma = NUMERIC_DATA( s_gamma )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_set_gamma ( gamma );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_remove_subtree ( USER_OBJECT_ s_tree_item )
{
   GtkTreeItem * tree_item = GTK_TREE_ITEM ((GtkObject*) getPtrValue( s_tree_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_item_remove_subtree ( tree_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_shift ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column, USER_OBJECT_ s_vertical, USER_OBJECT_ s_horizontal )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;
   int vertical = INTEGER_DATA( s_vertical )[0] ;
   int horizontal = INTEGER_DATA( s_horizontal )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_shift ( clist, row, column, vertical, horizontal );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_get_current_page ( USER_OBJECT_ s_notebook )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_notebook_get_current_page ( notebook );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_remove_submenu ( USER_OBJECT_ s_menu_item )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_remove_submenu ( menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_cell_type ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;


    GtkCellType ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_cell_type ( clist, row, column );
   _result =  S_check_GtkCellType_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gdk_fontset_load ( USER_OBJECT_ s_name )
{
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


    GdkFont * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_fontset_load ( name );
   _result = toRPointer(ans, "GdkFont");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_thaw ( USER_OBJECT_ s_calendar )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_calendar_thaw ( calendar );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_set_homogeneous ( USER_OBJECT_ s_table, USER_OBJECT_ s_homogeneous )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   Rboolean homogeneous = LOGICAL_DATA( s_homogeneous )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_set_homogeneous ( table, homogeneous );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_cell_style ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_cell_style ( clist, row, column );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_ancestor ( USER_OBJECT_ s_widget, USER_OBJECT_ s_type )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   unsigned int type = INTEGER_DATA( s_type )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_ancestor ( widget, type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_grab_remove ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_grab_remove ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_deselect ( USER_OBJECT_ s_menu_item )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_deselect ( menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_thaw ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_thaw ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_set_child_ipadding ( USER_OBJECT_ s_widget, USER_OBJECT_ s_ipad_x, USER_OBJECT_ s_ipad_y )
{
   GtkButtonBox * widget = GTK_BUTTON_BOX ((GtkObject*) getPtrValue( s_widget )) ;
   int ipad_x = INTEGER_DATA( s_ipad_x )[0] ;
   int ipad_y = INTEGER_DATA( s_ipad_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_box_set_child_ipadding ( widget, ipad_x, ipad_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_collapse ( USER_OBJECT_ s_tree_item )
{
   GtkTreeItem * tree_item = GTK_TREE_ITEM ((GtkObject*) getPtrValue( s_tree_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_item_collapse ( tree_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_set_activity_step ( USER_OBJECT_ s_pbar, USER_OBJECT_ s_step )
{
   GtkProgressBar * pbar = GTK_PROGRESS_BAR ((GtkObject*) getPtrValue( s_pbar )) ;
   unsigned int step = INTEGER_DATA( s_step )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_bar_set_activity_step ( pbar, step );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_unselect_item ( USER_OBJECT_ s_tree, USER_OBJECT_ s_item )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   int item = INTEGER_DATA( s_item )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_unselect_item ( tree, item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_realize ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_realize ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_unrealize ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_unrealize ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_column_title_active ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_column_title_active ( clist, column );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_is_ancestor ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_child )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   GtkCTreeNode * child = ( GtkCTreeNode * ) getPtrValue( s_child ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_is_ancestor ( ctree, node, child );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_uposition ( USER_OBJECT_ s_widget, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_uposition ( widget, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_set_orientation ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_orientation )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   GtkOrientation orientation = ( GtkOrientation ) INTEGER_DATA( s_orientation )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toolbar_set_orientation ( toolbar, orientation );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_show ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_show ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_new ( USER_OBJECT_ s_adjustment, USER_OBJECT_ s_climb_rate, USER_OBJECT_ s_digits )
{
   GtkAdjustment * adjustment = Rf_length( s_adjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;
   float climb_rate = NUMERIC_DATA( s_climb_rate )[0] ;
   unsigned int digits = INTEGER_DATA( s_digits )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_spin_button_new ( adjustment, climb_rate, digits );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_parent_window ( USER_OBJECT_ s_widget, USER_OBJECT_ s_parent_window )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkWindow * parent_window = ( GdkWindow * ) getPtrValue( s_parent_window ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_parent_window ( widget, parent_window );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drawing_area_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_drawing_area_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_label_set_pattern ( USER_OBJECT_ s_label, USER_OBJECT_ s_pattern )
{
   GtkLabel * label = GTK_LABEL ((GtkObject*) getPtrValue( s_label )) ;
   string pattern = CHAR_DEREF( STRING_ELT( s_pattern , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_label_set_pattern ( label, pattern );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_set_view_lines ( USER_OBJECT_ s_tree, USER_OBJECT_ s_flag )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   Rboolean flag = LOGICAL_DATA( s_flag )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_set_view_lines ( tree, flag );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_new ( USER_OBJECT_ s_type )
{
   GtkWindowType type = ( GtkWindowType ) INTEGER_DATA( s_type )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_window_new ( type );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_thaw ( USER_OBJECT_ s_layout )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_thaw ( layout );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_get_adjustment ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_range_get_adjustment ( range );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_put ( USER_OBJECT_ s_layout, USER_OBJECT_ s_child, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_put ( layout, child, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_homogeneous_tabs ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_homogeneous )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   Rboolean homogeneous = LOGICAL_DATA( s_homogeneous )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_homogeneous_tabs ( notebook, homogeneous );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_activate_default ( USER_OBJECT_ s_window )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_window_activate_default ( window );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_selection_convert ( USER_OBJECT_ s_widget, USER_OBJECT_ s_selection, USER_OBJECT_ s_target, USER_OBJECT_ s_time )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkAtom selection = ( GdkAtom) NUMERIC_DATA( s_selection )[0] ;
   GdkAtom target = ( GdkAtom) NUMERIC_DATA( s_target )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_selection_convert ( widget, selection, target, time );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_shell_deselect ( USER_OBJECT_ s_menu_shell )
{
   GtkMenuShell * menu_shell = GTK_MENU_SHELL ((GtkObject*) getPtrValue( s_menu_shell )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_shell_deselect ( menu_shell );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_toplevel ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_toplevel ( widget );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_attach ( USER_OBJECT_ s_table, USER_OBJECT_ s_child, USER_OBJECT_ s_left_attach, USER_OBJECT_ s_right_attach, USER_OBJECT_ s_top_attach, USER_OBJECT_ s_bottom_attach, USER_OBJECT_ s_xoptions, USER_OBJECT_ s_yoptions, USER_OBJECT_ s_xpadding, USER_OBJECT_ s_ypadding )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int left_attach = INTEGER_DATA( s_left_attach )[0] ;
   int right_attach = INTEGER_DATA( s_right_attach )[0] ;
   int top_attach = INTEGER_DATA( s_top_attach )[0] ;
   int bottom_attach = INTEGER_DATA( s_bottom_attach )[0] ;
   GtkAttachOptions xoptions = ( GtkAttachOptions ) INTEGER_DATA( s_xoptions )[0] ;
   GtkAttachOptions yoptions = ( GtkAttachOptions ) INTEGER_DATA( s_yoptions )[0] ;
   int xpadding = INTEGER_DATA( s_xpadding )[0] ;
   int ypadding = INTEGER_DATA( s_ypadding )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_attach ( table, child, left_attach, right_attach, top_attach, bottom_attach, xoptions, yoptions, xpadding, ypadding );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_draw_focus ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_draw_focus ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_set_title ( USER_OBJECT_ s_menu, USER_OBJECT_ s_title )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_set_title ( menu, title );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_widget ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_widget )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_widget ( clist, column, widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_show_text ( USER_OBJECT_ s_progress, USER_OBJECT_ s_show_text )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   int show_text = INTEGER_DATA( s_show_text )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_show_text ( progress, show_text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_display_options ( USER_OBJECT_ s_calendar, USER_OBJECT_ s_flags )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;
   GtkCalendarDisplayOptions flags = ( GtkCalendarDisplayOptions ) INTEGER_DATA( s_flags )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_calendar_display_options ( calendar, flags );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_freeze ( USER_OBJECT_ s_text )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_freeze ( text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_set_spacing ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_spacing )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_set_spacing ( ctree, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_transient_for ( USER_OBJECT_ s_window, USER_OBJECT_ s_parent )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   GtkWindow * parent = GTK_WINDOW ((GtkObject*) getPtrValue( s_parent )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_transient_for ( window, parent );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_freeze ( USER_OBJECT_ s_calendar )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_calendar_freeze ( calendar );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_signal_emit_stop_by_name ( USER_OBJECT_ s_object, USER_OBJECT_ s_name )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_signal_emit_stop_by_name ( object, name );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_radio_button_new_with_label_from_widget ( USER_OBJECT_ s_group, USER_OBJECT_ s_label )
{
   GtkRadioButton * group = Rf_length( s_group ) == 0 ? NULL :  GTK_RADIO_BUTTON ((GtkObject*) getPtrValue( s_group )) ;
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_radio_button_new_with_label_from_widget ( group, label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_get_layout ( USER_OBJECT_ s_widget )
{
   GtkButtonBox * widget = GTK_BUTTON_BOX ((GtkObject*) getPtrValue( s_widget )) ;


    GtkButtonBoxStyle ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_button_box_get_layout ( widget );
   _result =  S_check_GtkButtonBoxStyle_value (asRInt( ans ));


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_register_toplevel ( USER_OBJECT_ s_container )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_register_toplevel ( container );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_name ( USER_OBJECT_ s_widget, USER_OBJECT_ s_name )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_name ( widget, name );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_remove ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_remove ( clist, row );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_select ( USER_OBJECT_ s_menu_item )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_select ( menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_released ( USER_OBJECT_ s_button )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_released ( button );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_timeout_remove ( USER_OBJECT_ s_tag )
{
   int tag = INTEGER_DATA( s_tag )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_timeout_remove ( tag );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_append ( USER_OBJECT_ s_menu, USER_OBJECT_ s_child )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_append ( menu, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_hide ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_hide ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_toggle_add_mode ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_toggle_add_mode ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_forward_delete ( USER_OBJECT_ s_text, USER_OBJECT_ s_nchars )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   unsigned int nchars = INTEGER_DATA( s_nchars )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_forward_delete ( text, nchars );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hscale_new ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = Rf_length( s_adjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hscale_new ( adjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_main_quit (  )
{


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_main_quit (  );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_restore_default_style ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_restore_default_style ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_item_right_justify ( USER_OBJECT_ s_menu_item )
{
   GtkMenuItem * menu_item = GTK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_item_right_justify ( menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_pack_start_defaults ( USER_OBJECT_ s_box, USER_OBJECT_ s_child )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_pack_start_defaults ( box, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_set_color_cube ( USER_OBJECT_ s_nred_shades, USER_OBJECT_ s_ngreen_shades, USER_OBJECT_ s_nblue_shades, USER_OBJECT_ s_ngray_shades )
{
   unsigned int nred_shades = INTEGER_DATA( s_nred_shades )[0] ;
   unsigned int ngreen_shades = INTEGER_DATA( s_ngreen_shades )[0] ;
   unsigned int nblue_shades = INTEGER_DATA( s_nblue_shades )[0] ;
   unsigned int ngray_shades = INTEGER_DATA( s_ngray_shades )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_set_color_cube ( nred_shades, ngreen_shades, nblue_shades, ngray_shades );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_unlock_accelerators ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_unlock_accelerators ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_set_adjustment ( USER_OBJECT_ s_range, USER_OBJECT_ s_adjustment )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_set_adjustment ( range, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_set_font_name ( USER_OBJECT_ s_fontsel, USER_OBJECT_ s_fontname )
{
   GtkFontSelection * fontsel = GTK_FONT_SELECTION ((GtkObject*) getPtrValue( s_fontsel )) ;
   string fontname = CHAR_DEREF( STRING_ELT( s_fontname , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_set_font_name ( fontsel, fontname );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_accelerators_locked ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_accelerators_locked ( widget );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_get_font_name ( USER_OBJECT_ s_fontsel )
{
   GtkFontSelection * fontsel = GTK_FONT_SELECTION ((GtkObject*) getPtrValue( s_fontsel )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_get_font_name ( fontsel );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_viewport_set_hadjustment ( USER_OBJECT_ s_viewport, USER_OBJECT_ s_adjustment )
{
   GtkViewport * viewport = GTK_VIEWPORT ((GtkObject*) getPtrValue( s_viewport )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_viewport_set_hadjustment ( viewport, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_remove ( USER_OBJECT_ s_container, USER_OBJECT_ s_widget )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_remove ( container, widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_column_title ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_column_title ( clist, column );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_finish ( USER_OBJECT_ s_context, USER_OBJECT_ s_success, USER_OBJECT_ s_del, USER_OBJECT_ s_time )
{
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;
   Rboolean success = LOGICAL_DATA( s_success )[0] ;
   Rboolean del = LOGICAL_DATA( s_del )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_finish ( context, success, del, time );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_new_with_titles ( USER_OBJECT_ s_columns, USER_OBJECT_ s_titles )
{
   int columns = INTEGER_DATA( s_columns )[0] ;
   string * titles = asCStringArray( s_titles ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_new_with_titles ( columns, titles );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_menu_label_text ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_menu_text )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   string menu_text = CHAR_DEREF( STRING_ELT( s_menu_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_menu_label_text ( notebook, child, menu_text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_insert_page_menu ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_label, USER_OBJECT_ s_menu_label, USER_OBJECT_ s_position )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkWidget * tab_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_tab_label )) ;
   GtkWidget * menu_label = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu_label )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_insert_page_menu ( notebook, child, tab_label, menu_label, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_nth ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_row )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   unsigned int row = INTEGER_DATA( s_row )[0] ;


    GtkCTreeNode * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_node_nth ( ctree, row );
   _result = toRPointer(ans, "GtkCTreeNode");   _result = toRPointer(ans, "null-ok");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_sort_column ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_sort_column ( clist, column );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_set_modal ( USER_OBJECT_ s_window, USER_OBJECT_ s_modal )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   Rboolean modal = LOGICAL_DATA( s_modal )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_set_modal ( window, modal );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_adjustment_set_value ( USER_OBJECT_ s_adjustment, USER_OBJECT_ s_value )
{
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;
   float value = NUMERIC_DATA( s_value )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_adjustment_set_value ( adjustment, value );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_get_attach_widget ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_get_attach_widget ( menu );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_default_style (  )
{


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_default_style (  );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_color_selection_set_opacity ( USER_OBJECT_ s_colorsel, USER_OBJECT_ s_use_opacity )
{
   GtkColorSelection * colorsel = GTK_COLOR_SELECTION ((GtkObject*) getPtrValue( s_colorsel )) ;
   Rboolean use_opacity = LOGICAL_DATA( s_use_opacity )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_color_selection_set_opacity ( colorsel, use_opacity );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_select_all ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_select_all ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_bar_set_activity_blocks ( USER_OBJECT_ s_pbar, USER_OBJECT_ s_blocks )
{
   GtkProgressBar * pbar = GTK_PROGRESS_BAR ((GtkObject*) getPtrValue( s_pbar )) ;
   unsigned int blocks = INTEGER_DATA( s_blocks )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_bar_set_activity_blocks ( pbar, blocks );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_frame_set_label ( USER_OBJECT_ s_frame, USER_OBJECT_ s_label )
{
   GtkFrame * frame = GTK_FRAME ((GtkObject*) getPtrValue( s_frame )) ;
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_frame_set_label ( frame, label );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_snap_to_ticks ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_snap_to_ticks )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   Rboolean snap_to_ticks = LOGICAL_DATA( s_snap_to_ticks )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_snap_to_ticks ( spin_button, snap_to_ticks );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_option_menu_set_menu ( USER_OBJECT_ s_option_menu, USER_OBJECT_ s_menu )
{
   GtkOptionMenu * option_menu = GTK_OPTION_MENU ((GtkObject*) getPtrValue( s_option_menu )) ;
   GtkWidget * menu = GTK_WIDGET ((GtkObject*) getPtrValue( s_menu )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_option_menu_set_menu ( option_menu, menu );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_signal_handler_unblock ( USER_OBJECT_ s_object, USER_OBJECT_ s_id )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   unsigned int id = INTEGER_DATA( s_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_signal_handler_unblock ( object, id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_toggle_focus_row ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_toggle_focus_row ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_accelerator_signal ( USER_OBJECT_ s_widget, USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_accelerator_signal ( widget, group, key, modifiers );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_expand ( USER_OBJECT_ s_tree_item )
{
   GtkTreeItem * tree_item = GTK_TREE_ITEM ((GtkObject*) getPtrValue( s_tree_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_item_expand ( tree_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_row_style ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_style )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_row_style ( ctree, node, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_parent ( USER_OBJECT_ s_widget, USER_OBJECT_ s_parent )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkWidget * parent = GTK_WIDGET ((GtkObject*) getPtrValue( s_parent )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_parent ( widget, parent );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_selectable ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_selectable )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   Rboolean selectable = LOGICAL_DATA( s_selectable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_selectable ( ctree, node, selectable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_resize_children ( USER_OBJECT_ s_container )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_resize_children ( container );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_entry_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_hadjustment ( USER_OBJECT_ s_clist, USER_OBJECT_ s_adjustment )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_hadjustment ( clist, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_prepend ( USER_OBJECT_ s_menu, USER_OBJECT_ s_child )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_prepend ( menu, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_add_accel_group ( USER_OBJECT_ s_window, USER_OBJECT_ s_group )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_add_accel_group ( window, group );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_adjustment_changed ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_adjustment_changed ( adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_set_reserved ( USER_OBJECT_ s_nreserved )
{
   int nreserved = INTEGER_DATA( s_nreserved )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_set_reserved ( nreserved );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_check_resize ( USER_OBJECT_ s_container )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_check_resize ( container );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_dialog_set_font_name ( USER_OBJECT_ s_fsd, USER_OBJECT_ s_fontname )
{
   GtkFontSelectionDialog * fsd = GTK_FONT_SELECTION_DIALOG ((GtkObject*) getPtrValue( s_fsd )) ;
   string fontname = CHAR_DEREF( STRING_ELT( s_fontname , 0)) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_dialog_set_font_name ( fsd, fontname );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_draw_background ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_draw_background ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_set_default_ipad ( USER_OBJECT_ s_packer, USER_OBJECT_ s_ipad_x, USER_OBJECT_ s_ipad_y )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   unsigned int ipad_x = INTEGER_DATA( s_ipad_x )[0] ;
   unsigned int ipad_y = INTEGER_DATA( s_ipad_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_set_default_ipad ( packer, ipad_x, ipad_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_child_position ( USER_OBJECT_ s_tree, USER_OBJECT_ s_child )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tree_child_position ( tree, child );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_move ( USER_OBJECT_ s_layout, USER_OBJECT_ s_child, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_move ( layout, child, x, y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_page ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_page_num )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   int page_num = INTEGER_DATA( s_page_num )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_page ( notebook, page_num );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_statusbar_pop ( USER_OBJECT_ s_statusbar, USER_OBJECT_ s_context_id )
{
   GtkStatusbar * statusbar = GTK_STATUSBAR ((GtkObject*) getPtrValue( s_statusbar )) ;
   unsigned int context_id = INTEGER_DATA( s_context_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_statusbar_pop ( statusbar, context_id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_disable_activate ( USER_OBJECT_ s_combo )
{
   GtkCombo * combo = GTK_COMBO ((GtkObject*) getPtrValue( s_combo )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_combo_disable_activate ( combo );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_set_spacing ( USER_OBJECT_ s_box, USER_OBJECT_ s_spacing )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_set_spacing ( box, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_cursor_new_from_pixmap ( USER_OBJECT_ s_source, USER_OBJECT_ s_mask, USER_OBJECT_ s_fg, USER_OBJECT_ s_bg, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GdkPixmap * source = ( GdkPixmap * ) getPtrValue( s_source ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;
   GdkColor * fg = ( GdkColor * ) getPtrValue( s_fg ) ;
   GdkColor * bg = ( GdkColor * ) getPtrValue( s_bg ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


    GdkCursor * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_cursor_new_from_pixmap ( source, mask, fg, bg, x, y );
   _result = toRPointer(ans, "GdkCursor");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_signal_disconnect ( USER_OBJECT_ s_object, USER_OBJECT_ s_handler_id )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   unsigned int handler_id = INTEGER_DATA( s_handler_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_signal_disconnect ( object, handler_id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vbutton_box_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vbutton_box_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_file_selection_show_fileop_buttons ( USER_OBJECT_ s_filesel )
{
   GtkFileSelection * filesel = GTK_FILE_SELECTION ((GtkObject*) getPtrValue( s_filesel )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_file_selection_show_fileop_buttons ( filesel );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_clicked ( USER_OBJECT_ s_button )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_clicked ( button );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_set_preview_text ( USER_OBJECT_ s_fontsel, USER_OBJECT_ s_text )
{
   GtkFontSelection * fontsel = GTK_FONT_SELECTION ((GtkObject*) getPtrValue( s_fontsel )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_font_selection_set_preview_text ( fontsel, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_select ( USER_OBJECT_ s_tree_item )
{
   GtkTreeItem * tree_item = GTK_TREE_ITEM ((GtkObject*) getPtrValue( s_tree_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_item_select ( tree_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_lock ( USER_OBJECT_ s_group )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_lock ( group );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_set_border_width ( USER_OBJECT_ s_container, USER_OBJECT_ s_border_width )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   int border_width = INTEGER_DATA( s_border_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_set_border_width ( container, border_width );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_label_text ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_tab_text )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   string tab_text = CHAR_DEREF( STRING_ELT( s_tab_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_label_text ( notebook, child, tab_text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_unparent ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_unparent ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_window_remove_accel_group ( USER_OBJECT_ s_window, USER_OBJECT_ s_group )
{
   GtkWindow * window = GTK_WINDOW ((GtkObject*) getPtrValue( s_window )) ;
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_window_remove_accel_group ( window, group );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_color_selection_dialog_new ( USER_OBJECT_ s_title )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_color_selection_dialog_new ( title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_get_default (  )
{


    GtkAccelGroup * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_group_get_default (  );
   _result = toRPointer(ans, "GtkAccelGroup");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_activity_mode ( USER_OBJECT_ s_progress, USER_OBJECT_ s_activity_mode )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   unsigned int activity_mode = INTEGER_DATA( s_activity_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_activity_mode ( progress, activity_mode );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vseparator_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vseparator_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_composite_name ( USER_OBJECT_ s_widget, USER_OBJECT_ s_name )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   string name = CHAR_DEREF( STRING_ELT( s_name , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_composite_name ( widget, name );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_column_title_passive ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_column_title_passive ( clist, column );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_title ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_title )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_title ( clist, column, title );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_set_line_style ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_style )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeLineStyle style = ( GtkCTreeLineStyle ) INTEGER_DATA( s_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_set_line_style ( ctree, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_prepend_text ( USER_OBJECT_ s_entry, USER_OBJECT_ s_text )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_entry_prepend_text ( entry, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_slider_update ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_slider_update ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_hadjustment ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_hadjustment ( clist );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_button_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_check_button_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_dest_unset ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_dest_unset ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_curve_set_curve_type ( USER_OBJECT_ s_curve, USER_OBJECT_ s_type )
{
   GtkCurve * curve = GTK_CURVE ((GtkObject*) getPtrValue( s_curve )) ;
   GtkCurveType type = ( GtkCurveType ) INTEGER_DATA( s_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_curve_set_curve_type ( curve, type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_new_with_max_length ( USER_OBJECT_ s_max )
{
   int max = INTEGER_DATA( s_max )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_entry_new_with_max_length ( max );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_rc_get_style ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    GtkStyle * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_rc_get_style ( widget );
   _result = toRPointer(ans, "GtkStyle");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_vborder ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_tab_vborder )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   unsigned int tab_vborder = INTEGER_DATA( s_tab_vborder )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_vborder ( notebook, tab_vborder );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_collapse ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_collapse ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_find ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_child )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   GtkCTreeNode * child = ( GtkCTreeNode * ) getPtrValue( s_child ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_find ( ctree, node, child );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_thaw ( USER_OBJECT_ s_text )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_thaw ( text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_delete_item ( USER_OBJECT_ s_ifactory, USER_OBJECT_ s_path )
{
   GtkItemFactory * ifactory = GTK_ITEM_FACTORY ((GtkObject*) getPtrValue( s_ifactory )) ;
   string path = CHAR_DEREF( STRING_ELT( s_path , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_factory_delete_item ( ifactory, path );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_shadow_type ( USER_OBJECT_ s_clist, USER_OBJECT_ s_border )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   GtkShadowType border = ( GtkShadowType ) INTEGER_DATA( s_border )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_shadow_type ( clist, border );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_is_hot_spot ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_x, USER_OBJECT_ s_y )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_is_hot_spot ( ctree, x, y );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_column_titles_show ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_column_titles_show ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_set_child_packing ( USER_OBJECT_ s_packer, USER_OBJECT_ s_child, USER_OBJECT_ s_size, USER_OBJECT_ s_anchor, USER_OBJECT_ s_options, USER_OBJECT_ s_border_width, USER_OBJECT_ s_pad_x, USER_OBJECT_ s_pad_y, USER_OBJECT_ s_ipad_x, USER_OBJECT_ s_ipad_y )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkSideType size = ( GtkSideType ) INTEGER_DATA( s_size )[0] ;
   GtkAnchorType anchor = ( GtkAnchorType ) INTEGER_DATA( s_anchor )[0] ;
   GtkPackerOptions options = ( GtkPackerOptions ) INTEGER_DATA( s_options )[0] ;
   unsigned int border_width = INTEGER_DATA( s_border_width )[0] ;
   unsigned int pad_x = INTEGER_DATA( s_pad_x )[0] ;
   unsigned int pad_y = INTEGER_DATA( s_pad_y )[0] ;
   unsigned int ipad_x = INTEGER_DATA( s_ipad_x )[0] ;
   unsigned int ipad_y = INTEGER_DATA( s_ipad_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_set_child_packing ( packer, child, size, anchor, options, border_width, pad_x, pad_y, ipad_x, ipad_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_state ( USER_OBJECT_ s_widget, USER_OBJECT_ s_state )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GtkStateType state = ( GtkStateType ) INTEGER_DATA( s_state )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_state ( widget, state );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_get_font ( USER_OBJECT_ s_fontsel )
{
   GtkFontSelection * fontsel = GTK_FONT_SELECTION ((GtkObject*) getPtrValue( s_fontsel )) ;


    GdkFont * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_get_font ( fontsel );
   _result = toRPointer(ans, "GdkFont");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_select_child ( USER_OBJECT_ s_tree, USER_OBJECT_ s_child )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_select_child ( tree, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ruler_draw_pos ( USER_OBJECT_ s_ruler )
{
   GtkRuler * ruler = GTK_RULER ((GtkObject*) getPtrValue( s_ruler )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ruler_draw_pos ( ruler );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hbutton_box_get_spacing_default (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hbutton_box_get_spacing_default (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_popup ( USER_OBJECT_ s_ifactory, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_mouse_button, USER_OBJECT_ s_time )
{
   GtkItemFactory * ifactory = GTK_ITEM_FACTORY ((GtkObject*) getPtrValue( s_ifactory )) ;
   unsigned int x = INTEGER_DATA( s_x )[0] ;
   unsigned int y = INTEGER_DATA( s_y )[0] ;
   unsigned int mouse_button = INTEGER_DATA( s_mouse_button )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_factory_popup ( ifactory, x, y, mouse_button, time );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_scrollable ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_scrollable )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   int scrollable = INTEGER_DATA( s_scrollable )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_scrollable ( notebook, scrollable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_percentage ( USER_OBJECT_ s_progress, USER_OBJECT_ s_percentage )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   float percentage = NUMERIC_DATA( s_percentage )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_percentage ( progress, percentage );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_set_value_in_list ( USER_OBJECT_ s_combo, USER_OBJECT_ s_val, USER_OBJECT_ s_ok_if_empty )
{
   GtkCombo * combo = GTK_COMBO ((GtkObject*) getPtrValue( s_combo )) ;
   Rboolean val = LOGICAL_DATA( s_val )[0] ;
   Rboolean ok_if_empty = LOGICAL_DATA( s_ok_if_empty )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_combo_set_value_in_list ( combo, val, ok_if_empty );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_label_get_accel_width ( USER_OBJECT_ s_accel_label )
{
   GtkAccelLabel * accel_label = GTK_ACCEL_LABEL ((GtkObject*) getPtrValue( s_accel_label )) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_label_get_accel_width ( accel_label );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_add ( USER_OBJECT_ s_packer, USER_OBJECT_ s_child, USER_OBJECT_ s_side, USER_OBJECT_ s_anchor, USER_OBJECT_ s_options, USER_OBJECT_ s_border_width, USER_OBJECT_ s_pad_x, USER_OBJECT_ s_pad_y, USER_OBJECT_ s_ipad_x, USER_OBJECT_ s_ipad_y )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   GtkSideType side = ( GtkSideType ) INTEGER_DATA( s_side )[0] ;
   GtkAnchorType anchor = ( GtkAnchorType ) INTEGER_DATA( s_anchor )[0] ;
   GtkPackerOptions options = ( GtkPackerOptions ) INTEGER_DATA( s_options )[0] ;
   unsigned int border_width = INTEGER_DATA( s_border_width )[0] ;
   unsigned int pad_x = INTEGER_DATA( s_pad_x )[0] ;
   unsigned int pad_y = INTEGER_DATA( s_pad_y )[0] ;
   unsigned int ipad_x = INTEGER_DATA( s_ipad_x )[0] ;
   unsigned int ipad_y = INTEGER_DATA( s_ipad_y )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_add ( packer, child, side, anchor, options, border_width, pad_x, pad_y, ipad_x, ipad_y );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_signal_handler_block ( USER_OBJECT_ s_object, USER_OBJECT_ s_id )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   unsigned int id = INTEGER_DATA( s_id )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_signal_handler_block ( object, id );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_get_point ( USER_OBJECT_ s_text )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_text_get_point ( text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_item_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tree_item_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_optimal_column_width ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_optimal_column_width ( clist, column );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_pack1 ( USER_OBJECT_ s_paned, USER_OBJECT_ s_child, USER_OBJECT_ s_resize, USER_OBJECT_ s_shrink )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   Rboolean resize = LOGICAL_DATA( s_resize )[0] ;
   Rboolean shrink = LOGICAL_DATA( s_shrink )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_pack1 ( paned, child, resize, shrink );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_pack2 ( USER_OBJECT_ s_paned, USER_OBJECT_ s_child, USER_OBJECT_ s_resize, USER_OBJECT_ s_shrink )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   Rboolean resize = LOGICAL_DATA( s_resize )[0] ;
   Rboolean shrink = LOGICAL_DATA( s_shrink )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_pack2 ( paned, child, resize, shrink );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_column_titles_hide ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_column_titles_hide ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_draw_string ( USER_OBJECT_ s_drawable, USER_OBJECT_ s_font, USER_OBJECT_ s_gc, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_str )
{
   GdkDrawable * drawable = ( GdkDrawable * ) getPtrValue( s_drawable ) ;
   GdkFont * font = ( GdkFont * ) getPtrValue( s_font ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;
   string str = CHAR_DEREF( STRING_ELT( s_str , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_draw_string ( drawable, font, gc, x, y, str );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_append_item ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_text, USER_OBJECT_ s_tooltip, USER_OBJECT_ s_tooltip_private, USER_OBJECT_ s_icon, USER_OBJECT_ s_callback, USER_OBJECT_ s_user_data )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   string tooltip = CHAR_DEREF( STRING_ELT( s_tooltip , 0)) ;
   string tooltip_private = CHAR_DEREF( STRING_ELT( s_tooltip_private , 0)) ;
   GtkWidget * icon = Rf_length( s_icon ) == 0 ? NULL :  GTK_WIDGET ((GtkObject*) getPtrValue( s_icon )) ;
   GtkCallback * callback = ( GtkCallback * ) getPtrValue( s_callback ) ;
   void * user_data = ( void * ) getPtrValue( s_user_data ) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toolbar_append_item ( toolbar, text, tooltip, tooltip_private, icon, callback, user_data );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_exit ( USER_OBJECT_ s_code )
{
   int code = INTEGER_DATA( s_code )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_exit ( code );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_radio_button_new_from_widget ( USER_OBJECT_ s_group )
{
   GtkRadioButton * group = GTK_RADIO_BUTTON ((GtkObject*) getPtrValue( s_group )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_radio_button_new_from_widget ( group );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_dialog_get_preview_text ( USER_OBJECT_ s_fsd )
{
   GtkFontSelectionDialog * fsd = GTK_FONT_SELECTION_DIALOG ((GtkObject*) getPtrValue( s_fsd )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_dialog_get_preview_text ( fsd );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_rc_reparse_all (  )
{


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_rc_reparse_all (  );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_spin ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_direction, USER_OBJECT_ s_increment )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   GtkSpinType direction = ( GtkSpinType ) INTEGER_DATA( s_direction )[0] ;
   float increment = NUMERIC_DATA( s_increment )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_spin ( spin_button, direction, increment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_pixtext ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column, USER_OBJECT_ s_text, USER_OBJECT_ s_spacing, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   unsigned int spacing = INTEGER_DATA( s_spacing )[0] ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_pixtext ( ctree, node, column, text, spacing, pixmap, mask );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_column_visibility ( USER_OBJECT_ s_clist, USER_OBJECT_ s_column, USER_OBJECT_ s_visible )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int column = INTEGER_DATA( s_column )[0] ;
   Rboolean visible = LOGICAL_DATA( s_visible )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_column_visibility ( clist, column, visible );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_update_policy ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_policy )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   GtkSpinButtonUpdatePolicy policy = ( GtkSpinButtonUpdatePolicy ) INTEGER_DATA( s_policy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_update_policy ( spin_button, policy );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_paned_set_handle_size ( USER_OBJECT_ s_paned, USER_OBJECT_ s_size )
{
   GtkPaned * paned = GTK_PANED ((GtkObject*) getPtrValue( s_paned )) ;
   unsigned int size = INTEGER_DATA( s_size )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_paned_set_handle_size ( paned, size );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_changed ( USER_OBJECT_ s_editable )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_changed ( editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_set_position ( USER_OBJECT_ s_editable, USER_OBJECT_ s_position )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_set_position ( editable, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_push_style ( USER_OBJECT_ s_style )
{
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_push_style ( style );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_draw_pixmap ( USER_OBJECT_ s_drawable, USER_OBJECT_ s_gc, USER_OBJECT_ s_src, USER_OBJECT_ s_xsrc, USER_OBJECT_ s_ysrc, USER_OBJECT_ s_xdest, USER_OBJECT_ s_ydest, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GdkDrawable * drawable = ( GdkDrawable * ) getPtrValue( s_drawable ) ;
   GdkGC * gc = ( GdkGC * ) getPtrValue( s_gc ) ;
   GdkDrawable * src = ( GdkDrawable * ) getPtrValue( s_src ) ;
   int xsrc = INTEGER_DATA( s_xsrc )[0] ;
   int ysrc = INTEGER_DATA( s_ysrc )[0] ;
   int xdest = INTEGER_DATA( s_xdest )[0] ;
   int ydest = INTEGER_DATA( s_ydest )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gdk_draw_pixmap ( drawable, gc, src, xsrc, ysrc, xdest, ydest, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_set_use_arrows_always ( USER_OBJECT_ s_combo, USER_OBJECT_ s_val )
{
   GtkCombo * combo = GTK_COMBO ((GtkObject*) getPtrValue( s_combo )) ;
   Rboolean val = LOGICAL_DATA( s_val )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_combo_set_use_arrows_always ( combo, val );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_pixmap_set ( USER_OBJECT_ s_pixmap, USER_OBJECT_ s_val, USER_OBJECT_ s_mask )
{
   GtkPixmap * pixmap = GTK_PIXMAP ((GtkObject*) getPtrValue( s_pixmap )) ;
   GdkPixmap * val = ( GdkPixmap * ) getPtrValue( s_val ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_pixmap_set ( pixmap, val, mask );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_get_active ( USER_OBJECT_ s_menu )
{
   GtkMenu * menu = GTK_MENU ((GtkObject*) getPtrValue( s_menu )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_get_active ( menu );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_combo_set_item_string ( USER_OBJECT_ s_combo, USER_OBJECT_ s_item, USER_OBJECT_ s_item_value )
{
   GtkCombo * combo = GTK_COMBO ((GtkObject*) getPtrValue( s_combo )) ;
   GtkItem * item = GTK_ITEM ((GtkObject*) getPtrValue( s_item )) ;
   string item_value = CHAR_DEREF( STRING_ELT( s_item_value , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_combo_set_item_string ( combo, item, item_value );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_set_point ( USER_OBJECT_ s_text, USER_OBJECT_ s_index )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   unsigned int index = INTEGER_DATA( s_index )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_set_point ( text, index );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_reorder_child ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_child, USER_OBJECT_ s_position )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_reorder_child ( notebook, child, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_get_current_text ( USER_OBJECT_ s_progress )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_get_current_text ( progress );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_packer_set_default_border_width ( USER_OBJECT_ s_packer, USER_OBJECT_ s_border )
{
   GtkPacker * packer = GTK_PACKER ((GtkObject*) getPtrValue( s_packer )) ;
   unsigned int border = INTEGER_DATA( s_border )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_packer_set_default_border_width ( packer, border );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_shadow_type ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_shadow_type )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   GtkShadowType shadow_type = ( GtkShadowType ) INTEGER_DATA( s_shadow_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_shadow_type ( spin_button, shadow_type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_get_text_from_value ( USER_OBJECT_ s_progress, USER_OBJECT_ s_value )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   float value = NUMERIC_DATA( s_value )[0] ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_progress_get_text_from_value ( progress, value );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_get_nth_page ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_page_num )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   int page_num = INTEGER_DATA( s_page_num )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_notebook_get_nth_page ( notebook, page_num );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_handle_box_set_handle_position ( USER_OBJECT_ s_handle_box, USER_OBJECT_ s_position )
{
   GtkHandleBox * handle_box = GTK_HANDLE_BOX ((GtkObject*) getPtrValue( s_handle_box )) ;
   GtkPositionType position = ( GtkPositionType ) INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_handle_box_set_handle_position ( handle_box, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_idle_remove ( USER_OBJECT_ s_tag )
{
   int tag = INTEGER_DATA( s_tag )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_idle_remove ( tag );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_background ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_color )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   GdkColor * color = ( GdkColor * ) getPtrValue( s_color ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_background ( clist, row, color );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toggle_button_set_active ( USER_OBJECT_ s_toggle_button, USER_OBJECT_ s_state )
{
   GtkToggleButton * toggle_button = GTK_TOGGLE_BUTTON ((GtkObject*) getPtrValue( s_toggle_button )) ;
   Rboolean state = LOGICAL_DATA( s_state )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_toggle_button_set_active ( toggle_button, state );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_new ( USER_OBJECT_ s_columns )
{
   int columns = INTEGER_DATA( s_columns )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_new ( columns );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_get_data ( USER_OBJECT_ s_widget, USER_OBJECT_ s_context, USER_OBJECT_ s_target, USER_OBJECT_ s_time )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkDragContext * context = ( GdkDragContext * ) getPtrValue( s_context ) ;
   GdkAtom target = ( GdkAtom) NUMERIC_DATA( s_target )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_get_data ( widget, context, target, time );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_main (  )
{


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_main (  );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_pixmap ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_pixmap ( ctree, node, column, pixmap, mask );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_activate ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_activate ( widget );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_text_insert ( USER_OBJECT_ s_text, USER_OBJECT_ s_font, USER_OBJECT_ s_fore, USER_OBJECT_ s_back, USER_OBJECT_ s_chars, USER_OBJECT_ s_length )
{
   GtkText * text = GTK_TEXT ((GtkObject*) getPtrValue( s_text )) ;
   GdkFont * font = ( GdkFont * ) getPtrValue( s_font ) ;
   GdkColor * fore = ( GdkColor * ) getPtrValue( s_fore ) ;
   GdkColor * back = ( GdkColor * ) getPtrValue( s_back ) ;
   string chars = CHAR_DEREF( STRING_ELT( s_chars , 0)) ;
   int length = INTEGER_DATA( s_length )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_text_insert ( text, font, fore, back, chars, length );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_get_vadjustment ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_get_vadjustment ( clist );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_bar_prepend ( USER_OBJECT_ s_menu_bar, USER_OBJECT_ s_child )
{
   GtkMenuBar * menu_bar = GTK_MENU_BAR ((GtkObject*) getPtrValue( s_menu_bar )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_bar_prepend ( menu_bar, child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_color_selection_set_update_policy ( USER_OBJECT_ s_colorsel, USER_OBJECT_ s_policy )
{
   GtkColorSelection * colorsel = GTK_COLOR_SELECTION ((GtkObject*) getPtrValue( s_colorsel )) ;
   GtkUpdateType policy = ( GtkUpdateType ) INTEGER_DATA( s_policy )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_color_selection_set_update_policy ( colorsel, policy );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hruler_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hruler_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_dialog_new ( USER_OBJECT_ s_title )
{
   string title = CHAR_DEREF( STRING_ELT( s_title , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_dialog_new ( title );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_clear_background ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_clear_background ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_grab_default ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_grab_default ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_menu_item_set_show_toggle ( USER_OBJECT_ s_menu_item, USER_OBJECT_ s_always )
{
   GtkCheckMenuItem * menu_item = GTK_CHECK_MENU_ITEM ((GtkObject*) getPtrValue( s_menu_item )) ;
   Rboolean always = LOGICAL_DATA( s_always )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_check_menu_item_set_show_toggle ( menu_item, always );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_socket_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_socket_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_set_child_size_default ( USER_OBJECT_ s_min_width, USER_OBJECT_ s_min_height )
{
   int min_width = INTEGER_DATA( s_min_width )[0] ;
   int min_height = INTEGER_DATA( s_min_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_box_set_child_size_default ( min_width, min_height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vscale_new ( USER_OBJECT_ s_adjustment )
{
   GtkAdjustment * adjustment = Rf_length( s_adjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vscale_new ( adjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tooltips_new (  )
{


    GtkTooltips * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tooltips_new (  );
   _result = toRPointer(ans, "GtkTooltips");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_aspect_frame_new ( USER_OBJECT_ s_label, USER_OBJECT_ s_xalign, USER_OBJECT_ s_yalign, USER_OBJECT_ s_ratio, USER_OBJECT_ s_obey_child )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;
   float xalign = NUMERIC_DATA( s_xalign )[0] ;
   float yalign = NUMERIC_DATA( s_yalign )[0] ;
   float ratio = NUMERIC_DATA( s_ratio )[0] ;
   int obey_child = INTEGER_DATA( s_obey_child )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_aspect_frame_new ( label, xalign, yalign, ratio, obey_child );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_get_selectable ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_ctree_node_get_selectable ( ctree, node );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_select_item ( USER_OBJECT_ s_tree, USER_OBJECT_ s_item )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   int item = INTEGER_DATA( s_item )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_select_item ( tree, item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_remove_node ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_remove_node ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_pixtext ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_col, USER_OBJECT_ s_text, USER_OBJECT_ s_spacing, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int col = INTEGER_DATA( s_col )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   unsigned int spacing = INTEGER_DATA( s_spacing )[0] ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_pixtext ( clist, row, col, text, spacing, pixmap, mask );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_clear_items ( USER_OBJECT_ s_tree, USER_OBJECT_ s_start, USER_OBJECT_ s_end )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   int start = INTEGER_DATA( s_start )[0] ;
   int end = INTEGER_DATA( s_end )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_clear_items ( tree, start, end );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_box_set_layout ( USER_OBJECT_ s_widget, USER_OBJECT_ s_layout_style )
{
   GtkButtonBox * widget = GTK_BUTTON_BOX ((GtkObject*) getPtrValue( s_widget )) ;
   GtkButtonBoxStyle layout_style = ( GtkButtonBoxStyle ) INTEGER_DATA( s_layout_style )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_box_set_layout ( widget, layout_style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_pixmap_set_build_insensitive ( USER_OBJECT_ s_pixmap, USER_OBJECT_ s_build )
{
   GtkPixmap * pixmap = GTK_PIXMAP ((GtkObject*) getPtrValue( s_pixmap )) ;
   unsigned int build = INTEGER_DATA( s_build )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_pixmap_set_build_insensitive ( pixmap, build );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_bar_insert ( USER_OBJECT_ s_menu_bar, USER_OBJECT_ s_child, USER_OBJECT_ s_position )
{
   GtkMenuBar * menu_bar = GTK_MENU_BAR ((GtkObject*) getPtrValue( s_menu_bar )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   int position = INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_bar_insert ( menu_bar, child, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_set_locale (  )
{


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_set_locale (  );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_vbox_new ( USER_OBJECT_ s_homogeneous, USER_OBJECT_ s_spacing )
{
   Rboolean homogeneous = LOGICAL_DATA( s_homogeneous )[0] ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_vbox_new ( homogeneous, spacing );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_name ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_name ( widget );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_misc_set_padding ( USER_OBJECT_ s_misc, USER_OBJECT_ s_xpad, USER_OBJECT_ s_ypad )
{
   GtkMisc * misc = GTK_MISC ((GtkObject*) getPtrValue( s_misc )) ;
   int xpad = INTEGER_DATA( s_xpad )[0] ;
   int ypad = INTEGER_DATA( s_ypad )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_misc_set_padding ( misc, xpad, ypad );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_queue_draw_area ( USER_OBJECT_ s_widget, USER_OBJECT_ s_x, USER_OBJECT_ s_y, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int x = INTEGER_DATA( s_x )[0] ;
   int y = INTEGER_DATA( s_y )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_queue_draw_area ( widget, x, y, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_set_selection_mode ( USER_OBJECT_ s_tree, USER_OBJECT_ s_mode )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkSelectionMode mode = ( GtkSelectionMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_set_selection_mode ( tree, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_unselect_all ( USER_OBJECT_ s_list )
{
   GtkList * list = GTK_LIST ((GtkObject*) getPtrValue( s_list )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_unselect_all ( list );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_get_composite_name ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_get_composite_name ( widget );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_paste_clipboard ( USER_OBJECT_ s_editable )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_paste_clipboard ( editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_pack_start ( USER_OBJECT_ s_box, USER_OBJECT_ s_child, USER_OBJECT_ s_expand, USER_OBJECT_ s_fill, USER_OBJECT_ s_padding )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   Rboolean expand = LOGICAL_DATA( s_expand )[0] ;
   Rboolean fill = LOGICAL_DATA( s_fill )[0] ;
   int padding = INTEGER_DATA( s_padding )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_pack_start ( box, child, expand, fill, padding );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_scale_set_value_pos ( USER_OBJECT_ s_scale, USER_OBJECT_ s_pos )
{
   GtkScale * scale = GTK_SCALE ((GtkObject*) getPtrValue( s_scale )) ;
   GtkPositionType pos = ( GtkPositionType ) INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_scale_set_value_pos ( scale, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drawing_area_size ( USER_OBJECT_ s_darea, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkDrawingArea * darea = GTK_DRAWING_AREA ((GtkObject*) getPtrValue( s_darea )) ;
   int width = INTEGER_DATA( s_width )[0] ;
   int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drawing_area_size ( darea, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_row_height ( USER_OBJECT_ s_clist, USER_OBJECT_ s_height )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_row_height ( clist, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_queue_resize ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_queue_resize ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_expand_to_depth ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_depth )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int depth = INTEGER_DATA( s_depth )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_expand_to_depth ( ctree, node, depth );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_type_name ( USER_OBJECT_ s_type )
{
   unsigned int type = INTEGER_DATA( s_type )[0] ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_type_name ( type );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_activate ( USER_OBJECT_ s_group, USER_OBJECT_ s_key, USER_OBJECT_ s_modifiers )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   unsigned int key = INTEGER_DATA( s_key )[0] ;
   GdkModifierType modifiers = ( GdkModifierType ) INTEGER_DATA( s_modifiers )[0] ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_accel_group_activate ( group, key, modifiers );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_unselect_recursive ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_unselect_recursive ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_set_size ( USER_OBJECT_ s_layout, USER_OBJECT_ s_width, USER_OBJECT_ s_height )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;
   unsigned int width = INTEGER_DATA( s_width )[0] ;
   unsigned int height = INTEGER_DATA( s_height )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_set_size ( layout, width, height );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_item_select ( USER_OBJECT_ s_list_item )
{
   GtkListItem * list_item = GTK_LIST_ITEM ((GtkObject*) getPtrValue( s_list_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_list_item_select ( list_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_set_usize ( USER_OBJECT_ s_widget, USER_OBJECT_ s_height, USER_OBJECT_ s_width )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   int height = INTEGER_DATA( s_height )[0] ;
   int width = INTEGER_DATA( s_width )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_set_usize ( widget, height, width );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_set_wrap ( USER_OBJECT_ s_spin_button, USER_OBJECT_ s_wrap )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;
   Rboolean wrap = LOGICAL_DATA( s_wrap )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_spin_button_set_wrap ( spin_button, wrap );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_append ( USER_OBJECT_ s_clist, USER_OBJECT_ s_text )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   string * text = asCStringArray( s_text ) ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_clist_append ( clist, text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_show_border ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_show_border )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   Rboolean show_border = LOGICAL_DATA( s_show_border )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_show_border ( notebook, show_border );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_list_item_new_with_label ( USER_OBJECT_ s_label )
{
   string label = CHAR_DEREF( STRING_ELT( s_label , 0)) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_list_item_new_with_label ( label );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_cell_style ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column, USER_OBJECT_ s_style )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;
   GtkStyle * style = ( GtkStyle * ) getPtrValue( s_style ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_cell_style ( clist, row, column, style );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_accel_group_detach ( USER_OBJECT_ s_group, USER_OBJECT_ s_object )
{
   GtkAccelGroup * group = ( GtkAccelGroup * ) getPtrValue( s_group ) ;
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_accel_group_detach ( group, object );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_copy_clipboard ( USER_OBJECT_ s_editable )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_copy_clipboard ( editable );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_viewport_new ( USER_OBJECT_ s_hadjustment, USER_OBJECT_ s_vadjustment )
{
   GtkAdjustment * hadjustment = Rf_length( s_hadjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_hadjustment )) ;
   GtkAdjustment * vadjustment = Rf_length( s_vadjustment ) == 0 ? NULL :  GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_vadjustment )) ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_viewport_new ( hadjustment, vadjustment );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_sort ( USER_OBJECT_ s_clist )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_sort ( clist );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_editable_claim_selection ( USER_OBJECT_ s_editable, USER_OBJECT_ s_claim, USER_OBJECT_ s_time )
{
   GtkEditable * editable = GTK_EDITABLE ((GtkObject*) getPtrValue( s_editable )) ;
   Rboolean claim = LOGICAL_DATA( s_claim )[0] ;
   unsigned int time = INTEGER_DATA( s_time )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_editable_claim_selection ( editable, claim, time );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_child_type ( USER_OBJECT_ s_container )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_container_child_type ( container );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_item_factory_parse_rc_string ( USER_OBJECT_ s_rc_string )
{
   string rc_string = CHAR_DEREF( STRING_ELT( s_rc_string , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_item_factory_parse_rc_string ( rc_string );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_background ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_color )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   GdkColor * color = ( GdkColor * ) getPtrValue( s_color ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_background ( ctree, node, color );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_handle_box_set_snap_edge ( USER_OBJECT_ s_handle_box, USER_OBJECT_ s_position )
{
   GtkHandleBox * handle_box = GTK_HANDLE_BOX ((GtkObject*) getPtrValue( s_handle_box )) ;
   GtkPositionType position = ( GtkPositionType ) INTEGER_DATA( s_position )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_handle_box_set_snap_edge ( handle_box, position );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_grab_focus ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_widget_grab_focus ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_toolbar_insert_item ( USER_OBJECT_ s_toolbar, USER_OBJECT_ s_text, USER_OBJECT_ s_tooltip, USER_OBJECT_ s_tooltip_private, USER_OBJECT_ s_icon, USER_OBJECT_ s_callback, USER_OBJECT_ s_user_data, USER_OBJECT_ s_position )
{
   GtkToolbar * toolbar = GTK_TOOLBAR ((GtkObject*) getPtrValue( s_toolbar )) ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;
   string tooltip = CHAR_DEREF( STRING_ELT( s_tooltip , 0)) ;
   string tooltip_private = CHAR_DEREF( STRING_ELT( s_tooltip_private , 0)) ;
   GtkWidget * icon = Rf_length( s_icon ) == 0 ? NULL :  GTK_WIDGET ((GtkObject*) getPtrValue( s_icon )) ;
   GtkCallback * callback = ( GtkCallback * ) getPtrValue( s_callback ) ;
   void * user_data = ( void * ) getPtrValue( s_user_data ) ;
   int position = INTEGER_DATA( s_position )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_toolbar_insert_item ( toolbar, text, tooltip, tooltip_private, icon, callback, user_data, position );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_adjustment_clamp_page ( USER_OBJECT_ s_adjustment, USER_OBJECT_ s_lower, USER_OBJECT_ s_upper )
{
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;
   float lower = NUMERIC_DATA( s_lower )[0] ;
   float upper = NUMERIC_DATA( s_upper )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_adjustment_clamp_page ( adjustment, lower, upper );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_widget_event ( USER_OBJECT_ s_widget, USER_OBJECT_ s_event )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;
   GdkEvent * event = ( GdkEvent * ) getPtrValue( s_event ) ;


    Rboolean ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_widget_event ( widget, event );
  _result = asRLogical ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_set_format_string ( USER_OBJECT_ s_progress, USER_OBJECT_ s_format )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   string format = CHAR_DEREF( STRING_ELT( s_format , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_set_format_string ( progress, format );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_set_view_mode ( USER_OBJECT_ s_tree, USER_OBJECT_ s_mode )
{
   GtkTree * tree = GTK_TREE ((GtkObject*) getPtrValue( s_tree )) ;
   GtkTreeViewMode mode = ( GtkTreeViewMode ) INTEGER_DATA( s_mode )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tree_set_view_mode ( tree, mode );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_menu_item_set_active ( USER_OBJECT_ s_check_menu_item, USER_OBJECT_ s_state )
{
   GtkCheckMenuItem * check_menu_item = GTK_CHECK_MENU_ITEM ((GtkObject*) getPtrValue( s_check_menu_item )) ;
   Rboolean state = LOGICAL_DATA( s_state )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_check_menu_item_set_active ( check_menu_item, state );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_notebook_set_tab_hborder ( USER_OBJECT_ s_notebook, USER_OBJECT_ s_tab_hborder )
{
   GtkNotebook * notebook = GTK_NOTEBOOK ((GtkObject*) getPtrValue( s_notebook )) ;
   unsigned int tab_hborder = INTEGER_DATA( s_tab_hborder )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_notebook_set_tab_hborder ( notebook, tab_hborder );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_unregister_toplevel ( USER_OBJECT_ s_container )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_unregister_toplevel ( container );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_entry_get_text ( USER_OBJECT_ s_entry )
{
   GtkEntry * entry = GTK_ENTRY ((GtkObject*) getPtrValue( s_entry )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_entry_get_text ( entry );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_aspect_frame_set ( USER_OBJECT_ s_aspect_frame, USER_OBJECT_ s_xalign, USER_OBJECT_ s_yalign, USER_OBJECT_ s_ratio, USER_OBJECT_ s_obey_child )
{
   GtkAspectFrame * aspect_frame = GTK_ASPECT_FRAME ((GtkObject*) getPtrValue( s_aspect_frame )) ;
   float xalign = NUMERIC_DATA( s_xalign )[0] ;
   float yalign = NUMERIC_DATA( s_yalign )[0] ;
   float ratio = NUMERIC_DATA( s_ratio )[0] ;
   int obey_child = INTEGER_DATA( s_obey_child )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_aspect_frame_set ( aspect_frame, xalign, yalign, ratio, obey_child );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_menu_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_button_set_relief ( USER_OBJECT_ s_button, USER_OBJECT_ s_newstyle )
{
   GtkButton * button = GTK_BUTTON ((GtkObject*) getPtrValue( s_button )) ;
   GtkReliefStyle newstyle = ( GtkReliefStyle ) INTEGER_DATA( s_newstyle )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_button_set_relief ( button, newstyle );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_moveto ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_column, USER_OBJECT_ s_row_align, USER_OBJECT_ s_column_align )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int column = INTEGER_DATA( s_column )[0] ;
   float row_align = NUMERIC_DATA( s_row_align )[0] ;
   float column_align = NUMERIC_DATA( s_column_align )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_moveto ( clist, row, column, row_align, column_align );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_preview_set_dither ( USER_OBJECT_ s_preview, USER_OBJECT_ s_dither )
{
   GtkPreview * preview = GTK_PREVIEW ((GtkObject*) getPtrValue( s_preview )) ;
   GdkRgbDither dither = ( GdkRgbDither ) INTEGER_DATA( s_dither )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_preview_set_dither ( preview, dither );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tree_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_tree_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_set_hadjustment ( USER_OBJECT_ s_layout, USER_OBJECT_ s_adjustment )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_layout_set_hadjustment ( layout, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hbox_new ( USER_OBJECT_ s_homogeneous, USER_OBJECT_ s_spacing )
{
   Rboolean homogeneous = LOGICAL_DATA( s_homogeneous )[0] ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hbox_new ( homogeneous, spacing );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_hpaned_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_hpaned_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_drag_source_unset ( USER_OBJECT_ s_widget )
{
   GtkWidget * widget = GTK_WIDGET ((GtkObject*) getPtrValue( s_widget )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_drag_source_unset ( widget );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_calendar_unmark_day ( USER_OBJECT_ s_calendar, USER_OBJECT_ s_day )
{
   GtkCalendar * calendar = GTK_CALENDAR ((GtkObject*) getPtrValue( s_calendar )) ;
   unsigned int day = INTEGER_DATA( s_day )[0] ;


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_calendar_unmark_day ( calendar, day );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_label_set_line_wrap ( USER_OBJECT_ s_label, USER_OBJECT_ s_wrap )
{
   GtkLabel * label = GTK_LABEL ((GtkObject*) getPtrValue( s_label )) ;
   Rboolean wrap = LOGICAL_DATA( s_wrap )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_label_set_line_wrap ( label, wrap );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_range_draw_slider ( USER_OBJECT_ s_range )
{
   GtkRange * range = GTK_RANGE ((GtkObject*) getPtrValue( s_range )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_range_draw_slider ( range );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_event_box_new (  )
{


    GtkWidget * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_event_box_new (  );
   _result = R_gtkWidgetReference((GtkWidget*)ans, "GtkWidget");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_menu_bar_set_shadow_type ( USER_OBJECT_ s_menu_bar, USER_OBJECT_ s_type )
{
   GtkMenuBar * menu_bar = GTK_MENU_BAR ((GtkObject*) getPtrValue( s_menu_bar )) ;
   GtkShadowType type = ( GtkShadowType ) INTEGER_DATA( s_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_menu_bar_set_shadow_type ( menu_bar, type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_tips_query_set_caller ( USER_OBJECT_ s_tips_query, USER_OBJECT_ s_caller )
{
   GtkTipsQuery * tips_query = GTK_TIPS_QUERY ((GtkObject*) getPtrValue( s_tips_query )) ;
   GtkWidget * caller = GTK_WIDGET ((GtkObject*) getPtrValue( s_caller )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_tips_query_set_caller ( tips_query, caller );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_layout_get_hadjustment ( USER_OBJECT_ s_layout )
{
   GtkLayout * layout = GTK_LAYOUT ((GtkObject*) getPtrValue( s_layout )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_layout_get_hadjustment ( layout );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_sort_node ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_sort_node ( ctree, node );


  return(_result);
}
 

USER_OBJECT_
 S_gdk_atom_name ( USER_OBJECT_ s_atom )
{
   GdkAtom atom = ( GdkAtom) NUMERIC_DATA( s_atom )[0] ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gdk_atom_name ( atom );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_progress_configure ( USER_OBJECT_ s_progress, USER_OBJECT_ s_value, USER_OBJECT_ s_min, USER_OBJECT_ s_max )
{
   GtkProgress * progress = GTK_PROGRESS ((GtkObject*) getPtrValue( s_progress )) ;
   float value = NUMERIC_DATA( s_value )[0] ;
   float min = NUMERIC_DATA( s_min )[0] ;
   float max = NUMERIC_DATA( s_max )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_progress_configure ( progress, value, min, max );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_label_set_justify ( USER_OBJECT_ s_label, USER_OBJECT_ s_jtype )
{
   GtkLabel * label = GTK_LABEL ((GtkObject*) getPtrValue( s_label )) ;
   GtkJustification jtype = ( GtkJustification ) INTEGER_DATA( s_jtype )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_label_set_justify ( label, jtype );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_check_menu_item_toggled ( USER_OBJECT_ s_check_menu_item )
{
   GtkCheckMenuItem * check_menu_item = GTK_CHECK_MENU_ITEM ((GtkObject*) getPtrValue( s_check_menu_item )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_check_menu_item_toggled ( check_menu_item );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_box_reorder_child ( USER_OBJECT_ s_box, USER_OBJECT_ s_child, USER_OBJECT_ s_pos )
{
   GtkBox * box = GTK_BOX ((GtkObject*) getPtrValue( s_box )) ;
   GtkWidget * child = GTK_WIDGET ((GtkObject*) getPtrValue( s_child )) ;
   unsigned int pos = INTEGER_DATA( s_pos )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_box_reorder_child ( box, child, pos );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_statusbar_push ( USER_OBJECT_ s_statusbar, USER_OBJECT_ s_context_id, USER_OBJECT_ s_text )
{
   GtkStatusbar * statusbar = GTK_STATUSBAR ((GtkObject*) getPtrValue( s_statusbar )) ;
   unsigned int context_id = INTEGER_DATA( s_context_id )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


    unsigned int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_statusbar_push ( statusbar, context_id, text );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_table_set_row_spacing ( USER_OBJECT_ s_table, USER_OBJECT_ s_row, USER_OBJECT_ s_spacing )
{
   GtkTable * table = GTK_TABLE ((GtkObject*) getPtrValue( s_table )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int spacing = INTEGER_DATA( s_spacing )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_table_set_row_spacing ( table, row, spacing );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_pixmap ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row, USER_OBJECT_ s_col, USER_OBJECT_ s_pixmap, USER_OBJECT_ s_mask )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row = INTEGER_DATA( s_row )[0] ;
   int col = INTEGER_DATA( s_col )[0] ;
   GdkPixmap * pixmap = ( GdkPixmap * ) getPtrValue( s_pixmap ) ;
   GdkBitmap * mask = ( GdkBitmap * ) getPtrValue( s_mask ) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_pixmap ( clist, row, col, pixmap, mask );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_text ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column, USER_OBJECT_ s_text )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;
   string text = CHAR_DEREF( STRING_ELT( s_text , 0)) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_text ( ctree, node, column, text );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_vadjustment ( USER_OBJECT_ s_clist, USER_OBJECT_ s_adjustment )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_vadjustment ( clist, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_events_pending (  )
{


    int ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_events_pending (  );
  _result = asRInt ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_frame_set_label_align ( USER_OBJECT_ s_frame, USER_OBJECT_ s_xalign, USER_OBJECT_ s_yalign )
{
   GtkFrame * frame = GTK_FRAME ((GtkObject*) getPtrValue( s_frame )) ;
   float xalign = NUMERIC_DATA( s_xalign )[0] ;
   float yalign = NUMERIC_DATA( s_yalign )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_frame_set_label_align ( frame, xalign, yalign );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_container_set_focus_vadjustment ( USER_OBJECT_ s_container, USER_OBJECT_ s_adjustment )
{
   GtkContainer * container = GTK_CONTAINER ((GtkObject*) getPtrValue( s_container )) ;
   GtkAdjustment * adjustment = GTK_ADJUSTMENT ((GtkObject*) getPtrValue( s_adjustment )) ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_container_set_focus_vadjustment ( container, adjustment );


  return(_result);
}
 

USER_OBJECT_
 S_GTK_OBJECT_UNSET_FLAGS ( USER_OBJECT_ s_object, USER_OBJECT_ s_flags )
{
   GtkObject * object = GTK_OBJECT ((GtkObject*) getPtrValue( s_object )) ;
   GtkWidgetFlags flags = ( GtkWidgetFlags ) INTEGER_DATA( s_flags )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  GTK_OBJECT_UNSET_FLAGS ( object, flags );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_use_drag_icons ( USER_OBJECT_ s_clist, USER_OBJECT_ s_use_icons )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   Rboolean use_icons = LOGICAL_DATA( s_use_icons )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_use_drag_icons ( clist, use_icons );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_font_selection_dialog_get_font_name ( USER_OBJECT_ s_fsd )
{
   GtkFontSelectionDialog * fsd = GTK_FONT_SELECTION_DIALOG ((GtkObject*) getPtrValue( s_fsd )) ;


    string ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_font_selection_dialog_get_font_name ( fsd );
  _result = asRCharacter ( ans );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_ctree_node_set_shift ( USER_OBJECT_ s_ctree, USER_OBJECT_ s_node, USER_OBJECT_ s_column, USER_OBJECT_ s_vertical, USER_OBJECT_ s_horizontal )
{
   GtkCTree * ctree = GTK_CTREE ((GtkObject*) getPtrValue( s_ctree )) ;
   GtkCTreeNode * node = ( GtkCTreeNode * ) getPtrValue( s_node ) ;
   int column = INTEGER_DATA( s_column )[0] ;
   int vertical = INTEGER_DATA( s_vertical )[0] ;
   int horizontal = INTEGER_DATA( s_horizontal )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_ctree_node_set_shift ( ctree, node, column, vertical, horizontal );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_set_sort_type ( USER_OBJECT_ s_clist, USER_OBJECT_ s_sort_type )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   GtkSortType sort_type = ( GtkSortType ) INTEGER_DATA( s_sort_type )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_set_sort_type ( clist, sort_type );


  return(_result);
}
 

USER_OBJECT_
 S_gtk_spin_button_get_adjustment ( USER_OBJECT_ s_spin_button )
{
   GtkSpinButton * spin_button = GTK_SPIN_BUTTON ((GtkObject*) getPtrValue( s_spin_button )) ;


    GtkAdjustment * ans ;
   USER_OBJECT_ _result = NULL_USER_OBJECT;

	 ans =  gtk_spin_button_get_adjustment ( spin_button );
   _result = toRPointer(ans, "GtkAdjustment");


  return(_result);
}
 

USER_OBJECT_
 S_gtk_clist_swap_rows ( USER_OBJECT_ s_clist, USER_OBJECT_ s_row1, USER_OBJECT_ s_row2 )
{
   GtkCList * clist = GTK_CLIST ((GtkObject*) getPtrValue( s_clist )) ;
   int row1 = INTEGER_DATA( s_row1 )[0] ;
   int row2 = INTEGER_DATA( s_row2 )[0] ;


   USER_OBJECT_ _result = NULL_USER_OBJECT;

	  gtk_clist_swap_rows ( clist, row1, row2 );


  return(_result);
}
 

