\alias{gdk-Input-Devices}
\alias{GdkDevice}
\alias{GdkDeviceKey}
\alias{GdkDeviceAxis}
\alias{GdkTimeCoord}
\alias{GdkInputSource}
\alias{GdkInputMode}
\alias{GdkAxisUse}
\alias{GdkExtensionMode}
\name{gdk-Input-Devices}
\title{Input Devices}
\description{Functions for handling extended input devices}
\section{Methods and Functions}{
\code{\link{gdkDevicesList}()}\cr
\code{\link{gdkDeviceSetSource}(object, source)}\cr
\code{\link{gdkDeviceSetMode}(object, mode)}\cr
\code{\link{gdkDeviceSetKey}(object, index, keyval, modifiers)}\cr
\code{\link{gdkDeviceSetAxisUse}(object, index, use)}\cr
\code{\link{gdkDeviceGetCorePointer}()}\cr
\code{\link{gdkDeviceGetState}(object, window)}\cr
\code{\link{gdkDeviceGetHistory}(object, window, start, stop)}\cr
\code{\link{gdkDeviceGetAxis}(object, axes, use)}\cr
\code{\link{gdkInputSetExtensionEvents}(object, mask, mode)}\cr

}
\section{Detailed Description}{In addition to the normal keyboard and mouse input devices, GTK+ also
contains support for \dfn{extended input devices}. In
particular, this support is targeted at graphics tablets. Graphics
tablets typically return sub-pixel positioning information and possibly
information about the pressure and tilt of the stylus. Under
X, the support for extended devices is done through the 
\dfn{XInput} extension.
  
Because handling extended input devices may involve considerable
overhead, they need to be turned on for each \code{\link{GdkWindow}}
individually using \code{\link{gdkInputSetExtensionEvents}}.
(Or, more typically, for GtkWidgets, using \code{\link{gtkWidgetSetExtensionEvents}}).
As an additional complication, depending on the support from
the windowing system, its possible that a normal mouse
cursor will not be displayed for a particular extension
device. If an application does not want to deal with displaying
a cursor itself, it can ask only to get extension events
from devices that will display a cursor, by passing the
\code{GDK_EXTENSION_EVENTS_CURSOR} value to
\code{\link{gdkInputSetExtensionEvents}}. Otherwise, the application
must retrieve the device information using \code{\link{gdkDevicesList}},
check the \code{has_cursor} field, and, 
if it is \code{FALSE}, draw a cursor itself when it receives 
motion events.
  
Each pointing device is assigned a unique integer ID; events from a
particular device can be identified by the
\code{deviceid} field in the event structure. The
events generated by pointer devices have also been extended to contain
\code{pressure}, \code{xtilt}
and \code{ytilt} fields which contain the extended
information reported as additional \dfn{valuators}
from the device. The \code{pressure} field is a 
a double value ranging from 0.0 to 1.0, while the tilt fields are
double values ranging from -1.0 to 1.0. (With -1.0 representing the
maximum tilt to the left or up, and 1.0 representing the maximum
tilt to the right or down.)
  
One additional field in each event is the
\code{source} field, which contains an
enumeration value describing the type of device; this currently
can be one of \code{GDK_SOURCE_MOUSE}, \code{GDK_SOURCE_PEN}, \code{GDK_SOURCE_ERASER},
or \code{GDK_SOURCE_CURSOR}. This field is present to allow simple
applications to (for instance) delete when they detect eraser
devices without having to keep track of complicated per-device
settings.
  
Various aspects of each device may be configured. The easiest way of
creating a GUI to allow the user to configure such a device
is to use the \code{\link{GtkInputDialog}} widget in GTK+. 
However, even when using this widget, application writers
will need to directly query and set the configuration parameters
in order to save the state between invocations of the application.
The configuration of devices is queried using \code{\link{gdkDevicesList}}.
Each device must be activated using \code{\link{gdkDeviceSetMode}}, which
also controls whether the device's range is mapped to the
entire screen or to a single window. The mapping of the valuators of
the device onto the predefined valuator types is set using
\code{\link{gdkDeviceSetAxisUse}}. And the source type for each device
can be set with \code{\link{gdkDeviceSetSource}}.
  
Devices may also have associated \dfn{keys}
or function buttons. Such keys can be globally set to map
into normal X keyboard events. The mapping is set using
\code{\link{gdkDeviceSetKey}}.
  
The interfaces in this section will most likely be considerably
modified in the future to accomodate devices that may have different
sets of additional valuators than the pressure \code{xtilt}
and \code{ytilt}.}
\section{Structures}{\describe{
\item{\code{GdkDevice}}{
A \code{GdkDevice} structure contains
a detailed description of an extended input device. All
fields are read-only; but you can use \code{\link{gdkDeviceSetSource}},
\code{\link{gdkDeviceSetMode}}, \code{\link{gdkDeviceSetKey}} and \code{\link{gdkDeviceSetAxisUse}}
to configure various aspects of the device.

\describe{
\item{\code{name}}{[character] the parent instance}
\item{\code{source}}{[\code{\link{GdkInputSource}}] the name of this device.}
\item{\code{mode}}{[\code{\link{GdkInputMode}}] the type of this device.}
\item{\code{hasCursor}}{[logical] the mode of this device}
\item{\code{numAxes}}{[integer] \code{TRUE} if the pointer follows device motion.}
\item{\code{axes}}{[\code{\link{GdkDeviceAxis}}] the length of the \code{axes} list.}
\item{\code{numKeys}}{[integer] a list of \code{\link{GdkDeviceAxis}}, describing the axes of this device.}
\item{\code{keys}}{[\code{\link{GdkDeviceKey}}] the length of the \code{keys} list.}
}

}
\item{\code{GdkDeviceKey}}{
The \code{GdkDeviceKey} structure contains information
about the mapping of one device function button onto a normal X key event. 
It has the following fields:

\describe{
\item{\code{keyval}}{[numeric] the keyval to generate when the function button is pressed.
         If this is 0, no keypress will be generated.}
\item{\code{modifiers}}{[\code{\link{GdkModifierType}}] the modifiers set for the generated key event.}
}

}
\item{\code{GdkDeviceAxis}}{
The \code{GdkDeviceAxis} structure contains information
about the range and mapping of a device axis.

\describe{
\item{\code{use}}{[\code{\link{GdkAxisUse}}] specifies how the axis is used.}
\item{\code{min}}{[numeric] the minimal value that will be reported by this axis.}
\item{\code{max}}{[numeric] the maximal value that will be reported by this axis.}
}

}
\item{\code{GdkTimeCoord}}{
The \code{\link{GdkTimeCoord}} structure stores a single event in a
motion history. It contains the following fields:
\strong{\code{GdkTimeCoord} is a \link{transparent-type}.}

\describe{
\item{\code{time}}{[numeric] The timestamp for this event.}
\item{\code{axes}}{[numeric] the values of the device's axes.}
}

}
}}
\section{Enums and Flags}{\describe{
\item{\code{GdkInputSource}}{
An enumeration describing the type of an input device
in general terms.

\describe{
\item{\code{mouse}}{the device is a mouse. (This will be reported for the core
                    pointer, even if it is something else, such as a trackball.)}
\item{\code{pen}}{the device is a stylus of a graphics tablet or similar device.}
\item{\code{eraser}}{the device is an eraser. Typically, this would be the other end
                    of a stylus on a graphics tablet.}
\item{\code{cursor}}{the device is a graphics tablet "puck" or similar device.}
}

}
\item{\code{GdkInputMode}}{
An enumeration that describes the mode of an input device.

\describe{
\item{\code{disabled}}{the device is disabled and will not report any events.}
\item{\code{screen}}{the device is enabled. The device's coordinate space
                    maps to the entire screen.}
\item{\code{window}}{the device is enabled. The device's coordinate space
                    is mapped to a single window. The manner in which this window
                    is chosen is undefined, but it will typically be the same
                    way in which the focus window for key events is determined.}
}

}
\item{\code{GdkAxisUse}}{
An enumeration describing the way in which a device
axis (valuator) maps onto the predefined valuator
types that GTK+ understands.

\describe{
\item{\code{ignore}}{the axis is ignored.}
\item{\code{x}}{the axis is used as the x axis.}
\item{\code{y}}{the axis is used as the y axis.}
\item{\code{pressure}}{the axis is used for pressure information.}
\item{\code{xtilt}}{the axis is used for x tilt information.}
\item{\code{ytilt}}{the axis is used for x tilt information.}
\item{\code{wheel}}{the axis is used for wheel information.}
\item{\code{last}}{a constant equal to the numerically highest axis value.}
}

}
\item{\code{GdkExtensionMode}}{
An enumeration used to specify which extension events
are desired for a particular widget.

\describe{
\item{\code{none}}{no extension events are desired.}
\item{\code{all}}{all extension events are desired.}
\item{\code{cursor}}{extension events are desired only if a cursor
                              will be displayed for the device.}
}

}
}}
\references{\url{http://developer.gnome.org/doc/API/2.0/gdk/gdk-Input-Devices.html}}
\author{Derived by RGtkGen from GTK+ documentation}
\keyword{internal}
