# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Handlers for the context menu-driven Edit/Manage Privileges calls
#
# Written for Red Hat Inc. by Andrew Overholt <overholt@redhat.com>
#
# Uses commentOnContextMenuHandlers.tcl as a template
#
# Component of:  Red Hat Database GUI Administration tool

package require alterPrivilegesRaiser
package provide alterPrivilegesContextMenuHandlers 1.0

proc alterPrivilegesOnSequenceContextMenu { args } {
    set expectedArgs \
	[list \
	-clusterCollectionName\
	-clusterName\
	-databaseName\
	-sequenceName \
	]

    foreach option $expectedArgs {
	set options($option) ""
    }

    foreach { option value } $args {
	if {[lsearch -exact $expectedArgs $option] == -1} {
	    error "Unexpected option \"$option\" - only expect $expectedArgs"
	}
	set options($option) "$value"
    }

    set args "$args -objectType sequence"

    eval "alterPrivilegesRaiser \"Edit Privileges For Sequence\
        $options(-sequenceName)\" $args"
}

proc alterPrivilegesOnViewContextMenu { args } {
    set expectedArgs \
	[list \
	-clusterCollectionName\
	-clusterName\
	-databaseName\
	-viewName \
	]

    foreach option $expectedArgs {
	set options($option) ""
    }

    foreach { option value } $args {
	if {[lsearch -exact $expectedArgs $option] == -1} {
	    error "Unexpected option \"$option\" - only expect $expectedArgs"
	}
	set options($option) "$value"
    }

    set args "$args -objectType view"

    eval "alterPrivilegesRaiser \"Edit Privileges For View\
        $options(-viewName)\" $args"
}

proc alterPrivilegesOnTableContextMenu { args } {
    set expectedArgs \
	[list \
	-clusterCollectionName\
	-clusterName\
	-databaseName\
	-tableName \
	]

    foreach option $expectedArgs {
	set options($option) ""
    }

    foreach { option value } $args {
	if {[lsearch -exact $expectedArgs $option] == -1} {
	    error "Unexpected option \"$option\" - only expect $expectedArgs"
	}
	set options($option) "$value"
    }

    set args "$args -objectType table"

    eval "alterPrivilegesRaiser \"Edit Privileges For Table\
        $options(-tableName)\" $args"
}

proc alterPrivilegesOnUserContextMenu { args } {
    set expectedArgs \
	[list \
	-clusterCollectionName\
	-clusterName\
	-userName \
	]

    foreach option $expectedArgs {
	set options($option) ""
    }

    foreach { option value } $args {
	if {[lsearch -exact $expectedArgs $option] == -1} {
	    error "Unexpected option \"$option\" - only expect $expectedArgs"
	}
	set options($option) "$value"
    }

    set args "$args -objectType user"

    eval "alterPrivilegesRaiser \"Manage Privileges For User \
        $options(-userName)\" $args"
}

proc alterPrivilegesOnGroupContextMenu { args } {
    set expectedArgs \
	[list \
	-clusterCollectionName\
	-clusterName\
	-groupName \
	]

    foreach option $expectedArgs {
	set options($option) ""
    }

    foreach { option value } $args {
	if {[lsearch -exact $expectedArgs $option] == -1} {
	    error "Unexpected option \"$option\" - only expect $expectedArgs"
	}
	set options($option) "$value"
    }

    set args "$args -objectType group"
    eval "alterPrivilegesRaiser \"Manage Privileges For Group \
        $options(-groupName)\" $args"
}

# End of file
