# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Application menu and related functions
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package require Tk
package require Itcl
package require Itk
package require aboutBox
package require mainMisc
package require SQLLogWindow
package require clusterConfiguration

package provide menuProcs 1.0

proc getMenuBar {name} {
    global setting_showSystemObjects
    global setting_askConfirmations
    global setting_logSQLData

    set setting_showSystemObjects 1
    set setting_askConfirmations 1
    set setting_logSQLData 1

    set menuBarName $name

    iwidgets::menubar $name -menubuttons {
	menubutton file -text "File" -underline 0 -menu {
	    command add \
		-label "Add Cluster..." \
		-underline 1 \
		-command cluster_add
	    
	    command refresh \
		-label "Refresh Tree" \
		-underline 1 \
		-command file_refreshHierbox

	    separator sep1
	    
	    command exit \
		-label "Exit" \
		-underline 1 \
		-command "cleanUp"
	}

	menubutton edit -text "Edit" -underline 0 -menu {
	    command configureClusters \
		-label "Cluster Configuration..." \
		-underline 1 \
		-command configure_clusters
	}
	
	menubutton view -text "View" -underline 0 -menu {
	    checkbutton hideSystemObjects \
		-label "Show System Objects" \
		-underline 7 \
		-command view_toggleShowSystemObjects\
		-offvalue 0\
		-onvalue 1 \
		-indicatoron 1\
		-variable setting_showSystemObjects
		
	    checkbutton skipConfirmations \
		-label "Ask For Confirmations" \
		-command confirmConfirmDisable \
		-underline 8 \
		-offvalue 0\
		-onvalue 1 \
		-indicatoron 1\
		-variable setting_askConfirmations

	    checkbutton logSQLData \
		-label "Log SQL Data" \
		-underline 8 \
		-offvalue 0\
		-onvalue 1 \
		-indicatoron 1\
		-variable setting_logSQLData

	    separator sep1

	    command sqllog \
		    -label "Show SQL Log Window" \
		    -underline 1 \
		    -command showSQLLogWindow
	}

	# The H in "Help" is not underlined because "Alt-H" key events
	# are being eaten somewhere. They are not being received by
	# the binding that is set-up when -underline 0 is given an an
	# argument to menubutton
	menubutton help -text "Help" -menu {
	    command about \
		-label "About..." \
		-underline 1 \
		-command aboutBox
	}
    }
}

proc view_toggleShowSystemObjects {} {
    global setting_askConfirmations
    global setting_showSystemObjects
    global leftcs
    global rightcs

    set asIs $setting_showSystemObjects

    # If "Ask for confirmation" is on, notify the user that toggling
    # the display of system objects will collapse the tree, and ask
    # for confirmation

    if { $setting_askConfirmations == 1 } {
        if { $setting_showSystemObjects == 0 } {
            set title "Turn Off System Objects"
            set message "Disabling the display of system objects will cause a tree collapse in order to reset the tree contents. \n\
                         \nAre you sure you want to disable the display of system objects now?"
        } else {
            set title "Turn On System Objects"
            set message "Enabling the display of system objects will cause tree collapse in order to reset the tree contents. \n\
                         \nAre you sure you want to enable the display of system objects now?"
        }
        set sure [tk_messageBox -title $title -message $message -icon warning -type yesno]
        switch -- $sure {
            no {
                set setting_showSystemObjects [expr 1 - $asIs]
            }
            yes {
                $leftcs.box configure -showSystemObjects $setting_showSystemObjects
                $rightcs.megaView configure -showSystemObjects $setting_showSystemObjects
	        refreshHierbox
            }
        }

    # If "Ask for confirmation" is off, just toggle the display
    # of system objects

    } else {
        $leftcs.box configure -showSystemObjects $setting_showSystemObjects
        $rightcs.megaView configure -showSystemObjects $setting_showSystemObjects
        refreshHierbox
    }
}

proc confirmConfirmDisable {} {

    global setting_askConfirmations

    # If "Ask for confirmation" was on
    # Note: We check if the setting is 0. THIS IS CORRECT. That is because
    # this proc is called when the menu item is clicked. When clicked, the
    # value is first changed, and then the proc is called. So basically
    # we can only check the new value. If new is 0, then old must have been
    # 1. Hence we check if new is 0.

    if { $setting_askConfirmations == 0 } {
        set disable [tk_messageBox -icon warning -type yesno \
	    -title "Turn Off Confirmations" \
	    -message "By default the program displays confirmations whenever deleting / dropping objects, or when an action will cause the collapse of the tree. These confirmations are currently enabled.\n\
                      \nAre you sure you wish to disable confirmations?"]

	if { $disable == "yes"} {
	    set setting_askConfirmations 0
	} else {
	    set setting_askConfirmations 1
	}
    }
}

proc file_refreshHierbox {} {

    global setting_askConfirmations

    # If "Ask for confirmation" is on, notify the user that refreshing
    # the tree will cause it to collapse, and ask for confirmation

    if { $setting_askConfirmations == 1 } {
        set refresh [tk_messageBox -icon warning -type yesno \
	    -title "Refresh Tree" \
	    -message "Refreshing the tree will cause the tree to collapse.\n\
                      \nAre you sure you wish to refresh the tree?"]

	if { $refresh == "yes"} {
	    refreshHierbox
	}

    # If "Ask for confirmation" is off, just refresh the tree

    } else {
        refreshHierbox
    }
}

proc aboutBox {} {
    global applicationName
    global splashScreen
    global versionNumber
    global releaseStatus
    global copyrightInfo
    global contactTagline

    displayAboutBox \
	   "About $applicationName"\
	   splashScreen \
	   "$applicationName\n \
	   $versionNumber\n \n \
	   $releaseStatus\n\n \
           $copyrightInfo\n\n \
	   $contactTagline\n"
}

# End of file
