# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# TCL code to create a dialog to handle supported langauages (PL/pgSQL, 
# PL/Tcl, PL/TclU and PL/Perl)
#
# Written for Red Hat Inc. by Permaine Cheung <pcheung@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package require Tk
package require Itcl
package require Itk
package require Iwidgets
package require managePLDialog
package provide plHandler 1.0

proc plHandle { args } {

    # Create the window
    toplevel .handlePL

    # Withdraw the window while we pack it
    wm withdraw .handlePL

    # Disable the main program window
    wm transient .handlePL .
    grab .handlePL

    # Create a frame to hold the dialog

    frame .handlePL.hostedDialog -relief groove -borderwidth 1

    # Place the dialog in the window inside the frame

    if {[catch {eval ManagePLDialog .handlePL.hostedDialog.managePLDialog $args} errorText]} {
	tk_messageBox -icon error -message "An error occurred while raising the dialog box:\n $errorText\nThe operation was aborted." -title "errorText"
	handlePLDialog_Cancel
	return
    }

    # Pack the frame

    pack .handlePL.hostedDialog.managePLDialog -fill both -expand y
    pack .handlePL.hostedDialog -side top -fill both -expand y

    # Create and pack OK and Cancel Buttons
    button .handlePL.okButton -text "OK" -underline 0 -command handlePLDialog_OK
    button .handlePL.cancelButton -text "Cancel" -underline 0 -command handlePLDialog_Cancel
    pack .handlePL.cancelButton .handlePL.okButton -side right

    bind .handlePL <Alt-o> {handlePLDialog_OK; break}
    bind .handlePL <Alt-c> {handlePLDialog_Cancel; break}
    bind .handlePL.okButton <Return> {handlePLDialog_OK; break}
    bind .handlePL.cancelButton <Return> {handlePLDialog_Cancel; break}
    bind .handlePL <Escape> {handlePLDialog_Cancel; break}

    # Set the window title

    wm title .handlePL "Manage Supported Languages"
    wm deiconify .handlePL
}


proc handlePLDialog_OK {} {
    
    # First, validate the form

    set errorText [.handlePL.hostedDialog.managePLDialog validate]

    if {$errorText != "" } {

        # No, so display error message

        tk_messageBox -icon error -title "Error" \
                -message "$errorText"

        return
    }

    # Start the busy indicator

    status loadNotify 1

    # Now try and execute the action (apply the form)
    
    if {[catch {set errorText [.handlePL.hostedDialog.managePLDialog apply]} errorText2]} {

	# Lower the busy indicator

	status loadNotify 0

	tk_messageBox -icon error -title "Error" \
	    -message "An error occurred while processing this directive:\n$errorText2\nThe operation was aborted."
	return
    }

    # Lower the busy indicator

    status loadNotify 0

    # Check if everything went cleanly

    if {$errorText != "" } {

	# No, so display error message

	tk_messageBox -icon error -title "Error" \
		-message "The backend returned the error:\n $errorText"
    } else {
	
	# Yes, so lower the dialog (just use the cancel procedure)

	handlePLDialog_Cancel

	# Issue a refresh
	# Note that this hardcodes the hyperlink dispatcher / hyperlink
	# watcher names

	hyperlinker selectorMoveRequest [hyperlinkWatcher getCurrentLocation]
    }
    
}

proc handlePLDialog_Cancel {} {
    destroy .handlePL
}

# End of file

