# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Context pop-up menus for database objects in the hierbox list
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package require megaContextMenuGenerator
package provide popUpHandler 1.0

menu .popup -tearoff 0

MegaContextMenuGenerator contextMenuGenerator

proc popUpHandler { X Y args} {
    global clusterCollectionName
    eval contextMenuGenerator setArgs "$args -clusterCollectionName $clusterCollectionName"
    contextMenuGenerator populateMenu .popup
    .popup configure -font "Helvetica 11 normal"
    tk_popup .popup $X $Y
}

# End of file


