# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Utility procedures that use Tk
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package provide tkBits 1.0
package require Iwidgets

# Helper used for button bind by tkGetString

proc tkGetString_ok {} {
    global tkGetString_string
    global tkGetString_tempString

    set tkGetString_string $tkGetString_tempString
}

# Display a dialog prompting for a single string field
# Return the string

proc tkGetString { title message } {
    global tkGetString_string
    global tkGetString_tempString
    
    toplevel .tkGetString

    wm title .tkGetString $title

    iwidgets::entryfield .tkGetString.field -validate alphabetic -labeltext $message -textvariable tkGetString_tempString

    button .tkGetString.okButton -text "OK"

    pack .tkGetString.field -side left -expand 1 -fill y
    pack .tkGetString.okButton -side right -fill y
 
    bind .tkGetString.okButton <Button-1> tkGetString_ok
    
    set x [expr ([winfo screenwidth .]-[winfo reqwidth .tkGetString]) / 2]
    set y [expr ([winfo screenheight .]-[winfo reqheight .tkGetString]) / 2]
    wm geometry .tkGetString "+$x+$y"

    tkwait variable tkGetString_string
    unset tkGetString_tempString
    
    destroy .tkGetString
    
    return $tkGetString_string
}

# Center a window over another

proc placeWindow {window parent} {
    update idletasks
    set x [expr [winfo rootx $parent] + ([winfo width $parent]-[winfo reqwidth $window]) / 2]
    set y [expr [winfo rooty $parent] + ([winfo height $parent]-[winfo reqheight $window]) / 2]
    wm geometry $window "+$x+$y"
}

# End of file
