# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Generator for unique names in global scope
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package provide uniqueName 1.0

set uniqueNameCount 0

proc getUniqueName {} {
    global uniqueNameCount 

    # Get the unique name

    set uniqueName "generatedUniqueName[incr uniqueNameCount]"
    upvar #0 $uniqueName uniqueVar

    # Just for safety check that someone hasn't grabbed this

    while {[info exists uniqueVar]} {

	# Someone has grabbed it
	# Generate another

	set uniqueName "generatedUniqueName[incr uniqueNameCount]"
	upvar #0 $uniqueName uniqueVar
    }

    # Return the unique name

    return $uniqueName
}

# End of file
