#ifndef _RHEO_CAD_ELEMENT_H
#define _RHEO_CAD_ELEMENT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/reference_element.h"
#include "rheolef/point.h"
namespace rheolef { 

struct cad_element : public reference_element {

// allocator:

    cad_element();

// accessor:

    std::string name() const;
    size_type size() const;
    size_type degree() const;
    size_type degree2() const;
    size_type operator[](size_type i) const;
    bool is_linear() const;
    size_type n_node_from_degree (size_type deg, size_type deg2) const;
    size_type n_face_from_degree (size_type deg, size_type deg2) const;

    point ref_node (size_type i) const;
    void  ref_node (size_type i, point& x_ref) const;

    point ref_node_from_degree (size_type i, size_type subdeg, size_type subdeg2) const;
    void  ref_node_from_degree (size_type i, size_type subdeg, size_type subdeg2, point& x_ref) const;

// modifiers:

    void set_type (enum_type t, size_type deg = 1, size_type deg2 = std::numeric_limits<size_type>::max());
    size_type& operator[](size_type i);

// input/output:

    void put_rheo(std::ostream& os) const;

// data:

    size_type         _deg;
    size_type         _deg2;
    std::vector<size_type> _points;
};
// ---------------------------------------------------------------------------
// inlined
// ---------------------------------------------------------------------------
inline
cad_element::cad_element()
  : reference_element(), 
    _deg(0), 
    _deg2(0),
    _points()
{
}
inline
cad_element::size_type 
cad_element::size() const
{
    return _points.size();
}
inline
cad_element::size_type 
cad_element::degree() const
{
    return _deg;
}
inline
cad_element::size_type 
cad_element::degree2() const
{
    return _deg2;
}
inline
cad_element::size_type 
cad_element::operator[](size_type i) const
{
    return _points[i];
}
inline
cad_element::size_type&
cad_element::operator[](size_type i)
{
    return _points[i];
}
inline
bool
cad_element::is_linear() const
{
    return (_deg == 1 && (type() != q || _deg2 == 1));
}
inline
point
cad_element::ref_node_from_degree (size_type i, size_type subdeg, size_type subdeg2) const
{
    point x_ref;
    ref_node_from_degree (i, subdeg, subdeg2, x_ref);
    return x_ref;
}
inline
void
cad_element::ref_node (size_type i, point& x_ref) const
{
    ref_node_from_degree (i, degree(), degree2(), x_ref);
}
inline
point
cad_element::ref_node (size_type i) const
{
    point x_ref;
    ref_node (i, x_ref);
    return x_ref;
}
}// namespace rheolef
#endif // _RHEO_CAD_ELEMENT_H
