///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef.h"
#include "rounder.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment parallel(argc, argv);
  geo omega (argv[1]);
  Float tol  = (argc > 2) ? atof(argv[2]) : 1e-15;
  Float prec = (argc > 3) ? atof(argv[3]) : 1e-10;
  space Xh (omega, "P1");
  if (omega.dimension() >= 3) {
    Xh.block("back");
    Xh.block("front");
  }
  if (omega.dimension() >= 2) {
    Xh.block("top");
    Xh.block("bottom");
  }
  Xh.block("left");
  Xh.block("right");
  form a (Xh, Xh, "grad_grad");
  form m (Xh, Xh, "mass");
  field fh (Xh, 1.0);
  field uh (Xh, 0.0);
#ifdef TODO
  uh ["boundary"] = 0;
#endif // TODO
#ifdef TODO
  uh.u() = 0;
#endif // TODO
  size_t max_iter = 10000;
  int status = pcg (a.uu(), uh.u(), m.uu()*fh.u() + m.ub()*fh.b() - a.ub()*uh.b(),
                  eye<Float>(), max_iter, tol, &pcerr);
  pcout << setprecision(15) << compose (rounder(prec),uh);
  pcerr << "uh.u.par_size = " << uh.u().par_size() << endl
        << uh.u();
  pcerr << "uh.b.par_size = " << uh.b().par_size() << endl
        << uh.b();
}
