#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# --------------------------------------------------------------------
# run tests on scalar problems
# --------------------------------------------------------------------
BINGEO=${BINGEO-"../../nfem/bin"}
BINFEM=${BINFEM-"../../nfem/bin"}
SRCDIR=${SRCDIR-"../../../rheolef/doc/usrman"}
SRCGEO=${SRCGEO-"../../../rheolef/nfem/data"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../../nfem/basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../../nfem/basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../../nfem/form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

command="${BINGEO}/mkgeo_grid_1d 10       -region > line.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${BINGEO}/mkgeo_grid_2d 10 10    -region > square.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${BINGEO}/mkgeo_grid_3d  4  4  4 -region | ${BINFEM}/geo -upgrade -geo - > cube.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi


prgs="transmission"
check="transmission-error"
pols="P1"
geos="line square cube"
for p in $prgs; do
  for g in $geos; do
    for r in $pols; do
      command="./transmission $g $r | ./transmission-error"
      echo "      $command"
      eval $command 2>/dev/null
      if test $? -ne 0; then status=1; echo "        => *NO*"; fi
    done
  done
done

# --------------------------------------------------------------------
# clean
# --------------------------------------------------------------------
command="/bin/rm -f line.geo square.geo cube.geo"
echo "      $command"
eval $command 2>/dev/null

exit $status

