#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

command="../bin/mkgeo_grid_1d 10 | ./form_solve_tst P1 -round - left right"
echo "      $command"
eval $command 2>/dev/null | diff -bw ${SRCDIR}/form-solve-1d-P1.field - >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="../bin/mkgeo_grid_1d 10 | ./form_solve_tst P2 -round - left right"
echo "      $command"
eval $command  2>/dev/null | diff -bw ${SRCDIR}/form-solve-1d-P2.field - >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./form_solve_tst P1 -I${GEODIR} carre-v2 top bottom left right -ndigit 5 "
echo "      $command"
eval $command 2>/dev/null | diff -bw ${SRCDIR}/form_solve.field - >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="../bin/geo -upgrade -geo -I${GEODIR} box-T-3 | ./form_solve_tst P1 -name box-T-3 - top bottom left right foreground background -ndigit 5"
echo "      $command"
eval $command 2>/dev/null | diff -bw ${SRCDIR}/form_solve_3d.field - >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./form_solve_tst P2 -round -I${GEODIR} carre-v2 top bottom left right"
echo "      $command"
(eval $command > /dev/null) 2>&1 | grep u_ex | diff -bw ${SRCDIR}/form_solve_P2.valid - >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

exit $status

