///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test de techniques boost::preprocessor 
// en vue de la classe polymorphic_array<T>
//
// Author: Pierre.Saramito@imag.fr
//
// Date: 14 dec 2010
//
#ifndef BOOST_PP_IS_ITERATING

#ifndef _RHEOLEF_PP_BOOST_TST_CC
#define _RHEOLEF_PP_BOOST_TST_CC

#include <typeinfo>
#include <boost/mpl/vector.hpp>
#include <boost/mpl/size.hpp>
#include <boost/mpl/for_each.hpp>
#include <boost/mpl/at.hpp>
#include <boost/mpl/transform.hpp>
#include <boost/mpl/copy.hpp>
namespace mpl = boost::mpl;

#include <iostream>
#include <typeinfo>
using namespace std;

#include "rheolef/pretty_name.h"

#include "rheolef/distributor.h"
using namespace rheolef;

// the max number of derived class supported (not reached):
#define POLYMORPHIC_MAX_SIZE 4

// ---------------------------------------------------------
// 1) Horizontal repetition
// ---------------------------------------------------------
template <class V, int N>
struct polymorphic_data_v1 { };

#include <boost/preprocessor/repetition.hpp>
#include <boost/preprocessor/arithmetic/inc.hpp>
//#include <boost/preprocessor/punctuation/comma_if.hpp>

#define POLYMORPHIC_DATA_body_impl(z, k, unused)		\
    typedef typename mpl::at_c<V,k>::type T##k;              	\
    std::vector<T##k> _x##k;					\
    void f(T##k*t) const { 					\
	warning_macro ("f ("<< pretty_typename_macro(T##k) << ")");	\
    }

#define POLYMORPHIC_DATA_body(n) 			\
	BOOST_PP_REPEAT(n, POLYMORPHIC_DATA_body_impl, ~)

#define POLYMORPHIC_DATA(z, n, version)			\
template <class V>					\
struct polymorphic_data_v##version<V,n> {		\
    polymorphic_data_v##version<V,n>() {		\
	warning_macro ("cstor N="<<n);			\
    }							\
    POLYMORPHIC_DATA_body(n)				\
};

#define POLYMORPHIC_DATA_v1_declare(max_n)		\
	BOOST_PP_REPEAT(max_n, POLYMORPHIC_DATA, 1)

// main call:
POLYMORPHIC_DATA_v1_declare(POLYMORPHIC_MAX_SIZE)

#undef POLYMORPHIC_DATA_v1_declare
// ---------------------------------------------------------
// 2) Local iteration
// ---------------------------------------------------------

#include <boost/preprocessor/iteration/local.hpp>

template <class V, int N>
struct polymorphic_data_v2 { };

// main call:
#define  BOOST_PP_LOCAL_MACRO(n)   POLYMORPHIC_DATA(~, n, 2)
#define  BOOST_PP_LOCAL_LIMITS     (0, POLYMORPHIC_MAX_SIZE - 1)
#include BOOST_PP_LOCAL_ITERATE()
#undef   BOOST_PP_LOCAL_LIMITS
#undef   BOOST_PP_LOCAL_MACRO

// ---------------------------------------------------------
// 3) File iteration
// ---------------------------------------------------------

template <class V, int N>
struct polymorphic_data_v3 { };

#include <boost/preprocessor/iteration/iterate.hpp>

// main call:
#define  BOOST_PP_ITERATION_LIMITS (0, POLYMORPHIC_MAX_SIZE - 1)
#define  BOOST_PP_FILENAME_1       "pp_boost_tst_polymporphic_data.icc"
#include BOOST_PP_ITERATE()
#undef   BOOST_PP_FILENAME_1 
#undef   BOOST_PP_ITERATION_LIMITS

// ---------------------------------------------------------
// 4) self-iteration
// ---------------------------------------------------------

#include <boost/preprocessor/repetition.hpp>
#include <boost/preprocessor/arithmetic/sub.hpp>
#include <boost/preprocessor/iteration/iterate.hpp>

template <class V, int N>
struct polymorphic_data_v4 { };

// generate specializations
#define BOOST_PP_ITERATION_LIMITS (0, POLYMORPHIC_MAX_SIZE - 1)
#define BOOST_PP_FILENAME_1    "pp_boost_tst.cc" // this file
#include BOOST_PP_ITERATE()

// ---------------------------------------------------------
// undef internal macros
// ---------------------------------------------------------
#undef POLYMORPHIC_DATA_body_impl
#undef POLYMORPHIC_DATA_body
#undef POLYMORPHIC_DATA

#endif // _RHEOLEF_PP_BOOST_TST_CC

#else // BOOST_PP_IS_ITERATING

#define n BOOST_PP_ITERATION()

template <class V>
struct polymorphic_data_v4<V,n> {
    polymorphic_data_v4<V,n>() {
        warning_macro ("cstor N="<<n);
    }
    POLYMORPHIC_DATA_body(n)
};

#undef n

#endif // BOOST_PP_IS_ITERATING

#ifndef BOOST_PP_IS_ITERATING
// ------------------------------------
// application
// ------------------------------------
struct none {};

struct element {};
struct edge : element {};
struct triangle : element {};
struct quadrangle : element {};
struct tetra : element {};
struct penta : element {};
struct hexa : element {};

typedef mpl::vector1<edge>                  v1d;
typedef mpl::vector2<triangle,quadrangle>   v2d;
typedef mpl::vector3<tetra,penta,hexa>      v3d;

typedef polymorphic_data_v1<v3d,3> data_type;

int main(int argc, char**argv) {
  environment distributed (argc,argv);
  polymorphic_data_v1<v3d,3> data1;
  data1.f((tetra*)0);
  data1.f((penta*)0);
  data1.f((hexa*)0);
  polymorphic_data_v2<v3d,3> data2;
  data2.f((tetra*)0);
  data2.f((penta*)0);
  data2.f((hexa*)0);
  polymorphic_data_v3<v3d,3> data3;
  data3.f((tetra*)0);
  data3.f((penta*)0);
  data3.f((hexa*)0);
  polymorphic_data_v4<v3d,3> data4;
  data4.f((tetra*)0);
  data4.f((penta*)0);
  data4.f((hexa*)0);
#ifdef TODO
#endif // TODO
};
#endif // BOOST_PP_IS_ITERATING
