#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
GEODIR="${TOP_SRCDIR}/nfem/ptst"
NPROC_MAX=${NPROC_MAX-"8"}
SBINDIR="${TOP_SRCDIR}/nfem/sbin"
BINDIR="${TOP_SRCDIR}/nfem/pbin"
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

#echo "    skipped (not yet)"
#exit 0

#TODO: due to a limitation in weighted forms, failed when combining full compile code optimization and mpirun
if test $NPROC_MAX -gt 1; then
  NPROC_MAX=1
fi

run "${SBINDIR}/mkgeo_grid_2d -v4 11 11 -a -1 -b 1 -c -1 -d 1 -boundary 2>/dev/null | ${BINDIR}/geo -upgrade - > mesh-2d.geo 2>/dev/null"
if test $? -ne 0; then exit 1; fi

progs="p_laplacian_newton"
approxs="P1 P2 P3"
pvalues="1.5 2.5" ;# 1.5 => singular matrix for P1 with mumps(np>1) and P2, P3 with mumps and pastix
for prog in $progs; do
  for approx in $approxs; do
    for p in $pvalues; do
      # Pk approx diverges for p < 2 && k >= 2
      if test $p = "1.5" && test $approx = "P2" -o $approx = "P3"; then continue; fi
      loop_mpirun "./$prog mesh-2d.geo $approx $p 1e-10 2>/dev/null | \$RUN ./p_laplacian_post - -check >/dev/null 2>/dev/null"
      if test $? -ne 0; then status=1; fi
    done
  done
done
# --------------------------------------------------------------------
# clean
# --------------------------------------------------------------------
run "/bin/rm -f mesh-2d.geo.geo"

exit $status
