// file automatically generated by "basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P2.h"
using namespace rheolef;
using namespace std;
class basis_P2_p {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_e {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_t {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_q {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_T {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_P {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_H {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
basis_rep::dof_family_type
basis_P2_p::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_p::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = 1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_p::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_p::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_p::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] = 1.0;
}
void
basis_P2_p::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
}
void
basis_P2_p::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_p::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point();
}
basis_rep::dof_family_type
basis_P2_e::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_e::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  -3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+1.0;
      return val;
    }
    case 1: {
      val = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 2: {
      val =  -4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_e::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
      return val;
    }
    case 1: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
      return val;
    }
    case 2: {
      val[0] =  -8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_e::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_e::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(3);
  typedef Float T;
  values[0] =  -3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+1.0;
  values[1] = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
  values[2] =  4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]);
}
void
basis_P2_e::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(3);
  typedef Float T;
  values[0][0] =  4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[1][0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[2][0] =  -8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
}
void
basis_P2_e::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(3,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_e::hat_node(
  vector<point>& x)
{
  x.resize(3);
  x[0] = point(0.0);
  x[1] = point(1.0);
  x[2] = point(5.0000000000000000e-01);
}
basis_rep::dof_family_type
basis_P2_t::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_t::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  2.0000000000000000e+00*(hat_x[1]*hat_x[1])+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[1]*( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)+-3.0000000000000000e+00*hat_x[0]+1.0;
      return val;
    }
    case 1: {
      val = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 2: {
      val = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 3: {
      val =  -4.0000000000000000e+00*(hat_x[0]*hat_x[0])+-4.0000000000000000e+00*hat_x[1]*hat_x[0]+4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 4: {
      val = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
      return val;
    }
    case 5: {
      val =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_t::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      val[1] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      return val;
    }
    case 1: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
      val[1] = 0.0;
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
      return val;
    }
    case 3: {
      val[0] =  -8.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00;
      val[1] = -4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 4: {
      val[0] = 4.0000000000000000e+00*hat_x[1];
      val[1] = 4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 5: {
      val[0] = -4.0000000000000000e+00*hat_x[1];
      val[1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_t::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_t::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(6);
  typedef Float T;
  values[0] =  -3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[1]*hat_x[1])+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[1]*( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)+1.0;
  values[1] = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
  values[2] = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
  values[3] =  -4.0000000000000000e+00*hat_x[1]*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0];
  values[4] = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
  values[5] =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1];
}
void
basis_P2_t::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(6);
  typedef Float T;
  values[0][0] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
  values[0][1] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[1][0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[1][1] = 0.0;
  values[2][0] = 0.0;
  values[2][1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
  values[3][0] =  -4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
  values[3][1] = -4.0000000000000000e+00*hat_x[0];
  values[4][0] = 4.0000000000000000e+00*hat_x[1];
  values[4][1] = 4.0000000000000000e+00*hat_x[0];
  values[5][0] = -4.0000000000000000e+00*hat_x[1];
  values[5][1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00;
}
void
basis_P2_t::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(6,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_t::hat_node(
  vector<point>& x)
{
  x.resize(6);
  x[0] = point(0.0, 0.0);
  x[1] = point(1.0, 0.0);
  x[2] = point(0.0, 1.0);
  x[3] = point(5.0000000000000000e-01, 0.0);
  x[4] = point(5.0000000000000000e-01, 5.0000000000000000e-01);
  x[5] = point(0.0, 5.0000000000000000e-01);
}
basis_rep::dof_family_type
basis_P2_q::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_q::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0;
      return val;
    }
    case 1: {
      val =  (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0;
      return val;
    }
    case 2: {
      val =  ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/4.0+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/4.0;
      return val;
    }
    case 3: {
      val =  (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0;
      return val;
    }
    case 4: {
      val = -( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0;
      return val;
    }
    case 5: {
      val =  hat_x[0]/2.0-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0+(hat_x[0]*hat_x[0])/2.0;
      return val;
    }
    case 6: {
      val = -hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/2.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0;
      return val;
    }
    case 7: {
      val =  (hat_x[1]*hat_x[1])*( hat_x[0]-(hat_x[0]*hat_x[0]))/2.0-hat_x[0]/2.0+(hat_x[0]*hat_x[0])/2.0;
      return val;
    }
    case 8: {
      val =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_q::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0-hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0;
      val[1] = -hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))/2.0+hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0;
      return val;
    }
    case 1: {
      val[0] = -( 2.0*hat_x[0]+1.0)*hat_x[1]/4.0+( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/4.0;
      val[1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0-hat_x[0]/4.0;
      return val;
    }
    case 2: {
      val[0] =  ( 2.0*hat_x[0]+1.0)*hat_x[1]/4.0+( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/4.0;
      val[1] =  hat_x[0]/4.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0+(hat_x[0]*hat_x[0])/4.0;
      return val;
    }
    case 3: {
      val[0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0+hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0;
      val[1] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/2.0-hat_x[0]/4.0+(hat_x[0]*hat_x[0])/4.0;
      return val;
    }
    case 4: {
      val[0] = -hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1];
      val[1] =  (hat_x[0]*hat_x[0])/2.0-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(1.0/2.0);
      return val;
    }
    case 5: {
      val[0] = -( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/2.0+hat_x[0]+(1.0/2.0);
      val[1] = -( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1];
      return val;
    }
    case 6: {
      val[0] = -hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]);
      val[1] = -hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
      return val;
    }
    case 7: {
      val[0] = -(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/2.0+hat_x[0]-(1.0/2.0);
      val[1] = -( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1];
      return val;
    }
    case 8: {
      val[0] =  2.0*(hat_x[1]*hat_x[1])*hat_x[0]+-2.0*hat_x[0];
      val[1] = 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1];
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_q::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_q::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(9);
  typedef Float T;
  values[0] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0;
  values[1] =  ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/4.0-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/4.0;
  values[2] =  ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/4.0+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/4.0;
  values[3] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0;
  values[4] =  hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/2.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0;
  values[5] = -( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/2.0+(hat_x[0]*hat_x[0])/2.0+hat_x[0]/2.0;
  values[6] = -hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/2.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0;
  values[7] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/2.0-hat_x[0]/2.0+(hat_x[0]*hat_x[0])/2.0;
  values[8] = -(hat_x[0]*hat_x[0])+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])+1.0;
}
void
basis_P2_q::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(9);
  typedef Float T;
  values[0][0] = -hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0;
  values[0][1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0+hat_x[0]/4.0;
  values[1][0] = -hat_x[1]*( 2.0*hat_x[0]+1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/4.0;
  values[1][1] =  hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0-hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0;
  values[2][0] =  ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/4.0+( 2.0*hat_x[0]+1.0)*hat_x[1]/4.0;
  values[2][1] =  (hat_x[0]*hat_x[0])/4.0+hat_x[0]/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0;
  values[3][0] =  hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0;
  values[3][1] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/2.0-hat_x[0]/4.0+(hat_x[0]*hat_x[0])/4.0;
  values[4][0] = -hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1];
  values[4][1] =  (hat_x[0]*hat_x[0])/2.0-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(1.0/2.0);
  values[5][0] =  hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/2.0+(1.0/2.0);
  values[5][1] = -hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]));
  values[6][0] = -(hat_x[1]*hat_x[1])*hat_x[0]-hat_x[1]*hat_x[0];
  values[6][1] = -(hat_x[0]*hat_x[0])/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(1.0/2.0);
  values[7][0] = -(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/2.0+hat_x[0]-(1.0/2.0);
  values[7][1] = -( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1];
  values[8][0] =  2.0*hat_x[0]*(hat_x[1]*hat_x[1])+-2.0*hat_x[0];
  values[8][1] = 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1];
}
void
basis_P2_q::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(9,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_q::hat_node(
  vector<point>& x)
{
  x.resize(9);
  x[0] = point(-1.0, -1.0);
  x[1] = point(1.0, -1.0);
  x[2] = point(1.0, 1.0);
  x[3] = point(-1.0, 1.0);
  x[4] = point(0.0, -1.0);
  x[5] = point(1.0, 0.0);
  x[6] = point(0.0, 1.0);
  x[7] = point(-1.0, 0.0);
  x[8] = point(0.0, 0.0);
}
basis_rep::dof_family_type
basis_P2_T::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_T::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)*hat_x[1]+-3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[2]*( 4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00)+1.0;
      return val;
    }
    case 1: {
      val = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 2: {
      val = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 3: {
      val =  2.0000000000000000e+00*(hat_x[2]*hat_x[2])-hat_x[2];
      return val;
    }
    case 4: {
      val =  4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*hat_x[0]*hat_x[2]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 5: {
      val = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
      return val;
    }
    case 6: {
      val =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1]+-4.0000000000000000e+00*hat_x[1]*hat_x[2];
      return val;
    }
    case 7: {
      val =  -4.0000000000000000e+00*(hat_x[2]*hat_x[2])+( -4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00)*hat_x[2];
      return val;
    }
    case 8: {
      val = 4.0000000000000000e+00*hat_x[0]*hat_x[2];
      return val;
    }
    case 9: {
      val = 4.0000000000000000e+00*hat_x[1]*hat_x[2];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_T::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
      val[1] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
      val[2] =  4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      return val;
    }
    case 1: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
      val[1] = 0.0;
      val[2] = 0.0;
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
      val[2] = 0.0;
      return val;
    }
    case 3: {
      val[0] = 0.0;
      val[1] = 0.0;
      val[2] =  4.0000000000000000e+00*hat_x[2]-1.0000000000000000e+00;
      return val;
    }
    case 4: {
      val[0] =  -8.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00;
      val[1] = -4.0000000000000000e+00*hat_x[0];
      val[2] = -4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 5: {
      val[0] = 4.0000000000000000e+00*hat_x[1];
      val[1] = 4.0000000000000000e+00*hat_x[0];
      val[2] = 0.0;
      return val;
    }
    case 6: {
      val[0] = -4.0000000000000000e+00*hat_x[1];
      val[1] =  -8.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+-4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      val[2] = -4.0000000000000000e+00*hat_x[1];
      return val;
    }
    case 7: {
      val[0] = -4.0000000000000000e+00*hat_x[2];
      val[1] = -4.0000000000000000e+00*hat_x[2];
      val[2] =  -8.0000000000000000e+00*hat_x[2]+-4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00;
      return val;
    }
    case 8: {
      val[0] = 4.0000000000000000e+00*hat_x[2];
      val[1] = 0.0;
      val[2] = 4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 9: {
      val[0] = 0.0;
      val[1] = 4.0000000000000000e+00*hat_x[2];
      val[2] = 4.0000000000000000e+00*hat_x[1];
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_T::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_T::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(10);
  typedef Float T;
  values[0] =  ( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)*hat_x[1]+-3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])+2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( 4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00)*hat_x[2]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+1.0;
  values[1] = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
  values[2] = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
  values[3] =  2.0000000000000000e+00*(hat_x[2]*hat_x[2])-hat_x[2];
  values[4] =  -4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[0]*hat_x[2]+-4.0000000000000000e+00*hat_x[0]*hat_x[1];
  values[5] = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
  values[6] =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1]+-4.0000000000000000e+00*hat_x[1]*hat_x[2];
  values[7] =  -4.0000000000000000e+00*(hat_x[2]*hat_x[2])+( -4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00)*hat_x[2];
  values[8] = 4.0000000000000000e+00*hat_x[0]*hat_x[2];
  values[9] = 4.0000000000000000e+00*hat_x[1]*hat_x[2];
}
void
basis_P2_T::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(10);
  typedef Float T;
  values[0][0] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[0][1] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[0][2] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[1][0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[1][1] = 0.0;
  values[1][2] = 0.0;
  values[2][0] = 0.0;
  values[2][1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
  values[2][2] = 0.0;
  values[3][0] = 0.0;
  values[3][1] = 0.0;
  values[3][2] =  4.0000000000000000e+00*hat_x[2]-1.0000000000000000e+00;
  values[4][0] =  -8.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00;
  values[4][1] = -4.0000000000000000e+00*hat_x[0];
  values[4][2] = -4.0000000000000000e+00*hat_x[0];
  values[5][0] = 4.0000000000000000e+00*hat_x[1];
  values[5][1] = 4.0000000000000000e+00*hat_x[0];
  values[5][2] = 0.0;
  values[6][0] = -4.0000000000000000e+00*hat_x[1];
  values[6][1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00;
  values[6][2] = -4.0000000000000000e+00*hat_x[1];
  values[7][0] = -4.0000000000000000e+00*hat_x[2];
  values[7][1] = -4.0000000000000000e+00*hat_x[2];
  values[7][2] =  -4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[2]+-4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
  values[8][0] = 4.0000000000000000e+00*hat_x[2];
  values[8][1] = 0.0;
  values[8][2] = 4.0000000000000000e+00*hat_x[0];
  values[9][0] = 0.0;
  values[9][1] = 4.0000000000000000e+00*hat_x[2];
  values[9][2] = 4.0000000000000000e+00*hat_x[1];
}
void
basis_P2_T::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(10,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_T::hat_node(
  vector<point>& x)
{
  x.resize(10);
  x[0] = point(0.0, 0.0, 0.0);
  x[1] = point(1.0, 0.0, 0.0);
  x[2] = point(0.0, 1.0, 0.0);
  x[3] = point(0.0, 0.0, 1.0);
  x[4] = point(5.0000000000000000e-01, 0.0, 0.0);
  x[5] = point(5.0000000000000000e-01, 5.0000000000000000e-01, 0.0);
  x[6] = point(0.0, 5.0000000000000000e-01, 0.0);
  x[7] = point(0.0, 0.0, 5.0000000000000000e-01);
  x[8] = point(5.0000000000000000e-01, 0.0, 5.0000000000000000e-01);
  x[9] = point(0.0, 5.0000000000000000e-01, 5.0000000000000000e-01);
}
basis_rep::dof_family_type
basis_P2_P::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_P::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  hat_x[2]*( 2.0*hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+1.5000000000000000e+00)+-2.0000000000000000e+00*(hat_x[1]*hat_x[1])+3.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])-1.0)/2.0+(hat_x[2]*hat_x[2])*( 2.0*hat_x[1]*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)+2.0*(hat_x[1]*hat_x[1])+-3.0000000000000000e+00*hat_x[0]+2.0*(hat_x[0]*hat_x[0])+1.0)/2.0;
      return val;
    }
    case 1: {
      val =  hat_x[2]*( 5.0000000000000000e-01*hat_x[0]-(hat_x[0]*hat_x[0]))+(hat_x[2]*hat_x[2])*( -5.0000000000000000e-01*hat_x[0]+(hat_x[0]*hat_x[0]));
      return val;
    }
    case 2: {
      val =  (-(hat_x[1]*hat_x[1])+5.0000000000000000e-01*hat_x[1])*hat_x[2]+(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])+-5.0000000000000000e-01*hat_x[1]);
      return val;
    }
    case 3: {
      val =  hat_x[2]*( 2.0*(hat_x[1]*hat_x[1])+2.0*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)*hat_x[1]+2.0*(hat_x[0]*hat_x[0])+-3.0000000000000000e+00*hat_x[0]+1.0)/2.0+(hat_x[2]*hat_x[2])*( 2.0*(hat_x[1]*hat_x[1])+2.0*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)*hat_x[1]+2.0*(hat_x[0]*hat_x[0])+-3.0000000000000000e+00*hat_x[0]+1.0)/2.0;
      return val;
    }
    case 4: {
      val =  hat_x[2]*( -5.0000000000000000e-01*hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[2]*hat_x[2])*( -5.0000000000000000e-01*hat_x[0]+(hat_x[0]*hat_x[0]));
      return val;
    }
    case 5: {
      val =  (hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])+-5.0000000000000000e-01*hat_x[1])+hat_x[2]*( (hat_x[1]*hat_x[1])+-5.0000000000000000e-01*hat_x[1]);
      return val;
    }
    case 6: {
      val =  ( 2.0000000000000000e+00*hat_x[0]*hat_x[1]+-2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]))*hat_x[2]+( -2.0000000000000000e+00*hat_x[0]*hat_x[1]+2.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2]);
      return val;
    }
    case 7: {
      val =  2.0000000000000000e+00*hat_x[0]*hat_x[1]*(hat_x[2]*hat_x[2])+-2.0000000000000000e+00*hat_x[0]*hat_x[1]*hat_x[2];
      return val;
    }
    case 8: {
      val =  ( hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)+-2.0000000000000000e+00*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])+hat_x[2]*( hat_x[1]*( 2.0000000000000000e+00*hat_x[0]-2.0000000000000000e+00)+2.0000000000000000e+00*(hat_x[1]*hat_x[1]));
      return val;
    }
    case 9: {
      val =  2.0000000000000000e+00*(hat_x[1]*hat_x[1])+-3.0000000000000000e+00*hat_x[0]+( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)*hat_x[1]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+3.0000000000000000e+00*hat_x[0]+hat_x[1]*( -4.0000000000000000e+00*hat_x[0]+3.0000000000000000e+00)+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])+1.0;
      return val;
    }
    case 10: {
      val =  2.0000000000000000e+00*(hat_x[0]*hat_x[0])+( -2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])-hat_x[0];
      return val;
    }
    case 11: {
      val =  (hat_x[2]*hat_x[2])*( hat_x[1]+-2.0000000000000000e+00*(hat_x[1]*hat_x[1]))-hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 12: {
      val =  ( -2.0000000000000000e+00*hat_x[1]*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])+2.0000000000000000e+00*hat_x[0])*hat_x[2]+( -2.0000000000000000e+00*hat_x[1]*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])+2.0000000000000000e+00*hat_x[0])*(hat_x[2]*hat_x[2]);
      return val;
    }
    case 13: {
      val =  2.0000000000000000e+00*hat_x[1]*hat_x[2]*hat_x[0]+2.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])*hat_x[0];
      return val;
    }
    case 14: {
      val =  (hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00))+hat_x[2]*( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00));
      return val;
    }
    case 15: {
      val =  (hat_x[2]*hat_x[2])*( hat_x[1]*( 4.0000000000000000e+00*hat_x[0]-4.0000000000000000e+00)+4.0000000000000000e+00*(hat_x[1]*hat_x[1]))+hat_x[1]*( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)+-4.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 16: {
      val =  4.0000000000000000e+00*hat_x[0]+(hat_x[2]*hat_x[2])*( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*(hat_x[0]*hat_x[0]))+-4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 17: {
      val =  4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*hat_x[0]*(hat_x[2]*hat_x[2])*hat_x[1];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_P::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  ( 2.0000000000000000e+00*hat_x[1]+2.0*hat_x[0]-1.5000000000000000e+00)*(hat_x[2]*hat_x[2])+hat_x[2]*( -2.0000000000000000e+00*hat_x[1]+-2.0000000000000000e+00*hat_x[0]+1.5000000000000000e+00);
      val[1] =  (hat_x[2]*hat_x[2])*( 2.0*hat_x[1]+2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)+( -2.0000000000000000e+00*hat_x[1]+-2.0000000000000000e+00*hat_x[0]+1.5000000000000000e+00)*hat_x[2];
      val[2] = -(hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])+hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+1.5000000000000000e+00)+hat_x[2]*( 2.0*(hat_x[0]*hat_x[0])+hat_x[1]*( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)+2.0*(hat_x[1]*hat_x[1])+-3.0000000000000000e+00*hat_x[0]+1.0)+1.5000000000000000e+00*hat_x[0]-(1.0/2.0);
      return val;
    }
    case 1: {
      val[0] =  hat_x[2]*( -2.0000000000000000e+00*hat_x[0]+5.0000000000000000e-01)+(hat_x[2]*hat_x[2])*( 2.0*hat_x[0]-5.0000000000000000e-01);
      val[1] = 0.0;
      val[2] =  hat_x[2]*(-hat_x[0]+2.0*(hat_x[0]*hat_x[0]))+5.0000000000000000e-01*hat_x[0]-(hat_x[0]*hat_x[0]);
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] =  hat_x[2]*( -2.0000000000000000e+00*hat_x[1]+5.0000000000000000e-01)+(hat_x[2]*hat_x[2])*( 2.0*hat_x[1]-5.0000000000000000e-01);
      val[2] = -(hat_x[1]*hat_x[1])+hat_x[2]*( 2.0*(hat_x[1]*hat_x[1])-hat_x[1])+5.0000000000000000e-01*hat_x[1];
      return val;
    }
    case 3: {
      val[0] =  (hat_x[2]*hat_x[2])*( 2.0*hat_x[0]+2.0000000000000000e+00*hat_x[1]-1.5000000000000000e+00)+hat_x[2]*( 2.0*hat_x[0]+2.0000000000000000e+00*hat_x[1]-1.5000000000000000e+00);
      val[1] =  ( 2.0000000000000000e+00*hat_x[0]+2.0*hat_x[1]-1.5000000000000000e+00)*(hat_x[2]*hat_x[2])+( 2.0000000000000000e+00*hat_x[0]+2.0*hat_x[1]-1.5000000000000000e+00)*hat_x[2];
      val[2] =  -1.5000000000000000e+00*hat_x[0]+( -3.0000000000000000e+00*hat_x[0]+( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)*hat_x[1]+2.0*(hat_x[1]*hat_x[1])+2.0*(hat_x[0]*hat_x[0])+1.0)*hat_x[2]+(hat_x[1]*hat_x[1])+hat_x[1]*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)+(hat_x[0]*hat_x[0])+(1.0/2.0);
      return val;
    }
    case 4: {
      val[0] =  ( 2.0*hat_x[0]-5.0000000000000000e-01)*(hat_x[2]*hat_x[2])+( 2.0*hat_x[0]-5.0000000000000000e-01)*hat_x[2];
      val[1] = 0.0;
      val[2] =  (hat_x[0]*hat_x[0])+hat_x[2]*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])+-5.0000000000000000e-01*hat_x[0];
      return val;
    }
    case 5: {
      val[0] = 0.0;
      val[1] =  ( 2.0*hat_x[1]-5.0000000000000000e-01)*hat_x[2]+( 2.0*hat_x[1]-5.0000000000000000e-01)*(hat_x[2]*hat_x[2]);
      val[2] =  -5.0000000000000000e-01*hat_x[1]+hat_x[2]*(-hat_x[1]+2.0*(hat_x[1]*hat_x[1]))+(hat_x[1]*hat_x[1]);
      return val;
    }
    case 6: {
      val[0] =  hat_x[2]*( 2.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-2.0000000000000000e+00)+(hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00);
      val[1] =  -2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+2.0000000000000000e+00*hat_x[2]*hat_x[0];
      val[2] =  2.0000000000000000e+00*hat_x[0]*hat_x[1]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-2.0000000000000000e+00*hat_x[0]+( -4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0])*hat_x[2];
      return val;
    }
    case 7: {
      val[0] =  2.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])+-2.0000000000000000e+00*hat_x[1]*hat_x[2];
      val[1] =  2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+-2.0000000000000000e+00*hat_x[2]*hat_x[0];
      val[2] =  4.0000000000000000e+00*hat_x[1]*hat_x[2]*hat_x[0]+-2.0000000000000000e+00*hat_x[1]*hat_x[0];
      return val;
    }
    case 8: {
      val[0] =  2.0000000000000000e+00*hat_x[2]*hat_x[1]+-2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[1];
      val[1] =  ( -2.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00)*(hat_x[2]*hat_x[2])+( 2.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-2.0000000000000000e+00)*hat_x[2];
      val[2] =  hat_x[2]*( ( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1]+-4.0000000000000000e+00*(hat_x[1]*hat_x[1]))+( 2.0000000000000000e+00*hat_x[0]-2.0000000000000000e+00)*hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 9: {
      val[0] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]+(hat_x[2]*hat_x[2])*( -4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+3.0000000000000000e+00)-3.0000000000000000e+00;
      val[1] =  4.0000000000000000e+00*hat_x[0]+(hat_x[2]*hat_x[2])*( -4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+3.0000000000000000e+00)+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      val[2] = hat_x[2]*( ( -8.0000000000000000e+00*hat_x[0]+6.0000000000000000e+00)*hat_x[1]+6.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0])+-4.0000000000000000e+00*(hat_x[1]*hat_x[1])-2.0);
      return val;
    }
    case 10: {
      val[0] =  4.0000000000000000e+00*hat_x[0]+( -4.0000000000000000e+00*hat_x[0]+1.0)*(hat_x[2]*hat_x[2])-1.0000000000000000e+00;
      val[1] = 0.0;
      val[2] = ( 2.0*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]))*hat_x[2];
      return val;
    }
    case 11: {
      val[0] = 0.0;
      val[1] =  4.0000000000000000e+00*hat_x[1]+(hat_x[2]*hat_x[2])*( -4.0000000000000000e+00*hat_x[1]+1.0)-1.0000000000000000e+00;
      val[2] = ( 2.0*hat_x[1]+-4.0000000000000000e+00*(hat_x[1]*hat_x[1]))*hat_x[2];
      return val;
    }
    case 12: {
      val[0] =  ( -2.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)*(hat_x[2]*hat_x[2])+( -2.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)*hat_x[2];
      val[1] =  -2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+-2.0000000000000000e+00*hat_x[2]*hat_x[0];
      val[2] =  hat_x[2]*( 4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0])+-4.0000000000000000e+00*hat_x[1]*hat_x[0])+2.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-2.0000000000000000e+00*hat_x[1]*hat_x[0];
      return val;
    }
    case 13: {
      val[0] =  2.0000000000000000e+00*hat_x[2]*hat_x[1]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[1];
      val[1] =  2.0000000000000000e+00*hat_x[2]*hat_x[0]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0];
      val[2] =  2.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[2]*hat_x[0]*hat_x[1];
      return val;
    }
    case 14: {
      val[0] =  -2.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])+-2.0000000000000000e+00*hat_x[1]*hat_x[2];
      val[1] =  ( -2.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00)*hat_x[2]+( -2.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00)*(hat_x[2]*hat_x[2]);
      val[2] =  -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)*hat_x[1]+hat_x[2]*( -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+hat_x[1]*( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00));
      return val;
    }
    case 15: {
      val[0] =  -4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2]);
      val[1] =  -8.0000000000000000e+00*hat_x[1]+(hat_x[2]*hat_x[2])*( 8.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-4.0000000000000000e+00)+-4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      val[2] = ( hat_x[1]*( 8.0000000000000000e+00*hat_x[0]-8.0000000000000000e+00)+8.0000000000000000e+00*(hat_x[1]*hat_x[1]))*hat_x[2];
      return val;
    }
    case 16: {
      val[0] =  -4.0000000000000000e+00*hat_x[1]+( 4.0000000000000000e+00*hat_x[1]+8.0000000000000000e+00*hat_x[0]-4.0000000000000000e+00)*(hat_x[2]*hat_x[2])+-8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      val[1] =  4.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+-4.0000000000000000e+00*hat_x[0];
      val[2] = hat_x[2]*( -8.0000000000000000e+00*hat_x[0]+8.0000000000000000e+00*hat_x[0]*hat_x[1]+8.0000000000000000e+00*(hat_x[0]*hat_x[0]));
      return val;
    }
    case 17: {
      val[0] =  -4.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[1]+4.0000000000000000e+00*hat_x[1];
      val[1] =  4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0];
      val[2] = -8.0000000000000000e+00*hat_x[0]*hat_x[1]*hat_x[2];
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_P::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_P::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(18);
  typedef Float T;
  values[0] = -( -3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[1]*hat_x[1])+-2.0*( -2.0000000000000000e+00*hat_x[0]+1.5000000000000000e+00)*hat_x[1]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+1.0)*hat_x[2]/2.0+(hat_x[2]*hat_x[2])*( -3.0000000000000000e+00*hat_x[0]+2.0*(hat_x[1]*hat_x[1])+2.0*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)*hat_x[1]+2.0*(hat_x[0]*hat_x[0])+1.0)/2.0;
  values[1] =  hat_x[2]*( 5.0000000000000000e-01*hat_x[0]-(hat_x[0]*hat_x[0]))+( -5.0000000000000000e-01*hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2]);
  values[2] =  ( -5.0000000000000000e-01*hat_x[1]+(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])+hat_x[2]*( 5.0000000000000000e-01*hat_x[1]-(hat_x[1]*hat_x[1]));
  values[3] =  hat_x[2]*( -3.0000000000000000e+00*hat_x[0]+2.0*(hat_x[1]*hat_x[1])+2.0*(hat_x[0]*hat_x[0])+2.0*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)*hat_x[1]+1.0)/2.0+(hat_x[2]*hat_x[2])*( -3.0000000000000000e+00*hat_x[0]+2.0*(hat_x[1]*hat_x[1])+2.0*(hat_x[0]*hat_x[0])+2.0*( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)*hat_x[1]+1.0)/2.0;
  values[4] =  ( (hat_x[0]*hat_x[0])+-5.0000000000000000e-01*hat_x[0])*(hat_x[2]*hat_x[2])+( (hat_x[0]*hat_x[0])+-5.0000000000000000e-01*hat_x[0])*hat_x[2];
  values[5] =  ( (hat_x[1]*hat_x[1])+-5.0000000000000000e-01*hat_x[1])*(hat_x[2]*hat_x[2])+( (hat_x[1]*hat_x[1])+-5.0000000000000000e-01*hat_x[1])*hat_x[2];
  values[6] =  (hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-2.0000000000000000e+00*hat_x[1]*hat_x[0]+2.0000000000000000e+00*hat_x[0])+( 2.0000000000000000e+00*(hat_x[0]*hat_x[0])+2.0000000000000000e+00*hat_x[1]*hat_x[0]+-2.0000000000000000e+00*hat_x[0])*hat_x[2];
  values[7] =  -2.0000000000000000e+00*hat_x[1]*hat_x[2]*hat_x[0]+2.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])*hat_x[0];
  values[8] =  (hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00))+( 2.0000000000000000e+00*(hat_x[1]*hat_x[1])+hat_x[1]*( 2.0000000000000000e+00*hat_x[0]-2.0000000000000000e+00))*hat_x[2];
  values[9] =  2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)*hat_x[1]+( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+3.0000000000000000e+00)*hat_x[1]+3.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])+-3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+1.0;
  values[10] =  ( -2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])+2.0000000000000000e+00*(hat_x[0]*hat_x[0])-hat_x[0];
  values[11] = -hat_x[1]+(hat_x[2]*hat_x[2])*( hat_x[1]+-2.0000000000000000e+00*(hat_x[1]*hat_x[1]))+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
  values[12] =  hat_x[2]*( -2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-2.0000000000000000e+00*hat_x[1]*hat_x[0]+2.0000000000000000e+00*hat_x[0])+(hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-2.0000000000000000e+00*hat_x[1]*hat_x[0]+2.0000000000000000e+00*hat_x[0]);
  values[13] =  2.0000000000000000e+00*hat_x[1]*hat_x[2]*hat_x[0]+2.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])*hat_x[0];
  values[14] =  hat_x[2]*( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)*hat_x[1])+(hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)*hat_x[1]);
  values[15] =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1]+(hat_x[2]*hat_x[2])*( 4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( 4.0000000000000000e+00*hat_x[0]-4.0000000000000000e+00)*hat_x[1]);
  values[16] =  -4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0]+(hat_x[2]*hat_x[2])*( 4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*(hat_x[0]*hat_x[0])+-4.0000000000000000e+00*hat_x[0]);
  values[17] =  4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]*hat_x[1];
}
void
basis_P2_P::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(18);
  typedef Float T;
  values[0][0] =  (hat_x[2]*hat_x[2])*( 2.0*hat_x[0]+2.0000000000000000e+00*hat_x[1]-1.5000000000000000e+00)+hat_x[2]*( -2.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*hat_x[1]+1.5000000000000000e+00);
  values[0][1] =  (hat_x[2]*hat_x[2])*( 2.0000000000000000e+00*hat_x[0]+2.0*hat_x[1]-1.5000000000000000e+00)+hat_x[2]*( -2.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*hat_x[1]+1.5000000000000000e+00);
  values[0][2] = -(hat_x[0]*hat_x[0])+1.5000000000000000e+00*hat_x[0]+hat_x[1]*( -2.0000000000000000e+00*hat_x[0]+1.5000000000000000e+00)+( 2.0*(hat_x[0]*hat_x[0])+hat_x[1]*( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)+-3.0000000000000000e+00*hat_x[0]+2.0*(hat_x[1]*hat_x[1])+1.0)*hat_x[2]-(hat_x[1]*hat_x[1])-(1.0/2.0);
  values[1][0] =  ( -2.0000000000000000e+00*hat_x[0]+5.0000000000000000e-01)*hat_x[2]+( 2.0*hat_x[0]-5.0000000000000000e-01)*(hat_x[2]*hat_x[2]);
  values[1][1] = 0.0;
  values[1][2] = -(hat_x[0]*hat_x[0])+( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]+5.0000000000000000e-01*hat_x[0];
  values[2][0] = 0.0;
  values[2][1] =  ( -2.0000000000000000e+00*hat_x[1]+5.0000000000000000e-01)*hat_x[2]+( 2.0*hat_x[1]-5.0000000000000000e-01)*(hat_x[2]*hat_x[2]);
  values[2][2] =  5.0000000000000000e-01*hat_x[1]+(-hat_x[1]+2.0*(hat_x[1]*hat_x[1]))*hat_x[2]-(hat_x[1]*hat_x[1]);
  values[3][0] =  ( 2.0000000000000000e+00*hat_x[1]+2.0*hat_x[0]-1.5000000000000000e+00)*(hat_x[2]*hat_x[2])+( 2.0000000000000000e+00*hat_x[1]+2.0*hat_x[0]-1.5000000000000000e+00)*hat_x[2];
  values[3][1] =  (hat_x[2]*hat_x[2])*( 2.0*hat_x[1]+2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)+hat_x[2]*( 2.0*hat_x[1]+2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00);
  values[3][2] =  hat_x[2]*( ( 4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00)*hat_x[1]+2.0*(hat_x[1]*hat_x[1])+-3.0000000000000000e+00*hat_x[0]+2.0*(hat_x[0]*hat_x[0])+1.0)+(hat_x[1]*hat_x[1])+-1.5000000000000000e+00*hat_x[0]+( 2.0000000000000000e+00*hat_x[0]-1.5000000000000000e+00)*hat_x[1]+(hat_x[0]*hat_x[0])+(1.0/2.0);
  values[4][0] =  ( 2.0*hat_x[0]-5.0000000000000000e-01)*(hat_x[2]*hat_x[2])+( 2.0*hat_x[0]-5.0000000000000000e-01)*hat_x[2];
  values[4][1] = 0.0;
  values[4][2] =  hat_x[2]*( 2.0*(hat_x[0]*hat_x[0])-hat_x[0])+(hat_x[0]*hat_x[0])+-5.0000000000000000e-01*hat_x[0];
  values[5][0] = 0.0;
  values[5][1] =  ( 2.0*hat_x[1]-5.0000000000000000e-01)*(hat_x[2]*hat_x[2])+( 2.0*hat_x[1]-5.0000000000000000e-01)*hat_x[2];
  values[5][2] =  (hat_x[1]*hat_x[1])+( 2.0*(hat_x[1]*hat_x[1])-hat_x[1])*hat_x[2]+-5.0000000000000000e-01*hat_x[1];
  values[6][0] =  (hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)+hat_x[2]*( 2.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-2.0000000000000000e+00);
  values[6][1] =  -2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+2.0000000000000000e+00*hat_x[2]*hat_x[0];
  values[6][2] =  2.0000000000000000e+00*hat_x[0]*hat_x[1]+-2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[2]*( -4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]));
  values[7][0] =  -2.0000000000000000e+00*hat_x[2]*hat_x[1]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[1];
  values[7][1] =  -2.0000000000000000e+00*hat_x[2]*hat_x[0]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0];
  values[7][2] =  -2.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[0]*hat_x[1]*hat_x[2];
  values[8][0] =  -2.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])+2.0000000000000000e+00*hat_x[1]*hat_x[2];
  values[8][1] =  ( 2.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-2.0000000000000000e+00)*hat_x[2]+( -2.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00)*(hat_x[2]*hat_x[2]);
  values[8][2] =  2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00)*hat_x[1])*hat_x[2]+hat_x[1]*( 2.0000000000000000e+00*hat_x[0]-2.0000000000000000e+00);
  values[9][0] =  4.0000000000000000e+00*hat_x[1]+(hat_x[2]*hat_x[2])*( -4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+3.0000000000000000e+00)+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[9][1] =  ( -4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+3.0000000000000000e+00)*(hat_x[2]*hat_x[2])+4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[9][2] = hat_x[2]*( -4.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[1]*( -8.0000000000000000e+00*hat_x[0]+6.0000000000000000e+00)+-4.0000000000000000e+00*(hat_x[1]*hat_x[1])+6.0000000000000000e+00*hat_x[0]-2.0);
  values[10][0] =  ( -4.0000000000000000e+00*hat_x[0]+1.0)*(hat_x[2]*hat_x[2])+4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[10][1] = 0.0;
  values[10][2] = ( 2.0*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]))*hat_x[2];
  values[11][0] = 0.0;
  values[11][1] =  (hat_x[2]*hat_x[2])*( -4.0000000000000000e+00*hat_x[1]+1.0)+4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
  values[11][2] = ( 2.0*hat_x[1]+-4.0000000000000000e+00*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[12][0] =  hat_x[2]*( -2.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)+(hat_x[2]*hat_x[2])*( -2.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00);
  values[12][1] =  -2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+-2.0000000000000000e+00*hat_x[2]*hat_x[0];
  values[12][2] =  -2.0000000000000000e+00*hat_x[0]*hat_x[1]+2.0000000000000000e+00*hat_x[0]+-2.0000000000000000e+00*(hat_x[0]*hat_x[0])+hat_x[2]*( -4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]));
  values[13][0] =  2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[1]+2.0000000000000000e+00*hat_x[2]*hat_x[1];
  values[13][1] =  2.0000000000000000e+00*hat_x[2]*hat_x[0]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0];
  values[13][2] =  2.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[2]*hat_x[0]*hat_x[1];
  values[14][0] =  -2.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[1]+-2.0000000000000000e+00*hat_x[2]*hat_x[1];
  values[14][1] =  ( -2.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00)*hat_x[2]+( -2.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00)*(hat_x[2]*hat_x[2]);
  values[14][2] =  ( -2.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00)*hat_x[1]+-2.0000000000000000e+00*(hat_x[1]*hat_x[1])+( -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+hat_x[1]*( -4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00))*hat_x[2];
  values[15][0] =  4.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2])+-4.0000000000000000e+00*hat_x[1];
  values[15][1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+( 4.0000000000000000e+00*hat_x[0]+8.0000000000000000e+00*hat_x[1]-4.0000000000000000e+00)*(hat_x[2]*hat_x[2])+4.0000000000000000e+00;
  values[15][2] = hat_x[2]*( hat_x[1]*( 8.0000000000000000e+00*hat_x[0]-8.0000000000000000e+00)+8.0000000000000000e+00*(hat_x[1]*hat_x[1]));
  values[16][0] =  (hat_x[2]*hat_x[2])*( 4.0000000000000000e+00*hat_x[1]+8.0000000000000000e+00*hat_x[0]-4.0000000000000000e+00)+-4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
  values[16][1] =  4.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+-4.0000000000000000e+00*hat_x[0];
  values[16][2] = hat_x[2]*( 8.0000000000000000e+00*hat_x[1]*hat_x[0]+-8.0000000000000000e+00*hat_x[0]+8.0000000000000000e+00*(hat_x[0]*hat_x[0]));
  values[17][0] =  4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[17][1] =  -4.0000000000000000e+00*(hat_x[2]*hat_x[2])*hat_x[0]+4.0000000000000000e+00*hat_x[0];
  values[17][2] = -8.0000000000000000e+00*hat_x[2]*hat_x[0]*hat_x[1];
}
void
basis_P2_P::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(18,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_P::hat_node(
  vector<point>& x)
{
  x.resize(18);
  x[0] = point(0.0, 0.0, -1.0);
  x[1] = point(1.0, 0.0, -1.0);
  x[2] = point(0.0, 1.0, -1.0);
  x[3] = point(0.0, 0.0, 1.0);
  x[4] = point(1.0, 0.0, 1.0);
  x[5] = point(0.0, 1.0, 1.0);
  x[6] = point(5.0000000000000000e-01, 0.0, -1.0);
  x[7] = point(5.0000000000000000e-01, 5.0000000000000000e-01, -1.0);
  x[8] = point(0.0, 5.0000000000000000e-01, -1.0);
  x[9] = point(0.0, 0.0, 0.0);
  x[10] = point(1.0, 0.0, 0.0);
  x[11] = point(0.0, 1.0, 0.0);
  x[12] = point(5.0000000000000000e-01, 0.0, 1.0);
  x[13] = point(5.0000000000000000e-01, 5.0000000000000000e-01, 1.0);
  x[14] = point(0.0, 5.0000000000000000e-01, 1.0);
  x[15] = point(0.0, 5.0000000000000000e-01, 0.0);
  x[16] = point(5.0000000000000000e-01, 0.0, 0.0);
  x[17] = point(5.0000000000000000e-01, 5.0000000000000000e-01, 0.0);
}
basis_rep::dof_family_type
basis_P2_H::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_P2_H::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/8.0+( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
      return val;
    }
    case 1: {
      val =  (hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/8.0-hat_x[2]*( (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/8.0;
      return val;
    }
    case 2: {
      val =  (hat_x[2]*hat_x[2])*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1])/8.0-hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1])/8.0;
      return val;
    }
    case 3: {
      val =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])/8.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])/8.0;
      return val;
    }
    case 4: {
      val =  hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0+(hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0;
      return val;
    }
    case 5: {
      val = -hat_x[2]*( ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]-( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1]))/8.0-(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]-( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1]))/8.0;
      return val;
    }
    case 6: {
      val =  hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0+(hat_x[2]*hat_x[2])*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0;
      return val;
    }
    case 7: {
      val =  hat_x[2]*( ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))/8.0+(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))/8.0;
      return val;
    }
    case 8: {
      val = -( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])*(hat_x[2]*hat_x[2])/4.0+( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])*hat_x[2]/4.0;
      return val;
    }
    case 9: {
      val =  ( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/4.0;
      return val;
    }
    case 10: {
      val =  ( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*(hat_x[2]*hat_x[2])/4.0;
      return val;
    }
    case 11: {
      val =  (hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/4.0-hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/4.0;
      return val;
    }
    case 12: {
      val =  (hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0;
      return val;
    }
    case 13: {
      val =  ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/4.0-( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])*(hat_x[2]*hat_x[2])/4.0-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/4.0;
      return val;
    }
    case 14: {
      val = -( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/4.0+( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]/4.0+( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0;
      return val;
    }
    case 15: {
      val = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0+( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*(hat_x[2]*hat_x[2])/4.0;
      return val;
    }
    case 16: {
      val = -(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/4.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/4.0;
      return val;
    }
    case 17: {
      val =  hat_x[2]*( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))/4.0+(hat_x[2]*hat_x[2])*( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))/4.0;
      return val;
    }
    case 18: {
      val = -( hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/4.0-( hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0))*(hat_x[2]*hat_x[2])/4.0;
      return val;
    }
    case 19: {
      val =  hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/4.0+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/4.0;
      return val;
    }
    case 20: {
      val = -(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-1.0)/2.0+hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-1.0)/2.0;
      return val;
    }
    case 21: {
      val = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0+( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-(hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/2.0+(hat_x[0]*hat_x[0])/2.0-hat_x[0]/2.0;
      return val;
    }
    case 22: {
      val =  ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0-(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))/2.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0;
      return val;
    }
    case 23: {
      val =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)/2.0+hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)/2.0;
      return val;
    }
    case 24: {
      val = -( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/2.0+hat_x[0]/2.0+(hat_x[2]*hat_x[2])*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]-(hat_x[0]*hat_x[0]))/2.0+(hat_x[0]*hat_x[0])/2.0;
      return val;
    }
    case 25: {
      val =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/2.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0;
      return val;
    }
    case 26: {
      val = -(hat_x[0]*hat_x[0])+( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)*(hat_x[2]*hat_x[2])+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])+1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_H::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  hat_x[2]*( hat_x[1]*( 2.0*hat_x[0]-1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))/8.0-(hat_x[2]*hat_x[2])*( hat_x[1]*( 2.0*hat_x[0]-1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))/8.0;
      val[1] = -( (hat_x[0]*hat_x[0])-hat_x[0]+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*(hat_x[2]*hat_x[2])/8.0+( (hat_x[0]*hat_x[0])-hat_x[0]+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/8.0;
      val[2] =  ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]/8.0-( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])/8.0-( ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]-( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]))*hat_x[2]/4.0;
      return val;
    }
    case 1: {
      val[0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)-hat_x[1]*( 2.0*hat_x[0]+1.0))*hat_x[2]/8.0+( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)-hat_x[1]*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/8.0;
      val[1] =  (hat_x[2]*hat_x[2])*( 2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))-hat_x[0]-(hat_x[0]*hat_x[0]))/8.0-hat_x[2]*( 2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))-hat_x[0]-(hat_x[0]*hat_x[0]))/8.0;
      val[2] = -(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/8.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/8.0+( (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))*hat_x[2]/4.0;
      return val;
    }
    case 2: {
      val[0] = -( ( 2.0*hat_x[0]+1.0)*hat_x[1]+( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1]))*hat_x[2]/8.0+( ( 2.0*hat_x[0]+1.0)*hat_x[1]+( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/8.0;
      val[1] =  (hat_x[2]*hat_x[2])*( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]+(hat_x[0]*hat_x[0]))/8.0-hat_x[2]*( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]+(hat_x[0]*hat_x[0]))/8.0;
      val[2] = -( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/8.0-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/8.0+hat_x[2]*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])/4.0;
      return val;
    }
    case 3: {
      val[0] =  (hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]-1.0)*hat_x[1])/8.0-hat_x[2]*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]-1.0)*hat_x[1])/8.0;
      val[1] = -( (hat_x[0]*hat_x[0])-hat_x[0]+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/8.0+( (hat_x[0]*hat_x[0])-hat_x[0]+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
      val[2] = -( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])/8.0-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]/8.0+( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*hat_x[2]/4.0;
      return val;
    }
    case 4: {
      val[0] = -( hat_x[1]*( 2.0*hat_x[0]-1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))*(hat_x[2]*hat_x[2])/8.0-( hat_x[1]*( 2.0*hat_x[0]-1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))*hat_x[2]/8.0;
      val[1] =  ( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*hat_x[2]/8.0+( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
      val[2] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/8.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/8.0-( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*hat_x[2]/4.0;
      return val;
    }
    case 5: {
      val[0] = -( hat_x[1]*( 2.0*hat_x[0]+1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/8.0-( hat_x[1]*( 2.0*hat_x[0]+1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*hat_x[2]/8.0;
      val[1] = -hat_x[2]*( hat_x[0]+(hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/8.0-(hat_x[2]*hat_x[2])*( hat_x[0]+(hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/8.0;
      val[2] =  ( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])*hat_x[2]/4.0+( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/8.0-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/8.0;
      return val;
    }
    case 6: {
      val[0] =  hat_x[2]*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+hat_x[1]*( 2.0*hat_x[0]+1.0))/8.0+(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+hat_x[1]*( 2.0*hat_x[0]+1.0))/8.0;
      val[1] =  hat_x[2]*( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]+(hat_x[0]*hat_x[0]))/8.0+(hat_x[2]*hat_x[2])*( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]+(hat_x[0]*hat_x[0]))/8.0;
      val[2] =  ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/8.0+( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/8.0+( ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1]))*hat_x[2]/4.0;
      return val;
    }
    case 7: {
      val[0] =  hat_x[2]*( ( 2.0*hat_x[0]-1.0)*hat_x[1]+( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1]))/8.0+(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*hat_x[1]+( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1]))/8.0;
      val[1] = -(hat_x[2]*hat_x[2])*( 2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]-(hat_x[0]*hat_x[0]))/8.0-hat_x[2]*( 2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+hat_x[0]-(hat_x[0]*hat_x[0]))/8.0;
      val[2] =  hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0+( hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/4.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0;
      return val;
    }
    case 8: {
      val[0] =  hat_x[2]*( hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]*hat_x[1])/2.0-(hat_x[2]*hat_x[2])*( hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]*hat_x[1])/2.0;
      val[1] =  ( (hat_x[0]*hat_x[0])+-2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-1.0)*(hat_x[2]*hat_x[2])/4.0-( (hat_x[0]*hat_x[0])+-2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-1.0)*hat_x[2]/4.0;
      val[2] = -( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])*hat_x[2]/2.0+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/4.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/4.0;
      return val;
    }
    case 9: {
      val[0] = -hat_x[2]*( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+1.0)/4.0+(hat_x[2]*hat_x[2])*( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+1.0)/4.0;
      val[1] = -(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/2.0+hat_x[2]*( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/2.0;
      val[2] = -hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0+hat_x[2]*( hat_x[0]+(hat_x[0]*hat_x[0])-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/2.0+( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0;
      return val;
    }
    case 10: {
      val[0] = -( hat_x[0]*hat_x[1]+hat_x[0]*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0+( hat_x[0]*hat_x[1]+hat_x[0]*(hat_x[1]*hat_x[1]))*hat_x[2]/2.0;
      val[1] =  ( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)*hat_x[2]/4.0-( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-1.0)*(hat_x[2]*hat_x[2])/4.0;
      val[2] =  (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/4.0-hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))/2.0;
      return val;
    }
    case 11: {
      val[0] =  hat_x[2]*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+1.0)/4.0-(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+1.0)/4.0;
      val[1] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]*hat_x[2]/2.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]*(hat_x[2]*hat_x[2])/2.0;
      val[2] = -( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+hat_x[0]/4.0+( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[2]/2.0-(hat_x[0]*hat_x[0])/4.0;
      return val;
    }
    case 12: {
      val[0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0-( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)-hat_x[1]*( 2.0*hat_x[0]-1.0))*(hat_x[2]*hat_x[2])/4.0-hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0;
      val[1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0+( (hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/4.0+hat_x[0]/4.0;
      val[2] = -(1.0/2.0)*hat_x[2]*( hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))-(hat_x[1]*hat_x[1])*( hat_x[0]-(hat_x[0]*hat_x[0])));
      return val;
    }
    case 13: {
      val[0] =  ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/4.0-( 2.0*hat_x[0]+1.0)*hat_x[1]/4.0-(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])/4.0;
      val[1] =  ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]/2.0-hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0-(hat_x[2]*hat_x[2])*( 2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]-hat_x[0]-(hat_x[0]*hat_x[0]))/4.0;
      val[2] = (1.0/2.0)*hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]));
      return val;
    }
    case 14: {
      val[0] = -(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+( 2.0*hat_x[0]+1.0)*hat_x[1])/4.0+( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/4.0+( 2.0*hat_x[0]+1.0)*hat_x[1]/4.0;
      val[1] =  (hat_x[0]*hat_x[0])/4.0-(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+hat_x[0]+2.0*( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])/4.0+hat_x[0]/4.0+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/2.0;
      val[2] = -(1.0/2.0)*hat_x[2]*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]);
      return val;
    }
    case 15: {
      val[0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0-( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+hat_x[1]*( 2.0*hat_x[0]-1.0))*(hat_x[2]*hat_x[2])/4.0+hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0;
      val[1] =  ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]/2.0+(hat_x[0]*hat_x[0])/4.0-hat_x[0]/4.0-( 2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+(hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/4.0;
      val[2] = (1.0/2.0)*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*hat_x[2];
      return val;
    }
    case 16: {
      val[0] =  hat_x[2]*( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))/2.0+(hat_x[2]*hat_x[2])*( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))/2.0;
      val[1] =  hat_x[2]*( (hat_x[0]*hat_x[0])+-2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-1.0)/4.0+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+-2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-1.0)/4.0;
      val[2] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/4.0-hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))/2.0;
      return val;
    }
    case 17: {
      val[0] =  ( 2.0*hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+1.0)*hat_x[2]/4.0+( 2.0*hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+1.0)*(hat_x[2]*hat_x[2])/4.0;
      val[1] = -hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/2.0-hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[2]/2.0;
      val[2] =  hat_x[0]/4.0-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/4.0+(hat_x[0]*hat_x[0])/4.0+( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))*hat_x[2]/2.0;
      return val;
    }
    case 18: {
      val[0] = -( hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1])*hat_x[2]/2.0-( hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1])*(hat_x[2]*hat_x[2])/2.0;
      val[1] = -( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])/4.0-( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[0]*hat_x[0])-1.0)*hat_x[2]/4.0;
      val[2] = -( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/4.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/4.0-( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*hat_x[2]/2.0;
      return val;
    }
    case 19: {
      val[0] =  ( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)-1.0)*hat_x[2]/4.0+( 2.0*hat_x[0]-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)-1.0)*(hat_x[2]*hat_x[2])/4.0;
      val[1] = -hat_x[1]*hat_x[2]*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0-hat_x[1]*(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-hat_x[0])/2.0;
      val[2] =  (hat_x[0]*hat_x[0])/4.0+hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/2.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0-hat_x[0]/4.0;
      return val;
    }
    case 20: {
      val[0] = -hat_x[2]*( hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0])+(hat_x[2]*hat_x[2])*( hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]);
      val[1] =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*hat_x[2]*hat_x[1];
      val[2] =  (hat_x[0]*hat_x[0])/2.0-hat_x[2]*( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0-(1.0/2.0);
      return val;
    }
    case 21: {
      val[0] =  hat_x[0]-( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])/2.0-(hat_x[2]*hat_x[2])*( 2.0*hat_x[0]-( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])-1.0)/2.0-(1.0/2.0);
      val[1] = -(hat_x[2]*hat_x[2])*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1];
      val[2] = -hat_x[2]*( (hat_x[0]*hat_x[0])-hat_x[0]-( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1]));
      return val;
    }
    case 22: {
      val[0] =  hat_x[0]*hat_x[1]-( hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])-hat_x[0]*(hat_x[1]*hat_x[1]);
      val[1] = -( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])/2.0+(hat_x[2]*hat_x[2])*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-(hat_x[0]*hat_x[0])+1.0)/2.0-(1.0/2.0);
      val[2] = ( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2];
      return val;
    }
    case 23: {
      val[0] = -hat_x[2]*( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]))-(hat_x[2]*hat_x[2])*( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]));
      val[1] =  hat_x[2]*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[2]*hat_x[2])*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0);
      val[2] = -(hat_x[0]*hat_x[0])/2.0-( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)*hat_x[2]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0+(1.0/2.0);
      return val;
    }
    case 24: {
      val[0] = -( 2.0*hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])+1.0)*(hat_x[2]*hat_x[2])/2.0+hat_x[0]-( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])/2.0+(1.0/2.0);
      val[1] = -hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2]);
      val[2] = -( hat_x[0]+(hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0])))*hat_x[2];
      return val;
    }
    case 25: {
      val[0] = -hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]*hat_x[1]+( hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1])*(hat_x[2]*hat_x[2]);
      val[1] =  (hat_x[2]*hat_x[2])*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])-1.0)/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
      val[2] = ( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*hat_x[2];
      return val;
    }
    case 26: {
      val[0] =  2.0*(hat_x[1]*hat_x[1])*hat_x[0]+-2.0*( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[0])*(hat_x[2]*hat_x[2])+-2.0*hat_x[0];
      val[1] =  -2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0);
      val[2] = 2.0*hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-1.0);
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_P2_H::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_H::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(27);
  typedef Float T;
  values[0] =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])/8.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])/8.0;
  values[1] =  hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0-(hat_x[2]*hat_x[2])*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/8.0;
  values[2] =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])/8.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])/8.0;
  values[3] =  ( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*hat_x[2]/8.0-( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*(hat_x[2]*hat_x[2])/8.0;
  values[4] =  ( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*hat_x[2]/8.0+( ( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*(hat_x[2]*hat_x[2])/8.0;
  values[5] =  ( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])*(hat_x[2]*hat_x[2])/8.0+( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])*hat_x[2]/8.0;
  values[6] =  ( ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/8.0+( ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]+( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1]))*hat_x[2]/8.0;
  values[7] = -( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*hat_x[2]/8.0-( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/8.0;
  values[8] =  ( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*(hat_x[2]*hat_x[2])/4.0;
  values[9] =  (hat_x[2]*hat_x[2])*( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))/4.0-hat_x[2]*( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))/4.0;
  values[10] = -( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*(hat_x[2]*hat_x[2])/4.0+( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/4.0;
  values[11] =  hat_x[2]*( hat_x[0]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0]))/4.0-(hat_x[2]*hat_x[2])*( hat_x[0]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0]))/4.0;
  values[12] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/4.0-(hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/4.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0;
  values[13] = -( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]/4.0+(hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1]-( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1]))/4.0+( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])/4.0;
  values[14] =  hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/4.0-(hat_x[2]*hat_x[2])*( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))/4.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/4.0;
  values[15] =  (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))*(hat_x[2]*hat_x[2])/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/4.0;
  values[16] = -(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))/4.0-hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))/4.0;
  values[17] =  (hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])/4.0+hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])/4.0;
  values[18] = -hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))/4.0-(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))/4.0;
  values[19] =  hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/4.0+(hat_x[2]*hat_x[2])*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/4.0;
  values[20] =  (hat_x[2]*hat_x[2])*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)/2.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)/2.0;
  values[21] = -hat_x[0]/2.0+(hat_x[2]*hat_x[2])*( hat_x[0]-(hat_x[0]*hat_x[0])-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/2.0+(hat_x[0]*hat_x[0])/2.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/2.0;
  values[22] =  ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0-( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0;
  values[23] = -( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)*(hat_x[2]*hat_x[2])/2.0-( (hat_x[0]*hat_x[0])-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-1.0)*hat_x[2]/2.0;
  values[24] = -( hat_x[0]-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/2.0+hat_x[0]/2.0-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0+(hat_x[0]*hat_x[0])/2.0;
  values[25] = -( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/2.0+( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*(hat_x[2]*hat_x[2])/2.0-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0;
  values[26] =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])-( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)*(hat_x[2]*hat_x[2])+1.0;
}
void
basis_P2_H::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(27);
  typedef Float T;
  values[0][0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)-hat_x[1]*( 2.0*hat_x[0]-1.0))*hat_x[2]/8.0+( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)-hat_x[1]*( 2.0*hat_x[0]-1.0))*(hat_x[2]*hat_x[2])/8.0;
  values[0][1] = -( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*hat_x[2]/8.0+( hat_x[0]+-2.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/8.0;
  values[0][2] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0+hat_x[2]*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0]))/4.0+hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0;
  values[1][0] = -hat_x[2]*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])/8.0+(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])/8.0;
  values[1][1] =  ( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])/8.0-( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]/8.0;
  values[1][2] =  ( (hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))-hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))*hat_x[2]/4.0-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/8.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/8.0;
  values[2][0] =  (hat_x[2]*hat_x[2])*( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))/8.0-hat_x[2]*( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))/8.0;
  values[2][1] =  ( (hat_x[0]*hat_x[0])+hat_x[0]+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))*(hat_x[2]*hat_x[2])/8.0-( (hat_x[0]*hat_x[0])+hat_x[0]+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))*hat_x[2]/8.0;
  values[2][2] = -hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0+hat_x[2]*( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))/4.0;
  values[3][0] = -hat_x[2]*( hat_x[1]*( 2.0*hat_x[0]-1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))/8.0+(hat_x[2]*hat_x[2])*( hat_x[1]*( 2.0*hat_x[0]-1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))/8.0;
  values[3][1] = -hat_x[2]*( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/8.0+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/8.0;
  values[3][2] =  hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))/8.0-( hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))+(hat_x[1]*hat_x[1])*( hat_x[0]-(hat_x[0]*hat_x[0])))*hat_x[2]/4.0+(hat_x[1]*hat_x[1])*( hat_x[0]-(hat_x[0]*hat_x[0]))/8.0;
  values[4][0] = -hat_x[2]*( ( 2.0*hat_x[0]-1.0)*hat_x[1]-( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1]))/8.0-(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*hat_x[1]-( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1]))/8.0;
  values[4][1] =  ( 2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]-(hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/8.0+( 2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]-(hat_x[0]*hat_x[0])+hat_x[0])*hat_x[2]/8.0;
  values[4][2] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]/8.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/8.0+hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))/4.0;
  values[5][0] =  ( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])*hat_x[2]/8.0+( ( 2.0*hat_x[0]+1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]+1.0)*hat_x[1])*(hat_x[2]*hat_x[2])/8.0;
  values[5][1] = -( hat_x[0]+-2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/8.0-( hat_x[0]+-2.0*( hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[1]+(hat_x[0]*hat_x[0]))*hat_x[2]/8.0;
  values[5][2] = -hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/8.0-( hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))-(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0])))*hat_x[2]/4.0+(hat_x[1]*hat_x[1])*( hat_x[0]+(hat_x[0]*hat_x[0]))/8.0;
  values[6][0] =  ( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*hat_x[2]/8.0+( hat_x[1]*( 2.0*hat_x[0]+1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/8.0;
  values[6][1] =  hat_x[2]*( hat_x[0]+(hat_x[0]*hat_x[0])+2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/8.0+(hat_x[2]*hat_x[2])*( hat_x[0]+(hat_x[0]*hat_x[0])+2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))/8.0;
  values[6][2] =  hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/8.0+hat_x[2]*( hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0]))/4.0;
  values[7][0] =  hat_x[2]*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+hat_x[1]*( 2.0*hat_x[0]-1.0))/8.0+(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+hat_x[1]*( 2.0*hat_x[0]-1.0))/8.0;
  values[7][1] =  hat_x[2]*( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/8.0+(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])+2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])/8.0;
  values[7][2] =  hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0+( hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0]))*hat_x[2]/4.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])/8.0;
  values[8][0] = -hat_x[2]*( hat_x[1]*hat_x[0]-(hat_x[1]*hat_x[1])*hat_x[0])/2.0+(hat_x[2]*hat_x[2])*( hat_x[1]*hat_x[0]-(hat_x[1]*hat_x[1])*hat_x[0])/2.0;
  values[8][1] =  hat_x[2]*( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])+1.0)/4.0-(hat_x[2]*hat_x[2])*( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])+1.0)/4.0;
  values[8][2] =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/4.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/4.0-( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])*hat_x[2]/2.0;
  values[9][0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+-2.0*hat_x[0]-1.0)*(hat_x[2]*hat_x[2])/4.0+( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+-2.0*hat_x[0]-1.0)*hat_x[2]/4.0;
  values[9][1] =  hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[2]/2.0-hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/2.0;
  values[9][2] = -(hat_x[0]*hat_x[0])/4.0+(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])/4.0-hat_x[0]/4.0+hat_x[2]*( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[0])/2.0;
  values[10][0] = -( hat_x[1]*hat_x[0]+(hat_x[1]*hat_x[1])*hat_x[0])*(hat_x[2]*hat_x[2])/2.0+( hat_x[1]*hat_x[0]+(hat_x[1]*hat_x[1])*hat_x[0])*hat_x[2]/2.0;
  values[10][1] = -( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[0]*hat_x[0])-1.0)*(hat_x[2]*hat_x[2])/4.0+( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[0]*hat_x[0])-1.0)*hat_x[2]/4.0;
  values[10][2] =  (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/4.0-( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/2.0+hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/4.0;
  values[11][0] =  hat_x[2]*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+1.0)/4.0-(hat_x[2]*hat_x[2])*( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])+-2.0*hat_x[0]+1.0)/4.0;
  values[11][1] =  ( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2]*hat_x[1]/2.0-( (hat_x[0]*hat_x[0])-hat_x[0])*(hat_x[2]*hat_x[2])*hat_x[1]/2.0;
  values[11][2] =  hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]+(hat_x[0]*hat_x[0]))/2.0-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0;
  values[12][0] =  ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])/4.0-( ( 2.0*hat_x[0]-1.0)*(hat_x[1]*hat_x[1])-( 2.0*hat_x[0]-1.0)*hat_x[1])*(hat_x[2]*hat_x[2])/4.0-( 2.0*hat_x[0]-1.0)*hat_x[1]/4.0;
  values[12][1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[0]/4.0+( (hat_x[0]*hat_x[0])-hat_x[0]+-2.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1])*(hat_x[2]*hat_x[2])/4.0+( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]/2.0;
  values[12][2] = -(1.0/2.0)*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[13][0] = -hat_x[1]*( 2.0*hat_x[0]+1.0)/4.0+( hat_x[1]*( 2.0*hat_x[0]+1.0)-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0))*(hat_x[2]*hat_x[2])/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/4.0;
  values[13][1] = -hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0+hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0]))/2.0+( hat_x[0]+(hat_x[0]*hat_x[0])+-2.0*hat_x[1]*( hat_x[0]+(hat_x[0]*hat_x[0])))*(hat_x[2]*hat_x[2])/4.0;
  values[13][2] = -(1.0/2.0)*( ( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[1]*hat_x[1])-( (hat_x[0]*hat_x[0])+hat_x[0])*hat_x[1])*hat_x[2];
  values[14][0] =  (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/4.0-(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+hat_x[1]*( 2.0*hat_x[0]+1.0))/4.0+hat_x[1]*( 2.0*hat_x[0]+1.0)/4.0;
  values[14][1] =  hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0+(hat_x[0]*hat_x[0])/4.0-( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])+(hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])/4.0+hat_x[0]/4.0;
  values[14][2] = -(1.0/2.0)*( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])+hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]))*hat_x[2];
  values[15][0] = -(hat_x[2]*hat_x[2])*( hat_x[1]*( 2.0*hat_x[0]-1.0)+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0))/4.0+hat_x[1]*( 2.0*hat_x[0]-1.0)/4.0+(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/4.0;
  values[15][1] = -hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))/2.0+( 2.0*hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))+hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[2]*hat_x[2])/4.0-hat_x[0]/4.0+(hat_x[0]*hat_x[0])/4.0;
  values[15][2] = (1.0/2.0)*hat_x[2]*( ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1]));
  values[16][0] = -(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[1]*hat_x[0])/2.0-hat_x[2]*( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[1]*hat_x[0])/2.0;
  values[16][1] =  ( (hat_x[0]*hat_x[0])+-2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-1.0)*(hat_x[2]*hat_x[2])/4.0+( (hat_x[0]*hat_x[0])+-2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-1.0)*hat_x[2]/4.0;
  values[16][2] =  hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)/4.0+( hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0))*hat_x[2]/2.0-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/4.0;
  values[17][0] = -hat_x[2]*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+-2.0*hat_x[0]-1.0)/4.0-(hat_x[2]*hat_x[2])*( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+-2.0*hat_x[0]-1.0)/4.0;
  values[17][1] = -(hat_x[2]*hat_x[2])*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0-hat_x[2]*hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])/2.0;
  values[17][2] = -hat_x[2]*( ( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-hat_x[0]-(hat_x[0]*hat_x[0]))/2.0-( hat_x[0]+(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+hat_x[0]/4.0+(hat_x[0]*hat_x[0])/4.0;
  values[18][0] = -(hat_x[2]*hat_x[2])*( hat_x[0]*hat_x[1]+hat_x[0]*(hat_x[1]*hat_x[1]))/2.0-hat_x[2]*( hat_x[0]*hat_x[1]+hat_x[0]*(hat_x[1]*hat_x[1]))/2.0;
  values[18][1] = -hat_x[2]*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])-1.0)/4.0-(hat_x[2]*hat_x[2])*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])-1.0)/4.0;
  values[18][2] = -( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/4.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]/4.0-hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1])/2.0;
  values[19][0] = -( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+-2.0*hat_x[0]+1.0)*hat_x[2]/4.0-( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+-2.0*hat_x[0]+1.0)*(hat_x[2]*hat_x[2])/4.0;
  values[19][1] =  ( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]*hat_x[2]/2.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1]*(hat_x[2]*hat_x[2])/2.0;
  values[19][2] = -hat_x[0]/4.0+( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])/4.0+(hat_x[0]*hat_x[0])/4.0-( hat_x[0]-( hat_x[0]-(hat_x[0]*hat_x[0]))*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0]))*hat_x[2]/2.0;
  values[20][0] =  hat_x[2]*( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]))-(hat_x[2]*hat_x[2])*( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]));
  values[20][1] = -hat_x[1]*hat_x[2]*( (hat_x[0]*hat_x[0])-1.0)+hat_x[1]*(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-1.0);
  values[20][2] = -(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)/2.0+( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-1.0)-(hat_x[0]*hat_x[0])+1.0)*hat_x[2]+(hat_x[0]*hat_x[0])/2.0-(1.0/2.0);
  values[21][0] =  ( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)+-2.0*hat_x[0]+1.0)*(hat_x[2]*hat_x[2])/2.0-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]-1.0)/2.0+hat_x[0]-(1.0/2.0);
  values[21][1] = -hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])+hat_x[1]*(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-hat_x[0]);
  values[21][2] = -( (hat_x[0]*hat_x[0])-(hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])-hat_x[0])-hat_x[0])*hat_x[2];
  values[22][0] = -(hat_x[1]*hat_x[1])*hat_x[0]+( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[1]*hat_x[0])*(hat_x[2]*hat_x[2])+hat_x[1]*hat_x[0];
  values[22][1] =  (hat_x[2]*hat_x[2])*( 2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-(hat_x[0]*hat_x[0])+1.0)/2.0-( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+(hat_x[0]*hat_x[0])/2.0-(1.0/2.0);
  values[22][2] = -( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]-( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]))*hat_x[2];
  values[23][0] = -hat_x[2]*( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]))-(hat_x[2]*hat_x[2])*( hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1]));
  values[23][1] =  ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]*hat_x[2]+( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]*(hat_x[2]*hat_x[2]);
  values[23][2] =  ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])/2.0+( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)*hat_x[2]-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
  values[24][0] =  ( (hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)+-2.0*hat_x[0]-1.0)*(hat_x[2]*hat_x[2])/2.0-(hat_x[1]*hat_x[1])*( 2.0*hat_x[0]+1.0)/2.0+hat_x[0]+(1.0/2.0);
  values[24][1] =  hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0])*(hat_x[2]*hat_x[2])-hat_x[1]*( (hat_x[0]*hat_x[0])+hat_x[0]);
  values[24][2] = ( (hat_x[1]*hat_x[1])*( (hat_x[0]*hat_x[0])+hat_x[0])-(hat_x[0]*hat_x[0])-hat_x[0])*hat_x[2];
  values[25][0] = -(hat_x[1]*hat_x[1])*hat_x[0]+( (hat_x[1]*hat_x[1])*hat_x[0]+hat_x[1]*hat_x[0])*(hat_x[2]*hat_x[2])-hat_x[1]*hat_x[0];
  values[25][1] = -hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[2]*hat_x[2])*( 2.0*hat_x[1]*( (hat_x[0]*hat_x[0])-1.0)+(hat_x[0]*hat_x[0])-1.0)/2.0-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
  values[25][2] = hat_x[2]*( ( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1]));
  values[26][0] =  -2.0*(hat_x[2]*hat_x[2])*( hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0])+2.0*hat_x[0]*(hat_x[1]*hat_x[1])+-2.0*hat_x[0];
  values[26][1] =  -2.0*(hat_x[2]*hat_x[2])*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1]+2.0*( (hat_x[0]*hat_x[0])-1.0)*hat_x[1];
  values[26][2] = -2.0*( ( (hat_x[0]*hat_x[0])-1.0)*(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0)*hat_x[2];
}
void
basis_P2_H::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(27,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_H::hat_node(
  vector<point>& x)
{
  x.resize(27);
  x[0] = point(-1.0, -1.0, -1.0);
  x[1] = point(1.0, -1.0, -1.0);
  x[2] = point(1.0, 1.0, -1.0);
  x[3] = point(-1.0, 1.0, -1.0);
  x[4] = point(-1.0, -1.0, 1.0);
  x[5] = point(1.0, -1.0, 1.0);
  x[6] = point(1.0, 1.0, 1.0);
  x[7] = point(-1.0, 1.0, 1.0);
  x[8] = point(0.0, -1.0, -1.0);
  x[9] = point(1.0, 0.0, -1.0);
  x[10] = point(0.0, 1.0, -1.0);
  x[11] = point(-1.0, 0.0, -1.0);
  x[12] = point(-1.0, -1.0, 0.0);
  x[13] = point(1.0, -1.0, 0.0);
  x[14] = point(1.0, 1.0, 0.0);
  x[15] = point(-1.0, 1.0, 0.0);
  x[16] = point(0.0, -1.0, 1.0);
  x[17] = point(1.0, 0.0, 1.0);
  x[18] = point(0.0, 1.0, 1.0);
  x[19] = point(-1.0, 0.0, 1.0);
  x[20] = point(0.0, 0.0, -1.0);
  x[21] = point(-1.0, 0.0, 0.0);
  x[22] = point(0.0, -1.0, 0.0);
  x[23] = point(0.0, 0.0, 1.0);
  x[24] = point(1.0, 0.0, 0.0);
  x[25] = point(0.0, 1.0, 0.0);
  x[26] = point(0.0, 0.0, 0.0);
}
basis_P2::~basis_P2()
{
}
basis_P2::size_type
basis_P2::degree () const
{
    return 2;
}
basis_P2::size_type
basis_P2::size (
    reference_element hat_K, basis_rep::dof_family_type family) const
{
    if (family != element_constant::Lagrange && family != element_constant::dof_family_max) return 0;
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 3;
      }
      case reference_element::t: {
        return 6;
      }
      case reference_element::q: {
        return 9;
      }
      case reference_element::T: {
        return 10;
      }
      case reference_element::P: {
        return 18;
      }
      case reference_element::H: {
        return 27;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
basis_rep::dof_family_type
basis_P2::dof_family(
    reference_element hat_K,
    size_type         i_dof_local) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p::dof_family (i_dof_local);
      }
      case reference_element::e: {
      return basis_P2_e::dof_family (i_dof_local);
      }
      case reference_element::t: {
      return basis_P2_t::dof_family (i_dof_local);
      }
      case reference_element::q: {
      return basis_P2_q::dof_family (i_dof_local);
      }
      case reference_element::T: {
      return basis_P2_T::dof_family (i_dof_local);
      }
      case reference_element::P: {
      return basis_P2_P::dof_family (i_dof_local);
      }
      case reference_element::H: {
      return basis_P2_H::dof_family (i_dof_local);
      }
      default : {
        error_macro ("dof_family: unsupported `" << hat_K.name() << "' element type");
        return element_constant::dof_family_max;
      }
    }
}
Float
basis_P2::eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p::eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_P2_e::eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_P2_t::eval (i_dof_local,hat_x);
      }
      case reference_element::q: {
      return basis_P2_q::eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_P2_T::eval (i_dof_local,hat_x);
      }
      case reference_element::P: {
      return basis_P2_P::eval (i_dof_local,hat_x);
      }
      case reference_element::H: {
      return basis_P2_H::eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
point
basis_P2::grad_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_P2_e::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_P2_t::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::q: {
      return basis_P2_q::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_P2_T::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::P: {
      return basis_P2_P::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::H: {
      return basis_P2_H::grad_eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
        return point();
      }
    }
}
tensor
basis_P2::hessian_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
  error_macro ("hessian_eval: invalid basis P2");
  tensor ini_val(0.);
  return ini_val;
}
void
basis_P2::eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<Float>&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p::eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P2_e::eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P2_t::eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P2_q::eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P2_T::eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P2_P::eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P2_H::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_P2::grad_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<point>&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P2_e::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P2_t::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P2_q::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P2_T::grad_eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P2_P::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P2_H::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_P2::hessian_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<tensor >&    values) const
{
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2::hat_node(
    reference_element hat_K,
    vector<point>&    hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P2_p::hat_node (hat_node);
      }
      case reference_element::e: {
      return basis_P2_e::hat_node (hat_node);
      }
      case reference_element::t: {
      return basis_P2_t::hat_node (hat_node);
      }
      case reference_element::q: {
      return basis_P2_q::hat_node (hat_node);
      }
      case reference_element::T: {
      return basis_P2_T::hat_node (hat_node);
      }
      case reference_element::P: {
      return basis_P2_P::hat_node (hat_node);
      }
      case reference_element::H: {
      return basis_P2_H::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
basis_rep* make_P2(void) { return new_macro(basis_P2); }
