///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
/*
OVERVIEW:
   1. unary operations
      1.1. unary operators +x -x
   2. binary operations
      2.1. add v+v, v-v
      2.2. mult by constant f*v, v/f, dot(f,v), ...
      2.3. mult by field    f*v, v/f, dot(f,v), ...

TODO:
  - fh[0]*v : field_component
  - fh[0]*v[0]  => class test_component (const) : enable direct assembly for Stokes and mixed systems

SUMMARY:
   field_vf_expr: linear expressions with respect to a test function, as

        field fh (Xh,1);
        test v (Xh);
	field lh = integrate (fh*v);

   The v  can be replaced by any field_vf_expr (recursive definition), involving
   linear operators as tr(v), or derivation, as grad(v), div(v), etc.

   The fh factor can be replaced by any constant or field_nonlinear_expr or terminals.
   All these fh-like are "binded" into an unary multiplicative function in v:
	fh*v -> F_{fh}(v)
*/
#define _NO_FIELD_NONLINEAR_MAIN
#include "field_nonlinear_expr_ops_make.cc"
// *************************************************************************************
// part 1. unary operations
// *************************************************************************************

// =====================================================================================
// chap 1.1. unary operators +x -x
// =====================================================================================
void vf_unop (const op& o, s details) {
  // op(v)
  cout << "template<class T, class M, class VfTag>" << endl;
  vf_unop_base (o, details,
	"test_basic<T,M,VfTag>");
  // op(e)
  cout << "template<class Expr, class VfTag>" << endl;
  vf_unop_base (o, details,
	"field_vf_expr<Expr,VfTag>"); 
}
// -----------------------------------------------------------------------------
void vf_all_unops (const vector<op>& Op, s details) {
  for (size_t i = 0; i < Op.size(); i++) {
    vf_unop (Op[i], details);
  }
}
// *************************************************************************************
// part 2. binary operations
// *************************************************************************************

// =====================================================================================
// chap 2.1. add v+v, v-v [TODO]
// =====================================================================================
void vf_addop (const op& o, s details) {
  // test+test
  cout << "template<class T, class M, class VfTag>" << endl;
  vf_binop_base (o, details, 
  	"test_basic<T,M,VfTag>",
        "",
  	"test_basic<T,M,VfTag>");

  // test+expr
  cout << "template<class T, class M, class Expr, class VfTag>" << endl;
  vf_binop_base (o, details, 
  	"test_basic<T,M,VfTag>",
        "",
  	"field_vf_expr<Expr,VfTag>");

  // expr+test
  cout << "template<class T, class M, class Expr, class VfTag>" << endl;
  vf_binop_base (o, details, 
  	"field_vf_expr<Expr,VfTag>",
        "",
  	"test_basic<T,M,VfTag>");

  // expr+expr
  cout << "template<class Expr1, class Expr2, class VfTag>" << endl;
  vf_binop_base (o, details, 
  	"field_vf_expr<Expr1,VfTag>",
        "",
  	"field_vf_expr<Expr2,VfTag>");
}
void vf_all_addops (const vector<op>& Op, s details) {
  for (size_t i = 0; i < Op.size(); i++) {
    vf_addop (Op[i], details);
  }
}
// =====================================================================================
// chap 2.2. mult by constant f*v, v/f, dot(f,v), ...
// =====================================================================================
void vf_multop_by_constant (const op& o, const vector<v::type>& Types, s details) {
  for (size_t i = 1; i <=2; ++i) {
    // v*c, c*v
    // v/c but skip c/v (nonlinear)
    if (o.tag == "divides" && i == 1) continue;

    for (vector<v::type>::const_iterator iter = Types.begin(), last = Types.end(); iter != last; ++iter) {
      v::type t = *iter;
    
      // skip type errors as v/tensor or dot(v,tensor):
      if (o.tag == "divides" && !(t & v::s)) continue;
      if (o.tag == "dot_"    && t != v::p) continue;
      if (o.tag == "ddot_"   && t != v::t) continue;
    
      cout << "template<class T, class M, class VfTag>" << endl;
      vf_binop_by_constant_bind (o, details, i,
	valued(t,"T"),
	"test_basic<T,M,VfTag>");

      cout << "template<class Expr, class VfTag>" << endl;
      vf_binop_by_constant_bind (o, details, i,
	valued(t,"typename Expr::scalar_type"),
	"field_vf_expr<Expr,VfTag>"); 
    }
  }
}
// -----------------------------------------------------------------------------
void vf_all_multops_by_constant (const vector<op>& Op,  const vector<v::type>& Types, s details) {
  for (size_t i = 0; i < Op.size(); i++) {
    vf_multop_by_constant (Op[i], Types, details);
  }
}
// =====================================================================================
// chap 2.3. mult by field f*v, v/f, dot(f,v), ...
// =====================================================================================
// Note: use field_vf_expr_binded_bf that find the field as first arg and test as second
// when the inverse is need, swap function args thanks to the swap<BinaryFunction> class
void gf_multop_by_field_bind (s root, const op& o, s details, size_t i, s fld, s w_fld, s tst, s w_tst) {
  if (w_fld == "") w_fld = fld;
  if (w_tst == "") w_tst = tst;
  s arg1 = (i == 1) ? fld : tst;
  s arg2 = (i == 2) ? fld : tst;
  s f = (i == 1) ? "x" : "y";
  s v = (i == 2) ? "x" : "y";
  f = (!is_functor(fld)) ? f : f+".get_ref()"; // see also: curiously recurring template pattern (CRTP) C++ idiom
  f = (fld == w_fld)     ? f : "fld_t("+f+")";
  v = (tst == w_tst)     ? v : "tst_t("+v+")";
  s raw_op_t = details + "::" + o.tag;
  s op_t     = (i == 1) ? raw_op_t : details+"::swapper<" + raw_op_t + ">";
  s op_t_var = (i == 1) ? "raw_op_t" : details+"::swapper<raw_op_t>";
  s op       = (i == 1) ? "op_t()" : "op_t(raw_op_t())";
  cout << "inline" << endl
       << root << "_vf_expr<" << endl
       << "  " << root << "_vf_expr_binded_bf<" << endl
       << "    " << op_t << endl
       << "   ," << w_fld << endl
       << "   ," << w_tst << endl
       << "  >" << endl
       << ">" << endl
       << add_operator(o.name) << " (const " << arg1 << "& x, const " << arg2 << "& y)" << endl
       << "{" << endl
       << "  typedef " << raw_op_t << "                         raw_op_t;" << endl
       << "  typedef " << op_t_var << "                         op_t;" << endl
       << "  typedef " << w_fld << "                            fld_t;" << endl
       << "  typedef " << w_tst << "                            tst_t;" << endl
       << "  typedef " << root << "_vf_expr_binded_bf<op_t,fld_t,tst_t>  expr_t;" << endl
       << "  return  " << root << "_vf_expr<expr_t>(expr_t("<<op<<", "<<f<<", "<<v<<"));" << endl
       << "}" << endl;
}
void vf_multop_by_field_bind (const op& o, s details, size_t i, s fld, s w_fld, s tst, s w_tst="") {
  gf_multop_by_field_bind ("field", o, details, i, fld, w_fld, tst, w_tst);
}
void vf2_multop_by_field_bind (const op& o, s details, size_t i, s fld, s w_fld, s tst, s w_tst="") {
  gf_multop_by_field_bind ("form", o, details, i, fld, w_fld, tst, w_tst);
}
// -----------------------------------------------------------------------------
void vf_multop_by_field (const op& o, const vector<v::type>& Types, s details) {
  for (size_t i = 1; i <=2; ++i) {
    // v*f, f*v
    // v/f but skip f/v (nonlinear)
    if (o.tag == "divides" && i == 1) continue;

    // -------------
    // field
    // -------------
    cout << "template<class T, class M, class VfTag>" << endl;
    vf_multop_by_field_bind (o, details, i,
	"field_basic<T,M>",
	"field_expr_terminal_field<T,M>",
	"test_basic<T,M,VfTag>");

    cout << "template<class T, class M, class Expr, class VfTag>" << endl;
    vf_multop_by_field_bind (o, details, i,
	"field_basic<T,M>",
	"field_expr_terminal_field<T,M>",
	"field_vf_expr<Expr,VfTag>"); 

    // -----------------------------
    // field_expr: linear expr
    // -----------------------------
    cout << "template<class T, class M, class Expr, class VfTag>" << endl;
    vf_multop_by_field_bind (o, details, i,
	"field_expr<Expr>",
	"field_expr_terminal_field<T,M>",
	"test_basic<T,M,VfTag>");

    cout << "template<class FExpr, class Expr, class VfTag>" << endl;
    vf_multop_by_field_bind (o, details, i,
	"field_expr<FExpr>",
	"field_expr_terminal_field<typename FExpr::scalar_type,typename FExpr::memory_type>",
	"field_vf_expr<Expr,VfTag>"); 

    // -----------------------------
    // field_nl_expr: nonlinear expr
    // -----------------------------
    cout << "template<class T, class M, class Expr, class VfTag>" << endl;
    vf_multop_by_field_bind (o, details, i,
	"field_nonlinear_expr<Expr>",
	"",
	"test_basic<T,M,VfTag>");

    cout << "template<class FExpr, class Expr, class VfTag>" << endl;
    vf_multop_by_field_bind (o, details, i,
	"field_nonlinear_expr<FExpr>",
	"",
	"field_vf_expr<Expr,VfTag>"); 

    for (vector<v::type>::const_iterator iter = Types.begin(), last = Types.end(); iter != last; ++iter) {
      v::type t = *iter;
      // functor & functions: control the return type
      // and skip type errors as v/tensor or dot(v,tensor):
      if (!o.have_arg (i, t)) continue;
      // -----------------------------
      // field_functor, Result=Float,point,tensor
      // -----------------------------
      cout << "template<class T, class M, class Fun, class VfTag>" << endl;
      vf_multop_by_field_bind (o, details, i,
	"field_functor<Fun,"+valued(t,"T")+" >",
	"field_expr_terminal_function<Fun>",
	"test_basic<T,M,VfTag>");

      cout << "template<class Fun, class Expr, class VfTag>" << endl;
      vf_multop_by_field_bind (o, details, i,
	"field_functor<Fun,"+valued(t,"typename Expr::scalar_type")+" >",
	"field_expr_terminal_function<Fun>",
	"field_vf_expr<Expr,VfTag>"); 

      // ----------------------------------------
      // function or class-function, Result=Float
      // ----------------------------------------
      // TODO: ajouter ici la classe fct si l'arg est unique (genre dot ou ddot)
      // et sinon ajouter les vraies fonctions: pbs d'ecriture du typage dans le profil ?
      bool arg_is_unique = (o.arg(i) == v::s || o.arg(i) == v::p || o.arg(i) == v::t);
      bool use_class_fct = (t == v::s) || arg_is_unique;
      if (!use_class_fct) continue;
      s r = valued(t,"Float");
      cout << "template<class M, class VfTag>" << endl;
      vf_multop_by_field_bind (o, details, i,
	"function<"+r+"(const point&)>",
	"field_expr_terminal_function<function<"+r+"(const point&)> >",
	"test_basic<Float,M,VfTag>");

      cout << "template<class Expr, class VfTag>" << endl;
      vf_multop_by_field_bind (o, details, i,
	"function<"+r+"(const point&)>",
	"field_expr_terminal_function<function<"+r+"(const point&)> >",
	"field_vf_expr<Expr,VfTag>"); 
    }
  }
}
// -----------------------------------------------------------------------------
void vf_all_multops_by_field (const vector<op>& Op, const vector<v::type>& Types, s details) {
  for (size_t i = 0; i < Op.size(); i++) {
    vf_multop_by_field (Op[i], Types, details);
  }
}
#ifndef _NO_FIELD_VF_MAIN // for form_vf_expr_ops_make.cc that reuse some code
// =====================================================================================
int main() {
// =====================================================================================
  const s details = "details";
  const bool linear = true;
  header("FIELD_VF", "field_vf");

  vector<v::type> Types;
  Types.push_back(v::s);
  Types.push_back(v::p);
  Types.push_back(v::t);

  vector<op> Unop;
  Unop.push_back (op("+",   "unary_plus", linear));
  Unop.push_back (op("-",   "negate",     linear));
  Unop.push_back (op("tr",    v::t));
  Unop.push_back (op("trans", v::t));
  vf_all_unops (Unop, details);

  vector<op> Fmultop;
  Fmultop.push_back (op("*",    "multiplies"));
  Fmultop.push_back (op("/",    "divides",   v::all, v::s));
  Fmultop.push_back (op("dot",  v::p));
  Fmultop.push_back (op("ddot", v::t));
  vf_all_multops_by_constant (Fmultop, Types, details);
  vf_all_multops_by_field    (Fmultop, Types, details);

  // q + dot(grad(q),normal())
  vector<op> BinopLinear;
  BinopLinear.push_back (op("+", "plus",  linear));
  BinopLinear.push_back (op("-", "minus", linear));
  vf_all_addops (BinopLinear, details);

#ifdef TODO
  // fh[0]*v
  vector<s> Class;
  Class.push_back ("field_basic");
  Class.push_back ("field_component");
  Class.push_back ("field_component_const");

  // fh[0]*v[0]  => test_component (const)
#endif // TODO

  footer("FIELD_VF", "field_vf");
}
#endif // _NO_FIELD_VF_MAIN
