///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef.h"
using namespace std;
using namespace rheolef;


// fonction de courbure nulle aux extrêmités (pour interpolation par splines naturelles)
Float sinus (const point& x)
 {
   return sin(acos(-1.)*x[0]);
 }

int main (int argc, char**argv) 
 {
   geo omega(argv[1]);
   space H3h (omega, "H3");
   space V1h (omega, "P1");
   space V1dh(omega, "P1d");

   form invm1  (V1dh, V1dh, "inv_mass");
   form secder (H3h, V1dh, "d2_ds2");
   form mass   (V1dh, V1dh, "mass");

   field uh=spline(H3h, sinus);
   // la dérivée seconde est continue !
   field udd_P1d=(invm1*(secder*uh));
   field udd_P1=interpolate(V1h, udd_P1d);
   Float err_C2=(udd_P1d - interpolate(V1dh, udd_P1)).max();

   Float tol = 1e-10;
   if (fabs(err_C2) <= tol) {
        cerr << "ok" << endl;
        return 0;
    } else {
	cerr << "error = " << fabs(err_C2) << endl;
	cerr << "and tol = " << tol << endl;
        return 1;
    }
 
   field udd_e = -acos(-1.)*acos(-1.)*interpolate(V1dh, sinus);
   Float err_udd = mass(udd_P1d - udd_e, udd_P1d - udd_e);

   tol = 1e-4; // for N=100. convergence is in h^4
   if (fabs(err_udd) <= tol) {
        cerr << "ok" << endl;
        return 0;
    } else {
	cerr << "error = " << fabs(err_udd) << endl;
	cerr << "and tol = " << tol << endl;
        return 1;
    }
 }
