/*
  (c) 2003 Nathan Hjelm <hjelmn@cs.unm.edu>

  This is for getting rios back up.
*/

#include <stdio.h>
#include <string.h>

#include "config.h"

#include "rio.h"

int main(int argc, char *argv[]) {
  rios_t rio;
  
  if (argc < 2) {
    printf("USAGE: riofck [update <.lok file>] [format]\n");
    exit(1);
  }

  if (open_rio (&rio, 0, 1, 0) < 0) {
    fprintf (stderr, "Could not open a Rio.\n");
    exit(2);
  }
  
  if (strstr(argv[1], "update") != NULL) {
    printf("FCKRIO: updating firmware with %s\n", argv[3]);
    
    if (update_rio(&rio, argv[3]) < 0)
      fprintf (stderr, "Firmware update failed.\n");
    else
      fprintf (stderr, "Firmware update complete.\n");
  } else if (strstr(argv[1], "format") != NULL) {
    printf("FCKRIO: formating all memory\n");
    format_mem_rio (&rio, 0);
    format_mem_rio (&rio, 1);
  }
  
  return 0;
}
