# packaging rkt

This document aims to provide information about packaging rkt in Linux distributions. It covers dependencies, file ownership and permissions, and tips to observe packaging policies.

## Build-time dependencies

Please see [the list of build-time dependencies][build-deps].

### Offline builds

By default, the rkt build will download a CoreOS PXE image from the internet and extract some binaries, such as `systemd-nspawn` and `bash`. However, some packaging environments don't allow internet access during the build. To work around this, download the CoreOS PXE image before starting the build process, and use the `--with-coreos-local-pxe-image-path` and `--with-coreos-local-pxe-image-systemd-version` parameters. For more details, see the [configure script parameters documentation][build-config].

### Bundling with systemd

Most Linux distributions don't allow the use of prebuilt binaries, or reuse of code that is already otherwise packaged. systemd falls in this category, as Debian and Fedora already package systemd, and rkt needs systemd.

- [Debian Policy Manual, section 4.13 Convenience copies of code][debian-policy-4.13]
- [Fedora Packaging Guidelines][fedora-packaging-guidelines]
- [Fedora Packaging Committee][fedora-packaging-committee]

The configure script's `--with-stage1-flavors` option can be set to `host` to avoid rkt's dependency on systemd in these environments:

```
./configure --with-stage1-flavors=host
```

The `stage1-host.aci` archive generated by this build will not contain bash, systemd, or any other binaries from external sources. The binaries embedded in the stage1 archive are all built from the sources in the rkt git repository. The external binaries needed by this `stage1-host.aci` are copied from the host *at run time*. Packages using the `--with-stage1-flavors=host` option must therefore add a run-time dependency on systemd and bash. Whenever systemd and bash are upgraded on the host, rkt will use the new version at run time. It becomes the packager's responsibility to test the rkt package whenever a new version of systemd is packaged.

For more details, see the [configure script parameters documentation][build-config].

### Glide

rkt uses [Glide][glide] to maintain [a copy of dependencies in its source repository][rkt-vendor].

## Run-time dependencies

Please see [the list of run-time dependencies][run-deps].

## Packaging Externals

### Ownership and permissions of rkt directories

In general, subdirectories of `/var/lib/rkt`, and `/etc/rkt` should be created with the same ownership and permissions as described in the [directory list][rkt-dirs].

Any rkt package should create a system group `rkt`, and `rkt-admin`. The directory `/var/lib/rkt` should belong to group `rkt` with the `setgid` bit set (`chmod g+s`). The directory `/etc/rkt` should belong to group `rkt-admin` with the `setgid` bit set (`chmod g+s`).

When the ownership and permissions of `/var/lib/rkt` are set up correctly, members of group `rkt` should be able to fetch ACIs. Members of group `rkt-admin` should be able to trust GPG keys, and add additional configurations in `/etc/rkt`. Root privilege is still required to run pods.

The motivation to have separate `rkt`, and `rkt-admin` groups is that the person who makes administrative changes would likely be different than the unprivileged user who is able to fetch.

### systemd units

A few [example systemd unit files for rkt helper services][rkt-units] are included in the rkt sources. These units demonstrate systemd-managed units to run the rkt [metadata-service][rkt-metadata-svc] with socket-activation, the rkt [api-service][api-service], and a periodic [garbage collection][rkt-gc] service invoked at 12-hour intervals to purge dead pods.

[build-config]: build-configure.md
[build-deps]: dependencies.md#build-time-dependencies
[debian-policy-4.13]: https://www.debian.org/doc/debian-policy/ch-source.html#s-embeddedfiles
[fedora-packaging-committee]: https://www.mail-archive.com/devel@lists.fedoraproject.org/msg88276.html
[fedora-packaging-guidelines]: https://fedoraproject.org/wiki/Packaging:Guidelines#No_inclusion_of_pre-built_binaries_or_libraries
[glide]: https://glide.sh
[rkt-gc]: subcommands/gc.md
[rkt-metadata-svc]: subcommands/metadata-service.md
[api-service]: subcommands/api-service.md
[rkt-units]: https://github.com/coreos/rkt/tree/master/dist/init/systemd
[rkt-vendor]: https://github.com/coreos/rkt/tree/master/vendor
[run-deps]: dependencies.md#run-time-dependencies
[rkt-dirs]: https://github.com/coreos/rkt/blob/master/dist/init/systemd/tmpfiles.d/rkt.conf
