// globals

function preprocess () {
  

echo ('  require(ltm)\n');
}


function printout () {
        doPrintout (true);
}

function preview () {
        preprocess ();
        calculate ();
        doPrintout (false);
}

function doPrintout (final) {
        
        
        

  
  plot_type        = getValue("plot_type");
  plot_type_item   = getValue("plot_type_item");
  inp_items        = getValue("inp_items");
  spin_from        = getValue("spin_from");
  spin_to          = getValue("spin_to");
  annotation       = getValue("annotation");

  
  plot_options     = getValue("plotoptions.code.printout");
  plot_ops_main    = getValue("plotoptions.main");
  plot_ops_type    = getValue("plotoptions.pointtype");
  plot_ops_xlab    = getValue("plotoptions.xlab");
  plot_ops_ylab    = getValue("plotoptions.ylab");

  
  
  options = array() ;
  if(plot_type == "items" && plot_type_item == "ICC")
    options[] = "type=\"ICC\"" ;
  if(plot_type == "items" && plot_type_item == "IIC")
    options[] = "type=\"IIC\"" ;
    
    if(plot_type == "items" && inp_items) {
      
      
      inp_items = str_replace("-",":",inp_items);
      arr_items = split('[ ;]', inp_items);
      options[] = "items=c("+join(",", arr_items)+")"; }

  
  if(plot_type == "TIC")
    options[] = "type=\"IIC\", items=0" ;
  
  
  if(plot_type == "SEC")
    options[] = "type=\"IIC\", items=0, plot=FALSE" ;
  
  if(plot_type == "loadings")
    options[] = "type=\"loadings\"" ;

  
  
  if(spin_from != "-3.8" || spin_to != "3.8")
    options[] = "zrange=c("+round(spin_from,2)+","+round(spin_to,2)+")" ;
  
  if(annotation == "legend")
    options[] = "legend=TRUE" ;
  if(annotation == "plain")
    options[] = "annot=FALSE" ;

        if (final) { 
echo ('rk.header("Two parameter logistic model plot")\n');
echo ('\n');
echo ('rk.graph.on()\n');
      }
        

        
        
       if (plot_type == "SEC") { 
echo ('# two steps are needed to plot standard error curves\n');
echo ('# first some values are generated...\n');
echo ('res <- try(plot(' + getValue("x"));
              if(options) echo (", "+join(", ", options));
          echo ('))\n');
echo ('\n');
echo ('# ... and then they\'re used to plot the curves:\n');
echo ('try(plot(res[,"z"], 1/sqrt(res[,"info"]), lwd=2');
              
              if(!plot_ops_type) echo (", type=\"l\"");
              if(!plot_ops_xlab) echo (", xlab=\"Ability\"");
              if(!plot_ops_ylab) echo (", ylab=\"Standard Error\"");
              if(!plot_ops_main) echo (", main=\"Stadard Error of Measurement\"");
              if(plot_options) echo (plot_options);
  echo ('))\n');
}
        
        else { 
echo ('try(plot(' + getValue("x"));
              if(options) echo (", "+join(", ", options));
              if(plot_options) echo (plot_options);
          echo ('))\n');
}
        if (final) { 
echo ('rk.graph.off()\n');
}
}
