//QT_Spec.h, Copyright (c) 2001-2007 R.Lackner
//
//    This file is part of RLPlot.
//
//    RLPlot is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    RLPlot is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with RLPlot; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#include "rlplot.h"
#include <qwidget.h>
#include <qpen.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qmenubar.h>
#include <qscrollbar.h>
#include <qdragobject.h>
#include "TheDialog.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class TxtCurBlink:public QObject {
	Q_OBJECT
public:
	anyOutput *oCopyMark;
	anyOutput *bmCopyMark;

	TxtCurBlink();
	void Show();
	void showCopyMark();

protected:
	void timerEvent(QTimerEvent *);

private:
	POINT line[5];
	bool isVis;
	int count, cp_mark;
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//use sockets for to exchange clipboard data
#ifdef RLP_PORT

#include <qsocket.h>
#include <qserversocket.h>

class ReadCB:public QSocket {
	Q_OBJECT
public:
	ReadCB(QObject *parent=0, const char *name=0, GraphObj *g=0);
	~ReadCB();

private slots:
	void isConnected();
	void receiveData();
	void endData();
	void isError(int);

private:
	int level;
	char *format;
	QObject *par;
	GraphObj *DestGO;
	QString *res;
};

class RLPsock:public QSocket {
	Q_OBJECT
public:
	RLPsock(int sock, QObject *parent=0, const char *name=0, GraphObj *g=0);

private slots:
	void readClient();

private:
	QObject *par;
	GraphObj *SourceGO;
};

class RLPserver:public QServerSocket {
	Q_OBJECT
public:
	GraphObj *SourceGO;

	RLPserver(QObject* parent=0, GraphObj *g=0);
	~RLPserver();
	void newConnection(int socket){new RLPsock(socket, this, 0, SourceGO);};

	void SetGO(GraphObj *g);
	char *GetXML();
	char *GetRLP();
	char *GetTXT() {return text_plain; };

signals:
	void newConnect(RLPsock *);

private:
	char *text_xml, *text_rlp, *text_plain;
};

#endif //RLP_PORT

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class RLPmenu:public QMenuBar {
	Q_OBJECT
public:
	RLPmenu(QWidget *par, anyOutput *o, GraphObj *g);

public slots:
	void doMenuItem(int id);

private:
	anyOutput *OutputClass;
	QWidget *parent;
	GraphObj *BaseObj;

};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The Qt widget class implementet for RLPlot
class RLPwidget:public QWidget {
	Q_OBJECT

public:
	QScrollBar *HScroll, *VScroll;
	QPixmap *mempic;
	RLPwidget(QWidget *par=0, const char *name=0, anyOutput *o = 0,
		GraphObj *g = 0);
	~RLPwidget();

public slots:
	void hScrollEvent(int pos);
	void vScrollEvent(int pos);
	void cmOpen();
	void cmSaveData();
	void cmSaveDataAs();
	void cmExit();
	void cmExitRLP();
	void cmNewGraph();
	void cmNewPage();
	void cmDelGraph();
	void cmAddPlot();
	void cmAbout();
	void cmAddRowCol();
	void cmCopy();
	void cmCut();
	void cmPaste();
	void cmCopyGraph();
	void cmSaveGraphAs();
	void cmRedraw();
	void cmZoom25();
	void cmZoom50();
	void cmZoom100();
	void cmZoom200();
	void cmZoom400();
	void cmZoomIn();
	void cmZoomOut();
	void cmZoomFit();
	void cmPrint();
	void cmExport();
	void cmDelObj();
	void cmUpdate();
	void cmDefaults();
	void cmAddAxis();
	void cmAddLegend();
	void cmLayers();
	void cmUndo();
	void cmFillRange();
	void cmInsRow();
	void cmInsCol();
	void cmDelRow();
	void cmDelCol();
	void cmtStandard();
	void cmtDraw();
	void cmtPolyline();
	void cmtPolygon();
	void cmtRectangle();
	void cmtRoundrect();
	void cmtEllipse();
	void cmtArrow();
	void cmtText();
	void cmSmplStat();
	void cmRepCmeans();
	void cmRepregr();
	void cmReptwoway();
	void cmFile1() {openHistoryFile(0);};
	void cmFile2() {openHistoryFile(1);};
	void cmFile3() {openHistoryFile(2);};
	void cmFile4() {openHistoryFile(3);};
	void cmFile5() {openHistoryFile(4);};
	void cmFile6() {openHistoryFile(5);};

protected:
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);
	void closeEvent(QCloseEvent *);
	void mouseDoubleClickEvent(QMouseEvent *e);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	void keyPressEvent(QKeyEvent *e);
	void focusInEvent(QFocusEvent *e);

private:
	QWidget *parent;
	anyOutput *OutputClass;
	GraphObj *BaseObj;

	void openHistoryFile(int idx);
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class DlgWidget:public QWidget {
	Q_OBJECT
public:
	QPixmap *mempic;
	anyOutput *OutputClass;

	DlgWidget(QWidget *par=0, const char *name=0, tag_DlgObj *d = 0);
	~DlgWidget();

protected:
	void paintEvent(QPaintEvent *);
	void mouseDoubleClickEvent(QMouseEvent *e);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	void keyPressEvent(QKeyEvent *e);
	void focusInEvent(QFocusEvent *e);
	void focusOutEvent(QFocusEvent *e);
	void closeEvent(QCloseEvent *e);
	void timerEvent(QTimerEvent *);

private:
	QWidget *parent;
	tag_DlgObj *dlg;
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class BitMapQT:public anyOutput {
public:
	QWidget *widget;
	HatchOut *hgo;
	QPixmap *mempic;
	QImage *image;
	QPen qPen;
	QPainter qPainter;
	QFont qFont;

	BitMapQT(GraphObj *g, QWidget *wi, int vr = 98, int hr = 98);
	BitMapQT(int w, int h, double hr, double vr);
	~BitMapQT();
	bool SetLine(LineDEF *lDef);
	bool SetFill(FillDEF *fill);
	bool SetTextSpec(TextDEF *set);
	virtual bool Erase(DWORD Color);
	virtual bool StartPage() {return true;};
	bool CopyBitmap(int x, int y, anyOutput* src, int sx, int sy,
		int sw, int sh, bool invert);
	bool oGetTextExtent(char *text, int cb, int *width, int *height);
	bool oGetTextExtentW(w_char *text, int cb, int *width, int *height);
	bool oGetPix(int x, int y, DWORD *col);
	bool oDrawIcon(int type, int x, int y);
	bool oCircle(int x1, int y1, int x2, int y2, char* nam = 0L);
	bool oPolyline(POINT * pts, int cp, char *nam = 0L);
	bool oRectangle(int x1, int y1, int x2, int y2, char *nam = 0L);
	bool oSolidLine(POINT *p);
	bool oTextOut(int x, int y, char *txt, int cb);
	bool oTextOutW(int x, int y, w_char *txt, int cb);
	bool oPolygon(POINT *pts, int cp, char *nam = 0L);
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class OutputQT:public BitMapQT {
public:
	QScrollBar *HScroll, *VScroll;

	OutputQT(GraphObj *g);
	OutputQT(DlgWidget *wi);
	~OutputQT();
	bool ActualSize(RECT *rc);
	void Focus(){if(widget){widget->show(); widget->setActiveWindow();widget->raise();}};
	void Caption(char *txt);
	void MouseCursor(int cid, bool force);
	bool SetScroll(bool isVert, int iMin, int iMax, int iPSize, int iPos);
	bool EndPage();
	bool UpdateRect(RECT *rc, bool invert);
	void ShowBitmap(int x, int y, anyOutput* src);
	void ShowLine(POINT * pts, int cp, DWORD color);
	void ShowEllipse(POINT p1, POINT p2, DWORD color); 
	bool SetMenu(int type);
	void CheckMenu(int mid, bool check);
	void FileHistory();
	void CreateNewWindow(GraphObj *g);

private:
	GraphObj *BaseObj;
	RLPmenu *menu;
};

class PrintQT:public anyOutput{
public:
	HatchOut *hgo;
	QPrinter *printer;

	PrintQT(GraphObj *g, char *file);
	~PrintQT();
	bool ActualSize(RECT *rc);
	bool SetLine(LineDEF *lDef);
	bool SetFill(FillDEF *fill);
	bool SetTextSpec(TextDEF *set);
	bool StartPage();
	bool EndPage();
	bool Eject();
	bool oGetTextExtent(char *text, int cb, int *width, int *height);
	bool oGetTextExtentW(w_char *text, int cb, int *width, int *height);
	bool oCircle(int x1, int y1, int x2, int y2, char* nam = 0L);
	bool oPolyline(POINT * pts, int cp, char *nam = 0L);
	bool oRectangle(int x1, int y1, int x2, int y2, char *nam = 0L);
	bool oSolidLine(POINT *p);
	bool oTextOut(int x, int y, char *txt, int cb);
	bool oTextOutW(int x, int y, w_char *txt, int cb);
	bool oPolygon(POINT *pts, int cp, char *nam = 0L);

private:
	QPen qPen;
	QFont qFont;
	QPainter qPainter;
	QWMatrix dxf;
	char *fileName;
	GraphObj *go;
	bool bPrinting;
};
