\name{dMatrix-class}
\docType{class}
\alias{dMatrix-class}
\alias{lMatrix-class}
\alias{show,dMatrix-method}
\alias{coerce,dMatrix,matrix-method}
\alias{coerce,dMatrix,dgeMatrix-method}
\alias{coerce,dMatrix,sparseMatrix-method}
\alias{[,dMatrix,lMatrix,missing,ANY-method}
\alias{[,dMatrix,logical,missing,ANY-method}
% Group methods
\alias{Arith,dMatrix,dMatrix-method}
\alias{Arith,dMatrix,numeric-method}
\alias{Arith,numeric,dMatrix-method}
\alias{Math,dMatrix-method}
\alias{Math2,dMatrix,numeric-method}% Math2 = round + signif, but
\alias{Summary,dMatrix-method}
\alias{Compare,dMatrix,dMatrix-method}
\alias{Compare,dMatrix,numeric-method}
\alias{Compare,numeric,dMatrix-method}
% for silly reasons, need these 2+3 as well:
\alias{round,dMatrix,numeric-method}
\alias{signif,dMatrix,numeric-method}
\alias{log,dMatrix-method}
\alias{gamma,dMatrix-method}
\alias{lgamma,dMatrix-method}
%
% operations with one argument from the "integer" class
\alias{crossprod,dMatrix,integer-method}
\alias{crossprod,integer,dMatrix-method}
\alias{solve,dMatrix,integer-method}
\alias{\%*\%,dMatrix,integer-method}
\alias{\%*\%,integer,dMatrix-method}
\title{(Virtual) Class "dMatrix" of "double" Matrices}
\description{
  The \code{dMatrix} class is a virtual class contained by all actual
  classes of numeric matrices in the \pkg{Matrix} package.  Similarly,
  all the actual classes of logical matrices inherit from the
  \code{lMatrix} class.
}
%\section{Objects from the Class}{A virtual Class: No objects may be
%  created from it.
%}
\section{Slots}{
  Common to \emph{all} matrix object in the package:
  \describe{
    \item{\code{Dim}:}{Object of class \code{"integer"} - the dimensions
     of the matrix - must be an integer vector with exactly two
     non-negative values.}
    \item{\code{Dimnames}:}{list of length two; each component
      containing NULL or a \code{\link{character}} vector length
      equal the corresponding \code{Dim} element.}
  }
}
\section{Methods}{
  There are (very simplistic) group methods (see, e.g., \code{\link{Arith}})
  \describe{
    \item{Arith}{\code{signature(e1 = "dMatrix", e2 = "dMatrix")}: ... }
    \item{Arith}{\code{signature(e1 = "dMatrix", e2 = "numeric")}: ... }
    \item{Arith}{\code{signature(e1 = "numeric", e2 = "dMatrix")}: ... }
    \item{Math}{\code{signature(x = "dMatrix")}: ... }
    \item{Math2}{\code{signature(x = "dMatrix", digits = "numeric")}: ...}
  }
}
%\references{}
% Martin + Doug\author{Douglas Bates \email{bates@stat.wisc.edu}}
\seealso{
  The classes \code{\linkS4class{dgeMatrix}},
  \code{\linkS4class{dgCMatrix}}, and \code{\linkS4class{Matrix}}.
}
\examples{
 showClass("dMatrix")
}
\keyword{classes}
\keyword{algebra}
