//hash_tiger.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2011
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

#define STATE_LEN (3*8)
#define PSTATE_LEN (4*8)
#define DIGEST_LEN STATE_LEN
#define BLOCK_LEN (64)

static uint64_t table[4*256] = {
 0x02AAB17CF7E90C5ELLU   /*    0 */,    0xAC424B03E243A8ECLLU   /*    1 */,
 0x72CD5BE30DD5FCD3LLU   /*    2 */,    0x6D019B93F6F97F3ALLU   /*    3 */,
 0xCD9978FFD21F9193LLU   /*    4 */,    0x7573A1C9708029E2LLU   /*    5 */,
 0xB164326B922A83C3LLU   /*    6 */,    0x46883EEE04915870LLU   /*    7 */,
 0xEAACE3057103ECE6LLU   /*    8 */,    0xC54169B808A3535CLLU   /*    9 */,
 0x4CE754918DDEC47CLLU   /*   10 */,    0x0AA2F4DFDC0DF40CLLU   /*   11 */,
 0x10B76F18A74DBEFALLU   /*   12 */,    0xC6CCB6235AD1AB6ALLU   /*   13 */,
 0x13726121572FE2FFLLU   /*   14 */,    0x1A488C6F199D921ELLU   /*   15 */,
 0x4BC9F9F4DA0007CALLU   /*   16 */,    0x26F5E6F6E85241C7LLU   /*   17 */,
 0x859079DBEA5947B6LLU   /*   18 */,    0x4F1885C5C99E8C92LLU   /*   19 */,
 0xD78E761EA96F864BLLU   /*   20 */,    0x8E36428C52B5C17DLLU   /*   21 */,
 0x69CF6827373063C1LLU   /*   22 */,    0xB607C93D9BB4C56ELLU   /*   23 */,
 0x7D820E760E76B5EALLU   /*   24 */,    0x645C9CC6F07FDC42LLU   /*   25 */,
 0xBF38A078243342E0LLU   /*   26 */,    0x5F6B343C9D2E7D04LLU   /*   27 */,
 0xF2C28AEB600B0EC6LLU   /*   28 */,    0x6C0ED85F7254BCACLLU   /*   29 */,
 0x71592281A4DB4FE5LLU   /*   30 */,    0x1967FA69CE0FED9FLLU   /*   31 */,
 0xFD5293F8B96545DBLLU   /*   32 */,    0xC879E9D7F2A7600BLLU   /*   33 */,
 0x860248920193194ELLU   /*   34 */,    0xA4F9533B2D9CC0B3LLU   /*   35 */,
 0x9053836C15957613LLU   /*   36 */,    0xDB6DCF8AFC357BF1LLU   /*   37 */,
 0x18BEEA7A7A370F57LLU   /*   38 */,    0x037117CA50B99066LLU   /*   39 */,
 0x6AB30A9774424A35LLU   /*   40 */,    0xF4E92F02E325249BLLU   /*   41 */,
 0x7739DB07061CCAE1LLU   /*   42 */,    0xD8F3B49CECA42A05LLU   /*   43 */,
 0xBD56BE3F51382F73LLU   /*   44 */,    0x45FAED5843B0BB28LLU   /*   45 */,
 0x1C813D5C11BF1F83LLU   /*   46 */,    0x8AF0E4B6D75FA169LLU   /*   47 */,
 0x33EE18A487AD9999LLU   /*   48 */,    0x3C26E8EAB1C94410LLU   /*   49 */,
 0xB510102BC0A822F9LLU   /*   50 */,    0x141EEF310CE6123BLLU   /*   51 */,
 0xFC65B90059DDB154LLU   /*   52 */,    0xE0158640C5E0E607LLU   /*   53 */,
 0x884E079826C3A3CFLLU   /*   54 */,    0x930D0D9523C535FDLLU   /*   55 */,
 0x35638D754E9A2B00LLU   /*   56 */,    0x4085FCCF40469DD5LLU   /*   57 */,
 0xC4B17AD28BE23A4CLLU   /*   58 */,    0xCAB2F0FC6A3E6A2ELLU   /*   59 */,
 0x2860971A6B943FCDLLU   /*   60 */,    0x3DDE6EE212E30446LLU   /*   61 */,
 0x6222F32AE01765AELLU   /*   62 */,    0x5D550BB5478308FELLU   /*   63 */,
 0xA9EFA98DA0EDA22ALLU   /*   64 */,    0xC351A71686C40DA7LLU   /*   65 */,
 0x1105586D9C867C84LLU   /*   66 */,    0xDCFFEE85FDA22853LLU   /*   67 */,
 0xCCFBD0262C5EEF76LLU   /*   68 */,    0xBAF294CB8990D201LLU   /*   69 */,
 0xE69464F52AFAD975LLU   /*   70 */,    0x94B013AFDF133E14LLU   /*   71 */,
 0x06A7D1A32823C958LLU   /*   72 */,    0x6F95FE5130F61119LLU   /*   73 */,
 0xD92AB34E462C06C0LLU   /*   74 */,    0xED7BDE33887C71D2LLU   /*   75 */,
 0x79746D6E6518393ELLU   /*   76 */,    0x5BA419385D713329LLU   /*   77 */,
 0x7C1BA6B948A97564LLU   /*   78 */,    0x31987C197BFDAC67LLU   /*   79 */,
 0xDE6C23C44B053D02LLU   /*   80 */,    0x581C49FED002D64DLLU   /*   81 */,
 0xDD474D6338261571LLU   /*   82 */,    0xAA4546C3E473D062LLU   /*   83 */,
 0x928FCE349455F860LLU   /*   84 */,    0x48161BBACAAB94D9LLU   /*   85 */,
 0x63912430770E6F68LLU   /*   86 */,    0x6EC8A5E602C6641CLLU   /*   87 */,
 0x87282515337DDD2BLLU   /*   88 */,    0x2CDA6B42034B701BLLU   /*   89 */,
 0xB03D37C181CB096DLLU   /*   90 */,    0xE108438266C71C6FLLU   /*   91 */,
 0x2B3180C7EB51B255LLU   /*   92 */,    0xDF92B82F96C08BBCLLU   /*   93 */,
 0x5C68C8C0A632F3BALLU   /*   94 */,    0x5504CC861C3D0556LLU   /*   95 */,
 0xABBFA4E55FB26B8FLLU   /*   96 */,    0x41848B0AB3BACEB4LLU   /*   97 */,
 0xB334A273AA445D32LLU   /*   98 */,    0xBCA696F0A85AD881LLU   /*   99 */,
 0x24F6EC65B528D56CLLU   /*  100 */,    0x0CE1512E90F4524ALLU   /*  101 */,
 0x4E9DD79D5506D35ALLU   /*  102 */,    0x258905FAC6CE9779LLU   /*  103 */,
 0x2019295B3E109B33LLU   /*  104 */,    0xF8A9478B73A054CCLLU   /*  105 */,
 0x2924F2F934417EB0LLU   /*  106 */,    0x3993357D536D1BC4LLU   /*  107 */,
 0x38A81AC21DB6FF8BLLU   /*  108 */,    0x47C4FBF17D6016BFLLU   /*  109 */,
 0x1E0FAADD7667E3F5LLU   /*  110 */,    0x7ABCFF62938BEB96LLU   /*  111 */,
 0xA78DAD948FC179C9LLU   /*  112 */,    0x8F1F98B72911E50DLLU   /*  113 */,
 0x61E48EAE27121A91LLU   /*  114 */,    0x4D62F7AD31859808LLU   /*  115 */,
 0xECEBA345EF5CEAEBLLU   /*  116 */,    0xF5CEB25EBC9684CELLU   /*  117 */,
 0xF633E20CB7F76221LLU   /*  118 */,    0xA32CDF06AB8293E4LLU   /*  119 */,
 0x985A202CA5EE2CA4LLU   /*  120 */,    0xCF0B8447CC8A8FB1LLU   /*  121 */,
 0x9F765244979859A3LLU   /*  122 */,    0xA8D516B1A1240017LLU   /*  123 */,
 0x0BD7BA3EBB5DC726LLU   /*  124 */,    0xE54BCA55B86ADB39LLU   /*  125 */,
 0x1D7A3AFD6C478063LLU   /*  126 */,    0x519EC608E7669EDDLLU   /*  127 */,
 0x0E5715A2D149AA23LLU   /*  128 */,    0x177D4571848FF194LLU   /*  129 */,
 0xEEB55F3241014C22LLU   /*  130 */,    0x0F5E5CA13A6E2EC2LLU   /*  131 */,
 0x8029927B75F5C361LLU   /*  132 */,    0xAD139FABC3D6E436LLU   /*  133 */,
 0x0D5DF1A94CCF402FLLU   /*  134 */,    0x3E8BD948BEA5DFC8LLU   /*  135 */,
 0xA5A0D357BD3FF77ELLU   /*  136 */,    0xA2D12E251F74F645LLU   /*  137 */,
 0x66FD9E525E81A082LLU   /*  138 */,    0x2E0C90CE7F687A49LLU   /*  139 */,
 0xC2E8BCBEBA973BC5LLU   /*  140 */,    0x000001BCE509745FLLU   /*  141 */,
 0x423777BBE6DAB3D6LLU   /*  142 */,    0xD1661C7EAEF06EB5LLU   /*  143 */,
 0xA1781F354DAACFD8LLU   /*  144 */,    0x2D11284A2B16AFFCLLU   /*  145 */,
 0xF1FC4F67FA891D1FLLU   /*  146 */,    0x73ECC25DCB920ADALLU   /*  147 */,
 0xAE610C22C2A12651LLU   /*  148 */,    0x96E0A810D356B78ALLU   /*  149 */,
 0x5A9A381F2FE7870FLLU   /*  150 */,    0xD5AD62EDE94E5530LLU   /*  151 */,
 0xD225E5E8368D1427LLU   /*  152 */,    0x65977B70C7AF4631LLU   /*  153 */,
 0x99F889B2DE39D74FLLU   /*  154 */,    0x233F30BF54E1D143LLU   /*  155 */,
 0x9A9675D3D9A63C97LLU   /*  156 */,    0x5470554FF334F9A8LLU   /*  157 */,
 0x166ACB744A4F5688LLU   /*  158 */,    0x70C74CAAB2E4AEADLLU   /*  159 */,
 0xF0D091646F294D12LLU   /*  160 */,    0x57B82A89684031D1LLU   /*  161 */,
 0xEFD95A5A61BE0B6BLLU   /*  162 */,    0x2FBD12E969F2F29ALLU   /*  163 */,
 0x9BD37013FEFF9FE8LLU   /*  164 */,    0x3F9B0404D6085A06LLU   /*  165 */,
 0x4940C1F3166CFE15LLU   /*  166 */,    0x09542C4DCDF3DEFBLLU   /*  167 */,
 0xB4C5218385CD5CE3LLU   /*  168 */,    0xC935B7DC4462A641LLU   /*  169 */,
 0x3417F8A68ED3B63FLLU   /*  170 */,    0xB80959295B215B40LLU   /*  171 */,
 0xF99CDAEF3B8C8572LLU   /*  172 */,    0x018C0614F8FCB95DLLU   /*  173 */,
 0x1B14ACCD1A3ACDF3LLU   /*  174 */,    0x84D471F200BB732DLLU   /*  175 */,
 0xC1A3110E95E8DA16LLU   /*  176 */,    0x430A7220BF1A82B8LLU   /*  177 */,
 0xB77E090D39DF210ELLU   /*  178 */,    0x5EF4BD9F3CD05E9DLLU   /*  179 */,
 0x9D4FF6DA7E57A444LLU   /*  180 */,    0xDA1D60E183D4A5F8LLU   /*  181 */,
 0xB287C38417998E47LLU   /*  182 */,    0xFE3EDC121BB31886LLU   /*  183 */,
 0xC7FE3CCC980CCBEFLLU   /*  184 */,    0xE46FB590189BFD03LLU   /*  185 */,
 0x3732FD469A4C57DCLLU   /*  186 */,    0x7EF700A07CF1AD65LLU   /*  187 */,
 0x59C64468A31D8859LLU   /*  188 */,    0x762FB0B4D45B61F6LLU   /*  189 */,
 0x155BAED099047718LLU   /*  190 */,    0x68755E4C3D50BAA6LLU   /*  191 */,
 0xE9214E7F22D8B4DFLLU   /*  192 */,    0x2ADDBF532EAC95F4LLU   /*  193 */,
 0x32AE3909B4BD0109LLU   /*  194 */,    0x834DF537B08E3450LLU   /*  195 */,
 0xFA209DA84220728DLLU   /*  196 */,    0x9E691D9B9EFE23F7LLU   /*  197 */,
 0x0446D288C4AE8D7FLLU   /*  198 */,    0x7B4CC524E169785BLLU   /*  199 */,
 0x21D87F0135CA1385LLU   /*  200 */,    0xCEBB400F137B8AA5LLU   /*  201 */,
 0x272E2B66580796BELLU   /*  202 */,    0x3612264125C2B0DELLU   /*  203 */,
 0x057702BDAD1EFBB2LLU   /*  204 */,    0xD4BABB8EACF84BE9LLU   /*  205 */,
 0x91583139641BC67BLLU   /*  206 */,    0x8BDC2DE08036E024LLU   /*  207 */,
 0x603C8156F49F68EDLLU   /*  208 */,    0xF7D236F7DBEF5111LLU   /*  209 */,
 0x9727C4598AD21E80LLU   /*  210 */,    0xA08A0896670A5FD7LLU   /*  211 */,
 0xCB4A8F4309EBA9CBLLU   /*  212 */,    0x81AF564B0F7036A1LLU   /*  213 */,
 0xC0B99AA778199ABDLLU   /*  214 */,    0x959F1EC83FC8E952LLU   /*  215 */,
 0x8C505077794A81B9LLU   /*  216 */,    0x3ACAAF8F056338F0LLU   /*  217 */,
 0x07B43F50627A6778LLU   /*  218 */,    0x4A44AB49F5ECCC77LLU   /*  219 */,
 0x3BC3D6E4B679EE98LLU   /*  220 */,    0x9CC0D4D1CF14108CLLU   /*  221 */,
 0x4406C00B206BC8A0LLU   /*  222 */,    0x82A18854C8D72D89LLU   /*  223 */,
 0x67E366B35C3C432CLLU   /*  224 */,    0xB923DD61102B37F2LLU   /*  225 */,
 0x56AB2779D884271DLLU   /*  226 */,    0xBE83E1B0FF1525AFLLU   /*  227 */,
 0xFB7C65D4217E49A9LLU   /*  228 */,    0x6BDBE0E76D48E7D4LLU   /*  229 */,
 0x08DF828745D9179ELLU   /*  230 */,    0x22EA6A9ADD53BD34LLU   /*  231 */,
 0xE36E141C5622200ALLU   /*  232 */,    0x7F805D1B8CB750EELLU   /*  233 */,
 0xAFE5C7A59F58E837LLU   /*  234 */,    0xE27F996A4FB1C23CLLU   /*  235 */,
 0xD3867DFB0775F0D0LLU   /*  236 */,    0xD0E673DE6E88891ALLU   /*  237 */,
 0x123AEB9EAFB86C25LLU   /*  238 */,    0x30F1D5D5C145B895LLU   /*  239 */,
 0xBB434A2DEE7269E7LLU   /*  240 */,    0x78CB67ECF931FA38LLU   /*  241 */,
 0xF33B0372323BBF9CLLU   /*  242 */,    0x52D66336FB279C74LLU   /*  243 */,
 0x505F33AC0AFB4EAALLU   /*  244 */,    0xE8A5CD99A2CCE187LLU   /*  245 */,
 0x534974801E2D30BBLLU   /*  246 */,    0x8D2D5711D5876D90LLU   /*  247 */,
 0x1F1A412891BC038ELLU   /*  248 */,    0xD6E2E71D82E56648LLU   /*  249 */,
 0x74036C3A497732B7LLU   /*  250 */,    0x89B67ED96361F5ABLLU   /*  251 */,
 0xFFED95D8F1EA02A2LLU   /*  252 */,    0xE72B3BD61464D43DLLU   /*  253 */,
 0xA6300F170BDC4820LLU   /*  254 */,    0xEBC18760ED78A77ALLU   /*  255 */,
 0xE6A6BE5A05A12138LLU   /*  256 */,    0xB5A122A5B4F87C98LLU   /*  257 */,
 0x563C6089140B6990LLU   /*  258 */,    0x4C46CB2E391F5DD5LLU   /*  259 */,
 0xD932ADDBC9B79434LLU   /*  260 */,    0x08EA70E42015AFF5LLU   /*  261 */,
 0xD765A6673E478CF1LLU   /*  262 */,    0xC4FB757EAB278D99LLU   /*  263 */,
 0xDF11C6862D6E0692LLU   /*  264 */,    0xDDEB84F10D7F3B16LLU   /*  265 */,
 0x6F2EF604A665EA04LLU   /*  266 */,    0x4A8E0F0FF0E0DFB3LLU   /*  267 */,
 0xA5EDEEF83DBCBA51LLU   /*  268 */,    0xFC4F0A2A0EA4371ELLU   /*  269 */,
 0xE83E1DA85CB38429LLU   /*  270 */,    0xDC8FF882BA1B1CE2LLU   /*  271 */,
 0xCD45505E8353E80DLLU   /*  272 */,    0x18D19A00D4DB0717LLU   /*  273 */,
 0x34A0CFEDA5F38101LLU   /*  274 */,    0x0BE77E518887CAF2LLU   /*  275 */,
 0x1E341438B3C45136LLU   /*  276 */,    0xE05797F49089CCF9LLU   /*  277 */,
 0xFFD23F9DF2591D14LLU   /*  278 */,    0x543DDA228595C5CDLLU   /*  279 */,
 0x661F81FD99052A33LLU   /*  280 */,    0x8736E641DB0F7B76LLU   /*  281 */,
 0x15227725418E5307LLU   /*  282 */,    0xE25F7F46162EB2FALLU   /*  283 */,
 0x48A8B2126C13D9FELLU   /*  284 */,    0xAFDC541792E76EEALLU   /*  285 */,
 0x03D912BFC6D1898FLLU   /*  286 */,    0x31B1AAFA1B83F51BLLU   /*  287 */,
 0xF1AC2796E42AB7D9LLU   /*  288 */,    0x40A3A7D7FCD2EBACLLU   /*  289 */,
 0x1056136D0AFBBCC5LLU   /*  290 */,    0x7889E1DD9A6D0C85LLU   /*  291 */,
 0xD33525782A7974AALLU   /*  292 */,    0xA7E25D09078AC09BLLU   /*  293 */,
 0xBD4138B3EAC6EDD0LLU   /*  294 */,    0x920ABFBE71EB9E70LLU   /*  295 */,
 0xA2A5D0F54FC2625CLLU   /*  296 */,    0xC054E36B0B1290A3LLU   /*  297 */,
 0xF6DD59FF62FE932BLLU   /*  298 */,    0x3537354511A8AC7DLLU   /*  299 */,
 0xCA845E9172FADCD4LLU   /*  300 */,    0x84F82B60329D20DCLLU   /*  301 */,
 0x79C62CE1CD672F18LLU   /*  302 */,    0x8B09A2ADD124642CLLU   /*  303 */,
 0xD0C1E96A19D9E726LLU   /*  304 */,    0x5A786A9B4BA9500CLLU   /*  305 */,
 0x0E020336634C43F3LLU   /*  306 */,    0xC17B474AEB66D822LLU   /*  307 */,
 0x6A731AE3EC9BAAC2LLU   /*  308 */,    0x8226667AE0840258LLU   /*  309 */,
 0x67D4567691CAECA5LLU   /*  310 */,    0x1D94155C4875ADB5LLU   /*  311 */,
 0x6D00FD985B813FDFLLU   /*  312 */,    0x51286EFCB774CD06LLU   /*  313 */,
 0x5E8834471FA744AFLLU   /*  314 */,    0xF72CA0AEE761AE2ELLU   /*  315 */,
 0xBE40E4CDAEE8E09ALLU   /*  316 */,    0xE9970BBB5118F665LLU   /*  317 */,
 0x726E4BEB33DF1964LLU   /*  318 */,    0x703B000729199762LLU   /*  319 */,
 0x4631D816F5EF30A7LLU   /*  320 */,    0xB880B5B51504A6BELLU   /*  321 */,
 0x641793C37ED84B6CLLU   /*  322 */,    0x7B21ED77F6E97D96LLU   /*  323 */,
 0x776306312EF96B73LLU   /*  324 */,    0xAE528948E86FF3F4LLU   /*  325 */,
 0x53DBD7F286A3F8F8LLU   /*  326 */,    0x16CADCE74CFC1063LLU   /*  327 */,
 0x005C19BDFA52C6DDLLU   /*  328 */,    0x68868F5D64D46AD3LLU   /*  329 */,
 0x3A9D512CCF1E186ALLU   /*  330 */,    0x367E62C2385660AELLU   /*  331 */,
 0xE359E7EA77DCB1D7LLU   /*  332 */,    0x526C0773749ABE6ELLU   /*  333 */,
 0x735AE5F9D09F734BLLU   /*  334 */,    0x493FC7CC8A558BA8LLU   /*  335 */,
 0xB0B9C1533041AB45LLU   /*  336 */,    0x321958BA470A59BDLLU   /*  337 */,
 0x852DB00B5F46C393LLU   /*  338 */,    0x91209B2BD336B0E5LLU   /*  339 */,
 0x6E604F7D659EF19FLLU   /*  340 */,    0xB99A8AE2782CCB24LLU   /*  341 */,
 0xCCF52AB6C814C4C7LLU   /*  342 */,    0x4727D9AFBE11727BLLU   /*  343 */,
 0x7E950D0C0121B34DLLU   /*  344 */,    0x756F435670AD471FLLU   /*  345 */,
 0xF5ADD442615A6849LLU   /*  346 */,    0x4E87E09980B9957ALLU   /*  347 */,
 0x2ACFA1DF50AEE355LLU   /*  348 */,    0xD898263AFD2FD556LLU   /*  349 */,
 0xC8F4924DD80C8FD6LLU   /*  350 */,    0xCF99CA3D754A173ALLU   /*  351 */,
 0xFE477BACAF91BF3CLLU   /*  352 */,    0xED5371F6D690C12DLLU   /*  353 */,
 0x831A5C285E687094LLU   /*  354 */,    0xC5D3C90A3708A0A4LLU   /*  355 */,
 0x0F7F903717D06580LLU   /*  356 */,    0x19F9BB13B8FDF27FLLU   /*  357 */,
 0xB1BD6F1B4D502843LLU   /*  358 */,    0x1C761BA38FFF4012LLU   /*  359 */,
 0x0D1530C4E2E21F3BLLU   /*  360 */,    0x8943CE69A7372C8ALLU   /*  361 */,
 0xE5184E11FEB5CE66LLU   /*  362 */,    0x618BDB80BD736621LLU   /*  363 */,
 0x7D29BAD68B574D0BLLU   /*  364 */,    0x81BB613E25E6FE5BLLU   /*  365 */,
 0x071C9C10BC07913FLLU   /*  366 */,    0xC7BEEB7909AC2D97LLU   /*  367 */,
 0xC3E58D353BC5D757LLU   /*  368 */,    0xEB017892F38F61E8LLU   /*  369 */,
 0xD4EFFB9C9B1CC21ALLU   /*  370 */,    0x99727D26F494F7ABLLU   /*  371 */,
 0xA3E063A2956B3E03LLU   /*  372 */,    0x9D4A8B9A4AA09C30LLU   /*  373 */,
 0x3F6AB7D500090FB4LLU   /*  374 */,    0x9CC0F2A057268AC0LLU   /*  375 */,
 0x3DEE9D2DEDBF42D1LLU   /*  376 */,    0x330F49C87960A972LLU   /*  377 */,
 0xC6B2720287421B41LLU   /*  378 */,    0x0AC59EC07C00369CLLU   /*  379 */,
 0xEF4EAC49CB353425LLU   /*  380 */,    0xF450244EEF0129D8LLU   /*  381 */,
 0x8ACC46E5CAF4DEB6LLU   /*  382 */,    0x2FFEAB63989263F7LLU   /*  383 */,
 0x8F7CB9FE5D7A4578LLU   /*  384 */,    0x5BD8F7644E634635LLU   /*  385 */,
 0x427A7315BF2DC900LLU   /*  386 */,    0x17D0C4AA2125261CLLU   /*  387 */,
 0x3992486C93518E50LLU   /*  388 */,    0xB4CBFEE0A2D7D4C3LLU   /*  389 */,
 0x7C75D6202C5DDD8DLLU   /*  390 */,    0xDBC295D8E35B6C61LLU   /*  391 */,
 0x60B369D302032B19LLU   /*  392 */,    0xCE42685FDCE44132LLU   /*  393 */,
 0x06F3DDB9DDF65610LLU   /*  394 */,    0x8EA4D21DB5E148F0LLU   /*  395 */,
 0x20B0FCE62FCD496FLLU   /*  396 */,    0x2C1B912358B0EE31LLU   /*  397 */,
 0xB28317B818F5A308LLU   /*  398 */,    0xA89C1E189CA6D2CFLLU   /*  399 */,
 0x0C6B18576AAADBC8LLU   /*  400 */,    0xB65DEAA91299FAE3LLU   /*  401 */,
 0xFB2B794B7F1027E7LLU   /*  402 */,    0x04E4317F443B5BEBLLU   /*  403 */,
 0x4B852D325939D0A6LLU   /*  404 */,    0xD5AE6BEEFB207FFCLLU   /*  405 */,
 0x309682B281C7D374LLU   /*  406 */,    0xBAE309A194C3B475LLU   /*  407 */,
 0x8CC3F97B13B49F05LLU   /*  408 */,    0x98A9422FF8293967LLU   /*  409 */,
 0x244B16B01076FF7CLLU   /*  410 */,    0xF8BF571C663D67EELLU   /*  411 */,
 0x1F0D6758EEE30DA1LLU   /*  412 */,    0xC9B611D97ADEB9B7LLU   /*  413 */,
 0xB7AFD5887B6C57A2LLU   /*  414 */,    0x6290AE846B984FE1LLU   /*  415 */,
 0x94DF4CDEACC1A5FDLLU   /*  416 */,    0x058A5BD1C5483AFFLLU   /*  417 */,
 0x63166CC142BA3C37LLU   /*  418 */,    0x8DB8526EB2F76F40LLU   /*  419 */,
 0xE10880036F0D6D4ELLU   /*  420 */,    0x9E0523C9971D311DLLU   /*  421 */,
 0x45EC2824CC7CD691LLU   /*  422 */,    0x575B8359E62382C9LLU   /*  423 */,
 0xFA9E400DC4889995LLU   /*  424 */,    0xD1823ECB45721568LLU   /*  425 */,
 0xDAFD983B8206082FLLU   /*  426 */,    0xAA7D29082386A8CBLLU   /*  427 */,
 0x269FCD4403B87588LLU   /*  428 */,    0x1B91F5F728BDD1E0LLU   /*  429 */,
 0xE4669F39040201F6LLU   /*  430 */,    0x7A1D7C218CF04ADELLU   /*  431 */,
 0x65623C29D79CE5CELLU   /*  432 */,    0x2368449096C00BB1LLU   /*  433 */,
 0xAB9BF1879DA503BALLU   /*  434 */,    0xBC23ECB1A458058ELLU   /*  435 */,
 0x9A58DF01BB401ECCLLU   /*  436 */,    0xA070E868A85F143DLLU   /*  437 */,
 0x4FF188307DF2239ELLU   /*  438 */,    0x14D565B41A641183LLU   /*  439 */,
 0xEE13337452701602LLU   /*  440 */,    0x950E3DCF3F285E09LLU   /*  441 */,
 0x59930254B9C80953LLU   /*  442 */,    0x3BF299408930DA6DLLU   /*  443 */,
 0xA955943F53691387LLU   /*  444 */,    0xA15EDECAA9CB8784LLU   /*  445 */,
 0x29142127352BE9A0LLU   /*  446 */,    0x76F0371FFF4E7AFBLLU   /*  447 */,
 0x0239F450274F2228LLU   /*  448 */,    0xBB073AF01D5E868BLLU   /*  449 */,
 0xBFC80571C10E96C1LLU   /*  450 */,    0xD267088568222E23LLU   /*  451 */,
 0x9671A3D48E80B5B0LLU   /*  452 */,    0x55B5D38AE193BB81LLU   /*  453 */,
 0x693AE2D0A18B04B8LLU   /*  454 */,    0x5C48B4ECADD5335FLLU   /*  455 */,
 0xFD743B194916A1CALLU   /*  456 */,    0x2577018134BE98C4LLU   /*  457 */,
 0xE77987E83C54A4ADLLU   /*  458 */,    0x28E11014DA33E1B9LLU   /*  459 */,
 0x270CC59E226AA213LLU   /*  460 */,    0x71495F756D1A5F60LLU   /*  461 */,
 0x9BE853FB60AFEF77LLU   /*  462 */,    0xADC786A7F7443DBFLLU   /*  463 */,
 0x0904456173B29A82LLU   /*  464 */,    0x58BC7A66C232BD5ELLU   /*  465 */,
 0xF306558C673AC8B2LLU   /*  466 */,    0x41F639C6B6C9772ALLU   /*  467 */,
 0x216DEFE99FDA35DALLU   /*  468 */,    0x11640CC71C7BE615LLU   /*  469 */,
 0x93C43694565C5527LLU   /*  470 */,    0xEA038E6246777839LLU   /*  471 */,
 0xF9ABF3CE5A3E2469LLU   /*  472 */,    0x741E768D0FD312D2LLU   /*  473 */,
 0x0144B883CED652C6LLU   /*  474 */,    0xC20B5A5BA33F8552LLU   /*  475 */,
 0x1AE69633C3435A9DLLU   /*  476 */,    0x97A28CA4088CFDECLLU   /*  477 */,
 0x8824A43C1E96F420LLU   /*  478 */,    0x37612FA66EEEA746LLU   /*  479 */,
 0x6B4CB165F9CF0E5ALLU   /*  480 */,    0x43AA1C06A0ABFB4ALLU   /*  481 */,
 0x7F4DC26FF162796BLLU   /*  482 */,    0x6CBACC8E54ED9B0FLLU   /*  483 */,
 0xA6B7FFEFD2BB253ELLU   /*  484 */,    0x2E25BC95B0A29D4FLLU   /*  485 */,
 0x86D6A58BDEF1388CLLU   /*  486 */,    0xDED74AC576B6F054LLU   /*  487 */,
 0x8030BDBC2B45805DLLU   /*  488 */,    0x3C81AF70E94D9289LLU   /*  489 */,
 0x3EFF6DDA9E3100DBLLU   /*  490 */,    0xB38DC39FDFCC8847LLU   /*  491 */,
 0x123885528D17B87ELLU   /*  492 */,    0xF2DA0ED240B1B642LLU   /*  493 */,
 0x44CEFADCD54BF9A9LLU   /*  494 */,    0x1312200E433C7EE6LLU   /*  495 */,
 0x9FFCC84F3A78C748LLU   /*  496 */,    0xF0CD1F72248576BBLLU   /*  497 */,
 0xEC6974053638CFE4LLU   /*  498 */,    0x2BA7B67C0CEC4E4CLLU   /*  499 */,
 0xAC2F4DF3E5CE32EDLLU   /*  500 */,    0xCB33D14326EA4C11LLU   /*  501 */,
 0xA4E9044CC77E58BCLLU   /*  502 */,    0x5F513293D934FCEFLLU   /*  503 */,
 0x5DC9645506E55444LLU   /*  504 */,    0x50DE418F317DE40ALLU   /*  505 */,
 0x388CB31A69DDE259LLU   /*  506 */,    0x2DB4A83455820A86LLU   /*  507 */,
 0x9010A91E84711AE9LLU   /*  508 */,    0x4DF7F0B7B1498371LLU   /*  509 */,
 0xD62A2EABC0977179LLU   /*  510 */,    0x22FAC097AA8D5C0ELLU   /*  511 */,
 0xF49FCC2FF1DAF39BLLU   /*  512 */,    0x487FD5C66FF29281LLU   /*  513 */,
 0xE8A30667FCDCA83FLLU   /*  514 */,    0x2C9B4BE3D2FCCE63LLU   /*  515 */,
 0xDA3FF74B93FBBBC2LLU   /*  516 */,    0x2FA165D2FE70BA66LLU   /*  517 */,
 0xA103E279970E93D4LLU   /*  518 */,    0xBECDEC77B0E45E71LLU   /*  519 */,
 0xCFB41E723985E497LLU   /*  520 */,    0xB70AAA025EF75017LLU   /*  521 */,
 0xD42309F03840B8E0LLU   /*  522 */,    0x8EFC1AD035898579LLU   /*  523 */,
 0x96C6920BE2B2ABC5LLU   /*  524 */,    0x66AF4163375A9172LLU   /*  525 */,
 0x2174ABDCCA7127FBLLU   /*  526 */,    0xB33CCEA64A72FF41LLU   /*  527 */,
 0xF04A4933083066A5LLU   /*  528 */,    0x8D970ACDD7289AF5LLU   /*  529 */,
 0x8F96E8E031C8C25ELLU   /*  530 */,    0xF3FEC02276875D47LLU   /*  531 */,
 0xEC7BF310056190DDLLU   /*  532 */,    0xF5ADB0AEBB0F1491LLU   /*  533 */,
 0x9B50F8850FD58892LLU   /*  534 */,    0x4975488358B74DE8LLU   /*  535 */,
 0xA3354FF691531C61LLU   /*  536 */,    0x0702BBE481D2C6EELLU   /*  537 */,
 0x89FB24057DEDED98LLU   /*  538 */,    0xAC3075138596E902LLU   /*  539 */,
 0x1D2D3580172772EDLLU   /*  540 */,    0xEB738FC28E6BC30DLLU   /*  541 */,
 0x5854EF8F63044326LLU   /*  542 */,    0x9E5C52325ADD3BBELLU   /*  543 */,
 0x90AA53CF325C4623LLU   /*  544 */,    0xC1D24D51349DD067LLU   /*  545 */,
 0x2051CFEEA69EA624LLU   /*  546 */,    0x13220F0A862E7E4FLLU   /*  547 */,
 0xCE39399404E04864LLU   /*  548 */,    0xD9C42CA47086FCB7LLU   /*  549 */,
 0x685AD2238A03E7CCLLU   /*  550 */,    0x066484B2AB2FF1DBLLU   /*  551 */,
 0xFE9D5D70EFBF79ECLLU   /*  552 */,    0x5B13B9DD9C481854LLU   /*  553 */,
 0x15F0D475ED1509ADLLU   /*  554 */,    0x0BEBCD060EC79851LLU   /*  555 */,
 0xD58C6791183AB7F8LLU   /*  556 */,    0xD1187C5052F3EEE4LLU   /*  557 */,
 0xC95D1192E54E82FFLLU   /*  558 */,    0x86EEA14CB9AC6CA2LLU   /*  559 */,
 0x3485BEB153677D5DLLU   /*  560 */,    0xDD191D781F8C492ALLU   /*  561 */,
 0xF60866BAA784EBF9LLU   /*  562 */,    0x518F643BA2D08C74LLU   /*  563 */,
 0x8852E956E1087C22LLU   /*  564 */,    0xA768CB8DC410AE8DLLU   /*  565 */,
 0x38047726BFEC8E1ALLU   /*  566 */,    0xA67738B4CD3B45AALLU   /*  567 */,
 0xAD16691CEC0DDE19LLU   /*  568 */,    0xC6D4319380462E07LLU   /*  569 */,
 0xC5A5876D0BA61938LLU   /*  570 */,    0x16B9FA1FA58FD840LLU   /*  571 */,
 0x188AB1173CA74F18LLU   /*  572 */,    0xABDA2F98C99C021FLLU   /*  573 */,
 0x3E0580AB134AE816LLU   /*  574 */,    0x5F3B05B773645ABBLLU   /*  575 */,
 0x2501A2BE5575F2F6LLU   /*  576 */,    0x1B2F74004E7E8BA9LLU   /*  577 */,
 0x1CD7580371E8D953LLU   /*  578 */,    0x7F6ED89562764E30LLU   /*  579 */,
 0xB15926FF596F003DLLU   /*  580 */,    0x9F65293DA8C5D6B9LLU   /*  581 */,
 0x6ECEF04DD690F84CLLU   /*  582 */,    0x4782275FFF33AF88LLU   /*  583 */,
 0xE41433083F820801LLU   /*  584 */,    0xFD0DFE409A1AF9B5LLU   /*  585 */,
 0x4325A3342CDB396BLLU   /*  586 */,    0x8AE77E62B301B252LLU   /*  587 */,
 0xC36F9E9F6655615ALLU   /*  588 */,    0x85455A2D92D32C09LLU   /*  589 */,
 0xF2C7DEA949477485LLU   /*  590 */,    0x63CFB4C133A39EBALLU   /*  591 */,
 0x83B040CC6EBC5462LLU   /*  592 */,    0x3B9454C8FDB326B0LLU   /*  593 */,
 0x56F56A9E87FFD78CLLU   /*  594 */,    0x2DC2940D99F42BC6LLU   /*  595 */,
 0x98F7DF096B096E2DLLU   /*  596 */,    0x19A6E01E3AD852BFLLU   /*  597 */,
 0x42A99CCBDBD4B40BLLU   /*  598 */,    0xA59998AF45E9C559LLU   /*  599 */,
 0x366295E807D93186LLU   /*  600 */,    0x6B48181BFAA1F773LLU   /*  601 */,
 0x1FEC57E2157A0A1DLLU   /*  602 */,    0x4667446AF6201AD5LLU   /*  603 */,
 0xE615EBCACFB0F075LLU   /*  604 */,    0xB8F31F4F68290778LLU   /*  605 */,
 0x22713ED6CE22D11ELLU   /*  606 */,    0x3057C1A72EC3C93BLLU   /*  607 */,
 0xCB46ACC37C3F1F2FLLU   /*  608 */,    0xDBB893FD02AAF50ELLU   /*  609 */,
 0x331FD92E600B9FCFLLU   /*  610 */,    0xA498F96148EA3AD6LLU   /*  611 */,
 0xA8D8426E8B6A83EALLU   /*  612 */,    0xA089B274B7735CDCLLU   /*  613 */,
 0x87F6B3731E524A11LLU   /*  614 */,    0x118808E5CBC96749LLU   /*  615 */,
 0x9906E4C7B19BD394LLU   /*  616 */,    0xAFED7F7E9B24A20CLLU   /*  617 */,
 0x6509EADEEB3644A7LLU   /*  618 */,    0x6C1EF1D3E8EF0EDELLU   /*  619 */,
 0xB9C97D43E9798FB4LLU   /*  620 */,    0xA2F2D784740C28A3LLU   /*  621 */,
 0x7B8496476197566FLLU   /*  622 */,    0x7A5BE3E6B65F069DLLU   /*  623 */,
 0xF96330ED78BE6F10LLU   /*  624 */,    0xEEE60DE77A076A15LLU   /*  625 */,
 0x2B4BEE4AA08B9BD0LLU   /*  626 */,    0x6A56A63EC7B8894ELLU   /*  627 */,
 0x02121359BA34FEF4LLU   /*  628 */,    0x4CBF99F8283703FCLLU   /*  629 */,
 0x398071350CAF30C8LLU   /*  630 */,    0xD0A77A89F017687ALLU   /*  631 */,
 0xF1C1A9EB9E423569LLU   /*  632 */,    0x8C7976282DEE8199LLU   /*  633 */,
 0x5D1737A5DD1F7ABDLLU   /*  634 */,    0x4F53433C09A9FA80LLU   /*  635 */,
 0xFA8B0C53DF7CA1D9LLU   /*  636 */,    0x3FD9DCBC886CCB77LLU   /*  637 */,
 0xC040917CA91B4720LLU   /*  638 */,    0x7DD00142F9D1DCDFLLU   /*  639 */,
 0x8476FC1D4F387B58LLU   /*  640 */,    0x23F8E7C5F3316503LLU   /*  641 */,
 0x032A2244E7E37339LLU   /*  642 */,    0x5C87A5D750F5A74BLLU   /*  643 */,
 0x082B4CC43698992ELLU   /*  644 */,    0xDF917BECB858F63CLLU   /*  645 */,
 0x3270B8FC5BF86DDALLU   /*  646 */,    0x10AE72BB29B5DD76LLU   /*  647 */,
 0x576AC94E7700362BLLU   /*  648 */,    0x1AD112DAC61EFB8FLLU   /*  649 */,
 0x691BC30EC5FAA427LLU   /*  650 */,    0xFF246311CC327143LLU   /*  651 */,
 0x3142368E30E53206LLU   /*  652 */,    0x71380E31E02CA396LLU   /*  653 */,
 0x958D5C960AAD76F1LLU   /*  654 */,    0xF8D6F430C16DA536LLU   /*  655 */,
 0xC8FFD13F1BE7E1D2LLU   /*  656 */,    0x7578AE66004DDBE1LLU   /*  657 */,
 0x05833F01067BE646LLU   /*  658 */,    0xBB34B5AD3BFE586DLLU   /*  659 */,
 0x095F34C9A12B97F0LLU   /*  660 */,    0x247AB64525D60CA8LLU   /*  661 */,
 0xDCDBC6F3017477D1LLU   /*  662 */,    0x4A2E14D4DECAD24DLLU   /*  663 */,
 0xBDB5E6D9BE0A1EEBLLU   /*  664 */,    0x2A7E70F7794301ABLLU   /*  665 */,
 0xDEF42D8A270540FDLLU   /*  666 */,    0x01078EC0A34C22C1LLU   /*  667 */,
 0xE5DE511AF4C16387LLU   /*  668 */,    0x7EBB3A52BD9A330ALLU   /*  669 */,
 0x77697857AA7D6435LLU   /*  670 */,    0x004E831603AE4C32LLU   /*  671 */,
 0xE7A21020AD78E312LLU   /*  672 */,    0x9D41A70C6AB420F2LLU   /*  673 */,
 0x28E06C18EA1141E6LLU   /*  674 */,    0xD2B28CBD984F6B28LLU   /*  675 */,
 0x26B75F6C446E9D83LLU   /*  676 */,    0xBA47568C4D418D7FLLU   /*  677 */,
 0xD80BADBFE6183D8ELLU   /*  678 */,    0x0E206D7F5F166044LLU   /*  679 */,
 0xE258A43911CBCA3ELLU   /*  680 */,    0x723A1746B21DC0BCLLU   /*  681 */,
 0xC7CAA854F5D7CDD3LLU   /*  682 */,    0x7CAC32883D261D9CLLU   /*  683 */,
 0x7690C26423BA942CLLU   /*  684 */,    0x17E55524478042B8LLU   /*  685 */,
 0xE0BE477656A2389FLLU   /*  686 */,    0x4D289B5E67AB2DA0LLU   /*  687 */,
 0x44862B9C8FBBFD31LLU   /*  688 */,    0xB47CC8049D141365LLU   /*  689 */,
 0x822C1B362B91C793LLU   /*  690 */,    0x4EB14655FB13DFD8LLU   /*  691 */,
 0x1ECBBA0714E2A97BLLU   /*  692 */,    0x6143459D5CDE5F14LLU   /*  693 */,
 0x53A8FBF1D5F0AC89LLU   /*  694 */,    0x97EA04D81C5E5B00LLU   /*  695 */,
 0x622181A8D4FDB3F3LLU   /*  696 */,    0xE9BCD341572A1208LLU   /*  697 */,
 0x1411258643CCE58ALLU   /*  698 */,    0x9144C5FEA4C6E0A4LLU   /*  699 */,
 0x0D33D06565CF620FLLU   /*  700 */,    0x54A48D489F219CA1LLU   /*  701 */,
 0xC43E5EAC6D63C821LLU   /*  702 */,    0xA9728B3A72770DAFLLU   /*  703 */,
 0xD7934E7B20DF87EFLLU   /*  704 */,    0xE35503B61A3E86E5LLU   /*  705 */,
 0xCAE321FBC819D504LLU   /*  706 */,    0x129A50B3AC60BFA6LLU   /*  707 */,
 0xCD5E68EA7E9FB6C3LLU   /*  708 */,    0xB01C90199483B1C7LLU   /*  709 */,
 0x3DE93CD5C295376CLLU   /*  710 */,    0xAED52EDF2AB9AD13LLU   /*  711 */,
 0x2E60F512C0A07884LLU   /*  712 */,    0xBC3D86A3E36210C9LLU   /*  713 */,
 0x35269D9B163951CELLU   /*  714 */,    0x0C7D6E2AD0CDB5FALLU   /*  715 */,
 0x59E86297D87F5733LLU   /*  716 */,    0x298EF221898DB0E7LLU   /*  717 */,
 0x55000029D1A5AA7ELLU   /*  718 */,    0x8BC08AE1B5061B45LLU   /*  719 */,
 0xC2C31C2B6C92703ALLU   /*  720 */,    0x94CC596BAF25EF42LLU   /*  721 */,
 0x0A1D73DB22540456LLU   /*  722 */,    0x04B6A0F9D9C4179ALLU   /*  723 */,
 0xEFFDAFA2AE3D3C60LLU   /*  724 */,    0xF7C8075BB49496C4LLU   /*  725 */,
 0x9CC5C7141D1CD4E3LLU   /*  726 */,    0x78BD1638218E5534LLU   /*  727 */,
 0xB2F11568F850246ALLU   /*  728 */,    0xEDFABCFA9502BC29LLU   /*  729 */,
 0x796CE5F2DA23051BLLU   /*  730 */,    0xAAE128B0DC93537CLLU   /*  731 */,
 0x3A493DA0EE4B29AELLU   /*  732 */,    0xB5DF6B2C416895D7LLU   /*  733 */,
 0xFCABBD25122D7F37LLU   /*  734 */,    0x70810B58105DC4B1LLU   /*  735 */,
 0xE10FDD37F7882A90LLU   /*  736 */,    0x524DCAB5518A3F5CLLU   /*  737 */,
 0x3C9E85878451255BLLU   /*  738 */,    0x4029828119BD34E2LLU   /*  739 */,
 0x74A05B6F5D3CECCBLLU   /*  740 */,    0xB610021542E13ECALLU   /*  741 */,
 0x0FF979D12F59E2ACLLU   /*  742 */,    0x6037DA27E4F9CC50LLU   /*  743 */,
 0x5E92975A0DF1847DLLU   /*  744 */,    0xD66DE190D3E623FELLU   /*  745 */,
 0x5032D6B87B568048LLU   /*  746 */,    0x9A36B7CE8235216ELLU   /*  747 */,
 0x80272A7A24F64B4ALLU   /*  748 */,    0x93EFED8B8C6916F7LLU   /*  749 */,
 0x37DDBFF44CCE1555LLU   /*  750 */,    0x4B95DB5D4B99BD25LLU   /*  751 */,
 0x92D3FDA169812FC0LLU   /*  752 */,    0xFB1A4A9A90660BB6LLU   /*  753 */,
 0x730C196946A4B9B2LLU   /*  754 */,    0x81E289AA7F49DA68LLU   /*  755 */,
 0x64669A0F83B1A05FLLU   /*  756 */,    0x27B3FF7D9644F48BLLU   /*  757 */,
 0xCC6B615C8DB675B3LLU   /*  758 */,    0x674F20B9BCEBBE95LLU   /*  759 */,
 0x6F31238275655982LLU   /*  760 */,    0x5AE488713E45CF05LLU   /*  761 */,
 0xBF619F9954C21157LLU   /*  762 */,    0xEABAC46040A8EAE9LLU   /*  763 */,
 0x454C6FE9F2C0C1CDLLU   /*  764 */,    0x419CF6496412691CLLU   /*  765 */,
 0xD3DC3BEF265B0F70LLU   /*  766 */,    0x6D0E60F5C3578A9ELLU   /*  767 */,
 0x5B0E608526323C55LLU   /*  768 */,    0x1A46C1A9FA1B59F5LLU   /*  769 */,
 0xA9E245A17C4C8FFALLU   /*  770 */,    0x65CA5159DB2955D7LLU   /*  771 */,
 0x05DB0A76CE35AFC2LLU   /*  772 */,    0x81EAC77EA9113D45LLU   /*  773 */,
 0x528EF88AB6AC0A0DLLU   /*  774 */,    0xA09EA253597BE3FFLLU   /*  775 */,
 0x430DDFB3AC48CD56LLU   /*  776 */,    0xC4B3A67AF45CE46FLLU   /*  777 */,
 0x4ECECFD8FBE2D05ELLU   /*  778 */,    0x3EF56F10B39935F0LLU   /*  779 */,
 0x0B22D6829CD619C6LLU   /*  780 */,    0x17FD460A74DF2069LLU   /*  781 */,
 0x6CF8CC8E8510ED40LLU   /*  782 */,    0xD6C824BF3A6ECAA7LLU   /*  783 */,
 0x61243D581A817049LLU   /*  784 */,    0x048BACB6BBC163A2LLU   /*  785 */,
 0xD9A38AC27D44CC32LLU   /*  786 */,    0x7FDDFF5BAAF410ABLLU   /*  787 */,
 0xAD6D495AA804824BLLU   /*  788 */,    0xE1A6A74F2D8C9F94LLU   /*  789 */,
 0xD4F7851235DEE8E3LLU   /*  790 */,    0xFD4B7F886540D893LLU   /*  791 */,
 0x247C20042AA4BFDALLU   /*  792 */,    0x096EA1C517D1327CLLU   /*  793 */,
 0xD56966B4361A6685LLU   /*  794 */,    0x277DA5C31221057DLLU   /*  795 */,
 0x94D59893A43ACFF7LLU   /*  796 */,    0x64F0C51CCDC02281LLU   /*  797 */,
 0x3D33BCC4FF6189DBLLU   /*  798 */,    0xE005CB184CE66AF1LLU   /*  799 */,
 0xFF5CCD1D1DB99BEALLU   /*  800 */,    0xB0B854A7FE42980FLLU   /*  801 */,
 0x7BD46A6A718D4B9FLLU   /*  802 */,    0xD10FA8CC22A5FD8CLLU   /*  803 */,
 0xD31484952BE4BD31LLU   /*  804 */,    0xC7FA975FCB243847LLU   /*  805 */,
 0x4886ED1E5846C407LLU   /*  806 */,    0x28CDDB791EB70B04LLU   /*  807 */,
 0xC2B00BE2F573417FLLU   /*  808 */,    0x5C9590452180F877LLU   /*  809 */,
 0x7A6BDDFFF370EB00LLU   /*  810 */,    0xCE509E38D6D9D6A4LLU   /*  811 */,
 0xEBEB0F00647FA702LLU   /*  812 */,    0x1DCC06CF76606F06LLU   /*  813 */,
 0xE4D9F28BA286FF0ALLU   /*  814 */,    0xD85A305DC918C262LLU   /*  815 */,
 0x475B1D8732225F54LLU   /*  816 */,    0x2D4FB51668CCB5FELLU   /*  817 */,
 0xA679B9D9D72BBA20LLU   /*  818 */,    0x53841C0D912D43A5LLU   /*  819 */,
 0x3B7EAA48BF12A4E8LLU   /*  820 */,    0x781E0E47F22F1DDFLLU   /*  821 */,
 0xEFF20CE60AB50973LLU   /*  822 */,    0x20D261D19DFFB742LLU   /*  823 */,
 0x16A12B03062A2E39LLU   /*  824 */,    0x1960EB2239650495LLU   /*  825 */,
 0x251C16FED50EB8B8LLU   /*  826 */,    0x9AC0C330F826016ELLU   /*  827 */,
 0xED152665953E7671LLU   /*  828 */,    0x02D63194A6369570LLU   /*  829 */,
 0x5074F08394B1C987LLU   /*  830 */,    0x70BA598C90B25CE1LLU   /*  831 */,
 0x794A15810B9742F6LLU   /*  832 */,    0x0D5925E9FCAF8C6CLLU   /*  833 */,
 0x3067716CD868744ELLU   /*  834 */,    0x910AB077E8D7731BLLU   /*  835 */,
 0x6A61BBDB5AC42F61LLU   /*  836 */,    0x93513EFBF0851567LLU   /*  837 */,
 0xF494724B9E83E9D5LLU   /*  838 */,    0xE887E1985C09648DLLU   /*  839 */,
 0x34B1D3C675370CFDLLU   /*  840 */,    0xDC35E433BC0D255DLLU   /*  841 */,
 0xD0AAB84234131BE0LLU   /*  842 */,    0x08042A50B48B7EAFLLU   /*  843 */,
 0x9997C4EE44A3AB35LLU   /*  844 */,    0x829A7B49201799D0LLU   /*  845 */,
 0x263B8307B7C54441LLU   /*  846 */,    0x752F95F4FD6A6CA6LLU   /*  847 */,
 0x927217402C08C6E5LLU   /*  848 */,    0x2A8AB754A795D9EELLU   /*  849 */,
 0xA442F7552F72943DLLU   /*  850 */,    0x2C31334E19781208LLU   /*  851 */,
 0x4FA98D7CEAEE6291LLU   /*  852 */,    0x55C3862F665DB309LLU   /*  853 */,
 0xBD0610175D53B1F3LLU   /*  854 */,    0x46FE6CB840413F27LLU   /*  855 */,
 0x3FE03792DF0CFA59LLU   /*  856 */,    0xCFE700372EB85E8FLLU   /*  857 */,
 0xA7BE29E7ADBCE118LLU   /*  858 */,    0xE544EE5CDE8431DDLLU   /*  859 */,
 0x8A781B1B41F1873ELLU   /*  860 */,    0xA5C94C78A0D2F0E7LLU   /*  861 */,
 0x39412E2877B60728LLU   /*  862 */,    0xA1265EF3AFC9A62CLLU   /*  863 */,
 0xBCC2770C6A2506C5LLU   /*  864 */,    0x3AB66DD5DCE1CE12LLU   /*  865 */,
 0xE65499D04A675B37LLU   /*  866 */,    0x7D8F523481BFD216LLU   /*  867 */,
 0x0F6F64FCEC15F389LLU   /*  868 */,    0x74EFBE618B5B13C8LLU   /*  869 */,
 0xACDC82B714273E1DLLU   /*  870 */,    0xDD40BFE003199D17LLU   /*  871 */,
 0x37E99257E7E061F8LLU   /*  872 */,    0xFA52626904775AAALLU   /*  873 */,
 0x8BBBF63A463D56F9LLU   /*  874 */,    0xF0013F1543A26E64LLU   /*  875 */,
 0xA8307E9F879EC898LLU   /*  876 */,    0xCC4C27A4150177CCLLU   /*  877 */,
 0x1B432F2CCA1D3348LLU   /*  878 */,    0xDE1D1F8F9F6FA013LLU   /*  879 */,
 0x606602A047A7DDD6LLU   /*  880 */,    0xD237AB64CC1CB2C7LLU   /*  881 */,
 0x9B938E7225FCD1D3LLU   /*  882 */,    0xEC4E03708E0FF476LLU   /*  883 */,
 0xFEB2FBDA3D03C12DLLU   /*  884 */,    0xAE0BCED2EE43889ALLU   /*  885 */,
 0x22CB8923EBFB4F43LLU   /*  886 */,    0x69360D013CF7396DLLU   /*  887 */,
 0x855E3602D2D4E022LLU   /*  888 */,    0x073805BAD01F784CLLU   /*  889 */,
 0x33E17A133852F546LLU   /*  890 */,    0xDF4874058AC7B638LLU   /*  891 */,
 0xBA92B29C678AA14ALLU   /*  892 */,    0x0CE89FC76CFAADCDLLU   /*  893 */,
 0x5F9D4E0908339E34LLU   /*  894 */,    0xF1AFE9291F5923B9LLU   /*  895 */,
 0x6E3480F60F4A265FLLU   /*  896 */,    0xEEBF3A2AB29B841CLLU   /*  897 */,
 0xE21938A88F91B4ADLLU   /*  898 */,    0x57DFEFF845C6D3C3LLU   /*  899 */,
 0x2F006B0BF62CAAF2LLU   /*  900 */,    0x62F479EF6F75EE78LLU   /*  901 */,
 0x11A55AD41C8916A9LLU   /*  902 */,    0xF229D29084FED453LLU   /*  903 */,
 0x42F1C27B16B000E6LLU   /*  904 */,    0x2B1F76749823C074LLU   /*  905 */,
 0x4B76ECA3C2745360LLU   /*  906 */,    0x8C98F463B91691BDLLU   /*  907 */,
 0x14BCC93CF1ADE66ALLU   /*  908 */,    0x8885213E6D458397LLU   /*  909 */,
 0x8E177DF0274D4711LLU   /*  910 */,    0xB49B73B5503F2951LLU   /*  911 */,
 0x10168168C3F96B6BLLU   /*  912 */,    0x0E3D963B63CAB0AELLU   /*  913 */,
 0x8DFC4B5655A1DB14LLU   /*  914 */,    0xF789F1356E14DE5CLLU   /*  915 */,
 0x683E68AF4E51DAC1LLU   /*  916 */,    0xC9A84F9D8D4B0FD9LLU   /*  917 */,
 0x3691E03F52A0F9D1LLU   /*  918 */,    0x5ED86E46E1878E80LLU   /*  919 */,
 0x3C711A0E99D07150LLU   /*  920 */,    0x5A0865B20C4E9310LLU   /*  921 */,
 0x56FBFC1FE4F0682ELLU   /*  922 */,    0xEA8D5DE3105EDF9BLLU   /*  923 */,
 0x71ABFDB12379187ALLU   /*  924 */,    0x2EB99DE1BEE77B9CLLU   /*  925 */,
 0x21ECC0EA33CF4523LLU   /*  926 */,    0x59A4D7521805C7A1LLU   /*  927 */,
 0x3896F5EB56AE7C72LLU   /*  928 */,    0xAA638F3DB18F75DCLLU   /*  929 */,
 0x9F39358DABE9808ELLU   /*  930 */,    0xB7DEFA91C00B72ACLLU   /*  931 */,
 0x6B5541FD62492D92LLU   /*  932 */,    0x6DC6DEE8F92E4D5BLLU   /*  933 */,
 0x353F57ABC4BEEA7ELLU   /*  934 */,    0x735769D6DA5690CELLU   /*  935 */,
 0x0A234AA642391484LLU   /*  936 */,    0xF6F9508028F80D9DLLU   /*  937 */,
 0xB8E319A27AB3F215LLU   /*  938 */,    0x31AD9C1151341A4DLLU   /*  939 */,
 0x773C22A57BEF5805LLU   /*  940 */,    0x45C7561A07968633LLU   /*  941 */,
 0xF913DA9E249DBE36LLU   /*  942 */,    0xDA652D9B78A64C68LLU   /*  943 */,
 0x4C27A97F3BC334EFLLU   /*  944 */,    0x76621220E66B17F4LLU   /*  945 */,
 0x967743899ACD7D0BLLU   /*  946 */,    0xF3EE5BCAE0ED6782LLU   /*  947 */,
 0x409F753600C879FCLLU   /*  948 */,    0x06D09A39B5926DB6LLU   /*  949 */,
 0x6F83AEB0317AC588LLU   /*  950 */,    0x01E6CA4A86381F21LLU   /*  951 */,
 0x66FF3462D19F3025LLU   /*  952 */,    0x72207C24DDFD3BFBLLU   /*  953 */,
 0x4AF6B6D3E2ECE2EBLLU   /*  954 */,    0x9C994DBEC7EA08DELLU   /*  955 */,
 0x49ACE597B09A8BC4LLU   /*  956 */,    0xB38C4766CF0797BALLU   /*  957 */,
 0x131B9373C57C2A75LLU   /*  958 */,    0xB1822CCE61931E58LLU   /*  959 */,
 0x9D7555B909BA1C0CLLU   /*  960 */,    0x127FAFDD937D11D2LLU   /*  961 */,
 0x29DA3BADC66D92E4LLU   /*  962 */,    0xA2C1D57154C2ECBCLLU   /*  963 */,
 0x58C5134D82F6FE24LLU   /*  964 */,    0x1C3AE3515B62274FLLU   /*  965 */,
 0xE907C82E01CB8126LLU   /*  966 */,    0xF8ED091913E37FCBLLU   /*  967 */,
 0x3249D8F9C80046C9LLU   /*  968 */,    0x80CF9BEDE388FB63LLU   /*  969 */,
 0x1881539A116CF19ELLU   /*  970 */,    0x5103F3F76BD52457LLU   /*  971 */,
 0x15B7E6F5AE47F7A8LLU   /*  972 */,    0xDBD7C6DED47E9CCFLLU   /*  973 */,
 0x44E55C410228BB1ALLU   /*  974 */,    0xB647D4255EDB4E99LLU   /*  975 */,
 0x5D11882BB8AAFC30LLU   /*  976 */,    0xF5098BBB29D3212ALLU   /*  977 */,
 0x8FB5EA14E90296B3LLU   /*  978 */,    0x677B942157DD025ALLU   /*  979 */,
 0xFB58E7C0A390ACB5LLU   /*  980 */,    0x89D3674C83BD4A01LLU   /*  981 */,
 0x9E2DA4DF4BF3B93BLLU   /*  982 */,    0xFCC41E328CAB4829LLU   /*  983 */,
 0x03F38C96BA582C52LLU   /*  984 */,    0xCAD1BDBD7FD85DB2LLU   /*  985 */,
 0xBBB442C16082AE83LLU   /*  986 */,    0xB95FE86BA5DA9AB0LLU   /*  987 */,
 0xB22E04673771A93FLLU   /*  988 */,    0x845358C9493152D8LLU   /*  989 */,
 0xBE2A488697B4541ELLU   /*  990 */,    0x95A2DC2DD38E6966LLU   /*  991 */,
 0xC02C11AC923C852BLLU   /*  992 */,    0x2388B1990DF2A87BLLU   /*  993 */,
 0x7C8008FA1B4F37BELLU   /*  994 */,    0x1F70D0C84D54E503LLU   /*  995 */,
 0x5490ADEC7ECE57D4LLU   /*  996 */,    0x002B3C27D9063A3ALLU   /*  997 */,
 0x7EAEA3848030A2BFLLU   /*  998 */,    0xC602326DED2003C0LLU   /*  999 */,
 0x83A7287D69A94086LLU   /* 1000 */,    0xC57A5FCB30F57A8ALLU   /* 1001 */,
 0xB56844E479EBE779LLU   /* 1002 */,    0xA373B40F05DCBCE9LLU   /* 1003 */,
 0xD71A786E88570EE2LLU   /* 1004 */,    0x879CBACDBDE8F6A0LLU   /* 1005 */,
 0x976AD1BCC164A32FLLU   /* 1006 */,    0xAB21E25E9666D78BLLU   /* 1007 */,
 0x901063AAE5E5C33CLLU   /* 1008 */,    0x9818B34448698D90LLU   /* 1009 */,
 0xE36487AE3E1E8ABBLLU   /* 1010 */,    0xAFBDF931893BDCB4LLU   /* 1011 */,
 0x6345A0DC5FBBD519LLU   /* 1012 */,    0x8628FE269B9465CALLU   /* 1013 */,
 0x1E5D01603F9C51ECLLU   /* 1014 */,    0x4DE44006A15049B7LLU   /* 1015 */,
 0xBF6C70E5F776CBB1LLU   /* 1016 */,    0x411218F2EF552BEDLLU   /* 1017 */,
 0xCB0C0708705A36A3LLU   /* 1018 */,    0xE74D14754F986044LLU   /* 1019 */,
 0xCD56D9430EA8280ELLU   /* 1020 */,    0xC12591D7535F5065LLU   /* 1021 */,
 0xC83223F1720AEF96LLU   /* 1022 */,    0xC3A0396F7363A51FLLU   /* 1023 */
};

#define sbox1 (table+256*0)
#define sbox2 (table+256*1)
#define sbox3 (table+256*2)
#define sbox4 (table+256*3)

int roar_hash_tiger_init(struct roar_hash_tiger * state) {
 if ( state == NULL )
  return -1;

 memset(state, 0, sizeof(struct roar_hash_tiger));

 state->a = 0x0123456789ABCDEFLLU;
 state->b = 0xFEDCBA9876543210LLU;
 state->c = 0xF096A5B4C3B2E187LLU;

 state->inlen  = 0;
 state->blocks = 0;

 state->is_final = 0;

 return 0;
}

int roar_hash_tiger_uninit(struct roar_hash_tiger * state) {
 return 0;
}

int roar_hash_tiger_init_from_pstate(struct roar_hash_tiger * state, void * oldstate) {
 uint64_t blocks;
 unsigned char * p = oldstate;

 if ( state == NULL || oldstate == NULL )
  return -1;

 if ( roar_hash_tiger_init(state) == -1 )
  return -1;

#if BYTE_ORDER == BIG_ENDIAN && !defined(ROAR_TARGET_WIN32)
#define _in(m)  do { m = *(uint64_t*)p;  p += 8; } while(0)
#elif BYTE_ORDER == LITTLE_ENDIAN
#define _S(x, n) (((uint64_t)(p[(n)])) << (uint64_t)(x))
#define _in(m) do { m = (uint64_t)(_S(56, 0) | _S(48, 1) | _S(40, 2) | _S(32, 3) | \
                                   _S(24, 4) | _S(16, 5) | _S( 8, 6) | _S( 0, 7)   \
                        ); p += 8; } while (0)
#else
  ROAR_ERR("roar_hash_tiger_init_from_pstate(state=%p, ...): Tiger not implemented for non little or big endian systems!", state);
  return -1;
#define _in
#endif
 _in(state->a);
 _in(state->b);
 _in(state->c);
 _in(blocks);

 state->blocks = blocks;
#undef _in

 return 0;
}

static int roar_hash_tiger_export(struct roar_hash_tiger * state, void * newstate, size_t * len, int is_pstate) {
 unsigned char * p = newstate;
 size_t needlen;
 uint64_t blocks;

 if ( is_pstate ) {
  needlen = PSTATE_LEN;
 } else {
  needlen = STATE_LEN;
 }

 if ( state == NULL || newstate == NULL || len == NULL )
  return -1;

 if ( state->inlen != 0 )
  return -1;

 if ( *len < needlen )
  return -1;

 *len = needlen;

#if BYTE_ORDER == BIG_ENDIAN && !defined(ROAR_TARGET_WIN32)
#define _out(m) do { *(uint64_t*)p = m ; p += 8; } while(0)
#elif BYTE_ORDER == LITTLE_ENDIAN
#define _out(m) do { *p++ = m >> 56; *p++ = m >> 48; \
                     *p++ = m >> 40; *p++ = m >> 32; \
                     *p++ = m >> 24; *p++ = m >> 16; \
                     *p++ = m >>  8; *p++ = m;       } while(0)
#else
  ROAR_ERR("roar_hash_tiger_export(state=%p, ...): Tiger not implemented for non little or big endian systems!", state);
  return -1;
#define _out
#endif
 _out(state->a);
 _out(state->b);
 _out(state->c);
 if ( is_pstate ) {
  blocks = state->blocks;
  _out(blocks);
 }
#undef _out

 return 0;
}

int roar_hash_tiger_to_pstate(struct roar_hash_tiger * state, void * newstate, size_t * len) {
 return roar_hash_tiger_export(state, newstate, len, 1);
}

ssize_t roar_hash_tiger_statelen(struct roar_hash_tiger * state) {
 return PSTATE_LEN;
}

int roar_hash_tiger_finalize(struct roar_hash_tiger * state) {
 uint64_t len;

 if ( state == NULL )
  return -1;

 if ( state->is_final )
  return 0;

 len  = state->blocks * BLOCK_LEN + state->inlen;
 len *= 8; // byte -> bit

 if ( state->inlen < 56 ) { /* enough room */
  state->inbuf[state->inlen++] = 0x01; /* pad */
  while ( state->inlen < 56 )
   state->inbuf[state->inlen++] = 0;  /* pad */
 } else { /* need one extra block */
  state->inbuf[state->inlen++] = 0x01; /* pad character */
  while( state->inlen < 64 )
   state->inbuf[state->inlen++] = 0;

  roar_hash_tiger_proc_block(state, state->inbuf);
  memset(state->inbuf, 0, 56); /* fill next block with zeroes */
 }

  state->inbuf[56] = (len >>  0) & 0xFF;
  state->inbuf[57] = (len >>  8) & 0xFF;
  state->inbuf[58] = (len >> 16) & 0xFF;
  state->inbuf[59] = (len >> 24) & 0xFF;
  state->inbuf[60] = (len >> 32) & 0xFF;
  state->inbuf[61] = (len >> 40) & 0xFF;
  state->inbuf[62] = (len >> 48) & 0xFF;
  state->inbuf[63] = (len >> 56) & 0xFF;

 roar_hash_tiger_proc_block(state, state->inbuf);

 state->inlen    = 0;
 state->is_final = 1;

 return 0;
}

int roar_hash_tiger_get_digest(struct roar_hash_tiger * state, void * digest, size_t * len) {
 if ( state == NULL || digest == NULL )
  return -1;

 if ( roar_hash_tiger_finalize(state) == -1 )
  return -1;

 return roar_hash_tiger_export(state, digest, len, 0);
}

static void tiger_round( uint64_t * ra, uint64_t * rb, uint64_t * rc, uint64_t x, uint64_t mul) {
  uint64_t a = *ra;
  uint64_t b = *rb;
  uint64_t c = *rc;

  c ^= x;
  a -= (  sbox1[  c        & 0xff ] ^ sbox2[ (c >> 16) & 0xff ]
        ^ sbox3[ (c >> 32) & 0xff ] ^ sbox4[ (c >> 48) & 0xff ]);
  b += (  sbox4[ (c >>  8) & 0xff ] ^ sbox3[ (c >> 24) & 0xff ]
        ^ sbox2[ (c >> 40) & 0xff ] ^ sbox1[ (c >> 56) & 0xff ]);
  b *= mul;

  *ra = a;
  *rb = b;
  *rc = c;
}

static void pass(uint64_t * ra, uint64_t * rb, uint64_t * rc, uint64_t * x, uint64_t mul) {
 tiger_round(ra, rb, rc, x[0], mul);
 tiger_round(rb, rc, ra, x[1], mul);
 tiger_round(rc, ra, rb, x[2], mul);
 tiger_round(ra, rb, rc, x[3], mul);
 tiger_round(rb, rc, ra, x[4], mul);
 tiger_round(rc, ra, rb, x[5], mul);
 tiger_round(ra, rb, rc, x[6], mul);
 tiger_round(rb, rc, ra, x[7], mul);
}

static void key_schedule(uint64_t * x) {
 x[0] -= x[7] ^ 0xa5a5a5a5a5a5a5a5LL;
 x[1] ^= x[0];
 x[2] += x[1];
 x[3] -= x[2] ^ ((~x[1]) << 19 );
 x[4] ^= x[3];
 x[5] += x[4];
 x[6] -= x[5] ^ ((~x[4]) >> 23 );
 x[7] ^= x[6];
 x[0] += x[7];
 x[1] -= x[0] ^ ((~x[7]) << 19 );
 x[2] ^= x[1];
 x[3] += x[2];
 x[4] -= x[3] ^ ((~x[2]) >> 23 );
 x[5] ^= x[4];
 x[6] += x[5];
 x[7] -= x[6] ^ 0x0123456789abcdefLL;
}

int roar_hash_tiger_proc_block(struct roar_hash_tiger * state, void * block) {
#if BYTE_ORDER == BIG_ENDIAN && !defined(ROAR_TARGET_WIN32)
 uint64_t * block64 = block;
#endif
 uint64_t a, b, c, aa, bb, cc;
 uint64_t x[8];

 ROAR_DBG("roar_hash_tiger_proc_block(state=%p, block=%p) = ?", state, block);

 if ( state == NULL || block == NULL )
  return -1;

#if BYTE_ORDER == BIG_ENDIAN && !defined(ROAR_TARGET_WIN32)
#define MKWORD(d,n) \
                (  ((uint64_t)(d)[8*(n)+7]) << 56 | ((uint64_t)(d)[8*(n)+6]) << 48  \
                 | ((uint64_t)(d)[8*(n)+5]) << 40 | ((uint64_t)(d)[8*(n)+4]) << 32  \
                 | ((uint64_t)(d)[8*(n)+3]) << 24 | ((uint64_t)(d)[8*(n)+2]) << 16  \
                 | ((uint64_t)(d)[8*(n)+1]) << 8  | ((uint64_t)(d)[8*(n)  ])       )
  x[0] = MKWORD(block64, 0);
  x[1] = MKWORD(block64, 1);
  x[2] = MKWORD(block64, 2);
  x[3] = MKWORD(block64, 3);
  x[4] = MKWORD(block64, 4);
  x[5] = MKWORD(block64, 5);
  x[6] = MKWORD(block64, 6);
  x[7] = MKWORD(block64, 7);
#undef MKWORD
#elif BYTE_ORDER == LITTLE_ENDIAN
  memcpy(x, block, 64);
#else
  ROAR_ERR("roar_hash_tiger_proc_block(state=%p, block=%p): Tiger not implemented for non little or big endian systems!", state, block);
  return -1;
#endif

 // save_abc
 aa = a = state->a;
 bb = b = state->b;
 cc = c = state->c;

 // main calcs:
 pass(&a, &b, &c, x, 5);
 key_schedule(x);
 pass(&c, &a, &b, x, 7);
 key_schedule(x);
 pass(&b, &c, &a, x, 9);

 // feedforward
 state->a = a ^ aa;
 state->b = b - bb;
 state->c = c + cc;

 state->blocks++;

 ROAR_DBG("roar_hash_tiger_proc_block(state=%p, block=%p) = 0", state, block);
 return 0;
}

ssize_t roar_hash_tiger_blocklen(struct roar_hash_tiger * state) {
 return BLOCK_LEN;
}

int roar_hash_tiger_proc(struct roar_hash_tiger * state, void * data, size_t len) {
 size_t needlen;

 ROAR_DBG("roar_hash_tiger_proc(state=%p, data=%p, len=%llu) = ?", state, data, (long long unsigned int)len);

 if ( state == NULL )
  return -1;

 if ( len == 0 )
  return 0;

 if ( data == NULL )
  return -1;

 if ( state->inlen ) {
  needlen = BLOCK_LEN - state->inlen;
  ROAR_DBG("roar_hash_tiger_proc(state=%p, ...): adding %llu byte to inbuf block", state, (long long unsigned int)needlen);

  if ( len < needlen ) {
   ROAR_DBG("roar_hash_tiger_proc(state=%p, ...): inbufblock is short", state);
   memcpy(state->inbuf + state->inlen, data, len);
   state->inlen += len;
   ROAR_DBG("roar_hash_tiger_proc(state=%p, ...) = 0", state);
   return 0;
  }

  memcpy(state->inbuf + state->inlen, data, needlen);
  len  -= needlen;
  data += needlen;

  state->inlen = 0;

  if ( roar_hash_tiger_proc_block(state, state->inbuf) == -1 )
   return -1;
 }

 for (; len >= BLOCK_LEN; ) {
  ROAR_DBG("roar_hash_tiger_proc(state=%p, ...): running normal block...", state);

  if ( roar_hash_tiger_proc_block(state, data) == -1 )
   return -1;

  len  -= BLOCK_LEN;
  data += BLOCK_LEN;
 }

 if ( len ) {
  ROAR_DBG("roar_hash_tiger_proc(state=%p, ...): adding %llu byte to new inbuf", state, (long long unsigned int)len);
  memcpy(state->inbuf, data, len);
  state->inlen = len;
 }

 ROAR_DBG("roar_hash_tiger_proc(state=%p, ...) = 0", state);
 return 0;
}

//ll
