//caps.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2011
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "roard.h"

static uint32_t _g_caps_standards[] = {
 // message formats:
 ROAR_STD_MAKE(ROAR_STDV_ROARAUDIO,  0, 0), // v. 0

 // command sets:
 ROAR_STD_MAKE(ROAR_STDV_ROARAUDIO,  4, 0), // basic commands

 // well known numbers:
 ROAR_STD_MAKE(ROAR_STDV_ROARAUDIO, 12, 0), // codecs

 // transports:
#ifdef ROAR_HAVE_UNIX
 ROAR_STD_MAKE(ROAR_STDV_ROARAUDIO, 23, 0), // UNIX
#endif
#ifdef ROAR_HAVE_LIBDNET
 ROAR_STD_MAKE(ROAR_STDV_ROARAUDIO, 24, 0), // DECnet
#endif
#ifdef ROAR_HAVE_IPV4
 ROAR_STD_MAKE(ROAR_STDV_ROARAUDIO, 25, 0), // TCP
#endif

 0xFFFFFFFF // terminater
};

struct roar_stds g_caps_stds = {
 .stds_len = (sizeof(_g_caps_standards)/sizeof(*_g_caps_standards)) - 1,
 .stds     = _g_caps_standards
};

char * stds_string (void) {
 size_t len = g_caps_stds.stds_len * 14;
 char * ret = roar_mm_malloc(len);
 size_t off = 0;
 size_t i;
 int snpret;
 uint32_t cap;
 int version;

 if ( ret == NULL )
  return NULL;

 for (i = 0; i < g_caps_stds.stds_len; i++) {
  cap = g_caps_stds.stds[i];
  version = ROAR_STD_VERSION(cap);
  if ( version == 0 ) {
   snpret = snprintf(ret+off, len-off, "%i-%i,", ROAR_STD_VENDOR(cap), ROAR_STD_STD(cap));
  } else {
   snpret = snprintf(ret+off, len-off, "%i-%i-%i,", ROAR_STD_VENDOR(cap), ROAR_STD_STD(cap), version);
  }
  if ( snpret > 0 ) {
   off += snpret;
  } else {
   roar_mm_free(ret);
   return NULL;
  }
 }

 ret[off-1] = 0;

 return ret;
}

//ll
