//rat.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2013
 *
 *  This file is part of rat a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 */

#include "rat.h"
#include <string.h>

struct rat_testgroup {
 unsigned int ok, fail;
};

struct rat_tests {
 struct rat_testgroup all, subtests, cur_subtests;
 unsigned int testsc, subtestsc;
};

static struct rat_tests inst;

void rat_init(const char * name, const char * desc) {
 memset(&inst, 0, sizeof(inst));

 printf("---[ %s ]---\n", name);
 printf("Description: %s\n", desc);
 printf("\n");
}

int  rat_fin(void) {

 printf("\n");
 printf("Summery:\n");
 printf("%u of %u tests ok, %u tests failed.\n", inst.all.ok, inst.testsc, inst.all.fail);

 return inst.all.fail;
}

void rat_test(const char * title, int res) {
 printf("Test %-32s: %s\n", title, res ? "ok" : "failed");

 inst.testsc++;

 if ( res ) {
  inst.all.ok++;
 } else {
  inst.all.fail++;
 }
}

void rat_test_zero(const char * title, int res) {
 rat_test(title, res == 0);
}

void rat_test_with_subtests(const char * title) {
 memset(&(inst.cur_subtests), 0, sizeof(inst.cur_subtests));
 printf("Test %-32s: ", title);
 fflush(stdout);
}

void rat_subtests_fin(void) {
 printf("   %u ok, %u failed.\n", inst.cur_subtests.ok, inst.cur_subtests.fail);
 inst.subtests.ok   += inst.cur_subtests.ok;
 inst.subtests.fail += inst.cur_subtests.fail;

 inst.testsc++;

 if ( inst.cur_subtests.fail ) {
  inst.all.fail++;
 } else {
  inst.all.ok++;
 }
}

void rat_subtest(int res) {
 inst.subtestsc++;

 if ( res ) {
  printf(".");
  inst.cur_subtests.ok++;
 } else {
  printf("e");
  inst.cur_subtests.fail++;
 }
 fflush(stdout);
}

void rat_subtest_crit(int res) {
 inst.subtestsc++;

 if ( res ) {
  printf(".");
  inst.cur_subtests.ok++;
 } else {
  printf("E");
  inst.cur_subtests.fail++;
 }
 fflush(stdout);
}

//ll
