//ff_rpld.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "rpld.h"

static char *_strtok(char *str, const char *delim) {
 static char * next = NULL;

 if ( str == NULL )
  str = next;

 if ( str == NULL )
  return NULL;

 next = strstr(str, delim);

 if ( next != NULL ) {
  *next = 0;
   next++;
 }

 return str;
}

int ff_rpld_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl) {
 struct rpld_playlist_entry * plent = rpld_pl_get_first(pl);
#ifdef HAVE_LIB_UUID
 char uuid[37];
#endif

 (void)handle;

#ifdef HAVE_LIB_UUID
 uuid_unparse(plent->uuid, uuid);
#endif

 while ( plent != NULL ) {
  roar_vio_printf(vio,
#ifdef HAVE_LIB_UUID
                  "%s=%s=%s=%s=%s=%s=%s=%s=long:0x%.16LX/short:0x%.8X/uuid:%s=0x%.8x/%i=%s(0x%x)=%f\n",
#else
                  "%s=%s=%s=%s=%s=%s=%s=%s=long:0x%.16LX/short:0x%.8X=0x%.8x/%i=%s(0x%x)=%f\n",
#endif
                        roar_codec2str(plent->codec),
                        rpld_ple_time_hr(plent),
                        plent->meta.album,
                        plent->meta.title,
                        plent->meta.artist,
                        plent->meta.performer,
                        plent->meta.version,
                        plent->io.filename,
                        plent->global_tracknum,
                        plent->global_short_tracknum,
#ifdef HAVE_LIB_UUID
                        uuid,
#endif
                        plent->meta.discid,
                        plent->meta.tracknum,
                        roar_meta_strgenre(plent->meta.genre),
                        plent->meta.genre,
                        (double)plent->likeness
         );
  plent = plent->list.next;
 }

 return 0;
}

int ff_rpld_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl) {
 struct rpld_playlist_entry * plent_new;
 char buf[1024];
 char * s, * curtok;
 size_t len;

 (void)handle;

 while ((s = roar_vio_fgets(vio, buf, 1024)) != NULL ) {
  len = strlen(s);

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  for (s += len - 1; *s == '\r' || *s == '\n'; s--)
   *s = 0;

  if ( !*buf )
   continue;

  if ( (plent_new = rpld_ple_new()) == NULL )
   return -1;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // TYPE aka CODEC:
  if ( (curtok = _strtok(buf, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }

  plent_new->codec = roar_str2codec(curtok);

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // LENGTH, we ignore this
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }

  if ( strstr(curtok, ":") == NULL ) {
   // parse SS
   plent_new->length = atol(curtok);
  } else {
   // parse HH:MM:SS
   rpld_ple_set_time_hr(plent_new, curtok);
  }

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // ALBUM
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }
  strncpy(plent_new->meta.album, curtok, RPLD_MAX_PLF_LEN);
  plent_new->meta.album[RPLD_MAX_PLF_LEN-1] = 0;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // TITLE
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }
  strncpy(plent_new->meta.title, curtok, RPLD_MAX_PLF_LEN);
  plent_new->meta.title[RPLD_MAX_PLF_LEN-1] = 0;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // ARTIST
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }
  strncpy(plent_new->meta.artist, curtok, RPLD_MAX_PLF_LEN);
  plent_new->meta.artist[RPLD_MAX_PLF_LEN-1] = 0;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // PERFORMER
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }
  strncpy(plent_new->meta.performer, curtok, RPLD_MAX_PLF_LEN);
  plent_new->meta.performer[RPLD_MAX_PLF_LEN-1] = 0;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // VERSION
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }
  strncpy(plent_new->meta.version, curtok, RPLD_MAX_PLF_LEN);
  plent_new->meta.version[RPLD_MAX_PLF_LEN-1] = 0;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  // FILE
  if ( (curtok = _strtok(NULL, "=")) == NULL ) {
   rpld_ple_free(plent_new);
   return -1;
  }
  strncpy(plent_new->io.filename, curtok, RPLD_MAX_PLF_LEN);
  plent_new->io.filename[RPLD_MAX_PLF_LEN-1] = 0;

  ROAR_DBG("ff_rpld_pl_import(*) = ?");

  rpld_pl_push(pl, plent_new);
 }

 return 0;
}

//ll
