//proto_simple_vio.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_PROTO_SIMPLE_VIO_H_
#define _RPLD_PROTO_SIMPLE_VIO_H_

#define RPLD_PROTO_SIMPLE_VIO_BUFSIZE   1024

struct rpld_proto_simple_inst {
 struct roar_buffer * iobuffer;
 int input_dots;
 int output_dots;
 struct roar_vio_calls * vio;
};

int     rpld_proto_simple_vio_open    (struct roar_vio_calls * vio, struct roar_vio_calls * dst);
int     rpld_proto_simple_vio_close   (struct roar_vio_calls * vio);

ssize_t rpld_proto_simple_vio_read    (struct roar_vio_calls * vio, void *buf, size_t count);
ssize_t rpld_proto_simple_vio_write   (struct roar_vio_calls * vio, void *buf, size_t count);
//off_t   rpld_proto_simple_vio_lseek   (struct roar_vio_calls * vio, off_t offset, int whence);
//int     rpld_proto_simple_vio_nonblock(struct roar_vio_calls * vio, int state);
int     rpld_proto_simple_vio_sync    (struct roar_vio_calls * vio);
//int     rpld_proto_simple_vio_ctl     (struct roar_vio_calls * vio, int cmd, void * data);

#endif

//ll
