/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Character.h - Character class
 * Created by Robert Heller on Tue Jul 14 11:33:12 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Character.h,v $
 * Revision 1.3  1999/07/13 00:29:40  heller
 * Documentation updates (spelling, punctionation, spelling, caps/nocaps).
 *
 * Revision 1.2  1998/12/27 21:48:19  heller
 * Spelling errors fixed.
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _CHARACTER_H_
#define _CHARACTER_H_

#include <Record.h>

/*@ManDoc:
  \typeout{Generated by $Id: Character.h,v 1.3 1999/07/13 00:29:40 heller Rel1 $.}

  Basic character class.  Contains all of the information needed to describe
  a player or non-player character.
 */

class Character {
private:
	//@ManDoc: Character name.
	const char *name;
	//@ManDoc: Player name.
	const char *player;
	//@ManDoc: Character race.
	const char *race;
	//@ManDoc: Character class.
	const char *chclass;
	//@ManDoc: Character alignment.
	const char *alignment;
	//@ManDoc: Character sex.
	const char *sex;
	//@ManDoc: Additional comments.
	const char *comments;
	//@ManDoc: Character's image (GIF file).
	const char *image;
	//@ManDoc: Character hit points.
	int hitpoints;
	//@ManDoc: Character age.
	int age; 
	//@ManDoc: Character strength.
	int strength; 
	//@ManDoc: Character intelligence.
	int intelligence; 
	//@ManDoc: Character wisdom.
	int wisdom; 
	//@ManDoc: Character dexterity.
	int dexterity;
	//@ManDoc: Character constitution.
	int constitution; 
	//@ManDoc: Character charisma.
	int charisma; 
	//@ManDoc: Character exceptional strength.
	int exceptional_strength; 
	//@ManDoc: Character level.
	int level;
	//@ManDoc: Experience points.
	int experience_points;
	//@ManDoc: Gold pieces.
	int gold;
	//@ManDoc: Character hit die.
	int hdie;
	//@ManDoc: Character number of hit dice.
	int ndie;
	//@ManDoc: Character maximum number of hit dice.
	int maxdie;
	//@ManDoc: Data record.
	Record rawData;
	//@ManDoc: Internal initializer function.
	void _Character(int s, int i, int w, int d, int c, int ch,
			int es, int l, int hd, int nd, int md,
			const char * n, const char * p, const char * r, 
			const char * chc, const char * align, 
			const char * sex, int ag,const char * com,
			const char * im);
	//@ManDoc: Convert internal record to character.
	void RecordToCharacter ();
	//@ManDoc: Update internal record.
	void UpdateRecord();
public:
	//@ManDoc: Base constructor.
	Character() {//    s i w d c ch es l hd nd md
		_Character(0,0,0,0,0, 0, 0,1, 6, 1, 1,
		//	    n  p  r       chc
			    "","","Human","npc",
		//          align,sex,ag,com
			    "",   "",  0,"","");
		}
	//@ManDoc: Fighter character constructor (extra strength parameter).
	Character(
		//@ManDoc: Basic strength.
		int s,
		//@ManDoc: Intelligence.
		int i,
		//@ManDoc: Wisdom.
		int w,
		//@ManDoc: Dexterity.
		int d,
		//@ManDoc: Constitution.
		int c,
		//@ManDoc: Charisma.
		int ch,
		//@ManDoc: Extra strength.
		int es = 0,
		//@ManDoc: Level.
		int l = 1,
		//@ManDoc: Hit die.
		int hd = 6,
		//@ManDoc: Number of hit dice.
		int nd = 1,
		//@ManDoc: Maximum number of hit dice.
		int md = 1,
		//@ManDoc: Character's name.
		const char *n = "",
		//@ManDoc: Player's name.
		const char *p = "",
		//@ManDoc: Character's race.
		const char *r = "Human",
		//@ManDoc: Character's class.
		const char *chc = "npc",
		//@ManDoc: Character's alignment.
		const char *align = "",
		//@ManDoc: Character's sex.
		const char *sex = "",
		//@ManDoc: Character's age.
		int ag = 0,
		//@ManDoc: Commentary.
		const char *com = "",
		//@ManDoc: Image.
		const char *im = ""
	) {		// s i w d c ch es l hd nd md
		_Character(s,i,w,d,c,ch,es,l,hd,nd,md,
		//	    n p r chc align,sex,ag,com im
			    n,p,r,chc,align,sex,ag,com,im);
	}
	//@ManDoc: Non Fighter character constructor (no extra strength parameter).
	Character(
		//@ManDoc: Basic strength.
		int s,
		//@ManDoc: Intelligence.
		int i,
		//@ManDoc: Wisdom.
		int w,
		//@ManDoc: Dexterity.
		int d,
		//@ManDoc: Constitution.
		int c,
		//@ManDoc: Charisma.
		int ch,
		//@ManDoc: Level.
		int l = 1,
		//@ManDoc: Hit die.
		int hd = 6,
		//@ManDoc: Number of hit dice.
		int nd = 1,
		//@ManDoc: Maximum number of hit dice.
		int md = 1,
		//@ManDoc: Character's name.
		const char *n = "",
		//@ManDoc: Player's name.
		const char *p = "",
		//@ManDoc: Character's race.
		const char *r = "Human",
		//@ManDoc: Character's class.
		const char *chc = "npc",
		//@ManDoc: Character's alignment.
		const char *align = "",
		//@ManDoc: Character's sex.
		const char *sex = "",
		//@ManDoc: Character's age.
		int ag = 0,
		//@ManDoc: Commentary.
		const char *com = "",
		//@ManDoc: Image.
		const char *im = ""
	) {		// s i w d c ch es l hd nd md
		_Character(s,i,w,d,c,ch, 0,l,hd,nd,md,
		//	    n p r chc align,sex,ag,com im
			    n,p,r,chc,align,sex,ag,com,im);
	}
	//@ManDoc: Copy constructor (from pointer).
	Character (const Character *that);
	//@ManDoc: Copy constructor (from reference).
	Character (const Character &that);
	//@ManDoc: Type conversion constructor, from a Record.
	Character (const Record *rec);
	//@ManDoc: Destructor.
	~Character() {};
	//@ManDoc: Type conversion: convert to a Record.
	operator const Record  () const {return rawData;}
	//@ManDoc: Return hit points.
	int HitPoints() const {return (int)hitpoints;}
	//@ManDoc: Return age.
	int Age() const {return (int)age;}
	//@ManDoc: Return strength.
	int Strength() const {return (int) strength;}
	//@ManDoc: Return intelligence.
	int Intelligence() const {return (int) intelligence;}
	//@ManDoc: Return wisdom.
	int Wisdom() const {return (int) wisdom;}
	//@ManDoc: Return dexterity.
	int Dexterity() const {return (int) dexterity;}
	//@ManDoc: Return constitution.
	int Constitution() const {return (int) constitution;}
	//@ManDoc: Return charisma.
	int Charisma() const {return (int) charisma;}
	//@ManDoc: Return exceptional strength.
	int ExceptionalStrength() const {return (int) exceptional_strength;}
	//@ManDoc: Return level.
	int Level() const {return (int) level;}
	//@ManDoc: Return experience points.
	int ExperiencePoints () const {return (int) experience_points;}
	//@ManDoc: Return gold.
	int Gold () const {return (int) gold;}
	//@ManDoc: Return name.
	const char *Name() const {return name;}
	//@ManDoc: Return player.
	const char *Player() const {return player;}
	//@ManDoc: Return race.
	const char *Race() const {return race;}
	//@ManDoc: Return character class.
	const char *CharacterClass() const {return chclass;}
	//@ManDoc: Return alignment.
	const char *Alignment() const {return alignment;}
	//@ManDoc: Return sex.
	const char *Sex() const {return sex;}
	//@ManDoc: Return Comments.
	const char *Comments() const {return comments;}
	//@ManDoc: Return image.
	const char *Image() const {return image;}
	//@ManDoc: Set age.
	int SetAge(int newage);
	//@ManDoc: Set strength.
	int SetStrength(int newS);
	//@ManDoc: Set intelligence.
	int SetIntelligence(int newI);
	//@ManDoc: Set wisdom.
	int SetWisdom(int newW);
	//@ManDoc: Set dexterity.
	int SetDexterity(int newD);
	//@ManDoc: Set constitution.
	int SetConstitution(int newC);
	//@ManDoc: Set charisma.
	int SetCharisma(int newCh);
	//@ManDoc: Set exceptional strength.
	int SetExceptionalStrength(int newES);
	//@ManDoc: Set experience points.
	int SetExperiencePoints(int newEP);
	//@ManDoc: Set gold.
	int SetGold(int newGP);
	//@ManDoc: Set name.
	const char *SetName(const char * newN);
	//@ManDoc: Set player.
	const char *SetPlayer(const char * newP);
	//@ManDoc: Set race.
	const char *SetRace(const char *newR);
	//@ManDoc: Set character class.
	const char *SetCharacterClass(const char *newCh);
	//@ManDoc: Set alignment.
	const char *SetAlignment(const char *newA);
	//@ManDoc: Set sex.
	const char *SetSex(const char *newS);
	//@ManDoc: Set comments.
	const char *SetComments(const char *newC);
	//@ManDoc: Set image.
	const char *SetImage(const char *newI);
	//@ManDoc: Advance character's level.
	void AdvanceLevel();
	//@ManDoc: Update character from Record.
	void UpdateFromRecord (const Record &rec)
	{
		rawData = rec;
		RecordToCharacter ();
	}
};
	
#endif // _CHARACTER_H_

