/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Dice.cc - Dice Class
 * Created by Robert Heller on Tue Jul 14 17:22:23 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Dice.cc,v $
 * Revision 1.2  1998/12/30 01:04:49  heller
 * Add comments to the code.
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <Dice.h>
#include <time.h>
#include <math.h>

static char rcsid[] = "$Id: Dice.cc,v 1.2 1998/12/30 01:04:49 heller Rel1 $";




int RandomInteger::rmarin(int ij, int kl)
{
        float s, t;
        int i, j, k, l, m;
        int ii, jj;

        if ( ( ij < 0 || ij > 31328 ) ||
                ( kl < 0 || kl > 30081 ) )
        {
#ifdef PRINTF
                printf ("RMARIN: The first random number seed must have a "
                        "value between 0 and 31328\n");
                printf ("        The second random number seed must have a "
                        "value between 0 and 30081");
#endif
                return 1;
        }

        i = (int)fmod(ij/177.0, 177.0) + 2;
        j = (int)fmod(ij      , 177.0) + 2;
        k = (int)fmod(kl/169.0, 178.0) + 1;
        l = (int)fmod(kl      , 169.0);

        for ( ii=0; ii<=96; ii++ )
        {
                s = (float)0.0;
                t = (float)0.5;
                for ( jj=0; jj<=23; jj++ )
                {
                        m = (int)fmod( fmod(i*j,179.0)*k , 179.0 );
                        i = j;
                        j = k;
                        k = m;
                        l = (int)fmod( 53.0*l+1.0 , 169.0 );
                        if ( fmod(l*m,64.0) >= 32)
                                s = s + t;
                        t = (float)(0.5 * t);
                }
                u[ii] = s;
        }

        c  = (float)(  362436.0 / 16777216.0);
        cd = (float)( 7654321.0 / 16777216.0);
        cm = (float)(16777213.0 / 16777216.0);

        i97 = 96;
        j97 = 32;

        test = true;

        return 0;
}

int RandomInteger::ranmar(float rvec[], int len)
{
        float uni;
        int ivec;

        if ( !test )
        {

#ifdef PRINTF
                printf ("RANMAR: Call the initialization routine (RMARIN) "
                        "before calling RANMAR.\n");
#endif
                return 1;
        }

        for ( ivec=0; ivec < len; ivec++)
        {
                uni = u[i97] - u[j97];
                if ( uni < 0.0F )
                        uni = uni + 1.0;
                u[i97] = uni;
                i97--;
                if ( i97 < 0 )
                        i97 = 96;
                j97--;
                if ( j97 < 0 )
                        j97 = 96;
                c = c - cd;
                if ( c < 0.0F )
                        c = c + cm;
                uni = uni - c;
                if ( uni < 0.0F )
                        uni = uni + 1.0;
                rvec[ivec] = uni;
        }
        return 0;
}
/*
 I use the following procedure in TC to generate seeds:

  The sow() procedure calculates two seeds for use with the random number
  generator from the system clock.  I decided how to do this myself, and
  I am sure that there must be better ways to select seeds; hopefully,
  however, this is good enough.  The first seed is calculated from the values
  for second, minute, hour, and year-day; weighted with the second most
  significant and year-day least significant.  The second seed weights the
  values in reverse.
*/
void RandomInteger::_seed()
{
        struct tm *tm_now;
        float s_sig, s_insig, maxs_sig, maxs_insig;
        time_t secs_now;
        int s, m, h, d, s1, s2;

        time(&secs_now);
        tm_now = localtime(&secs_now);

        s = tm_now->tm_sec + 1;
        m = tm_now->tm_min + 1;
        h = tm_now->tm_hour + 1;
        d = tm_now->tm_yday + 1;

        maxs_sig   = (float)(60.0 + 60.0/60.0 + 24.0/60.0/60.0 +
              366.0/24.0/60.0/60.0);
        maxs_insig = (float)(60.0 + 60.0*60.0 + 24.0*60.0*60.0 +
              366.0*24.0*60.0*60.0);

        s_sig      = (float)(s + m/60.0 + h/60.0/60.0 + d/24.0/60.0/60.0);
        s_insig    = (float)(s + m*60.0 + h*60.0*60.0 + d*24.0*60.0*60.0);

        s1 = (int)(s_sig   / maxs_sig   * 31328.0);
        s2 = (int)(s_insig / maxs_insig * 30081.0);

	rmarin(s1,s2);
}

/*
 * Initialize a dice instance.  Create a RandomInteger instance that implements
 * a single die of the proper type.  Called from the constructors.
 */

void Dice::_Dice()
{
	if (nsides == 0)
	{
		dice = new RandomInteger(0,99);
	} else
	{
		dice = new RandomInteger(1,nsides);
	}
}

/*
 * Destructor: delete the RandomInteger instance created at contruction time
 */
 
Dice::~Dice()
{
	delete dice;
}

/*
 * Roll the dice.  Roll the single die repeatedly upto ndice times, taking
 * the sum.  Return this value.
 */
 
unsigned int Dice::Roll()
{
	unsigned int iRoll;
	iRoll = 0;
	for (unsigned int i = 0;i < ndice; i++) iRoll += (*dice)();
	return iRoll;
}
