#include "../module_tree.h"
#include "enumentry.h"

static void selectionDone(GtkMenuShell* widget, EnumEntry* data)
{
        data->changed();
}

EnumEntry::EnumEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        optionMenu = gtk_option_menu_new();
        menu = gtk_menu_new();
        gtk_signal_connect(GTK_OBJECT(menu), "selection-done", GTK_SIGNAL_FUNC(selectionDone), this);

        try {
                string enumVarName = "enum_" + varName;        
                const DataSetMap* mi;
                Path m = mod;
                do {
                        mi = ModuleTree::instance()->module_info(m);
                        m.remove_last();
                } while (!mi->validIndex(enumVarName) && m.length() > 0);

                const DataSetMap& mInf = *mi;

                if (mInf.validIndex(enumVarName)) {                
                        const DataSet& enum_variables = mInf[enumVarName];
                        for (int j = 0; j < enum_variables.count(); j++) {
                                string name = enum_variables.getString(j);
                        
                                names.push_back(name);
                        
                                GtkWidget* menuItem = gtk_menu_item_new_with_label(const_cast<gchar *> (name.c_str()));
                                gtk_object_set_user_data(GTK_OBJECT(menuItem), reinterpret_cast<void *> (names.size() - 1));
                                gtk_menu_append(GTK_MENU(menu), menuItem);
                        }
                
                        gtk_option_menu_set_menu(GTK_OPTION_MENU(optionMenu), menu);
                        gtk_box_pack_start(GTK_BOX(hbox), optionMenu, true, true, 40);
                
                        reload();
                }
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}
        
DataSet EnumEntry::getValue()
{
        GtkWidget* active = gtk_menu_get_active(GTK_MENU(menu));
        int index = int(gtk_object_get_user_data(GTK_OBJECT(active)));
        string newValue = names[index];
        return DataSet(newValue);
}

void EnumEntry::setValue(const DataSet& value)
{
        if (value.count() > 0) {
                for (unsigned int i = 0; i < names.size(); i++) {
                        if (names[i] == value.getString()) {
                                gtk_option_menu_set_history(GTK_OPTION_MENU(optionMenu), i);
                        }
                }
        }
}
