/* xmms (http://xmms.org/) used as a reference when writing this code */

#include "../common.h"
#include "configuration.h"
#include "module_tree_display.h"
#include "../module_registry.h"

static void newClicked(GtkButton* widget, ModuleTreeDisplay* data)
{
        data->newModule();
}

static void delClicked(GtkButton* widget, ModuleTreeDisplay* data)
{
        data->delModule();
}

static void activate_cb(GtkMenuItem *menuitem, ModuleTreeDisplay *data)
{
        data->module_type_selected();
}

ModuleTreeDisplay::ModuleTreeDisplay(Configuration& parent_)
        : parent(parent_)
{
        vbox = gtk_vbox_new(false, 0);

        /* new module type selector */
        GtkWidget* hbox = gtk_hbox_new(false, 0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox, false, false, 0);
        GtkWidget* optionMenu = gtk_option_menu_new();
        menu = gtk_menu_new();

        int num_mods = ModuleRegistry::instance()->module_count();
        for (int i = 0; i < num_mods; i++) {
                const string& mname = ModuleRegistry::instance()->module_name(i);
                if (mname != "Root-Portal") {
                        GtkWidget* menuItem = gtk_menu_item_new_with_label(const_cast<gchar*> (mname.c_str()));
                        gtk_object_set_user_data(GTK_OBJECT(menuItem), reinterpret_cast<void *> (i));
                        gtk_signal_connect(GTK_OBJECT(menuItem), "activate", GTK_SIGNAL_FUNC(activate_cb), this);
                        gtk_menu_append(GTK_MENU(menu), menuItem);
                }
        }
        
        gtk_option_menu_set_menu(GTK_OPTION_MENU(optionMenu), menu);

        gtk_box_pack_start_defaults(GTK_BOX(hbox), optionMenu);
        gtk_widget_show(optionMenu);

        /* new module and delete module buttons */
        hbox = gtk_hbox_new(false, 0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox, false, false, 0);
        
        GtkWidget* newButton = gtk_button_new_with_label("New");
        gtk_signal_connect(GTK_OBJECT(newButton), "clicked", GTK_SIGNAL_FUNC(newClicked), this);
        gtk_box_pack_start(GTK_BOX(hbox), newButton, false, false, 2);

        GtkWidget* delButton = gtk_button_new_with_label("Delete");
        gtk_signal_connect(GTK_OBJECT(delButton), "clicked", GTK_SIGNAL_FUNC(delClicked), this);
        gtk_box_pack_start(GTK_BOX(hbox), delButton, false, false, 2);
       
        /* existing module tree */
        GtkWidget* scrollWin = gtk_scrolled_window_new(0, 0);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollWin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
        gtk_box_pack_start_defaults(GTK_BOX(vbox), scrollWin);
        gtk_widget_show(scrollWin);

//          tree = gtk_ctree_new(1, 0);
//          gtk_ctree_set_line_style(GTK_CTREE(tree), GTK_CTREE_LINES_DOTTED);
//          gtk_signal_connect(GTK_OBJECT(tree), "tree-select-row", GTK_SIGNAL_FUNC(rowSelect_), this);
//          gtk_clist_set_column_auto_resize(GTK_CLIST(tree), 0, true);
        gtk_container_add(GTK_CONTAINER(scrollWin), tree.get_widget());
        tree.add_listener(this);
}

ModuleTreeDisplay::~ModuleTreeDisplay()
{
}

//  void ModuleTreeDisplay::renumber()
//  {
//          Path *npath = new Path();
//          gtk_ctree_post_recursive_to_depth(GTK_CTREE(tree), rootNode, 2, &renumber_func, npath);
//          delete npath;
//  }

//  void ModuleTreeDisplay::tree_visit(GtkCTreeNode *node)
//  {
//          if (gtk_ctree_is_ancestor(GTK_CTREE(tree), last_visited, node))
//                  cout << "next level" << endl;
//          cout << "---" << endl;
//          last_visited = node;
//  }

void ModuleTreeDisplay::setNewModuleType(const string& modTypeName)
{
        newModTypeName = modTypeName;
}

void ModuleTreeDisplay::newModule()
{
        try {
                int mod_num = int(gtk_object_get_user_data(GTK_OBJECT(gtk_menu_get_active(GTK_MENU(menu)))));
                const string& typeName = ModuleRegistry::instance()->module_name(mod_num);
                ModuleTree::instance()->create_child(mod, typeName);
                Path child = mod;
                child.add_last(ModuleTree::instance()->child_count(mod) - 1);
                ModuleTree::instance()->overlay_defaults(child);
                ModuleTree::instance()->post_startup(child);
                expandNode(child);
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }                
}

void ModuleTreeDisplay::delModule()
{
        if (mod.length() >= 1) { // don't want people to delete the root node
                try {
                        Path parent = tree.currently_selected();
                        parent.remove_last();
                        ModuleTree::instance()->delete_child(parent, tree.currently_selected().last());
                        rpdbgmsg("deleting " << mod.to_string());
                        tree.delete_by_path(mod);
                } catch (ModuleError ex) {
                        cerr << "Module exception: " << ex.description << endl;
                }
        } else {
                rpdbgmsg("refusing to delete root node");
        }
}

void ModuleTreeDisplay::load()
{
        tree.clear();
        expandNode(Path());
        tree.expand_all();
        tree.show_all();
}

void ModuleTreeDisplay::expandNode(const Path& moduleNode)
{
        try {
                string mname = ModuleTree::instance()->get_type(moduleNode);
                tree.set_path_name(moduleNode, mname);
                int num_children = ModuleTree::instance()->child_count(moduleNode);
                for (int i = 0; i < num_children; i++) {
                        Path p = moduleNode;
                        p.add_last(i);
                expandNode(p);
                }
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

void ModuleTreeDisplay::node_selected(const Path& path)
{
        mod = path;
        parent.moduleFocus(mod);
}

void ModuleTreeDisplay::module_type_selected()
{
                int mod_num = int(gtk_object_get_user_data(GTK_OBJECT(gtk_menu_get_active(GTK_MENU(menu)))));
                const string& typeName = ModuleRegistry::instance()->module_name(mod_num);
                const DataSetMap& modInf = ModuleRegistry::instance()->module_info(typeName).module_info();

                parent.set_appbar_string(modInf["description"].toString());
}
