#define PATHED_TREE_CPP
#include "pathed_tree.h"

#include <iostream>
#include <algorithm>
using namespace std;

static void row_selectf(GtkCTree* ctree, GList* node, gint column, PathedTree* data)
{
        data->row_select(node);
}

PathedTreeNode::PathedTreeNode()
        : parent(0),
          node(0)
{
}
PathedTreeNode::PathedTreeNode(const PathedTreeNode *p)
        : parent(p),
          node(0)
{
}

PathedTreeNode::~PathedTreeNode()
{
        for (int i = 0; i < int(children.size()); i++)
                delete children[i];
}

PathedTree::PathedTree()
        : root_node(0)
{
        tree = gtk_ctree_new(1, 0);
        gtk_ctree_set_line_style(GTK_CTREE(tree), GTK_CTREE_LINES_DOTTED);
        gtk_signal_connect(GTK_OBJECT(tree), "tree-select-row", GTK_SIGNAL_FUNC(row_selectf), this);
        gtk_clist_set_column_auto_resize(GTK_CLIST(tree), 0, true);
}

PathedTree::~PathedTree()
{
        if (root_node != 0)
                delete root_node;
}

PathedTreeNode& PathedTreeNode::add_child()
{
        children.push_back(new PathedTreeNode(this));
        return *children[children.size() - 1];
}

void PathedTree::row_select(GList *node)
{
        PathedTreeNode *n = root_node->get_by_widget(GTK_CTREE_NODE(node));
        mod = n->get_path();
        rpdbgmsg("row selected: " << mod.to_string());
        notify_node_selected(mod);
}

void PathedTree::set_path_name(const Path& p, const string& name)
{
        PathedTreeNode *new_node;
        GtkCTreeNode* parent_node = 0;
        if (root_node == 0) {
                root_node = new PathedTreeNode();
                new_node = root_node;
        } else {
                Path np = p;
                np.remove_last();
                PathedTreeNode& tmp = root_node->get_by_path(np);
                assert(tmp.num_children() == p.last());
                new_node = &tmp.add_child();
                parent_node = tmp.get_widget();
                gtk_ctree_expand(GTK_CTREE(tree), parent_node);
        }
                
        gchar* text = const_cast<gchar*> (name.c_str());
        GtkCTreeNode *node = gtk_ctree_insert_node(GTK_CTREE(tree), parent_node, 0,
                                                   &text, 4, 0, 0, 0, 0, false, false);
        new_node->set_widget(node);
        // if this was the root-node that was just created, then we might as well
        // select it
        if (root_node == new_node)
                select(Path());
}

PathedTreeNode& PathedTreeNode::get_by_path(const Path& p)
{
        if (p.length() == 0)
                return *this;
        assert(p.first() < int(children.size()));
        Path np = p;
        np.remove_first();
        return children[p.first()]->get_by_path(np);
}

void PathedTree::delete_by_path(const Path& p)
{
        Path np = p;
        np.remove_last();
        PathedTreeNode &parent = root_node->get_by_path(np);
        PathedTreeNode *node = &root_node->get_by_path(p);
        gtk_ctree_remove_node(GTK_CTREE(tree), node->get_widget());
        parent.remove_child(p.last());
        if (mod == p) {
                if (p.last() > 0)
                        np.add_last(p.last() - 1);
                select(np);
        }
}

PathedTreeNode *PathedTreeNode::get_by_widget(GtkCTreeNode *w)
{
        if (node == w)
                return this;
        for (int i = 0; i < int(children.size()); i++) {
                PathedTreeNode *result = children[i]->get_by_widget(w);
                if (result)
                        return result;
        }
        return 0;
}

void PathedTree::remove_listener(PathedTreeListener *l)
{
        listeners.erase(find(listeners.begin(), listeners.end(), l));
}

void PathedTreeNode::remove_child(int num)
{
        vector<PathedTreeNode *>::iterator t = children.begin();
        t+= num;
        delete *t;
        children.erase(t);
}

void PathedTree::select(const Path& p)
{
        rpdbgmsg("selected " << p.to_string());
        GtkCTreeNode *n = root_node->get_by_path(p).get_widget();
        assert(n != NULL);
        gtk_ctree_select(GTK_CTREE(tree), n);
}

void PathedTree::clear()
{
        if (root_node)
                gtk_ctree_remove_node(GTK_CTREE(tree), root_node->get_widget());
        delete root_node;
        root_node = 0;
}

int PathedTreeNode::child_num(const PathedTreeNode *child) const
{
        for (int i = 0; i < int(children.size()); i++) {
                if (children[i] == child)
                        return i;
        }
        rpfailure();
        return 0;
}

int PathedTreeNode::mynum() const
{
        assert(parent);
        return parent->child_num(this);
}

Path PathedTreeNode::get_path() const
{
        if (parent == 0)
                return Path();
        Path tmp;
        if (parent)
                tmp = parent->get_path();
        
        tmp.add_last(mynum());
        return tmp;
}
