#include "dataset.h"
#include "utils.h"

#include <string>
using namespace std;

/* create from a comma separated string */
DataSet::DataSet(const string& dt)
{
        if (dt != "\\") {
                string param;
                for (string::const_iterator i = dt.begin(); i < dt.end(); ++i) {
                        if ((*i) == '\\') {
                                ++i;
                                if ((*i) == '\\')
                                        param += '\\';
                                else if ((*i) == ',')
                                        param += ',';
                                else
                                        param += '\\' + (*i);
                        } else {
                                if ((*i) == ',') {
                                        storage.push_back(param);
                                        param.erase();
                                } else {
                                        param+= *i;
                                }
                        }
                }
                storage.push_back(param);
        }
}

string DataSet::asString() const
{
        if (count() == 0)
                return "\\";
        
        string result;
        for (vector<Data>::const_iterator i = storage.begin(); i < storage.end(); ++i) {
                string elem = (*i).getString();
                string new_elem;
                for (string::const_iterator j = elem.begin(); j != elem.end(); j++) {
                        if ((*j) == ',')
                                new_elem += "\\,";
                        else if ((*j) == '\\')
                                new_elem += "\\\\";
                        else
                                new_elem += (*j);
                }
                result += "," + new_elem;
        }
        if (result.length() > 0)
                return string(result, 1, result.length()); // cut off the initial ","
        return result;
}

string DataSet::toString() const
{
        string result;
        for (vector<Data>::const_iterator i = storage.begin(); i < storage.end(); ++i) {
                string elem = (*i).getString();
                result += "," + elem;
        }
        if (result.length() > 0)
                return string(result, 1, result.length()); // cut off the initial ","
        return result;
}

void DataSet::addDataSet(const DataSet& other)
{
        for (vector<Data>::const_iterator i = other.storage.begin(); i < other.storage.end(); ++i)
                storage.push_back(*i);
}

void DataSet::noBlanks()
{
        for (int i = 0; i < int(storage.size()); i++) {
                if (storage[i].getString().length() == 0) {
                        removeEntry(i);
                }
        }
}

string Data::getString() const
{
        switch (dtype) {
                case DATA_TYPE_STRING:
                        return *stringData;
                case DATA_TYPE_INT:
                        return int_to_string(intData);
                case DATA_TYPE_BOOL:
                        return boolData ? "false" : "true";
                case DATA_TYPE_DOUBLE:
                        return double_to_string(doubleData);;
                default:
                        INTERNAL_ERROR;
                        throw BadDataType();
        }
}

int Data::getInt() const throw(BadDataType)
{
        switch (dtype) {
                case DATA_TYPE_STRING:
                        return atoi(stringData->c_str());
                case DATA_TYPE_INT:
                        return intData;
                case DATA_TYPE_BOOL:
                        return boolData ? 0 : 1;
                case DATA_TYPE_DOUBLE:
                        return int(doubleData);
                default:
                        INTERNAL_ERROR;
                        throw BadDataType();
        }
}

bool Data::getBool() const throw(BadDataType)
{
        switch (dtype) {
                case DATA_TYPE_STRING:
                        if (*stringData == "0") return false;
                        if (*stringData == "1") return true;
                        if (*stringData == "false") return false;
                        if (*stringData == "true") return true;
                        return false;
                case DATA_TYPE_INT:
                        return intData != 0;
                case DATA_TYPE_BOOL:
                        return boolData;
                case DATA_TYPE_DOUBLE:
                        throw BadDataType();
                default:
                        INTERNAL_ERROR;
                        throw BadDataType();
        }
}

double Data::getDouble() const throw(BadDataType)
{
        switch (dtype) {
                case DATA_TYPE_STRING:
                        return atof(stringData->c_str());
                case DATA_TYPE_INT:
                        return intData;
                case DATA_TYPE_BOOL:
                        throw BadDataType();
                case DATA_TYPE_DOUBLE:
                        return doubleData;
                default:
                        INTERNAL_ERROR;
                        throw BadDataType();
        }
}

Data& Data::operator=(const Data& other)
{
        switch (other.dtype) {
                case DATA_TYPE_STRING:
                        if (dtype == DATA_TYPE_STRING)
                                *stringData = *other.stringData;
                        else
                                stringData = new string(*other.stringData);
                        break;
                case DATA_TYPE_BOOL:
                        boolData = other.boolData;
                        break;
                case DATA_TYPE_INT:
                        intData = other.intData;
                        break;
                case DATA_TYPE_DOUBLE:
                        doubleData = other.doubleData;
                        break;
                default:
                        INTERNAL_ERROR;
                        throw BadDataType();
        }
        dtype = other.dtype;
        return *this;
}
