#include "drawing_area.h"
#include "rootwindow.h"
#include "drawing_area_registry.h"

extern "C" {
#include "toon.h"
}

char toon_message[TOON_MESSAGE_LENGTH] = "";

DrawingArea::DrawingArea()
        : x(0),
          y(0),
          width(0),
          height(0)
{
        Window parent;
        
        openDisplay();
        Display *dpy = getDisplay();
        screen = DefaultScreen(dpy);        
        root = ToonGetRootWindow(dpy, screen, &parent);
        gc = DefaultGC(dpy, screen);

        DrawingAreaRegistry::instance()->register_da(this);

        unsigned long fg_pixel = WhitePixel(dpy, screen);
        XSetForeground(dpy, gc, fg_pixel);        

	unsigned long bg_pixel = BlackPixel(dpy, screen);
	XSetBackground(dpy, gc, bg_pixel);

        XSelectInput(dpy, root, ExposureMask);
}

DrawingArea::~DrawingArea()
{
        DrawingAreaRegistry::instance()->unregister_da(this);
        closeDisplay();
}

void DrawingArea::service()
{
        static int recheck_root = 0;

        /* We periodically recheck the root window, since often
         * root-portal will, load, then nautilus will follow some time
         * later.*/
        
        if (recheck_root == 0) {
                Window root_tmp;
                Window parent;
                Display *dpy = getDisplay();
                screen = DefaultScreen(dpy);        
                root_tmp = ToonGetRootWindow(dpy, screen, &parent);
                if (root != root_tmp) {
                        root = root_tmp;
                        recheck_root = 1;
                } else {
                        recheck_root = 500;
                }
        }
        recheck_root--;
}

void DrawingArea::set_x(int nx)
{
        erase();
        x = nx;
        redraw(NULL);
}

void DrawingArea::set_y(int ny)
{
        erase();
        y = ny;
        redraw(NULL);
}

void DrawingArea::set_width(int nwidth)
{
        erase();
        width = nwidth;
        redraw(NULL);
}

void DrawingArea::set_height(int nheight)
{
        erase();
        height = nheight;
        redraw(NULL);
}

bool DrawingArea::intersects_with_exposed_area(XExposeEvent *ev)
{
        return ((ev->x >= x) && (ev->x <= x + width)
                && (ev->y >= y) && (ev->y <= y + height)) // top left inside
                || ((ev->x >= x) && (ev->x <= x + width) && (ev->y + ev->height >= y)
                    && (ev->y + ev->height <= y + height)) // bottom left inside
                || ((ev->x + ev->width >= x) && (ev->x + ev->width <= x + width)
                    && (ev->y >= y) && (ev->y <= y + height)) // top right inside
                || ((ev->x + ev->width >= x) && (ev->x + ev->width <= x + width)
                    && (ev->y + ev->width >= y) && (ev->y + ev->width <= y + height)) // top right inside
                || ((x >= ev->x) && (x <= ev->x + ev->width) && (y >= ev->y)
                    && (y <= ev->y + ev->height)) // completely inside
                || ((ev->x >= x) && (ev->x <= x + width) && (ev->y <= y)
                    && (ev->y + ev->height >= y + height)) // vertical overlap
                || ((ev->y >= y) && (ev->y <= y + height) && (ev->x <= x)
                    && (ev->x + ev->width >= x + width)); // horizontal overlap
}

void DrawingArea::erase()
{
        Display *dpy = getDisplay();
        XClearArea(dpy, root, x, y, width, height, false);
}

//  void DrawingArea::redraw()
//  {
//          Display *dpy = getDisplay();
//          int row;
//          int ascent;

//          char msg[] = "hi there";
//          ascent = font->ascent;
//          int textheight = ascent + font->descent;

//          for (row=0; row < 10; row++) {
//                  int yp = y + row * textheight;

//  //  #if 1
//  //                  XClearArea(dpy, win, x, yp, width, textheight, 0);
//                  XDrawImageString(dpy, win, gc, x, yp + ascent, msg, strlen(msg));
                                
//  //  #endif
                
//  //  #if 0
//  //                  XClearArea(dpy, win, pty->xoff, y,
//  //                             tty_pixwidth, height, 0);
//  //                  if (buf[0]!=0)
//  //                          XDrawString(dpy, win, gc, pty->xoff, y+ascent, buf, strlen(buf));
//  //  #endif
//          }
//  }


