#include "gnometext.h"
#include "../../module_registry.h"
#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <X11/Xatom.h>

DataSetMap *GnomeText::moduleInfo = 0;

Module* gnometext_constructor()
{
        return new GnomeText();
}

const DataSetMap& GnomeText::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Display text in a borderless window on the desktop"));
                moduleInfo->set("supported_vars", DataSet("xpos,ypos,width,height,background,shaded,colour,font,transparent")); // pattern_name,pattern,pattern_action
                moduleInfo->set("supported_var_types", DataSet("int,int,int,int,image,bool,enum,font,bool"));
                moduleInfo->set("supported_var_defaults", DataSet("0,0,200,100,,false,white,,true"));
                moduleInfo->set("overridable", DataSet("false,false,false,false,false,false,true,false,false"));
                moduleInfo->set("enum_colour", DataSet("white,lightcyan,pink,lightpurple,lightmagenta,lightblue,yellow,lightgreen,lightred,darkgrey,grey,cyan,purple,magenta,blue,brown,green,red,black"));
        }
        return *moduleInfo;
}

extern "C" int gnometext_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Gnometext", &gnometext_constructor, GnomeText::get_module_info_instance());
        return 0;
}

extern "C" void gnometext_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Gnometext");
        GnomeText::destroy_module_info();
}

gint windowmove_(GtkWidget* widget, GdkEventConfigure* event, GnomeText* data)
{
        data->windowMove(event);
	return true;
}

gint windowclick_(GtkWidget* widget,GdkEventButton* event,GnomeText* data)
{
	data->windowClick(event);
	return true;
}

gint showconfig_(GtkWidget* widget,GdkEventConfigure* event,GnomeText* data)
{
	rootPortal->configure();
	return true;
}

gint act_on_pattern_(GtkWidget* widget,GdkEventButton* event,GnomeText* data)
{
  data->actOnPattern(event);
  return true;
}

void set_window_type(GdkWindow *window)
{
        Atom atoms[1] = { None };
        Atom net_wm_window_type;

        Display *gdk_display = GDK_WINDOW_XDISPLAY(window);
        
        net_wm_window_type = XInternAtom(gdk_display, 
                                         "_NET_WM_WINDOW_TYPE", False);

        atoms[0] = XInternAtom(gdk_display, 
                               "_NET_WM_STATE_BELOW",
                               False);

        XChangeProperty(GDK_WINDOW_XDISPLAY(window),
                        GDK_WINDOW_XWINDOW(window),
                        net_wm_window_type,
                        XA_ATOM, 32, PropModeReplace,
                        (guchar *)atoms, 1);
}

GnomeText::GnomeText()
{
        colour = getcolour("white");
        
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(window);

        gtk_window_stick(GTK_WINDOW(window));

        //gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_DESKTOP);
        
//  	gdk_win_hints_init();
//         gdk_win_hints_set_state(window, GnomeWinState(WIN_STATE_HID_TRANSIENT | WIN_STATE_STICKY));
//         gdk_win_hints_set_hints(window, GnomeWinHints(WIN_HINTS_SKIP_FOCUS | WIN_HINTS_SKIP_WINLIST
//                                                       | WIN_HINTS_SKIP_TASKBAR | WIN_HINTS_FOCUS_ON_CLICK
//                                                       | WIN_HINTS_GROUP_TRANSIENT));
//  	gdk_win_hints_set_layer(window, WIN_LAYER_BELOW);
        
	gdk_window_set_decorations(window->window, (GdkWMDecoration)0);

	term = zvt_term_new();
	zvt_term_set_blink(ZVT_TERM(term), false);
	zvt_term_set_bell(ZVT_TERM(term), false);
	zvt_term_set_scrollback(ZVT_TERM(term), 0);
	zvt_term_reset(ZVT_TERM(term), true);
	
        gtk_signal_connect(GTK_OBJECT(window), "configure_event", GTK_SIGNAL_FUNC(windowmove_), this);
	gtk_signal_connect(GTK_OBJECT(window), "button_press_event", GTK_SIGNAL_FUNC(windowclick_), this);

	gtk_container_add(GTK_CONTAINER(window), term);
        zvt_term_hide_pointer(ZVT_TERM(term));
        reSync();
}

void GnomeText::buildSmallMenu()
{
	smallmenu = gtk_menu_new();
	add_menu_item(smallmenu,"Configuration",(void*)showconfig_);
//  	add_menu_item(smallmenu,"New Filetail Portal",(void*)showconfig_);
	gtk_widget_show (smallmenu);
}

void GnomeText::add_menu_item(GtkWidget* menu,const char* aName,const void* aFunction)
{
  GtkWidget *entry = gtk_menu_item_new_with_label(aName);
  gtk_widget_show(entry);
  gtk_menu_append(GTK_MENU(menu),entry);
  gtk_signal_connect(GTK_OBJECT(entry),"activate",GTK_SIGNAL_FUNC(aFunction),(gpointer)NULL);
}

void GnomeText::add_submenu_item(GtkWidget* menu,const char* aName, GtkWidget* aMenu)
{
  GtkWidget *entry = gtk_menu_item_new_with_label(aName);
  gtk_widget_show(entry);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(entry),aMenu);
  gtk_menu_append(GTK_MENU(menu),entry);
}

void GnomeText::buildFullMenu()
{
        fullmenu = gtk_menu_new();
	add_submenu_item(fullmenu,"Configuration",smallmenu);
	for (int i=0;;i++) {
	  if (env.getString("pattern_name",i,"").c_str()[0] == 0)
	    break;
	  else {
	    add_menu_item(fullmenu,env.getString("pattern_name",i,"").c_str(),(void*)act_on_pattern_);
	    zvt_term_match_add
	      (ZVT_TERM(term),
	       const_cast<char*> (env.getString("pattern",i,"").c_str()),
	       VTATTR_UNDERLINE,
	       (void *)env.getString("pattern_action",i,"").c_str());
	  }
	}
        gtk_widget_show (fullmenu);
}

void GnomeText::postStartup()
{
        Module::postStartup();
	buildSmallMenu();
	buildFullMenu();
	gtk_widget_show_all(window);
        //set_window_type(gtk_widget_get_parent_window(window));
        updated("xpos", env["xpos"]); // ypos will be updated also (can't do one without the other)
}

GnomeText::~GnomeText()
{
        gtk_signal_disconnect_by_func(GTK_OBJECT(window), GTK_SIGNAL_FUNC(windowmove_), this);
        gtk_signal_emit_by_name(GTK_OBJECT(window), "destroy");
        rpdbgmsg(getName() << " module destroyed");
}

void GnomeText::windowMove(GdkEventConfigure* event)
{
        rpdbgmsg("GnomeText: window move detected");
        if (event->x != env.getInt("xpos", 0, 0)
            || event->y != env.getInt("ypos", 0, 0)
            || event->width != env.getInt("width", 0, 0)
            || event->height != env.getInt("height", 0, 0)) {
                env.set("xpos", DataSet(event->x));
                env.set("ypos", DataSet(event->y));
                env.set("width", DataSet(event->width));
                env.set("height", DataSet(event->height));
                reSync();
        }
}

//  void FileTail::service()
//  {
//          Module::service();
//          if (window_moved) {
//                  reSync();
//                  window_moved = true;
//          }
//  }

void GnomeText::reSync()
{
        zvt_term_set_background(ZVT_TERM(term), const_cast<char*> (env.getString("background", 0, "").c_str()), env.getBool("transparent", 0, true), env.getBool("shaded", 0, false));
        gtk_widget_queue_draw(window);
}       

void GnomeText::windowClick(GdkEventButton* event)
{
	if (event->button == 3) {
		int x,y;
		GdkModifierType mask;
		gdk_window_get_pointer(window->window,&x,&y,&mask);
		char* match = zvt_term_match_check (ZVT_TERM(term),x/ZVT_TERM(term)->charwidth,y/ZVT_TERM(term)->charheight,0);
		if (match==NULL) {
			gtk_menu_popup(GTK_MENU(smallmenu),(GtkWidget*)NULL,(GtkWidget*)NULL,(void (*)(GtkMenu*,gint*,gint*,gboolean*,void*))NULL,(char*)NULL,3,2000);
		}
		else {
			gtk_menu_popup(GTK_MENU(fullmenu),(GtkWidget*)NULL,(GtkWidget*)NULL,(void (*)(GtkMenu*,gint*,gint*,gboolean*,void*))NULL,(char*)NULL,3,2000);
		}
	}
}

void GnomeText::actOnPattern(GdkEventButton* event)
{
}

void GnomeText::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "textline") {
                display();
        } else if (keyName == "xpos" || keyName == "ypos") {
                gtk_widget_set_uposition(window, env.getInt("xpos", 0, 0), env.getInt("ypos", 0, 0));
                zvt_term_reset(ZVT_TERM(term), false);
        } else if (keyName == "internalFocus") {
                if (data.getBool()) {
                        gtk_widget_hide_all(window);
                        gdk_window_set_decorations(window->window, (GdkWMDecoration)1);
                        gtk_widget_show_all(window);
                } else {
                        gtk_widget_hide_all(window);
                        gdk_window_set_decorations(window->window,(GdkWMDecoration)0);
                        gtk_widget_show_all(window);
                }
        } else if (keyName == "background" || keyName == "shaded" || keyName == "transparent") {
                reSync();
        } else if (keyName == "length") {  // backward compatability
                set("height", data);
        } else if (keyName == "width" || keyName == "height") {
                gtk_widget_hide_all(window);
                gtk_widget_set_usize(window, env.getInt("width", 0, 100), env.getInt("height", 0, 100));
                zvt_term_reset(ZVT_TERM(term), false);
                gtk_widget_queue_draw(window);
                gtk_widget_show_all(window);
                reSync();
        } else if (keyName == "colour") {
                colour = getcolour(data.getString());
        } else if (keyName == "font") {
                if (data.getString().size() > 0) {
                        zvt_term_set_font_name (ZVT_TERM(term), const_cast<char *> (data.getString().c_str()));
                }
                
        }
}

static const string white("\033[1;37m");
static const string lightcyan("\033[1;36m");
static const string pink("\033[1;35m");
static const string lightpurple("\033[1;35m");
static const string lightmagenta("\033[1;35m");
static const string lightblue("\033[1;34m");
static const string yellow("\033[1;33m");
static const string lightgreen("\033[1;32m");
static const string lightred("\033[1;31m");
static const string darkgrey("\033[1;30m");
static const string grey("\033[0;37m");
static const string cyan("\033[0;36m");
static const string purple("\033[0;35m");
static const string magenta("\033[0;35m");
static const string blue("\033[0;34m");
static const string brown("\033[0;33m");
static const string green("\033[0;32m");
static const string red("\033[0;31m");
static const string black("\033[0;30m");
static const string noColour("");

/* Take in 'data', compare it with the colour string to see if it's real ie; [white] [darkgrey] etc, generate
 * output as ANSI code if it's real */
const string& GnomeText::getcolour(const string& colourStr) const
{
        if (colourStr == "white")
                return white;
        if (colourStr == "lightcyan")
                return lightcyan;
        if (colourStr == "pink")
                return pink;
        if (colourStr == "lightpurple")
                return lightpurple;
        if (colourStr == "lightmagenta")
                return lightmagenta;
        if (colourStr == "lightblue")
                return lightblue;
        if (colourStr == "yellow")
                return yellow;
        if (colourStr == "lightgreen")
                return lightgreen;
        if (colourStr == "lightred")
                return lightred;
        if (colourStr == "darkgrey")
                return darkgrey;
        if (colourStr == "grey")
                return grey;
        if (colourStr == "cyan")
                return cyan;
        if (colourStr == "purple")
                return purple;
        if (colourStr == "magenta")
                return magenta;
        if (colourStr == "blue")
                return blue;
        if (colourStr == "brown")
                return brown;
        if (colourStr == "green")
                return green;
        if (colourStr == "red")
                return red;
        if (colourStr == "black")
                return black;
        
        return noColour;
}

/* writes 'textline' to the display */
void GnomeText::display()
{
        string textline;
        env.getExpanded(textline, "textline");

    	/* compare with old */
        if (oldTextLine == textline)
                return;
	
	/* save old */
	oldTextLine = textline;
    
	string newdata = "\n\r" + colour;
        
        for (int a = 0; a < textline.length(); a++) {
                if (textline[a] == '[') {
                        for (int i = a; i < textline.length(); i++) {
                                if (textline[i] == ']') {
                                        string colourDesc(textline, a + 1, i - a - 1);
                                        const string& colourChange = getcolour(colourDesc);
                                        if (colourChange.length()) {
                                                newdata += colourChange;
                                                a = i;
                                        } else if (colour.length() && colourDesc == "normal") {
                                                newdata += colour;
                                                a = i;
                                        } else {
                                                newdata += textline[a];
                                        }
                                        break;
                                }
                        }
                } else {
                        newdata += textline[a];
                }
        }
        zvt_term_feed(ZVT_TERM(term), const_cast<char*> (newdata.c_str()), newdata.length());
}
