#include <unistd.h>

#include "remote.h"
#include "../../module_registry.h"
#include "../../utils.h"

DataSetMap *Remote::moduleInfo = 0;

Module* remote_constructor()
{
        return new Remote();
}

const DataSetMap& Remote::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Run sub-modules on a remote system"));
                moduleInfo->set("supported_vars", DataSet("rsh_cmd"));
                moduleInfo->set("supported_var_types", DataSet("string"));
                moduleInfo->set("supported_var_defaults", DataSet("ssh -C -l username hostname root-portal -s --no-x"));
                moduleInfo->set("overridable", DataSet("false"));
                moduleInfo->set("output_variables", DataSet(""));
        }
        return *moduleInfo;
}

extern "C" int remote_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Remote", &remote_constructor, Remote::get_module_info_instance());
        return 0;
}

extern "C" void remote_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Remote");
        Remote::destroy_module_info();
}

Remote::Remote()
        : have_result(false),
          base_proxy("Remote")
{
}

Remote::~Remote()
{
        shutdown();
        rpdbgmsg(getName() << " module destroyed");
}

void Remote::shutdown()
{
        if (connected) {
                string send_command = "shutdown\n";
                if (write(sending_pipe[1], send_command.c_str(), send_command.length()) <= 0) {
                        cerr << "error writing to remote shell\n";
                }
        }
}

void Remote::service()
{
        Module::service();
        get_line(true);
        while (update_buffer.size() > 0) {
                string line = update_buffer[0];
                update_buffer.erase(update_buffer.begin());
                
                int line_length = line.length();
                string lhs;
                int i = 0;
                while (line[i] != '=' && i < line_length) {
                        lhs += line[i];
                        i++;
                }
                if (i < line_length) {
                        i++; // skip '='
                        string rhs(line, i, line_length - i);
                        DataSet msg;
                        msg.addString(rhs);
                        updateParent(lhs, msg);
                }
        }
        while (message_buffer.size() > 0) {
                string line = message_buffer[0];
                message_buffer.erase(message_buffer.begin());
                
                string message;
                Path path;
                string tmp;
                for (int i = 0; i < int(line.length()); i++) {
                        if (line[i] == '/') {
                                if (tmp.length() > 0) {
                                        if (message.length() > 0) {
                                                message += '/' + tmp;
                                        } else {
                                                if (isdigit(tmp[0])) {
                                                        path.add_last(atoi(tmp.c_str()));
                                                } else {
                                                        if (message.length() > 0)
                                                                message += '/';
                                                        message += tmp;
                                                }
                                        }
                                        tmp = "";
                                }
                        } else {
                                tmp += line[i];
                        }
                }
                if (message.length() > 0)
                        message += '/';
                message += tmp;
                return_message(DataSet(message), path);
        }
}

void Remote::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "rsh_cmd") {
                pipe(sending_pipe);
                pipe(receiving_pipe);
                if (!fork()) {
                        // child
                        close(sending_pipe[1]);
                        close(receiving_pipe[0]);

                        // redirect standard input
                        close(0);
                        dup(sending_pipe[0]);
                        close(sending_pipe[0]);

                        // redirect standard output
                        close(1);
                        dup(receiving_pipe[1]);
                        close(receiving_pipe[1]);
                        
                        execl("/bin/sh", "sh", "-c", data.toString().c_str(), NULL);
                        exit(0);
                } else {
                        // parent
                        close(sending_pipe[0]);
                        close(receiving_pipe[1]);
                        connected = true;
                }
        }
}

bool Remote::get_line(bool nonblocking)
{
        try {
                string result = read_line(receiving_pipe[0], nonblocking);
                if (result.length() == 0)
                        return false;
                if (result[0] == 'R') {
                        result_buffer = string(result, 1);
                        have_result = true;
                } else if (result[0] == 'U') {
                        update_buffer.push_back(string(result, 1));                        
                } else if (result[0] == 'M') {
                        message_buffer.push_back(string(result, 1));
                } else {
                        rpwarning("unreconised input line \"" << result << "\"\n");
                }
                return true;
        } catch (FileException) {
                connected = false;
                return false;
        }        
}

string Remote::send_on_command(const Path& path, const string& command, const string& parameter)
{
        string result;
        bool done = false;
        if (connected) {
                if (command == "create_child"
                    || command == "delete_child"
                    || command == "set_value"
                    || command == "post_startup"
                    || command == "pre_shutdown"
                    || command == "overlay_defaults") {
                        string send_command = path.to_string() + command + "/" + parameter + "\n";
                        rpdbgmsg("sending command \"" << send_command << "\"\n");
                        if (write(sending_pipe[1], send_command.c_str(), send_command.length()) <= 0) {
                                cerr << "error writing to remote shell\n";
                        } else {
                                string result;
                                while (true) {
                                        if (!get_line(false)) {
                                                rpdbgmsg("2222222222");
                                                DataSet msg;
                                                msg.addString("Error");
                                                msg.addString("Remote shell connection lost");
                                                return_message(msg);
                                                
                                                result = "!!ERROR!!connection lost";
                                                break;
                                        } else if (have_result) {
                                                result = result_buffer;
                                                have_result = false;
                                                break;
                                        }
                                }
                                done = true;
                                rpdbgmsg("result of command \"" << result << "\"\n");
                        }
                } else {
                        rpdbgmsg("not sending because we have the info localy");
                }
        } else {
                rpdbgmsg("not sending because we are not connected");
        }
        string result2 = base_proxy.issue_command(path, command, parameter);
        if (!done)
                result = result2;
        return result;
}

string Remote::execute_command(const string& command_name, const string& parameter)
{
        if (command_name == "create_child"
            || command_name == "delete_child"
            || command_name == "child_count") {
                return send_on_command(Path(), command_name, parameter);
        } else {
                return default_execute_command(command_name, parameter);
        }
        
}

